/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <signal.h>
#include <string.h>
#include <sys/ioctl.h>
#include <malloc.h>
#include <locale.h>
#include <libintl.h>
#include <gtk/gtk.h>

#include "icons/chinput.xpm"

#define _(String)  gettext(String)
#define N_(String)  gettext(String)
#define __(String) (String)

GtkWidget *pixlabel(GtkWidget *w, char **pixdata, char *title)
{
        GtkWidget *toplevel;
        GtkWidget *box;
        GtkWidget *label;
        GtkWidget *pixmapwid;
        GdkPixmap *pixmap;
        GdkBitmap *mask;
        GtkStyle *style;

        box = gtk_hbox_new(FALSE, 0);
        gtk_container_set_border_width(GTK_CONTAINER(box), 0);
        //add pixmap
        if(pixdata){
                toplevel = gtk_widget_get_toplevel(w);
                gtk_widget_realize(toplevel);
                style = gtk_widget_get_style(toplevel);
                pixmap = gdk_pixmap_create_from_xpm_d(
                        toplevel->window, &mask,
                        &style->bg[GTK_STATE_NORMAL], pixdata);
                pixmapwid = gtk_pixmap_new(pixmap, mask);
                gtk_box_pack_start(GTK_BOX(box), pixmapwid, TRUE, TRUE, 3);
                gtk_widget_show(pixmapwid);
        }

        //add label
        if(title){
		label = gtk_label_new(_(title));
        	gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 3);
        	gtk_widget_show(label);
	}

        return box;
}

static char *buffer1 = "\nbuffer1";
static char *buffer2 = "\nbuffer2";

static void add_label(GtkWidget *vbox, char *string)
{
	GtkWidget *label;

	label = gtk_label_new(_(string));
	gtk_box_pack_start(GTK_BOX(vbox), label, TRUE, TRUE, 0);
        //gtk_label_set_line_wrap(GTK_LABEL(label), FALSE);
	gtk_label_set_justify(GTK_LABEL(label), GTK_JUSTIFY_LEFT);
	gtk_misc_set_alignment(GTK_MISC(label), 0.0, 0.0);
	gtk_widget_show(label);
}

static void add_image(GtkWidget *vbox, char **icon)
{
	GtkWidget *pix;

	pix = pixlabel(vbox, icon, NULL);
	gtk_box_pack_start(GTK_BOX(vbox), pix, TRUE, TRUE, 0);
	gtk_widget_show(pix);
}

void menubar_help()
{
        //usage
        static GtkWidget *window = NULL;
        GtkWidget *vbox, *vbox2, *button, *separator, *scrolled_window;

        if(!window){
                window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
                gtk_widget_set_usize(window, 700, 500);
                gtk_window_set_policy(GTK_WINDOW(window), TRUE, TRUE, FALSE);
                gtk_signal_connect(GTK_OBJECT(window), "destroy",
                        GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);
                gtk_window_set_title(GTK_WINDOW(window), "Help");
                gtk_container_set_border_width(GTK_CONTAINER(window), 10);
                gtk_widget_show(window);

                vbox = gtk_vbox_new(FALSE, 0);
                gtk_container_add(GTK_CONTAINER(window), vbox);
                gtk_widget_show(vbox);

                scrolled_window = gtk_scrolled_window_new(NULL, NULL);
                gtk_box_pack_start(GTK_BOX(vbox), scrolled_window, TRUE, TRUE, 5);
                gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolled_window), GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
                gtk_widget_show(scrolled_window);

		vbox2 = gtk_vbox_new(FALSE, 0);
		//gtk_container_add(GTK_CONTAINER(scrolled_window), vbox2);
		gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolled_window), vbox2);
		gtk_widget_show(vbox2);

		add_label(vbox2, buffer1);
		add_image(vbox2, icon_chinput);
		add_label(vbox2, buffer2);

                separator = gtk_hseparator_new();
                gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 5);
                gtk_widget_show(separator);

                button = gtk_button_new_with_label("Close");
                gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
                        GTK_SIGNAL_FUNC(gtk_widget_destroy),
                        GTK_OBJECT(window));
                gtk_box_pack_start(GTK_BOX(vbox), button, FALSE, FALSE, 5);
                GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
                gtk_widget_grab_default(button);
                gtk_widget_show(button);
        }

/*
        if(!GTK_WIDGET_VISIBLE(window))
                gtk_widget_show(window);
        else
                gtk_widget_destroy(window);
*/
}

void menubar_exit()
{
	//FIXME should destroy tooltips for each button

	gtk_main_quit();
        gtk_exit(0);
	//kill(getpid(), 9);
	exit(0);
}


