/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <signal.h>
#include <string.h>
#include <sys/ioctl.h>
#include <malloc.h>
#include <locale.h>
#include <libintl.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>

#define _(String)  gettext(String)
#define N_(String)  gettext(String)
#define __(String) (String)

#include "defs.h"
#include "hzclient.h"
#include "chinput.h"
#include "hzserver.h"
#include "xpm_yes.h"
#include "xpm_no.h"
#define  MAX_IMES	60
#define  MAX_ITEM	7

extern int flag_encoding;
extern chinput_ime chinputime[MAX_IMES];
extern chinput_rc  chinputrc;
extern int index_ime;

int cur_row = 0;
int total_rows;
int flag_action = 1;

static GtkWidget *window = NULL;
static GtkWidget *chinput_style, *chinput_autohide, *chinput_showime;
static GtkWidget *chinput_clist, *chinput_dictionary, *chinput_hwtimeout;
static GtkWidget *chinput_font, *chinput_fontgb, *chinput_fontbig5;
static GtkWidget *chinput_width;
static GtkWidget *chinput_dimcolor, *chinput_lightcolor, *chinput_panelcolor,
		 *chinput_hzcolor, *chinput_ledcolor, *chinput_barcolor;
static GtkTooltips *tips_style=NULL, *tips_autohide=NULL, *tips_showime=NULL;
static GtkTooltips *tips_dictionary=NULL, *tips_hwtimeout=NULL;
static GtkTooltips *tips_dimcolor=NULL, *tips_lightcolor=NULL, 
	*tips_panelcolor=NULL, *tips_hzcolor=NULL, *tips_ledcolor=NULL, 
	*tips_barcolor=NULL, *tips_width=NULL;
static GtkTooltips *tips_font=NULL, *tips_fontgb=NULL, *tips_fontbig5=NULL;
static GtkTooltips *tips_name=NULL, *tips_namehz=NULL, *tips_encoding, 
	*tips_fname=NULL, *tips_module=NULL;
static gchar *titles[MAX_ITEM];
static GtkWidget *win_edit;

#include "all.h"

static int check_item(char *item)
{
	if(!item || !item[0]) return 0;
	return 1;
}

static int check_file(char *fname)
{
        char name[256];
        if(!strcmp(fname, "gb")) return 1;           //ZNPY
        if(fname[0] == '/')
		strcpy(name, fname);
	else
		sprintf(name, "%s/%s", chinputrc.dictionary, fname);

        if(access(name, F_OK) == 0) return 1;
        else return 0;
}

static int check_encoding(char *encoding)
{
	if(!strcmp(encoding, "GB") || !strcmp(encoding, "BIG5")) return 1;
	return 0;
}

static int check_font(char *font)
{
	if(strchr(font, ' ')) return 0;
	return 1;
}

static int check_color(char *color)
{
	int i;
	if(strlen(color) != 7) return 0;
	if(color[0] != '#') return 0;
	for(i=1; i<7; i++){
		if(!((color[i] >= 'a' && color[i] <= 'f') || 
		     (color[i] >= 'A' && color[i] <= 'F') ||
		     (color[i] >= '0' && color[i] <= '9'))) return 0;
	}
	return 1;
}

static void destroy_tips()
{
}

static void set_pixmap(int row, int col, char *val)
{
	GdkPixmap *pixmap;
       	GdkBitmap *mask;
       	GtkStyle  *style;
       	//add the first button
       	style = gtk_widget_get_style(window);
	if(!strcmp(val," "))pixmap=gdk_pixmap_create_from_xpm_d(window->window, 
		&mask, &style->bg[GTK_STATE_NORMAL], xpm_yes);
	else pixmap = gdk_pixmap_create_from_xpm_d(window->window, 
		&mask, &style->bg[GTK_STATE_NORMAL], xpm_no);
	gtk_clist_set_pixtext((GtkCList *)chinput_clist, row, col, 	
		val, 0, pixmap, mask);
}

static int add_list(GtkWidget *list)
{
	int i;
	int flag_bad = 0;
	gchar *item[MAX_ITEM];
	for(i=0; i<index_ime; i++){
		if((!strcmp(chinputime[i].encoding, "GB") && 
		    !strcmp(chinputime[i].name, chinputrc.ime_gb)) ||
		   (!strcmp(chinputime[i].encoding, "BIG5") &&
		    !strcmp(chinputime[i].name, chinputrc.ime_big5)))
			item[0] = " ";
		else
			item[0] = "";
		item[1] = chinputime[i].name;
		if(flag_encoding == HZSERVER_ENCODING_GB){
			item[2] = chinputime[i].namegb;
		} else if(flag_encoding == HZSERVER_ENCODING_BIG5){
			item[2] = chinputime[i].namebig5;
		}
		item[3] = chinputime[i].encoding;
		if(chinputime[i].favorite == 1) item[4] = " ";
		else item[4] = "";
		item[5] = chinputime[i].fname;
		item[6] = chinputime[i].module;
		gtk_clist_append((GtkCList *)list, item);

		//checking
		if(!check_item(item[1]) || !check_item(item[2])  ||
		   !check_encoding(item[3]) ||
		   !check_file(item[5]) || !check_file(item[6])){
      			GdkColor col1, col2;
			GtkStyle *style;
			int j;
			col1.red   = 46000;
			col1.green = 46000;
			col1.blue  = 46000;
			col2.red   = 0;
			col2.green = 0;
			col2.blue  = 0;

			flag_bad = 1;
			style = gtk_style_copy (window->style);
			style->base[GTK_STATE_NORMAL] = col1;
			style->base[GTK_STATE_SELECTED] = col2;

			for(j=0; j<MAX_ITEM; j++)
				gtk_clist_set_cell_style(GTK_CLIST(chinput_clist), i, j, style);
		}
		set_pixmap(i, 0, item[0]);
		set_pixmap(i, 4, item[4]);
	}

	return flag_bad;
}
static void reset_gui()
{
	//reset GUI
	if(chinputrc.dmode == HZSERVER_DMODE_OVERSPOT)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chinput_style), TRUE);
	else
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chinput_style), FALSE);
        if(chinputrc.hmode == HZSERVER_HMODE_AUTO)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chinput_autohide), TRUE);
	else
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chinput_autohide), FALSE);
        if(chinputrc.showime == 1)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chinput_showime), TRUE);
	else
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chinput_showime), FALSE);
	
        gtk_entry_set_text(GTK_ENTRY(chinput_dictionary), "/root/Chinput/datas");
        gtk_entry_set_text(GTK_ENTRY(chinput_font), "8x16");
        gtk_entry_set_text(GTK_ENTRY(chinput_fontgb), "-*-song-medium-r-normal--16-*-*-*-*-*-gbk-0");
        gtk_entry_set_text(GTK_ENTRY(chinput_fontbig5), "-*-song-medium-r-normal--16-*-*-*-*-*-big5-0");
        gtk_entry_set_text(GTK_ENTRY(chinput_dimcolor),      "#666666");
        gtk_entry_set_text(GTK_ENTRY(chinput_lightcolor),    "#f5f5f5");
        gtk_entry_set_text(GTK_ENTRY(chinput_panelcolor),    "#c0c0c0");
        gtk_entry_set_text(GTK_ENTRY(chinput_hzcolor),       "#000000");
        gtk_entry_set_text(GTK_ENTRY(chinput_ledcolor),      "#00ff00");
        gtk_entry_set_text(GTK_ENTRY(chinput_barcolor),      "#000080");

        gtk_entry_set_text(GTK_ENTRY(chinput_hwtimeout), "1500");

	gtk_clist_clear(GTK_CLIST(chinput_clist));
	add_list(chinput_clist);
}

static void set_default(GtkWidget *w, gpointer data)
{
	//reset the whole things to definitely the default

	chinputrc.dmode	= HZSERVER_DMODE_OVERSPOT;
	chinputrc.hmode	= HZSERVER_HMODE_NO;
	chinputrc.showime = 1;
	strcpy(chinputrc.dictionary, "/root/Chinput/datas");
	strcpy(chinputrc.ime_gb, "ZNPY");
	strcpy(chinputrc.ime_big5, "PY");
	strcpy(chinputrc.font, "8x16");
	strcpy(chinputrc.gbfont, "-*-song-medium-r-normal--16-*-*-*-*-*-gbk-0");
	strcpy(chinputrc.big5font, "-*-song-medium-r-normal--16-*-*-*-*-*-big5-0");
	chinputrc.width		=	70;

	strcpy(chinputrc.dimcolor,	"#666666");
	strcpy(chinputrc.lightcolor,	"#f5f5f5");
	strcpy(chinputrc.panelcolor,	"#c0c0c0");
	strcpy(chinputrc.hzcolor,	"#000000");
	strcpy(chinputrc.ledcolor,	"#00ff00");
	strcpy(chinputrc.barcolor,	"#000080");

	chinputrc.hwtimeout	=	1500;

	strcpy(chinputime[0].name, "ZNPY");
	strcpy(chinputime[0].namegb, "ƴ");
	strcpy(chinputime[0].namebig5, "");
	strcpy(chinputime[0].encoding, "GB");
	strcpy(chinputime[0].fname, "gb");
	strcpy(chinputime[0].module, "/usr/lib/libfreepy.so");
	chinputime[0].favorite = 1;

	strcpy(chinputime[1].name, "PY");
	strcpy(chinputime[1].namegb, "޵ƴ");
	strcpy(chinputime[1].namebig5, "Lի");
	strcpy(chinputime[1].encoding, "GB");
	strcpy(chinputime[1].fname, "gb/py.tab");
	strcpy(chinputime[1].module, "/usr/lib/libhzinput.so");
	chinputime[1].favorite = 1;

	strcpy(chinputime[2].name, "TONEPY");
	strcpy(chinputime[2].namegb, "ƴ");
	strcpy(chinputime[2].namebig5, "aի");
	strcpy(chinputime[2].encoding, "GB");
	strcpy(chinputime[2].fname, "gb/tonepy.tab");
	strcpy(chinputime[2].module, "/usr/lib/libhzinput.so");
	chinputime[2].favorite = 0;

	strcpy(chinputime[3].name, "CCDOSPY");
	strcpy(chinputime[3].namegb, "дƴ");
	strcpy(chinputime[3].namebig5, "Yg");
	strcpy(chinputime[3].encoding, "GB");
	strcpy(chinputime[3].fname, "gb/shuangpin.tab");
	strcpy(chinputime[3].module, "/usr/lib/libhzinput.so");
	chinputime[3].favorite	= 1;

	strcpy(chinputime[4].name, "WuBi");
	strcpy(chinputime[4].namegb, "");
	strcpy(chinputime[4].namebig5, "r");
	strcpy(chinputime[4].encoding, "GB");
	strcpy(chinputime[4].fname, "gb/wubi.tab");
	strcpy(chinputime[4].module, "/usr/lib/libhzinput.so");
	chinputime[4].favorite = 1;

	strcpy(chinputime[5].name,"CangJie");
	strcpy(chinputime[5].namegb, "");
	strcpy(chinputime[5].namebig5, "aeJ");
	strcpy(chinputime[5].encoding, "GB");
	strcpy(chinputime[5].fname, "gb/cangjie.tab");
	strcpy(chinputime[5].module, "/usr/lib/libhzinput.so");
	chinputime[5].favorite = 0;

	strcpy(chinputime[6].name,"English");
	strcpy(chinputime[6].namegb, "Ӣ");
	strcpy(chinputime[6].namebig5, "^~J");
	strcpy(chinputime[6].encoding, "GB");
	strcpy(chinputime[6].fname, "gb/english.tab");
	strcpy(chinputime[6].module, "/usr/lib/libhzinput.so");
	chinputime[6].favorite = 0;

	strcpy(chinputime[7].name,"CTLau");
	strcpy(chinputime[7].namegb, "");
	strcpy(chinputime[7].namebig5, "Bf");
	strcpy(chinputime[7].encoding, "GB");
	strcpy(chinputime[7].fname, "gb/ctlau.tab");
	strcpy(chinputime[7].module, "/usr/lib/libhzinput.so");
	chinputime[7].favorite = 0;

	strcpy(chinputime[8].name,"SW");
	strcpy(chinputime[8].namegb, "β");
	strcpy(chinputime[8].namebig5, "X");
	strcpy(chinputime[8].encoding, "GB");
	strcpy(chinputime[8].fname, "gb/sw.tab");
	strcpy(chinputime[8].module, "/usr/lib/libhzinput.so");
	chinputime[8].favorite = 0;

	strcpy(chinputime[9].name,"QianMa");
	strcpy(chinputime[9].namegb, "Ǯ");
	strcpy(chinputime[9].namebig5, "XJ");
	strcpy(chinputime[9].encoding, "GB");
	strcpy(chinputime[9].fname, "gb/qianma.tab");
	strcpy(chinputime[9].module, "/usr/lib/libhzinput.so");
	chinputime[9].favorite = 0;

	strcpy(chinputime[10].name,"ZRM");
	strcpy(chinputime[10].namegb, "Ȼ");
	strcpy(chinputime[10].namebig5, "۵MX");
	strcpy(chinputime[10].encoding, "GB");
	strcpy(chinputime[10].fname, "gb/ziranma.tab");
	strcpy(chinputime[10].module, "/usr/lib/libhzinput.so");
	chinputime[10].favorite	= 1;

	strcpy(chinputime[11].name,"MGM");
	strcpy(chinputime[11].namegb, "");
	strcpy(chinputime[11].namebig5, "XڽX");
	strcpy(chinputime[11].encoding, "GB");
	strcpy(chinputime[11].fname, "gb/mgm.tab");
	strcpy(chinputime[11].module, "/usr/lib/libhzinput.so");
	chinputime[11].favorite	= 0;

	strcpy(chinputime[12].name,"PY");
	strcpy(chinputime[12].namegb, "ƴ");
	strcpy(chinputime[12].namebig5, "J");
	strcpy(chinputime[12].encoding, "BIG5");
	strcpy(chinputime[12].fname, "big5/PY.cit");
	strcpy(chinputime[12].module, "/usr/lib/libcxterminput.so");
	chinputime[12].favorite	 = 1;

	strcpy(chinputime[13].name,"ETZY");
	strcpy(chinputime[13].namegb, "ע");
	strcpy(chinputime[13].namebig5, "ʤѪ`");
	strcpy(chinputime[13].encoding, "BIG5");
	strcpy(chinputime[13].fname, "big5/ETZY.cit");
	strcpy(chinputime[13].module, "/usr/lib/libcxterminput.so");
	chinputime[13].favorite = 1;

	strcpy(chinputime[14].name,"ZOZY");
	strcpy(chinputime[14].namegb, "һע");
	strcpy(chinputime[14].namebig5, "s@`");
	strcpy(chinputime[14].encoding, "BIG5");
	strcpy(chinputime[14].fname, "big5/ZOZY.cit");
	strcpy(chinputime[14].module, "/usr/lib/libcxterminput.so");
	chinputime[14].favorite	= 1;

	strcpy(chinputime[15].name,"Simplex");
	strcpy(chinputime[15].namegb, "");
	strcpy(chinputime[15].namebig5, "²J");
	strcpy(chinputime[15].encoding, "BIG5");
	strcpy(chinputime[15].fname, "big5/Simplex.cit");
	strcpy(chinputime[15].module, "/usr/lib/libhzinput.so");
	chinputime[15].favorite	= 0;

	strcpy(chinputime[16].name,"CangJie");
	strcpy(chinputime[16].namegb, "");
	strcpy(chinputime[16].namebig5, "ܾeJ");
	strcpy(chinputime[16].encoding, "BIG5");
	strcpy(chinputime[16].fname, "big5/CangJie.cit");
	strcpy(chinputime[16].module, "/usr/lib/libcxterminput.so");
	chinputime[16].favorite	= 1;

	strcpy(chinputime[17].name,"English");
	strcpy(chinputime[17].namegb, "Ӣ");
	strcpy(chinputime[17].namebig5, "^~J");
	strcpy(chinputime[17].encoding, "BIG5");
	strcpy(chinputime[17].fname, "big5/English.cit");
	strcpy(chinputime[17].module, "/usr/lib/libcxterminput.so");
	chinputime[17].favorite	= 0;

	strcpy(chinputime[18].name,"4Corner");
	strcpy(chinputime[18].namegb, "ĽǺ");
	strcpy(chinputime[18].namebig5, "|X");
	strcpy(chinputime[18].encoding, "BIG5");
	strcpy(chinputime[18].fname, "big5/4Corner.cit");
	strcpy(chinputime[18].module, "/usr/lib/libcxterminput.so");
	chinputime[18].favorite	= 0;

	strcpy(chinputime[19].name,"HSU");
	strcpy(chinputime[19].namegb, "ע");
	strcpy(chinputime[19].namebig5, "\\f");
	strcpy(chinputime[19].encoding, "BIG5");
	strcpy(chinputime[19].fname, "big5/HSU.cit");
	strcpy(chinputime[19].module, "/usr/lib/libcxterminput.so");
	chinputime[19].favorite	= 0;

	strcpy(chinputime[20].name,"ARRAY30");
	strcpy(chinputime[20].namegb, "У");
	strcpy(chinputime[20].namebig5, "C");
	strcpy(chinputime[20].encoding, "BIG5");
	strcpy(chinputime[20].fname, "big5/ARRAY30.cit");
	strcpy(chinputime[20].module, "/usr/lib/libcxterminput.so");
	chinputime[20].favorite	= 1;

	strcpy(chinputime[21].name,"Boshiamy");
	strcpy(chinputime[21].namegb, "Ϻ");
	strcpy(chinputime[21].namebig5, "");
	strcpy(chinputime[21].encoding, "BIG5");
	strcpy(chinputime[21].fname, "big5/Boshiamy.cit");
	strcpy(chinputime[21].module, "/usr/lib/libcxterminput.so");
	chinputime[21].favorite	= 1;

	index_ime = 22;
	total_rows = 22;

	reset_gui();
}

static void set_rescan(GtkWidget *w, gpointer data)
{
	scan_menu();
	gtk_clist_clear(GTK_CLIST(chinput_clist));
	reset_gui();
}

static void set_apply(GtkWidget *w, gpointer data)
{
	int i, j;
	char fname[256];

	//get all values
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chinput_style)))
		chinputrc.dmode = HZSERVER_DMODE_OVERSPOT;
	else
		chinputrc.dmode = HZSERVER_DMODE_ROOT;
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chinput_autohide)))
		chinputrc.hmode = HZSERVER_HMODE_AUTO;
	else
		chinputrc.hmode = HZSERVER_HMODE_NO;
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(chinput_showime)))
		chinputrc.showime = 1;
	else
		chinputrc.showime = 0;

        strcpy(chinputrc.dictionary, 
		gtk_entry_get_text(GTK_ENTRY(chinput_dictionary)));
	if(!check_file(chinputrc.dictionary)){
		warning("Dictionary path not valid!");
		return;
	}
        strcpy(chinputrc.font,
		gtk_entry_get_text(GTK_ENTRY(chinput_font)));
	if(!check_font(chinputrc.font)){
		warning("Western font invalid!");
		return;
	}
        strcpy(chinputrc.gbfont,
		gtk_entry_get_text(GTK_ENTRY(chinput_fontgb)));
	if(!check_font(chinputrc.gbfont)){
		warning("Chinese GB font invalid!");
		return;
	}
        strcpy(chinputrc.big5font,
		gtk_entry_get_text(GTK_ENTRY(chinput_fontbig5)));
	if(!check_font(chinputrc.big5font)){
		warning("Chinese Big5 font invalid!");
		return;
	}
        chinputrc.width  = 
		atoi(gtk_entry_get_text(GTK_ENTRY(chinput_width)));
        strcpy(chinputrc.dimcolor,
		gtk_entry_get_text(GTK_ENTRY(chinput_dimcolor)));
	if(!check_color(chinputrc.dimcolor)){
		warning("Dim color invalid!");
		return;
	}
        strcpy(chinputrc.lightcolor,
		gtk_entry_get_text(GTK_ENTRY(chinput_lightcolor)));
	if(!check_color(chinputrc.lightcolor)){
		warning("Light color invalid!");
		return;
	}
        strcpy(chinputrc.panelcolor,
		gtk_entry_get_text(GTK_ENTRY(chinput_panelcolor)));
	if(!check_color(chinputrc.panelcolor)){
		warning("Panel color invalid!");
		return;
	}
        strcpy(chinputrc.hzcolor,
		gtk_entry_get_text(GTK_ENTRY(chinput_hzcolor)));
	if(!check_color(chinputrc.hzcolor)){
		warning("hzcolor invalid!");
		return;
	}
        strcpy(chinputrc.ledcolor,
		gtk_entry_get_text(GTK_ENTRY(chinput_ledcolor)));
	if(!check_color(chinputrc.ledcolor)){
		warning("Text color invalid!");
		return;
	}
        strcpy(chinputrc.barcolor,
		gtk_entry_get_text(GTK_ENTRY(chinput_barcolor)));
	if(!check_color(chinputrc.barcolor)){
		warning("Title bar color invalid!");
		return;
	}
        chinputrc.hwtimeout  = 
		atoi(gtk_entry_get_text(GTK_ENTRY(chinput_hwtimeout)));
	for(i=0; i<total_rows; i++){
		gchar *item[MAX_ITEM];
		for(j=0; j<MAX_ITEM; j++){
		        guint8 spacing;
        		GdkPixmap *pixmap;
		        GdkBitmap *mask;
			if(j==0||j==4) gtk_clist_get_pixtext(GTK_CLIST(chinput_clist), i, j, &item[j], &spacing, &pixmap, &mask);
			else gtk_clist_get_text(GTK_CLIST(chinput_clist), i, j, &item[j]);
		}
		if(!strcmp(item[0], " ")){
			if(!strcmp(item[4], "GB"))
				strcpy(chinputrc.ime_gb, item[1]);
			else
				strcpy(chinputrc.ime_big5, item[1]);
		}
		strcpy(chinputime[i].name, item[1]);
		if(flag_encoding == HZSERVER_ENCODING_GB){
			strcpy(chinputime[i].namegb, item[2]);
			strcpy(chinputime[i].namebig5, item[2]);
		} else if(flag_encoding == HZSERVER_ENCODING_BIG5){
			strcpy(chinputime[i].namegb, item[2]);
			strcpy(chinputime[i].namebig5, item[2]);
		}
		strcpy(chinputime[i].encoding, item[3]);
		if(!strcmp(item[4], " "))
			chinputime[i].favorite = 1;
		else
			chinputime[i].favorite = 0;
		strcpy(chinputime[i].fname, item[5]);
		strcpy(chinputime[i].module, item[6]);
	}
	index_ime = total_rows;
	//save
	if(getenv("HOME")){
		sprintf(fname, "%s/.chinput", getenv("HOME"));
		write_resource(fname);
	}
	destroy_tips();
	gtk_widget_destroy(window);

	warning(_("You should restart chinput to take effect"));

}
static void set_cancel(GtkWidget *w, gpointer data)
{
	destroy_tips();
	gtk_widget_destroy(window);
}

static void add_label_entry_notips(GtkWidget *parent, GtkWidget **entry,
	char *label, char *deftext)
{
	GtkWidget *l, *hbox;
	char text[30];

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), hbox, FALSE, TRUE, 0);
	gtk_widget_show(hbox);

	sprintf(text, "%-20s", label);
	l = gtk_label_new(text);
	gtk_box_pack_start(GTK_BOX(hbox), l, FALSE, FALSE, 0);
	gtk_widget_show(l);

	//*entry = gtk_entry_new_with_max_length(50);
	*entry = gtk_entry_new();
	if(deftext) gtk_entry_set_text(GTK_ENTRY(*entry), deftext);
	gtk_box_pack_start(GTK_BOX(hbox), *entry, TRUE, TRUE, 0);
	gtk_widget_show(*entry);
}

static void add_label_entry(GtkWidget *parent, GtkWidget **entry,
	char *label, char *deftext, GtkTooltips **tips, char *info)
{
	GtkWidget *l, *hbox;
	char text[30];

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(parent), hbox, FALSE, TRUE, 0);
	gtk_widget_show(hbox);

	sprintf(text, "%-20s", label);
	l = gtk_label_new(text);
	gtk_box_pack_start(GTK_BOX(hbox), l, FALSE, FALSE, 0);
	gtk_widget_show(l);

	//*entry = gtk_entry_new_with_max_length(50);
	*entry = gtk_entry_new();
	if(deftext) gtk_entry_set_text(GTK_ENTRY(*entry), deftext);
	gtk_box_pack_start(GTK_BOX(hbox), *entry, TRUE, TRUE, 0);
	gtk_widget_show(*entry);

	//tooltips
	*tips = gtk_tooltips_new();
	gtk_tooltips_set_tip(*tips, *entry, info, info);
}

static GtkWidget *item_default, *item_name, *item_namehz, *item_encoding, 
	*item_favorite, *item_fname, *item_module;

static void edit_ok(GtkWidget *w, gpointer data)
{
	int i, j;
	gchar *item[MAX_ITEM];
	Boolean value_default, value_favorite;

	//set value to cur_row
	value_default = gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item_default));
	if(value_default) item[0] = " ";
	else item[0] = "";


	item[1] = gtk_entry_get_text(GTK_ENTRY(item_name));
	if(!check_item(item[1])){
		warning("Input method name index should not be empty!");
		return;
	}
	item[2] = gtk_entry_get_text(GTK_ENTRY(item_namehz));
	if(!check_item(item[2])){
		warning("Input method name in Chinese should not be empty!");
		return;
	}
	item[3] = gtk_entry_get_text(GTK_ENTRY(item_encoding));
	if(!check_encoding(item[3])){
		warning("Input method encoding should be GB or BIG5 !");
		return;
	}
	value_favorite =gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item_favorite));
	if(value_favorite || value_default) item[4] = " ";
	else item[4] = "";
	item[5] = gtk_entry_get_text(GTK_ENTRY(item_fname));
	if(!check_file(item[5])){
		warning("Input method file name empty or not exist!");
		return;
	}
	item[6] = gtk_entry_get_text(GTK_ENTRY(item_module));
	if(!check_file(item[6])){
		warning("Input method module empty or not exist!");
		return;
	}

	//check default items, only one default item allowed for
	//each encoding
	if(value_default){
		for(i=0; i<total_rows; i++){
			gchar *tmpitem[MAX_ITEM];
			for(j=0; j<MAX_ITEM; j++){
			        guint8 spacing;
        			GdkPixmap *pixmap;
        			GdkBitmap *mask;
				if(j==0||j==4)
					gtk_clist_get_pixtext((GtkCList *)chinput_clist, i, j, &tmpitem[j], &spacing, &pixmap, &mask);
				else
        				gtk_clist_get_text((GtkCList *)chinput_clist, i, j, &tmpitem[j]);
			}
			if(!strcmp(tmpitem[0], " ") && 
			   !strcmp(tmpitem[4], item[4])){
				set_pixmap(i, 0, "");
				break;
			}

		}
	}
	if(flag_action == 1){	//edit action
		for(i=0; i<MAX_ITEM; i++){
			gtk_clist_set_text((GtkCList *)chinput_clist, cur_row, i, item[i]);
			if((i==0 || i==4) &&!strcmp(item[i], " ")) 
				set_pixmap(cur_row, i, " ");
		}
	} else {		//append action
		gtk_clist_append((GtkCList *)chinput_clist, item);
		if(!strcmp(item[0], " ")) set_pixmap(cur_row, 0, " ");
		if(!strcmp(item[4], " ")) set_pixmap(cur_row, 4, " ");
		total_rows ++;
	}

	gtk_widget_destroy(win_edit);
	
}


static void edit_cancel(GtkWidget *w, gpointer data)
{
	gtk_widget_destroy(win_edit);
}

static void toggle_default(GtkWidget *w, gpointer data)
{
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w)))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(item_favorite), TRUE);
}

static void toggle_favorite(GtkWidget *w, gpointer data)
{
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(item_default)))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(item_favorite), TRUE);
}

static void ime_real_edit(gchar *item[])
{
	GtkWidget *vb, *separator, *hb, *bok, *bcancel;

	//popup a window and edit the ime
	win_edit = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_title(GTK_WINDOW(win_edit), _("Edit IME"));
	gtk_signal_connect(GTK_OBJECT(win_edit), "destroy",
                   GTK_SIGNAL_FUNC(gtk_widget_destroy), &win_edit);
	gtk_window_set_position(GTK_WINDOW(win_edit), GTK_WIN_POS_MOUSE);
	gtk_widget_show(win_edit);

	vb = gtk_vbox_new(FALSE, 5);
        gtk_container_add(GTK_CONTAINER(win_edit), vb);

	item_default = gtk_check_button_new_with_label(_("Default"));
	gtk_signal_connect(GTK_OBJECT(item_default), "toggled",
		GTK_SIGNAL_FUNC(toggle_default), NULL);
	gtk_box_pack_start(GTK_BOX(vb), item_default, FALSE, TRUE, 0);
	if(strcmp(item[0], ""))
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(item_default), TRUE);
	gtk_widget_show(item_default);
	add_label_entry(vb, &item_name, _("Index:"), item[1], &tips_name, _("Input method name for indexing."));
	add_label_entry(vb, &item_namehz, _("Chinese Name:"), item[2], &tips_namehz, _("Input method name in pinyin for message translation."));
	add_label_entry(vb, &item_encoding, _("Encoding:"), item[3], &tips_encoding, _("Encoding of current input method, which should be GB or BIG5"));
	item_favorite = gtk_check_button_new_with_label(_("Favorite"));
	gtk_signal_connect(GTK_OBJECT(item_favorite), "toggled",
		GTK_SIGNAL_FUNC(toggle_favorite), NULL);
        gtk_box_pack_start(GTK_BOX(vb), item_favorite, FALSE, TRUE, 0);
        if(strcmp(item[4], ""))
                gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(item_favorite), TRUE);
	gtk_widget_show(item_favorite);
	add_label_entry(vb, &item_fname, _("File Name:"), item[5], &tips_fname, _("File name the input method will load in."));
	add_label_entry(vb, &item_module, _("Module:"), item[6], &tips_module, _("Module path and name of current input method."));

        //separator
        separator = gtk_hseparator_new();
        gtk_box_pack_start(GTK_BOX(vb), separator, FALSE, FALSE, 5);
        gtk_widget_show(separator);

        //hbox
        hb = gtk_hbox_new(TRUE, 0);
        gtk_box_pack_start(GTK_BOX(vb), hb, FALSE, FALSE, 5);
        gtk_widget_show(hb);
        //add three buttons
        bok = gtk_button_new_with_label(_("OK"));
        gtk_signal_connect_object(GTK_OBJECT(bok), "clicked",
                GTK_SIGNAL_FUNC(edit_ok), NULL);
        gtk_box_pack_start(GTK_BOX(hb), bok, TRUE, TRUE, 5);
        gtk_widget_show(bok);
        bcancel = gtk_button_new_with_label(_("Cancel"));
        gtk_signal_connect_object(GTK_OBJECT(bcancel), "clicked",
                GTK_SIGNAL_FUNC(edit_cancel), NULL);
        gtk_box_pack_start(GTK_BOX(hb), bcancel, TRUE, TRUE, 5);
        gtk_widget_show(bcancel);
	
	gtk_widget_show(vb);
}

static void ime_edit(GtkWidget *w, gpointer data)
{
	int i;
        gchar *item[MAX_ITEM];
	guint8 spacing;
	GdkPixmap *pixmap;
	GdkBitmap *mask;

	for(i=0; i<MAX_ITEM; i++){
		if(i==0 ||i==4){
			gtk_clist_get_pixtext((GtkCList *)chinput_clist, cur_row, i, &item[i], &spacing, &pixmap, &mask);
		} else {
        		gtk_clist_get_text((GtkCList *)chinput_clist, cur_row, i, &item[i]);
		}
	}
	flag_action = 1;
	ime_real_edit(item);
}

static void ime_add(GtkWidget *w, gpointer data)
{
        gchar *item[MAX_ITEM] = {"", "", "", "", "", "", ""};

	flag_action = 2;
	ime_real_edit(item);

}
static void ime_del(GtkWidget *w, gpointer data)
{
	int i;
	gchar *item[MAX_ITEM];
	int val;

	val = yesno(_("Are you sure to delete current input method?"));
	if(val == 0) return;

	if(total_rows < 1) return;
	//if a default item removed, warn the user
	for(i=0; i<MAX_ITEM; i++)
        	gtk_clist_get_text((GtkCList *)chinput_clist, cur_row, i, &item[i]);
	if(!strcmp(item[0], " ")){
		printf(_("You are removing an item as the default ime.\n"));
		return;
	}

	//delete current entry
	gtk_clist_remove(GTK_CLIST(chinput_clist), cur_row);
	gtk_clist_select_row((GtkCList *)chinput_clist, 0, 0);
	total_rows --;
}

static void add_styles(GtkWidget *parent)
{
	GtkWidget *vb;
	vb = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent), vb);
	gtk_widget_show(vb);

	//add three check buttons
	chinput_style = gtk_check_button_new_with_label(_("Caret Mode"));
	gtk_box_pack_start(GTK_BOX(vb), chinput_style, FALSE, TRUE, 0);
	if(chinputrc.dmode == HZSERVER_DMODE_OVERSPOT)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chinput_style), TRUE);
	gtk_widget_show(chinput_style);
	tips_style = gtk_tooltips_new();
	gtk_tooltips_set_tip(tips_style, chinput_style, _("XIM input style: either Caret mode or Root mode."), "");

	chinput_autohide = gtk_check_button_new_with_label(_("Input Bar Autohide"));
	if(chinputrc.hmode == HZSERVER_HMODE_AUTO)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chinput_autohide), TRUE);
	gtk_box_pack_start(GTK_BOX(vb), chinput_autohide, FALSE, TRUE, 0);
	gtk_widget_show(chinput_autohide);

	tips_autohide = gtk_tooltips_new();
	gtk_tooltips_set_tip(tips_autohide, chinput_autohide, _("Input bar will hide automatically if there is no character in the inputbar."), "");
	chinput_showime = gtk_check_button_new_with_label(_("Show IME in Input Bar"));
	if(chinputrc.showime == 1)
		gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(chinput_showime), TRUE);
	gtk_box_pack_start(GTK_BOX(vb), chinput_showime, FALSE, TRUE, 0);
	gtk_widget_show(chinput_showime);
	
	tips_showime = gtk_tooltips_new();
	gtk_tooltips_set_tip(tips_showime, chinput_showime, _("Displaying input method name in the inputbar when there is no character in it."), "");
}
/*
static void add_misc(GtkWidget *parent)
{
	GtkWidget *vb;
	char width[10];
	sprintf(width, "%d", chinputrc.width);

	vb = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent), vb);

	add_label_entry(vb, &chinput_dictionary, _("Dictionary Path:"), chinputrc.dictionary, &tips_dictionary, _("The dictionary path of input method. In this directory, input methods are divided into GB and Big5 encoding, and put into these dirctories"));
	add_label_entry(vb, &chinput_width, _("Inputbar Width:"), width, &tips_width, _("The horizontal input bar width."));
	add_label_entry(vb, &chinput_dimcolor, _("Dim Color:"), chinputrc.dimcolor, &tips_dimcolor, _("The shadow color of input bar and other windows."));
	add_label_entry(vb, &chinput_lightcolor, _("Light Color:"), chinputrc.lightcolor, &tips_lightcolor, _("The light color of input bar and other windows."));
	add_label_entry(vb, &chinput_panelcolor, _("Panel Color:"), chinputrc.panelcolor, &tips_panelcolor, _("The panel color of input bar and other windows, it would be better if the color sits between dim color and light color."));
	add_label_entry(vb, &chinput_hzcolor, _("Chinese Color:"), chinputrc.hzcolor, &tips_hzcolor, _("Chinese color in input bar and other windows."));
	add_label_entry(vb, &chinput_ledcolor, _("Led Color:"), chinputrc.ledcolor, &tips_ledcolor, _("Led color of power switch of root input window"));
	add_label_entry(vb, &chinput_barcolor, _("Bar Color:"), chinputrc.barcolor, &tips_barcolor, _("Title bar color of virtual keyboard and handwriting recognition window."));
	add_label_entry(vb, &chinput_font, _("Western Font:"), chinputrc.font, &tips_font, _("Western font, usually 8x16 can fit the current panel."));
	add_label_entry(vb, &chinput_fontgb, _("GB Font:"), chinputrc.gbfont, &tips_fontgb, _("Chinese GB font, usually 16x16 can fit the current panel."));
	add_label_entry(vb, &chinput_fontbig5, _("Big5 Font:"), chinputrc.big5font, &tips_fontbig5, _("Chinese Big5 font, usually 15x16 or 16x16 can fit the current panel."));
	gtk_widget_show(vb);
}

static void add_hwtimeout(GtkWidget *parent)
{
	GtkWidget *vb;
	char timeout[10];

	sprintf(timeout, "%d", chinputrc.hwtimeout);
	vb = gtk_vbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(parent), vb);
	add_label_entry(vb, &chinput_hwtimeout, _("Timeout(ms):"), timeout, &tips_hwtimeout, _("Timeout of handwriting recognition in miliseconds."));
	gtk_widget_show(vb);
}
*/

void selection_made( GtkWidget      *clist,
                     gint            row,
                     gint            column,
                     GdkEventButton *event,
                     gpointer        data )
{
    cur_row = row;
}

void create_page1(GtkWidget *notebook, char *label)
{
	GtkWidget *child;
	GtkWidget *l;
	GtkWidget *frame_dictpath, *frame_fonts, *frame_color;
	GtkWidget *label_dictpath, *label_fonts, *label_color;
	GtkWidget *v, *vbox;
	
	child = gtk_frame_new(label);
	gtk_widget_set_usize(child,  640, 480);
	gtk_container_set_border_width(GTK_CONTAINER(child), 10);
	gtk_widget_show(child);

	//vbox 
	v = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(child), v);
	gtk_widget_show(v);

	//dictionary
	frame_dictpath = gtk_frame_new(_("Dictionary Path"));
	gtk_box_pack_start(GTK_BOX(v), frame_dictpath, TRUE, TRUE, 0);
	gtk_widget_show(frame_dictpath);

	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(frame_dictpath), vbox);
	gtk_widget_show(vbox);

	label_dictpath = gtk_label_new(_("Dictionary path of Chinput. Chinput now share the same dictionary as unicon, please specify the path if you installed the dictionary in a new place."));
	gtk_label_set_line_wrap(label_dictpath, TRUE);
	gtk_box_pack_start(GTK_BOX(vbox), label_dictpath, TRUE, TRUE, 0);
	gtk_widget_show(label_dictpath);

	add_label_entry_notips(vbox, &chinput_dictionary, _("Dictionary Path:"), chinputrc.dictionary);

	//fonts
	frame_fonts = gtk_frame_new(_("Fonts"));
	gtk_box_pack_start(GTK_BOX(v), frame_fonts, TRUE, TRUE, 0);
	gtk_widget_show(frame_fonts);

	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(frame_fonts), vbox);
	gtk_widget_show(vbox);

	label_fonts = gtk_label_new(_("Fonts the input server used"));
	gtk_box_pack_start(GTK_BOX(vbox), label_fonts, TRUE, TRUE, 0);
	gtk_label_set_line_wrap(label_fonts, TRUE);
	gtk_widget_show(label_fonts);

	add_label_entry_notips(vbox, &chinput_font, _("Western Font:"), chinputrc.font);
	add_label_entry_notips(vbox, &chinput_fontgb, _("GB Font:"), chinputrc.gbfont);
	add_label_entry_notips(vbox, &chinput_fontbig5, _("Big5 Font:"), chinputrc.big5font);

	//color
	frame_color = gtk_frame_new(_("Color"));
	gtk_box_pack_start(GTK_BOX(v), frame_color, TRUE, TRUE, 0);
	gtk_widget_show(frame_color);

	vbox = gtk_vbox_new(FALSE, 5);
	gtk_container_add(GTK_CONTAINER(frame_color), vbox);
	gtk_widget_show(vbox);

	label_color = gtk_label_new(_("Input server colors"));
	gtk_box_pack_start(GTK_BOX(vbox), label_color, TRUE, TRUE, 0);
	gtk_label_set_line_wrap(label_color, TRUE);
	gtk_widget_show(label_color);

	add_label_entry_notips(vbox, &chinput_dimcolor, _("Dim Color:"), chinputrc.dimcolor);
	add_label_entry_notips(vbox, &chinput_lightcolor, _("Light Color:"), chinputrc.lightcolor);
	add_label_entry_notips(vbox, &chinput_panelcolor, _("Panel Color:"), chinputrc.panelcolor);
	add_label_entry_notips(vbox, &chinput_hzcolor, _("Chinese Color:"), chinputrc.hzcolor);
	add_label_entry_notips(vbox, &chinput_ledcolor, _("Led Color:"), chinputrc.ledcolor);
	add_label_entry_notips(vbox, &chinput_barcolor, _("Bar Color:"), chinputrc.barcolor);


	l = gtk_label_new(label);
	gtk_widget_show(l);

	gtk_notebook_append_page(notebook, child, l);
}
void create_page2(GtkWidget *notebook, char *label)
{
	GtkWidget *child;
	GtkWidget *l;

	child = gtk_frame_new(label);
	gtk_container_set_border_width(GTK_CONTAINER(child), 10);
	gtk_widget_show(child);

	l = gtk_label_new(label);
	gtk_widget_show(l);

	gtk_notebook_append_page(notebook, child, l);
}
void create_page3(GtkWidget *notebook, char *label)
{
	GtkWidget *child;
	GtkWidget *l;
        GtkWidget *vb;
        char timeout[10];

	child = gtk_frame_new(label);
	gtk_container_set_border_width(GTK_CONTAINER(child), 10);
	gtk_widget_show(child);

        sprintf(timeout, "%d", chinputrc.hwtimeout);
        vb = gtk_vbox_new(FALSE, 0);
        gtk_container_add(GTK_CONTAINER(child), vb);
        add_label_entry_notips(vb, &chinput_hwtimeout, _("Timeout(ms):"), timeout);
        gtk_widget_show(vb);


	l = gtk_label_new(label);
	gtk_widget_show(l);

	gtk_notebook_append_page(notebook, child, l);
}
void create_page4(GtkWidget *notebook, char *label)
{
	GtkWidget *child;
	GtkWidget *l;

	child = gtk_frame_new(label);
	gtk_container_set_border_width(GTK_CONTAINER(child), 10);
	gtk_widget_show(child);

	l = gtk_label_new(label);
	gtk_widget_show(l);

	gtk_notebook_append_page(notebook, child, l);
}
void create_page5(GtkWidget *notebook, char *label)
{
	GtkWidget *child;
	GtkWidget *l;
	GtkWidget *scrollwin;
	GtkWidget *vc2h, *vc2;
	GtkWidget *button_add, *button_del, *button_edit;
        int flag_invalid = 0;
        
        titles[0] = _("Default");
        titles[1] = _("Index");                                                         titles[2] = _("Chinese Name");
        titles[3] = _("Encoding");
        titles[4] = _("Favorite");
        titles[5] = _("File");
        titles[6] = _("Module");


	child = gtk_frame_new(label);
	gtk_container_set_border_width(GTK_CONTAINER(child), 10);
	gtk_widget_show(child);

        //add right part
        vc2 = gtk_vbox_new(FALSE, 10);
        gtk_container_add(GTK_CONTAINER(child), vc2);
        gtk_widget_show(vc2);

        //add clist(in a scrolled window)
        scrollwin = gtk_scrolled_window_new (NULL, NULL);
        gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrollwin),
                //GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
	gtk_box_pack_start(GTK_BOX(vc2), scrollwin, TRUE, TRUE, 5);
        gtk_widget_show(scrollwin);
        chinput_clist = gtk_clist_new_with_titles(MAX_ITEM, titles);
        gtk_clist_set_shadow_type (GTK_CLIST(chinput_clist), GTK_SHADOW_OUT);
        //gtk_clist_set_column_width (GTK_CLIST(chinput_clist), 1, 250);
        gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrollwin), chinput_clist);
        if(add_list(chinput_clist)) flag_invalid = 1;
        gtk_clist_select_row((GtkCList *)chinput_clist, cur_row, 0);
        gtk_signal_connect(GTK_OBJECT(chinput_clist), "select_row",
               GTK_SIGNAL_FUNC(selection_made), NULL);
        gtk_widget_show(chinput_clist);

        //add buttons
        vc2h = gtk_hbox_new(FALSE, 0);
        gtk_box_pack_start(GTK_BOX(vc2), vc2h, FALSE, TRUE, 5);
        gtk_widget_show(vc2h);

        button_add = gtk_button_new_with_label(_("Add Input Method"));
        gtk_signal_connect_object(GTK_OBJECT(button_add), "clicked",
                GTK_SIGNAL_FUNC(ime_add), NULL);
        gtk_box_pack_start(GTK_BOX(vc2h), button_add, TRUE, TRUE, 5);
        gtk_widget_show(button_add);
        button_del = gtk_button_new_with_label(_("Delete Input Method"));
        gtk_signal_connect_object(GTK_OBJECT(button_del), "clicked",
                GTK_SIGNAL_FUNC(ime_del), NULL);
        gtk_box_pack_start(GTK_BOX(vc2h), button_del, TRUE, TRUE, 5);
        gtk_widget_show(button_del);
        button_edit = gtk_button_new_with_label(_("Edit Input Method"));
        gtk_signal_connect_object(GTK_OBJECT(button_edit), "clicked",
                GTK_SIGNAL_FUNC(ime_edit), NULL);
        gtk_box_pack_start(GTK_BOX(vc2h), button_edit, TRUE, TRUE, 5);
        gtk_widget_show(button_edit);


	l = gtk_label_new(label);
	gtk_widget_show(l);

	gtk_notebook_append_page(notebook, child, l);
}

void menubar_manage(GtkWidget *w, gpointer data)
{
	GtkWidget *hc, *paned, *vc1, *vc2;
	GtkWidget *f1, *f2, *f3, *scrollwin, *vc2h;
	GtkWidget *separator;
	GtkWidget *vbox, *hbox;
	GtkWidget *button_default, *button_rescan,*button_apply, *button_cancel;
	GtkWidget *button_add, *button_del, *button_edit;
	GtkWidget *notebook;
	int flag_invalid = 0;

	titles[0] = _("Default");
	titles[1] = _("Index");
	titles[2] = _("Chinese Name");
	titles[3] = _("Encoding");
	titles[4] = _("Favorite");
	titles[5] = _("File");
	titles[6] = _("Module");
	total_rows = index_ime;

	if(window) return;
	//create the window
	window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	gtk_window_set_policy(GTK_WINDOW(window), TRUE, TRUE, FALSE);
	gtk_signal_connect(GTK_OBJECT(window), "destroy",
                GTK_SIGNAL_FUNC(gtk_widget_destroyed), &window);
	gtk_window_set_title(GTK_WINDOW(window), _("Chinput Managment"));
	gtk_container_set_border_width(GTK_CONTAINER(window), 10);
	gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
	gtk_widget_show(window);

	vbox = gtk_vbox_new(FALSE, 5);
        gtk_container_add(GTK_CONTAINER(window), vbox);
        gtk_widget_show(vbox);


	//create notebook
	notebook = gtk_notebook_new();
	gtk_notebook_set_tab_pos(GTK_NOTEBOOK(notebook), GTK_POS_TOP);
	gtk_box_pack_start(GTK_BOX(vbox), notebook, TRUE, TRUE, 0);
	//gtk_container_set_border_width(GTK_CONTAINER(notebook), 10);
	gtk_widget_show(notebook);

	create_page1(notebook, _("General"));
	create_page2(notebook, _("Styles"));
	create_page3(notebook, _("Handwriting"));
	create_page4(notebook, _("Voice"));
	create_page5(notebook, _("Input Method"));
/*
	//horizontal container
	hc = gtk_hbox_new(FALSE, 10);
	gtk_box_pack_start(GTK_BOX(vbox), hc, TRUE, TRUE, 5);
	gtk_widget_show(hc);

	//paned
	paned = gtk_hpaned_new ();
	gtk_box_pack_start(GTK_BOX(hc), paned, TRUE, TRUE, 5);
	gtk_container_set_border_width(GTK_CONTAINER(paned), 10);
	gtk_widget_show(paned);


	//add left part
	vc1 = gtk_vbox_new(FALSE, 10);
	//gtk_box_pack_start(GTK_BOX(hc), vc1, FALSE, TRUE, 0);
	gtk_paned_add1(GTK_PANED(paned), vc1);
	gtk_widget_show(vc1);

	//add frames
	f1 = gtk_frame_new(NULL);
	gtk_frame_set_label(GTK_FRAME(f1), _("Input Server Style"));
	gtk_box_pack_start(GTK_BOX(vc1), f1, TRUE, TRUE, 0);
	add_styles(f1);
	gtk_widget_show(f1);

	f2 = gtk_frame_new(NULL);
	gtk_frame_set_label(GTK_FRAME(f2), _("Input Server Misc"));
	gtk_box_pack_start(GTK_BOX(vc1), f2, TRUE, TRUE, 0);
	add_misc(f2);
	gtk_widget_show(f2);

	f3 = gtk_frame_new(NULL);
	gtk_frame_set_label(GTK_FRAME(f3),_("Handwriting Recognition Timeout"));
	gtk_box_pack_start(GTK_BOX(vc1), f3, TRUE, TRUE, 0);
	add_hwtimeout(f3);
	gtk_widget_show(f3);

	//add right part
	vc2 = gtk_vbox_new(FALSE, 10);
        //gtk_box_pack_start(GTK_BOX(hc), vc2, TRUE, TRUE, 0);
	gtk_paned_add2(GTK_PANED(paned), vc2);
        gtk_widget_show(vc2);

	//add clist(in a scrolled window)
	scrollwin = gtk_scrolled_window_new (NULL, NULL);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrollwin),
                //GTK_POLICY_ALWAYS, GTK_POLICY_ALWAYS);
                GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
        gtk_box_pack_start(GTK_BOX(vc2), scrollwin, TRUE, TRUE, 0);
        gtk_widget_show(scrollwin);
        chinput_clist = gtk_clist_new_with_titles(MAX_ITEM, titles);
        gtk_clist_set_shadow_type (GTK_CLIST(chinput_clist), GTK_SHADOW_OUT);
        //gtk_clist_set_column_width (GTK_CLIST(chinput_clist), 1, 250);
        gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrollwin), chinput_clist);
	if(add_list(chinput_clist)) flag_invalid = 1;
	gtk_clist_select_row((GtkCList *)chinput_clist, cur_row, 0);
	gtk_signal_connect(GTK_OBJECT(chinput_clist), "select_row",
               GTK_SIGNAL_FUNC(selection_made), NULL);
        gtk_widget_show(chinput_clist);

	//add buttons
	vc2h = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start(GTK_BOX(vc2), vc2h, FALSE, TRUE, 5);
	gtk_widget_show(vc2h);

	button_add = gtk_button_new_with_label(_("Add Input Method"));
        gtk_signal_connect_object(GTK_OBJECT(button_add), "clicked",
                GTK_SIGNAL_FUNC(ime_add), NULL);
        gtk_box_pack_start(GTK_BOX(vc2h), button_add, TRUE, TRUE, 5);
        gtk_widget_show(button_add);
	button_del = gtk_button_new_with_label(_("Delete Input Method"));
        gtk_signal_connect_object(GTK_OBJECT(button_del), "clicked",
                GTK_SIGNAL_FUNC(ime_del), NULL);
        gtk_box_pack_start(GTK_BOX(vc2h), button_del, TRUE, TRUE, 5);
        gtk_widget_show(button_del);
	button_edit = gtk_button_new_with_label(_("Edit Input Method"));
        gtk_signal_connect_object(GTK_OBJECT(button_edit), "clicked",
                GTK_SIGNAL_FUNC(ime_edit), NULL);
        gtk_box_pack_start(GTK_BOX(vc2h), button_edit, TRUE, TRUE, 5);
        gtk_widget_show(button_edit);
*/
	//separator
	separator = gtk_hseparator_new();
	gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 5);
	gtk_widget_show(separator);

	//hbox
	hbox = gtk_hbox_new(TRUE, 0);
	gtk_box_pack_start(GTK_BOX(vbox), hbox, FALSE, FALSE, 5);
	gtk_widget_show(hbox);
	//add three buttons
	button_default = gtk_button_new_with_label(_("Set Default"));
	gtk_signal_connect_object(GTK_OBJECT(button_default), "clicked",
                GTK_SIGNAL_FUNC(set_default), NULL);
        gtk_box_pack_start(GTK_BOX(hbox), button_default, TRUE, TRUE, 5);
	gtk_widget_show(button_default);

	button_rescan = gtk_button_new_with_label(_("Rescan"));
	gtk_signal_connect_object(GTK_OBJECT(button_rescan), "clicked",
                GTK_SIGNAL_FUNC(set_rescan), NULL);
        gtk_box_pack_start(GTK_BOX(hbox), button_rescan, TRUE, TRUE, 5);
	gtk_widget_show(button_rescan);

	button_apply = gtk_button_new_with_label(_("Save"));
	gtk_signal_connect_object(GTK_OBJECT(button_apply), "clicked",
                GTK_SIGNAL_FUNC(set_apply), NULL);
        gtk_box_pack_start(GTK_BOX(hbox), button_apply, TRUE, TRUE, 5);
	gtk_widget_show(button_apply);

	button_cancel = gtk_button_new_with_label(_("Cancel"));
	gtk_signal_connect_object(GTK_OBJECT(button_cancel), "clicked",
                GTK_SIGNAL_FUNC(set_cancel), NULL);
        gtk_box_pack_start(GTK_BOX(hbox), button_cancel, TRUE, TRUE, 5);
	gtk_widget_show(button_cancel);
	if(flag_invalid){
		warning(_("You have defined some invalid input methods in your resource file!"));
	}
}

