/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <signal.h>
#include <string.h>
#include <sys/ioctl.h>
#include <malloc.h>
#include <locale.h>
#include <libintl.h>
#include <gtk/gtk.h>
#include <time.h>

#include "icons/information.xpm"

#define _(String)  gettext(String)
#define N_(String)  gettext(String)
#define __(String) (String)

extern GtkWidget *pixlabel(GtkWidget *w, char **pixdata, char *title);
void create_tips_window();
static GtkWidget *tipswindow = NULL;
static GtkWidget *tips;
/*
static char *zwintips[] = {
//zwinpro
"TL-ZWinPro    ʽ   ƽ ̨,               λ     ",
"TL-ZWinPro   ̳  http://turbolinux.com.cn/ZWinPro/index.html",
"TL-ZWinPro  Ŀ ǰ Ψ һ ֧   Ļ ȡ   Linux     ƽ ̨",
"TL-ZWinPro   ץ ȡ Ӣ       /",
"  Alt      ,  ץ ȡ  Ļ    ",
"TL-ZWinPro     KDE  GNOME  Applet      ",
"TL-ZWinPro, CLE, CLEEX, zhXwin, LXCS  ʹ      ʽ ,    X ϵ ͳ      ",
"TL-ZWinPro   Դ  /usr/lib/ZWinPro/ZWinPro.ad        ",
"TL-ZWinPro ʹ  Chinput      ",
"TL-ZWinPro               (Ŀ ǰ ֻ  TL-ZWinPro  CLEEX ֧    )",
"TL-ZWinPro ʹ  TrueType         ʾ(Ŀ ǰ ֻ  TL-ZWinPro,CLE  CLEEX ֧    )",
"TL-ZWinPro        ʾ Ϊ    ʾ,     ʾ     ʾ   ƥ ",
"TL-ZWinPro   ĳ      , chinput Ҳ        ",
"TL-ZWinPro ֧      (Ŀ ǰ ֻ  TL-ZWinPro,CLE  CLEEX ֧ )",
"X Window ϵ ͳ     ,  X          ",
" ֧  Locale  Linux ϵ ͳ     Ϊ  ȫ    ϵ ͳ",
"TL-ZWinPro û  ֱ    X    ,  Ϊ   Xlib      ϵ ͳ   ",
"TL-ZWinPro û  ֱ    X   ,  Ϊ   Xlib         ͬ ʱ      ",
"  TL-ZWinPro      X         ,   ռ     Դ",
"TL-ZWinPro   Java  ȡ  ר   ,    Java    /  ʾ  ",
"TL-ZWinPro      ǰ     Lesstif,      gtk",
"TL-ZWinPro ֧  GBK  ",
"TL-ZWinPro            zwinpro",
"              zwincontrol",
"TL-ZWinPro    ʵ      zwincontrol, chinput  edict",
"TL-ZWinPro     ֲ  С  ñ ",

//dict
"  ץ        Control        ץ  ",
"  ץ                edict &",


//chinput
"    Chinput,         chinput &",
"Chinput     ֧  XIM    ׼",
"ʹ  Chinput    rxvt ʱ, rxvt     Ϊ rxvt -im Chinput -pt Root",
"Chinput  ʹ         ϵ ͳ,            ƽ ̨   ",
"Control-space     /     ",
"Chinput        1996     ,    ftp://ftp.ifcss.org/pub/software/ ",
"Chinput  F3 / Shift-F3    °     ȡ ",
"Chinput     ʹ    -one          ģ ʽ, -two    ˫   ʾ ģ ʽ",
"    Chinput ֧  ȫ  /             ",
"Chinput          ZhenChun Li    ƴ ",
"Chinput ÿ ʮ     һ    ƴ      ",
"Chinput           ͬ   GB  Big5  ",
"Chinput        ʱ,      ѭ    ",
"Chinput  ϵ ͳ  Դ   Ϊ /usr/lib/ZWinPro/Chinput.ad,    Դ   Ϊ ~/.chinput",
"Chinput        ʱ  ",
"F1        /  ֹ Chinput     ",
"F2-F8   Shift/Alt F2-F8          ", 
"Chinput  ʹ      -- 16    24  ",
" ʹ  CXterm ʱ    Chinput  ",
"      ļ ʱ ͬ ʱ   GB  Big5 ,       ͨ      ",

//i18n
"i18n  internationalization (  )   д",
"l10n  localization (  )  д",
"g11n  globalization  д",
"   Ҫ      ʾ ,     ӡ   ",
"GPL  General Public License   д",
"        ʱ ,  Ҫ  ԭ    License    ɾ ,   ѭ GPL",

//turbolinux
"TurboLinux            Linux ϵ ͳ,        FTP վ  ",
"TurboLinux ֧  codepage 936/950,    MSWindow ϵ ͳ     ,        һ  ",
"TurboLinux  codepage      ʵ ,     ʵ  GBK codepage ",
"TurboLinux ֧    Postscript  ӡ,      Linux ϵ ͳ   Ҫ    ",
"TurboLinux    Postscript  ӡ        ,   ʵ     GB/Big5/GBK  PS  ӡ",
"TurboLinux   ʹ   netscape  ֱ   ӡ   ҳ ",
"TurboLinux   ʹ   ӡ   GB/Big5/GBK    ",
"TurboLinux ֧  GBK  ",
"TurboLinux    ʹ      TrueType    14    ʾ  ",
"TurboLinux ֧  GB/Big5/GBK Locale",
"TurboLinux  Applixware         ",
"TurboLinux ʹ       xdict,    Ӣ   .      Linux ϵ ͳ   ־ ֮ һ",
"TurboLinux     ע   ˾ Ϊ   ˼      ˾",
"  Linux          ʾ,  װ TurboLinux    λ   ,    С  ñ", 
"TurboLinux    /      ,   Server/Enterprise Server/Cluster Server  ",
"TurboLinux ֧  չ ʾ  ,     mgp  TurboLinux С   , ֧  TrueType  ",

//tricks
"jvim     CXterm      ",
"xv     ץ ͼ, ץ    Ļ ʱ      ",
"xpaint    MSWindow   paint",
" xterm          ʹ  Shift + PgUp/PgDn",
"    ʱ,   ʹ  minicom   expect/send   ",
"   ʹ    ͷ        ,  ʹ  tcsh",
"sleep         һ  ʱ    ִ     ",
"cat       .au  ,  ʽ Ϊ cat file.au > /dev/audio",
"cd $owd   ת       Ŀ ¼",
"   Ļ     ʱ,   reset    ",
"egrep   ʹ      ʽ  ",
"kill -HUP       ĳ Щ  ",
" ʹ  more     ʱ,    control-b    ҳ",
"ɾ  LILO,    DOS     ,  FDISK /MBR ɾ ",
" limit coredumpsize 0 (tcsh)     core   С",
"rpm2targz    rpm  ת   tar.gz ",
"wget  Linux          ",
"  ʹ  locate   ׼ ȷ    ,     updatedb     ",
"ʹ  xterm -fn 12x24           ",
"ʹ  CXterm -fn 12x24 -fh ccs24           ",
"          ȷ,   ʹ  xkeycaps  ӳ   ",
"Control + Alt + BackSpace     XWindow",
" X    24 λ  ɫ     ʹ  startx -- -bpp 24",
"  X       800x600, ʹ  100dpi   Ч   ",
"  ʹ    ƽ ̨ ʱ,        LD_PRELOAD ȥ ,  ִ   ;   ʹ  run_nohz",
"XessLite  һ        ǿ        ֧        ӡ",
" Linux  Ҳ    VCD,      Ϊ mtv,xreadvcd",
" Linux  Ҳ   ʹ       ",
"Linux  Ҳ  DOOM(lxdoom/lsdoom),  X ģ ʽ  SVGA ģ ʽ,    ͨ     ս",
"GIMP -   ǿ   ͼ     ,  TL-ZWinPro  ֧  TrueType  ",
"GIMP   ʹ  Wacom  д ",
"ת  GB  Big5     ʹ  g2b  b2g",
"gifmerge     GIF  , gifdisect    GIF       ͼ Ƭ ",
"      ʱ , ʹ  Control-a        ",
"ʹ  kppp   ʱ         ",
"IBM       ʶ     ֲ   Linux ",
"ͨ  X Swallow    netscape    X  ",
"    Linux û   װ    , Ҳ   ͨ    ʹ    Linux    , xset fp+ tcp/remotehost:port",
"a2ps        ת   PS    ӡ,    ",
"psnup   ʹ   һ ҳ ֽ   ӡ  ҳ PS",
"ʹ        ճ    (        ,     ͬ ʱ  )",
"  shell  ʹ  tab    ʹ       Ŀ ¼    ",
"  shell ,          ʹ  Control-d  ʾ ĳ Ŀ ¼   ƥ    ",
"ʹ  tar ztvf file.tar.gz ֻ      ",
"ʹ  unzip -l file.zip ֻ      ",
"ɾ  DOS    ^M  ʹ    sed 's/^V^M//g' oldfile > newfile",

//programming
"gtk ֧    ,            ",
"gtk  ֧  unicode",
"Qt2.0 ֧    ",
"XForms   һ     ,     Դ  ",
"Kenton Lee    XWindow   ѯ ,    ҳ http://www.rahul.net/kenton/index.shtml   ǧ    X   ",

//homepages
"    http://freshmeat.net/      Linux  ",
"    http://slashdot.org/    Linux   ",
"    http://SAL.KachinaTech.COM/sal1.html   Linux    ѧ Ӧ   "
"˫ ţ http://www.tucows.com/ Ҳ    Linux    ",
};
*/

/*  Need to hardcode the MAXTIPS constant.  -ypwong
 #define MAXTIPS                (sizeof(zwintips)/sizeof(zwintips[0]))
*/
#define MAXTIPS		122

static int flag_browse = 0;
static int cur_item = 0;
static int prev_item = 0;

void menubar_tips()
{
	create_tips_window();
}

static void tips_next()
{
	int j;
        char zwintipID[15];     /* this variable will contain the msgid of
                                   the zwintip that will be displayed.
                                   --ypwong */

	if(flag_browse == 0){
		while((j =(int) ((float)MAXTIPS * rand()/(RAND_MAX+1.0)))==prev_item);
		prev_item = j;
		
	} else {
		j = cur_item;
		if(j == MAXTIPS) {
			j = 0;
			cur_item = 0;
		}
	}
    /*
	gtk_label_set_text(GTK_LABEL(tips), zwintips[j]);
    */
        /* construct the string.  --ypwong */
        sprintf(zwintipID, "zwintip%d", j+1);
	gtk_label_set_text(GTK_LABEL(tips), _(zwintipID));
	if(flag_browse == 1) cur_item ++;
}

static void checkbutton_cb(GtkWidget *w, void *data)
{
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w))){
		cur_item = 0;
		flag_browse = 1;
	} else {
		flag_browse = 0;
	}
}


void create_tips_window()
{
        GtkWidget *vbox, *hbox1, *hbox2, *bnext, *bclose, 
		*separator, *pix, *label, *checkbutton;
	GtkStyle *style;
        char zwintipID[15];     /* newly added.  --ypwong */
        if(!tipswindow){
		int j;

		srand(time(NULL));
		j=(int) ((float)MAXTIPS * rand()/(RAND_MAX+1.0));
                tipswindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
                gtk_widget_set_usize(tipswindow, 450, 300);
                gtk_window_set_policy(GTK_WINDOW(tipswindow),FALSE,FALSE,FALSE);
                gtk_signal_connect(GTK_OBJECT(tipswindow), "destroy",
                        GTK_SIGNAL_FUNC(gtk_widget_destroyed), &tipswindow);
                gtk_window_set_title(GTK_WINDOW(tipswindow), "TurboLinux ZWinPro Tips");
                gtk_container_set_border_width(GTK_CONTAINER(tipswindow), 10);

                vbox = gtk_vbox_new(FALSE, 15);
		gtk_container_set_border_width(GTK_CONTAINER(vbox), 15);
                gtk_container_add(GTK_CONTAINER(tipswindow), vbox);
                gtk_widget_show(vbox);

		hbox1 = gtk_hbox_new(FALSE, 0);
		gtk_box_pack_start(GTK_BOX(vbox), hbox1, FALSE, FALSE, 5);
		gtk_widget_show(hbox1);

		pix = pixlabel(tipswindow, icon_info, NULL);
		gtk_box_pack_start(GTK_BOX(hbox1), pix, FALSE, FALSE, 5);
		gtk_widget_show(pix);

		label = gtk_label_new(_("Do You Know?"));
		style = gtk_style_copy(GTK_WIDGET(label)->style);
		gdk_font_unref(style->font);
		/*  Don't specify the encoding because the user may
		 *  use either GB/GBK or Big5, or even others.  --ypwong */
		style->font = gdk_fontset_load("-adobe-times-medium-r-normal--24-*-*-*-*-*-iso8859-1,-*-*-medium-r-normal--24-*-*-*-*-*-*-*");
		gtk_widget_set_style(label, style);
		gtk_box_pack_start(GTK_BOX(hbox1), label,TRUE,TRUE,5);
		gtk_widget_show(label);

                separator = gtk_hseparator_new();
                gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 5);
                gtk_widget_show(separator);

		//tips
                sprintf(zwintipID, "zwintip%d", j+1);
                /*
		tips = gtk_label_new(zwintips[j]);
                */
		tips = gtk_label_new(_(zwintipID));
                gtk_box_pack_start(GTK_BOX(vbox), tips, TRUE, FALSE, 15);
		gtk_label_set_line_wrap(GTK_LABEL(tips), TRUE);
		gtk_widget_show(tips);

                separator = gtk_hseparator_new();
                gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 5);
                gtk_widget_show(separator);

		hbox2 = gtk_hbox_new(FALSE, 0);
                gtk_box_pack_start(GTK_BOX(vbox), hbox2, FALSE, FALSE, 5);
                gtk_widget_show(hbox2);

		checkbutton = gtk_check_button_new_with_label(_("Read in sequence"));
		gtk_box_pack_start(GTK_BOX(hbox2),checkbutton, FALSE, FALSE, 5);
		gtk_signal_connect(GTK_OBJECT(checkbutton), "toggled",
	                GTK_SIGNAL_FUNC(checkbutton_cb), NULL);
		gtk_widget_show(checkbutton);		

                bnext = gtk_button_new_with_label(_("Next"));
                gtk_signal_connect(GTK_OBJECT(bnext), "clicked",
                        GTK_SIGNAL_FUNC(tips_next), (gpointer)NULL);
		gtk_box_pack_start(GTK_BOX(hbox2), bnext, TRUE, TRUE, 5);
		//gtk_widget_set_usize(bnext, 80, 32);
		gtk_widget_show(bnext);

		bclose = gtk_button_new_with_label(_("Close window"));
                gtk_signal_connect_object(GTK_OBJECT(bclose), "clicked",
                        GTK_SIGNAL_FUNC(gtk_widget_destroy),
                        GTK_OBJECT(tipswindow));
		gtk_box_pack_start(GTK_BOX(hbox2), bclose, TRUE, TRUE, 5);
		//gtk_widget_set_usize(bclose, 80, 32);
		gtk_widget_show(bclose);

        }

        if(!GTK_WIDGET_VISIBLE(tipswindow))
                gtk_widget_show(tipswindow);
        else
                gtk_widget_destroy(tipswindow);
}

