/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <signal.h>
#include <string.h>
#include <sys/ioctl.h>
#include <locale.h>
#include <libintl.h>
#define _(String)  gettext(String)
#define N_(String)  gettext(String)
#define __(String) (String)

#include "defs.h"
#include "hzclient.h"
#include "chinput.h"
#include "hzserver.h"
#define  MAX_IMES	60

extern int flag_encoding;
extern chinput_ime chinputime[MAX_IMES];
extern chinput_rc  chinputrc;
extern int index_ime;

int write_resource_default(char *outfile)
{
	FILE *fp;
	char msg[256];

        fp = fopen(outfile, "w");
        if(!fp) {
		sprintf(msg, "Can not open file %s for writing!", outfile);
		warning(msg);
		return 0;
	}

	fprintf(fp, "\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! Resource file for Chinput-%s\n", VERSION);
	fprintf(fp, "!!! Generated by zwincontrol, Please do not edit by hand\n");
	fprintf(fp, "!\n");
	fprintf(fp, "\n");
	fprintf(fp, "!\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! locales\n");
	fprintf(fp, "!\n");
	
	fprintf(fp, "chinput.gblocale		=	zh_CN.GBK\n");
	fprintf(fp, "chinput.big5locale		=	zh_CN.GBK\n");
	fprintf(fp, "! input style: AUTO ROOT OVERSPOT ONSPOT OFFSPOT \n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.dmode		=	AUTO\n");

	fprintf(fp, "!\n");
	fprintf(fp, "! input window auto-hide mode AUTO or NO, only for CARET mode\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.hmode		=	NO\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! choice window auto popup mode: AUTO or NO, only for ONSPOT style\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.cmode           =       AUTO\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! area style for OFFSPOT style, CLIENT or SERVER\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.areamode        =       SERVER\n");

	fprintf(fp, "!\n");
	fprintf(fp, "! show input method in the input window\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.showime		=	YES\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! input method\n");
	fprintf(fp, "! for gb  : TONEPY, PY, CCDOSPY, WuBi, CangJie, English, CTLau, SW, \n");
	fprintf(fp, "!           QianMa, TeleCode, ZRM\n");
	fprintf(fp, "! for big5: PY, ETZY, ZOZY, Simplex, CangJie, \n");
	fprintf(fp, "!	    English, 4Corner, HSU, ARRAY30, Boshiamy\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.dictionary		=	/usr/local/lib/Chinput/im\n");
	fprintf(fp, "chinput.inputmethod.gb		=	ZNPY\n");
	fprintf(fp, "chinput.inputmethod.big5	=	PY\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! 16 point font set\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.font			=	8x16\n");
	fprintf(fp, "chinput.gbfont			=	-*-*-medium-r-normal--16-*-*-*-*-*-gbk-0\n");
	fprintf(fp, "chinput.big5font		=	-*-*-medium-r-normal--16-*-*-*-*-*-gbk-0\n");
	fprintf(fp, "!\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! inputbar width in chars\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.width	=	70\n");
	fprintf(fp, "\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! panel color \n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.dimcolor	=	#666666\n");
	fprintf(fp, "chinput.lightcolor	=	#f5f5f5\n");
	fprintf(fp, "chinput.panelcolor	=	#c0c0c0\n");
	fprintf(fp, "chinput.hzcolor		=	#000000\n");
	fprintf(fp, "chinput.ledcolor	=	#00ff00\n");
	fprintf(fp, "chinput.barcolor	=	#000080\n");
	fprintf(fp, "\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! handwriting recognition timeout\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.hwtimeout	=	1500\n");

	fprintf(fp, "!\n");
	fprintf(fp, "! Input Method read by chinput\n");
	fprintf(fp, "! Format: The following items should be in the correct order\n");
	fprintf(fp, "!         [Section] : Input Method, the same in chinput.inputmethod.gb\n");
	fprintf(fp, "!         NAMEGB    : Name for gettext\n");
	fprintf(fp, "!         NAMEBIG5  : Name appeared in input bar\n");
	fprintf(fp, "!         ENCODING  : Encoding for this IME, should be GB or BIG5\n");
	fprintf(fp, "!         FILE      : Where the input method file located, maybe absolute path\n");
	fprintf(fp, "!                     or relative to chinput.dictionary\n");
	fprintf(fp, "!         MODULE    : absolute path of module\n");
	fprintf(fp, "!         FAVORITE  : I like this input method\n");
	fprintf(fp, "!\n");

	//write input method
	fprintf(fp, "[ZNPY]\n");
	fprintf(fp, "IMENAME			=	ƴ\n");
	fprintf(fp, "IMENAME			=	\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	/usr/local/lib/Chinput/im/cce\n");
	fprintf(fp, "MODULE			=	/usr/local/lib/Chinput/im/cce_pinyin.so\n");
	fprintf(fp, "FAVORITE		=	YES\n");
	fprintf(fp, "\n");

	fprintf(fp, "[WSB]\n");
	fprintf(fp, "IMENAME			=	WIN˫ƴ\n");
	fprintf(fp, "IMENAME			=	GBK\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	gb/sp.tab\n");
	fprintf(fp, "MODULE			=	/usr/local/lib/Chinput/im/TL_hzinput.so\n");
	fprintf(fp, "FAVORITE		=	YES\n");
	fprintf(fp, "\n");
	fprintf(fp, "[CCPY]\n");
	fprintf(fp, "IMENAME			=	CCDOS˫ƴ\n");
	fprintf(fp, "IMENAME			=	Yg\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	gb/CCDOSPY.tab\n");
	fprintf(fp, "MODULE			=	/usr/local/lib/Chinput/im/TL_hzinput.so\n");
	fprintf(fp, "FAVORITE		=	YES\n");
	fprintf(fp, "\n");
	fprintf(fp, "[WuBi]\n");
	fprintf(fp, "IMENAME			=	\n");
	fprintf(fp, "IMENAME			=	r\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	gb/WuBi.tab\n");
	fprintf(fp, "MODULE			=	/usr/local/lib/Chinput/im/TL_hzinput.so\n");
	fprintf(fp, "FAVORITE		=	YES\n");
	
	fprintf(fp, "[GBK]\n");
	fprintf(fp, "IMENAME			=	GBKƴ\n");
	fprintf(fp, "IMENAME			=	r\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	gbk/gbkpy_mb.tab\n");
	fprintf(fp, "MODULE			=	/usr/local/lib/Chinput/im/TL_hzinput.so\n");
	fprintf(fp, "FAVORITE		=	YES\n");
	


	fclose(fp);
	return 1;
}

int write_resource(char *outfile)
{
	int i;
	FILE *fp;
	char msg[256];

        fp = fopen(outfile, "w");
        if(!fp){
		sprintf(msg, "Cannot open file %s for writing.\n", outfile);
		warning(msg);
		return 0;
	}

	fprintf(fp, "!!!\n");
	fprintf(fp, "!!! This file is part of\n");
	fprintf(fp, "!!!\n");
	fprintf(fp, "!!!                        TurboLinux  ZWinPro\n");
	fprintf(fp, "!!!\n");
	fprintf(fp, "!!!                 Copyright (C) 1999 TurboLinux, Inc.\n"); 
	fprintf(fp, "!!!                        All Rights Reserved\n");
	fprintf(fp, "!!! Distributed under the terms of the GNU General Public License (GPL)\n");
	fprintf(fp, "!!!\n");
	fprintf(fp, "!!!\n");
	fprintf(fp, "!!! Authors:     TurboLinux Chinese Development Team:\n");
	fprintf(fp, "!!!              Justin Yu   <justiny@turbolinux.com.cn>\n");
	fprintf(fp, "!!!              Sean Chen   <seanc@turbolinux.com.cn>\n");
	fprintf(fp, "!!!              Daniel Fang <danf@turbolinux.com.cn>\n");
	fprintf(fp, "!!! WWW:         http://www.turbolinux.com.cn/ZWinPro/\n");
	fprintf(fp, "!!! FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/\n");
	fprintf(fp, "!!!\n");
	fprintf(fp, "\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! Resource file for Chinput-%s\n", VERSION);
	fprintf(fp, "!!! Generated by zwincontrol, Please do not edit by hand\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! locales\n");
	fprintf(fp, "chinput.gblocale		=	zh_CN.GBK\n");
	fprintf(fp, "chinput.big5locale		=	zh_CN.GBK\n");
	fprintf(fp, "\n");

	fprintf(fp, "!\n");
	fprintf(fp, "! input style: AUTO, ROOT, OVERSPOT, ONSPOT, OFFSPOT\n");
	fprintf(fp, "!\n");
	if(chinputrc.dmode == HZSERVER_DMODE_AUTO)
		fprintf(fp, "chinput.dmode		=	AUTO\n");
	else if(chinputrc.dmode == HZSERVER_DMODE_ROOT)
		fprintf(fp, "chinput.dmode		=	ROOT\n");
	else if(chinputrc.dmode == HZSERVER_DMODE_OVERSPOT)
		fprintf(fp, "chinput.dmode		=	OVERSPOT\n");
	else if(chinputrc.dmode == HZSERVER_DMODE_ONSPOT)
		fprintf(fp, "chinput.dmode		=	ONSPOT\n");
	else if(chinputrc.dmode == HZSERVER_DMODE_OFFSPOT)
		fprintf(fp, "chinput.dmode		=	OFFSPOT\n");


	fprintf(fp, "!\n");
	fprintf(fp, "! input window auto-hide mode AUTO or NO, only for CARET mode\n");
	fprintf(fp, "!\n");
	if(chinputrc.hmode == HZSERVER_HMODE_AUTO)
		fprintf(fp, "chinput.hmode		=	AUTO\n");
	else
		fprintf(fp, "chinput.hmode		=	NO\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! choice window auto popup mode: AUTO or NO, only for ONSPOT style\n");
	fprintf(fp, "!\n");
	if(chinputrc.cmode == HZSERVER_CMODE_AUTO)
		fprintf(fp, "chinput.cmode		=	AUTO\n");
	else
		fprintf(fp, "chinput.cmode		=	NO\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! area style for OFFSPOT style, CLIENT or SERVER\n");
	fprintf(fp, "!\n");
	if(chinputrc.areamode == HZSERVER_AREAMODE_SERVER)
		fprintf(fp, "chinput.areamode	=	SERVER\n");
	else
		fprintf(fp, "chinput.areamode	=	CLIENT\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! show input method in the input window\n");
	fprintf(fp, "!\n");
	if(chinputrc.showime == 1)
		fprintf(fp, "chinput.showime		=	YES\n");
	else
		fprintf(fp, "chinput.showime		=	NO\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! input method\n");
	fprintf(fp, "! for gb  : TONEPY, PY, CCDOSPY, WuBi, CangJie, English, CTLau, SW, \n");
	fprintf(fp, "!           QianMa, TeleCode, ZRM\n");
	fprintf(fp, "! for big5: PY, ETZY, ZOZY, Simplex, CangJie, \n");
	fprintf(fp, "!	    English, 4Corner, HSU, ARRAY30, Boshiamy\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.dictionary		=	%s\n", 
		chinputrc.dictionary);
	fprintf(fp, "chinput.inputmethod.gb		=	%s\n",
		chinputrc.ime_gb);
	fprintf(fp, "chinput.inputmethod.big5	=	%s\n",
		chinputrc.ime_big5);
	fprintf(fp, "!\n");
	fprintf(fp, "! 16 point font set\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.font			=	%s\n",
		chinputrc.font);
	fprintf(fp, "chinput.gbfont			=	%s\n",
		chinputrc.gbfont);
	fprintf(fp, "chinput.big5font		=	%s\n",
		chinputrc.big5font);
	fprintf(fp, "!\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! inputbar width in chars\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.width	=	%d\n", chinputrc.width);
	fprintf(fp, "\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! panel color \n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.dimcolor	=	%s\n",chinputrc.dimcolor);
	fprintf(fp, "chinput.lightcolor	=	%s\n",chinputrc.lightcolor);
	fprintf(fp, "chinput.panelcolor	=	%s\n",chinputrc.panelcolor);
	fprintf(fp, "chinput.hzcolor		=	%s\n",chinputrc.hzcolor);
	fprintf(fp, "chinput.ledcolor	=	%s\n",chinputrc.ledcolor);
	fprintf(fp, "chinput.barcolor	=	%s\n",chinputrc.barcolor);
	fprintf(fp, "\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! handwriting recognition timeout\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.hwtimeout	=	%d\n",chinputrc.hwtimeout);

	fprintf(fp, "!\n");
	fprintf(fp, "! Input Method read by chinput\n");
	fprintf(fp, "! Format: The following items should be in the correct order\n");
	fprintf(fp, "!         [Section] : Input Method, the same in chinput.inputmethod.gb\n");
	fprintf(fp, "!         NAMEGB    : Name for gettext\n");
	fprintf(fp, "!         NAMEBIG5  : Name appeared in input bar\n");
	fprintf(fp, "!         ENCODING  : Encoding for this IME, should be GB or BIG5\n");
	fprintf(fp, "!         PROMPT    : Appeared in two rows input bar\n");
	fprintf(fp, "!         FILE      : Where the input method file located, maybe absolute path\n");
	fprintf(fp, "!                     or relative to chinput.dictionary\n");
	fprintf(fp, "!         MODULE    : absolute path of module\n");
	fprintf(fp, "!         FAVORITE  : I like this input method\n");
	fprintf(fp, "!\n");

	//write input method
	for(i=0; i<index_ime; i++){
		fprintf(fp, "[%s]\n", chinputime[i].name);
		if(flag_encoding == HZSERVER_ENCODING_GB){
			char stmp[30];
			fprintf(fp, "IMENAME		=	%s\n",
				chinputime[i].namegb);
			gbmixstring_big5mixstring(chinputime[i].namegb, stmp, 
				strlen(chinputime[i].namegb));
			fprintf(fp, "IMENAME		=	%s\n", stmp);
		} else {
			char stmp[30];
			big5mixstring_gbmixstring(chinputime[i].namebig5, stmp,
				strlen(chinputime[i].namebig5));
			fprintf(fp, "IMENAME		=	%s\n", stmp);
			fprintf(fp, "IMENAME		=	%s\n",
				chinputime[i].namebig5);
		}
		fprintf(fp, "ENCODING	=	%s\n",
			chinputime[i].encoding);
		fprintf(fp, "FILE		=	%s\n",
			chinputime[i].fname);
		fprintf(fp, "MODULE		=	%s\n",
			chinputime[i].module);
		if(chinputime[i].favorite == 1)
			fprintf(fp, "FAVORITE	=	YES\n");
		else
			fprintf(fp, "FAVORITE	=	NO\n");
		fprintf(fp, "\n");
	}
	
	fclose(fp);
	return 1;
}


int file_exist(char *fname)
{
        char name[256];
        if(!strcmp(fname, "gb")) return 1;           //ZNPY
	if(fname[0] == '/') strcpy(name, fname);
	else sprintf(name, "%s/%s", chinputrc.dictionary, fname);

        if(access(name, F_OK) == 0) return 1;
        else return 0;
}

static int mystrcmp(char *str1, char *str2)
{
        return strncmp(str1, str2, strlen(str2));
}


//
static char *get_value(char *line)
{
	char *ptr;
	char *ptr2;
	line[strlen(line)-1] = '\0';			//trim line
	ptr = strchr(line, '=') + 1;			//search value
	while(*ptr == ' ' || *ptr == '\t') ptr++;	//skip spaces
	ptr2 = ptr;
	while(*ptr2 && *ptr2 != ' ' && *ptr2 != '\t') ptr2++;//skip non spaces
	*ptr2 = '\0';					//trim line
	return ptr;
}

int scan_menu()
{
	FILE *fp;
	char fname[256];
	char line[256];

	sprintf(fname, "%s/.chinput", getenv("HOME"));
	fp = fopen(fname, "r");
	if(!fp){
		fp = fopen("/usr/local/lib/Chinput/Chinput.ad", "r");
		if(!fp) return 0;
	}

	index_ime = 0;
	while(fgets(line, 256, fp)){
		if(line[0] == '!') continue;
                if(line[0] == '\n') continue;
                if(!mystrcmp(line, "chinput.dmode")){
			char *ptr = get_value(line);
                        if(!strcmp(ptr, "AUTO"))
                                chinputrc.dmode = HZSERVER_DMODE_AUTO;
                        else if(!strcmp(ptr, "ROOT"))
                                chinputrc.dmode = HZSERVER_DMODE_ROOT;
                        else if(!strcmp(ptr, "OVERSPOT"))
                                chinputrc.dmode = HZSERVER_DMODE_OVERSPOT;
                        else if(!strcmp(ptr, "ONSPOT"))
                                chinputrc.dmode = HZSERVER_DMODE_ONSPOT;
                        else if(!strcmp(ptr, "OFFSPOT"))
                                chinputrc.dmode = HZSERVER_DMODE_OFFSPOT;
                } else if(!mystrcmp(line, "chinput.hmode")){
                        if(!strcmp(get_value(line), "AUTO"))
                                chinputrc.hmode = HZSERVER_HMODE_AUTO;
                        else
                                chinputrc.hmode = HZSERVER_HMODE_NO;
                } else if(!mystrcmp(line, "chinput.cmode")){
                        if(!strcmp(get_value(line), "AUTO"))
                                chinputrc.cmode = HZSERVER_CMODE_AUTO;
                        else
                                chinputrc.cmode = HZSERVER_CMODE_NO;
                } else if(!mystrcmp(line, "chinput.areamode")){
                        if(!strcmp(get_value(line), "CLIENT"))
                                chinputrc.areamode = HZSERVER_AREAMODE_CLIENT;
                        else
                                chinputrc.areamode = HZSERVER_AREAMODE_SERVER;
                } else if(!mystrcmp(line, "chinput.dictionary")){
                        strcpy(chinputrc.dictionary, get_value(line));
                } else if(!mystrcmp(line, "chinput.showime")){
                        if(!strcmp(get_value(line), "YES"))
                                chinputrc.showime = 1;
                        else
                                chinputrc.showime = 0;
                } else if(!mystrcmp(line, "chinput.font")){
                        strcpy(chinputrc.font, get_value(line));
                } else if(!mystrcmp(line, "chinput.gbfont")){
                        strcpy(chinputrc.gbfont, get_value(line));
                } else if(!mystrcmp(line, "chinput.big5font")){
                        strcpy(chinputrc.big5font, get_value(line));
                } else if(!mystrcmp(line, "chinput.width")){
                        chinputrc.width = atoi(get_value(line));
                } else if(!mystrcmp(line, "chinput.dimcolor")){
                        strcpy(chinputrc.dimcolor, get_value(line));
                } else if(!mystrcmp(line, "chinput.lightcolor")){
                        strcpy(chinputrc.lightcolor, get_value(line));
                } else if(!mystrcmp(line, "chinput.panelcolor")){
                        strcpy(chinputrc.panelcolor, get_value(line));
                } else if(!mystrcmp(line, "chinput.hzcolor")){
                        strcpy(chinputrc.hzcolor, get_value(line));
                } else if(!mystrcmp(line, "chinput.ledcolor")){
                        strcpy(chinputrc.ledcolor, get_value(line));
                } else if(!mystrcmp(line, "chinput.barcolor")){
                        strcpy(chinputrc.barcolor, get_value(line));
                } else if(!mystrcmp(line, "chinput.hwtimeout")){
                        chinputrc.hwtimeout = atoi(get_value(line));
                } else if(!mystrcmp(line, "chinput.inputmethod.gb")){
                        strcpy(chinputrc.ime_gb, get_value(line));
                } else if(!mystrcmp(line, "chinput.inputmethod.big5")){
                        strcpy(chinputrc.ime_big5, get_value(line));
                } else if(line[0] == '[') {	//find an entry
			char *ptr;
			ptr = strchr(line, ']');
			*ptr = '\0';		//trim
			strcpy(chinputime[index_ime].name, line+1);
			if(!fgets(line, 256, fp)) return 0;
			strcpy(chinputime[index_ime].namegb, get_value(line));
			if(!fgets(line, 256, fp)) return 0;
			strcpy(chinputime[index_ime].namebig5, get_value(line));
			if(!fgets(line, 256, fp)) return 0;
			strcpy(chinputime[index_ime].encoding,get_value(line));
			if(!fgets(line, 256, fp)) return 0;
			strcpy(chinputime[index_ime].fname,get_value(line));
			if(!fgets(line, 256, fp)) return 0;
			strcpy(chinputime[index_ime].module,get_value(line));
			if(!fgets(line, 256, fp)) return 0;
			if(!strcmp(get_value(line), "YES"))
				chinputime[index_ime].favorite = 1;
			else
				chinputime[index_ime].favorite = 0;
			//if(chinputime[index_ime].favorite == 1 &&
			//   file_exist(chinputime[index_ime].fname))index_ime++;
			index_ime ++;
		}
	}
	fclose(fp);
	return 1;
}

