/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <signal.h>
#include <string.h>
#include <sys/ioctl.h>
#include <locale.h>
#include <libintl.h>
#include <X11/cursorfont.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>

#define _(String)  gettext(String)
#define N_(String)  gettext(String)
#define __(String) (String)

#include "defs.h"
#include "hzclient.h"
#include "icons/z.xpm"
#include "icons/e.xpm"
//#include "icons/input.xpm"
#include "icons/help.xpm"
#include "icons/keyboard.xpm"
#include "icons/handwriting.xpm"
#include "icons/voice.xpm"
#include "chinput.h"
#include "hzserver.h"
#define  MAX_IMES	60

int flag_display = DISPLAY_WESTERN;
int flag_font = FONT_GB_SONG;
int flag_input = INPUT_WESTERN;
int flag_corner = CORNER_HALF;
int flag_punct = PUNCT_WESTERN;
int flag_enc = ENC_GB;
int flag_lock = LOCK_NONE;
int flag_hide = BAR_HIDE;
int flag_encoding = HZSERVER_ENCODING_GB;
int flag_showwindow = 0;
int flag_scan = 1;
int index_ime = 0;

chinput_ime chinputime[MAX_IMES];
chinput_rc  chinputrc;

typedef struct _icon_button {
	GtkWidget *w;
	GtkWidget *l;
	GtkWidget *pixmapwid;
	GtkTooltips *tooltips;
	int	cursor;
	int	x;
	int	y;
	int	width;
	int	height;
	int	status;
	char	*label1;
	char	*label2;
	char	**xpm;
	char	*tips;
} icon_button;

typedef struct _menu_item {
	char	*label;
	int	data;
	int	n_submenu;
	struct _menu_item *submenu;
	void 	(*func)();
} menu_item;

typedef struct _menu_button {
	GtkWidget *w;
	GtkWidget *l;
	int	x;
	int	y;
	int	width;
	int	height;
	char	*label;
	menu_item *menu;
	int	n_menu;
	void 	(*func)();
} menu_button;


extern void menubar_manage();
extern void menubar_help();
extern void menubar_tips();
static void menubar_pin();
extern void menubar_exit();
void menubar_lock();
//static void menubar_input();
static void chinputime_input();

menu_item m_lock[] = {
	{"Lock GB Input",	LOCK_GB,	0,  	NULL,	menubar_lock},
	{"Lock BIG5 Input",	LOCK_BIG5,	0,  	NULL,	menubar_lock},
	{"--------",		0,		0,  	NULL,	NULL},
	{"Unlock Input",	LOCK_NONE,	0,  	NULL,	menubar_lock},
};

menu_item m_input[] = {
	{"Simplified Chinese Input",	0,	1,  	NULL,	NULL},
	{"Traditional Chinese Input",	0,	1,	NULL,	NULL},
};
menu_item m_help[] = {
	{"IME Manage",		0,	0,	NULL,	menubar_manage},
	{"--------",		0,	0,	NULL,	NULL},
	{"Help",		0,	0,	NULL,	menubar_help},
	{"Tips",		0,	0,	NULL,	menubar_tips},
	{"--------",		0,	0,	NULL,	NULL},
	{"Controlbar Display Switching",0,	0,	NULL,	menubar_pin},
	{"--------",		0,	0,	NULL,	NULL},
	{"Exit",		0,	0,	NULL,	menubar_exit},
};

#include "all.h"
static void create_toolbar();
static void add_iconbutton(GtkWidget *p, GtkWidget *fixed, icon_button *ib);
void        config_keyboard();
static void toolbar_corner();
static void toolbar_punct();
//static void toolbar_enc();
static void toolbar_keyboard();
static void toolbar_handwriting();
static void toolbar_voice();
static void add_label_iconbutton();
static void add_pixmap_iconbutton();
static char *get_input_label();
static GtkWidget *create_ime_menu();


#define ICON_WIDTH 	26
#define ICON_HEIGHT	26
#define TOTAL_WIDTH	(ICON_WIDTH*11 + 18)

icon_button iconbuttons[] = {
	{NULL,	NULL,	NULL,	NULL,	0,	1,		1,	ICON_WIDTH,ICON_HEIGHT, 0,	NULL, 	NULL,	icon_z,		"Moving the toolbar"},
	{NULL,	NULL,	NULL,	NULL,	1,	ICON_WIDTH+2,	1,	ICON_WIDTH,ICON_HEIGHT, 0,	"FullCorner", "HalfCorner",	NULL,	"Setting half/full corner mod of the input server"},
	{NULL,	NULL,	NULL,	NULL,	1,	ICON_WIDTH*2+4,	1,	ICON_WIDTH,ICON_HEIGHT, 1,	"WesternPunct",	"ChinesePunct",	NULL,	"Setting Chinese/English punctuation mode of the input server"},
	{NULL,	NULL,	NULL,	NULL,	2,	ICON_WIDTH*3+6,	1,	ICON_WIDTH,ICON_HEIGHT, 1,	"Simplified", 	"Simplified",	NULL,	"Client encoding status"},
	{NULL,	NULL,	NULL,	NULL,	2,	ICON_WIDTH*4+8, 1,	ICON_WIDTH*3,ICON_HEIGHT, 0,	"ZhiNengPinYin","ZhiNengPinYin", 	NULL,	"Setting input method"},
	{NULL,	NULL,	NULL,	NULL,	1,	ICON_WIDTH*7+10,1,	ICON_WIDTH,ICON_HEIGHT, 0,	NULL, 	NULL,	icon_keyboard,	"Virtual Keyboard"},
	{NULL,	NULL,	NULL,	NULL,	1,	ICON_WIDTH*8+12,1,	ICON_WIDTH,ICON_HEIGHT, 0,	NULL, 	NULL,	icon_handwriting,	"Handwriting Recognition"},
	{NULL,	NULL,	NULL,	NULL,	1,	ICON_WIDTH*9+14,1,	ICON_WIDTH,ICON_HEIGHT, 0,	NULL, 	NULL,	icon_voice,	"Voice Recognition"},
	{NULL,	NULL,	NULL,	NULL,	2,	ICON_WIDTH*10+16,1,	ICON_WIDTH,ICON_HEIGHT, 0,	NULL, 	NULL,	icon_help,	"Help for Chinput..."},
};

GtkWidget *root_window;
int button_x, button_y;
int root_x0, root_y0;
int win_x0, win_y0;
Atom hz_cprotocol_atom;
Atom hz_config_atom;
Cursor move_cursor, arrow_cursor, down_cursor;
//static Atom hz_toolbar_atom;


int set_input_flag(int flag)
{
	//change pixmap
	GtkWidget *pixmapwid;
	GdkPixmap *pixmap;
	GdkBitmap *mask;	
	GtkStyle  *style;

	style = gtk_widget_get_style(root_window);
	if(flag == BAR_HIDE)
		pixmap = gdk_pixmap_create_from_xpm_d(root_window->window, &mask, &style->bg[GTK_STATE_NORMAL], icon_e);
	else
		pixmap = gdk_pixmap_create_from_xpm_d(root_window->window, &mask, &style->bg[GTK_STATE_NORMAL], icon_z);

	pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(pixmapwid);
	gtk_container_remove(GTK_CONTAINER(iconbuttons[0].w), iconbuttons[0].pixmapwid);
	gtk_container_add(GTK_CONTAINER(iconbuttons[0].w), pixmapwid);
	iconbuttons[0].pixmapwid = pixmapwid;
}

static GdkFilterReturn process_client(
        GdkXEvent *xev,
        GdkEvent  *event,
        gpointer   data)
{
        XClientMessageEvent *ev = (XClientMessageEvent *)xev;

        if(ev->message_type!=hz_config_atom) {
                printf("Invalid message from client.\n");
                return 0;
        }

        switch(ev->data.l[0]){
                case ZWIN_FLAG_ENC:
			//record encoding
                        flag_enc = ev->data.l[1];

			if(flag_lock == LOCK_GB || flag_lock == LOCK_BIG5) 
				return 0;

			//if locked, ignore the encoding setting

        		if(flag_enc == ENC_GB)
                		gtk_label_set_text(GTK_LABEL(iconbuttons[3].l), _("Simplified"));
        		else
                		gtk_label_set_text(GTK_LABEL(iconbuttons[3].l), _("Traditional"));
                        break;
		case ZWIN_FLAG_CORNER:
			flag_corner = ev->data.l[1];
			if(flag_corner == CORNER_FULL)
                		gtk_label_set_text(GTK_LABEL(iconbuttons[1].l), _("FullCorner"));
			else
                		gtk_label_set_text(GTK_LABEL(iconbuttons[1].l), _("HalfCorner"));
			break;
		case ZWIN_FLAG_PUNCT:
			flag_punct = ev->data.l[1];
        		if(flag_punct == PUNCT_CHINESE)
                		gtk_label_set_text(GTK_LABEL(iconbuttons[2].l), _("ChinesePunct"));
			else
                		gtk_label_set_text(GTK_LABEL(iconbuttons[2].l), _("WesternPunct"));
			break;
		case ZWIN_FLAG_INPUT:
                	gtk_label_set_text(GTK_LABEL(iconbuttons[4].l), 
				get_input_label(ev->data.l[1]));
			break;
		case ZWIN_FLAG_HIDE:
			flag_hide = ev->data.l[1];
			//if(flag_showwindow == 1) set_input_flag(flag_hide);
			set_input_flag(flag_hide);
			if(flag_hide == BAR_HIDE && flag_showwindow == 0){
				gtk_widget_hide(root_window);
			}else{
				gtk_widget_show(root_window);
				//set_input_flag(BAR_POP);
			}
			break;
		case ZWIN_FLAG_MANAGE:
			menubar_manage(NULL, NULL);
			break;
		default:
			break;
	}
	return 0;
}

static void logo_pressed(GtkWidget *widget, GdkEventButton *event)
{
	button_x = (int) event->x;
	button_y = (int) event->y;
	root_x0 = (int) event->x_root;
	root_y0 = (int) event->y_root;
	win_x0 = root_x0 - button_x;
	win_y0 = root_y0 - button_y;

  	gtk_grab_add (widget);
  	gdk_pointer_grab (widget->window, TRUE,
                    GDK_BUTTON_RELEASE_MASK |
                    GDK_BUTTON_MOTION_MASK |
                    GDK_POINTER_MOTION_HINT_MASK,
                    NULL, NULL, 0);
}

static void logo_released(GtkWidget *widget)
{
  	gtk_grab_remove (widget);
  	gdk_pointer_ungrab (0);
}

static void logo_motion(GtkWidget *widget, GdkEventMotion *event)
{
	int root_x, root_y;
	root_x   = (int) event->x_root;
	root_y   = (int) event->y_root;

  	gtk_widget_set_uposition (root_window, 
		win_x0 + root_x - root_x0, win_y0 + root_y - root_y0);
}

static void icon_enter(GtkWidget *widget, GdkEventCrossing *event)
{
	//raise up
	gdk_window_show(root_window->window);

}


static void toolbar_corner()
{
	flag_corner = (flag_corner == CORNER_FULL ? CORNER_HALF : CORNER_FULL);
	if(flag_corner == CORNER_FULL){
		gtk_label_set_text(GTK_LABEL(iconbuttons[1].l), _("FullCorner"));
		config_corner(1);
	} else {
		gtk_label_set_text(GTK_LABEL(iconbuttons[1].l), _("HalfCorner"));
		config_corner(0);
	}
}

static void toolbar_punct()
{
	flag_punct = (flag_punct == PUNCT_CHINESE ? PUNCT_WESTERN : PUNCT_CHINESE);
	if(flag_punct == PUNCT_CHINESE) {
		gtk_label_set_text(GTK_LABEL(iconbuttons[2].l), _("ChinesePunct"));
		config_punct(1);
	} else {
		gtk_label_set_text(GTK_LABEL(iconbuttons[2].l), _("WesternPunct"));
		config_punct(0);
	}
}

static void toolbar_keyboard()
{
	config_keyboard();
}

static void toolbar_handwriting()
{
	config_handwriting();
}

static void toolbar_voice()
{
	config_voice();
}


static void add_iconbutton(GtkWidget *p, GtkWidget *fixed, icon_button *ib)
{
	if(ib->xpm) add_pixmap_iconbutton(p, fixed, ib);
	else add_label_iconbutton(p, fixed, ib);
}

static void add_label_iconbutton(GtkWidget *p, GtkWidget *fixed, icon_button *ib)
{
	if(ib->status == 1)
		ib->l = gtk_label_new(_(ib->label1));
	else
		ib->l = gtk_label_new(_(ib->label2));
	gtk_widget_show(ib->l);

	ib->w = gtk_button_new();
        gtk_container_add(GTK_CONTAINER(ib->w), ib->l);
        gtk_widget_show(ib->w);

        gtk_container_set_border_width(GTK_CONTAINER(ib->w), 0);
        gtk_signal_connect(GTK_OBJECT(ib->w), "enter_notify_event",
                GTK_SIGNAL_FUNC(icon_enter), NULL);

        gtk_widget_set_events(ib->w,
                         gtk_widget_get_events (ib->w) |
                         GDK_BUTTON_MOTION_MASK |
                         GDK_POINTER_MOTION_HINT_MASK |
                         GDK_BUTTON_PRESS_MASK);

        gtk_widget_set_usize(ib->w, ib->width+2, ib->height+2);
        gtk_fixed_put(GTK_FIXED(fixed), ib->w, ib->x, ib->y);

	ib->tooltips = gtk_tooltips_new();
	gtk_tooltips_set_tip(ib->tooltips, ib->w, _(ib->tips), _(ib->tips));
	
	if(ib->cursor == 0)
		XDefineCursor(gdk_display, GDK_WINDOW_XWINDOW(ib->w->window), move_cursor);
	else if(ib->cursor == 1)
		XDefineCursor(gdk_display, GDK_WINDOW_XWINDOW(ib->w->window), arrow_cursor);
	else if(ib->cursor == 2)
		XDefineCursor(gdk_display, GDK_WINDOW_XWINDOW(ib->w->window), down_cursor);
        gtk_widget_show(ib->w);
}

static void add_pixmap_iconbutton(GtkWidget *p, GtkWidget *fixed, icon_button *ib)
{
	//GtkWidget *pixmapwid;
	GdkPixmap *pixmap;
	GdkBitmap *mask;	
	GtkStyle  *style;

	//add the first button
	style = gtk_widget_get_style(p);
	pixmap = gdk_pixmap_create_from_xpm_d(p->window, &mask,
		&style->bg[GTK_STATE_NORMAL], ib->xpm);

	ib->pixmapwid = gtk_pixmap_new(pixmap, mask);
	gtk_widget_show(ib->pixmapwid);

	ib->w = gtk_button_new();
	gtk_container_set_border_width(GTK_CONTAINER(ib->w), 0);
	gtk_container_add(GTK_CONTAINER(ib->w), ib->pixmapwid);
	gtk_signal_connect(GTK_OBJECT(ib->w), "enter_notify_event",
                GTK_SIGNAL_FUNC(icon_enter), NULL);

  	gtk_widget_set_events(ib->w,
                         gtk_widget_get_events (ib->w) |
                         GDK_BUTTON_MOTION_MASK |
                         GDK_POINTER_MOTION_HINT_MASK |
                         GDK_BUTTON_PRESS_MASK);

	gtk_widget_set_usize(ib->w, ib->width+2, ib->height+2);
	gtk_fixed_put(GTK_FIXED(fixed), ib->w, ib->x, ib->y);

	ib->tooltips = gtk_tooltips_new();
	gtk_tooltips_set_tip(ib->tooltips, ib->w, _(ib->tips), _(ib->tips));

	if(ib->cursor == 0)
		XDefineCursor(gdk_display, GDK_WINDOW_XWINDOW(ib->w->window), move_cursor);
	else if(ib->cursor == 1)
		XDefineCursor(gdk_display, GDK_WINDOW_XWINDOW(ib->w->window), arrow_cursor);
	else if(ib->cursor == 2)
		XDefineCursor(gdk_display, GDK_WINDOW_XWINDOW(ib->w->window), down_cursor);
	gtk_widget_show(ib->w);
}

static GtkWidget *create_ime_menu(int n)
{
	int i;
	GtkWidget *menu;
	GtkWidget *menu_item;

	menu = gtk_menu_new();

	if(n == 0){		//gb input
		for(i=0; i<index_ime; i++){
			if(chinputime[i].favorite == 1 &&
			   file_exist(chinputime[i].fname)){
			if(!strcmp(chinputime[i].encoding, "GB")){
				if(flag_encoding == HZSERVER_ENCODING_GB)
					menu_item = gtk_menu_item_new_with_label(chinputime[i].namegb);
				else {
					char stmp[30];
					gbmixstring_big5mixstring(chinputime[i].namegb, stmp, strlen(chinputime[i].namegb));
					menu_item = gtk_menu_item_new_with_label(stmp);
				}
					
				gtk_menu_append(GTK_MENU(menu), menu_item);
				gtk_signal_connect(GTK_OBJECT(menu_item), 
					"activate", GTK_SIGNAL_FUNC(chinputime_input), (gpointer)i);
				gtk_widget_show(menu_item);
			}
			}
		}
	} else {		//big5 input
		for(i=0; i<index_ime; i++){
			if(chinputime[i].favorite == 1 &&
			   file_exist(chinputime[i].fname)){
			if(!strcmp(chinputime[i].encoding, "BIG5")){
				if(flag_encoding == HZSERVER_ENCODING_BIG5)
					menu_item = gtk_menu_item_new_with_label(chinputime[i].namebig5);
				else {
					char stmp[30];
					big5mixstring_gbmixstring(chinputime[i].namebig5, stmp, strlen(chinputime[i].namebig5));
					menu_item = gtk_menu_item_new_with_label(stmp);
				}
				gtk_menu_append(GTK_MENU(menu), menu_item);
				gtk_signal_connect(GTK_OBJECT(menu_item), 
					"activate", GTK_SIGNAL_FUNC(chinputime_input), (gpointer)i);
				gtk_widget_show(menu_item);
			}
			}
		}
	}
	return menu;
}

static GtkWidget *create_menu(menu_item *im, int num)
{
	int i;
	GtkWidget *menu;
	GtkWidget *menu_item;

	menu = gtk_menu_new();

	for(i=0; i<num; i++){
		if(im[i].label[0] == '-')
			menu_item = gtk_menu_item_new();
		else
			menu_item = gtk_menu_item_new_with_label(_(im[i].label));
		//only for input method menu
		if(im[i].n_submenu){
			GtkWidget *submenu;
			submenu = create_ime_menu(i);
			gtk_menu_item_set_submenu(GTK_MENU_ITEM(menu_item), submenu);

		}
		gtk_menu_append(GTK_MENU(menu), menu_item);
		//callback
		if(im[i].func)
		gtk_signal_connect(GTK_OBJECT(menu_item), "activate",
			GTK_SIGNAL_FUNC(im[i].func), (gpointer)im[i].data);

		gtk_widget_show(menu_item);
	}

	return menu;
}

static char *get_input_label(int n)
{
	if(flag_encoding == HZSERVER_ENCODING_GB)
		return chinputime[n].namegb;
	else
		return chinputime[n].namebig5;
}

static void chinputime_input(GtkWidget *w, gpointer data)
{
        int n = (int)data;

        //printf("input: %d\n", (int)data);
        config_input(n);

        //set label
	if(flag_encoding == HZSERVER_ENCODING_GB)
        	gtk_label_set_text(GTK_LABEL(iconbuttons[4].l), 
			chinputime[n].namegb);
	else
        	gtk_label_set_text(GTK_LABEL(iconbuttons[4].l), 
			chinputime[n].namebig5);
}

void menubar_lock(GtkWidget *w, gpointer data)
{
	GdkColor col;
	GtkStyle *style;

	flag_lock = (int)data;

	if(flag_lock == LOCK_NONE){
		col.red   = 0;
		col.green = 0;
		col.blue  = 0;
		style = gtk_style_copy (w->style);
		style->fg[GTK_STATE_NORMAL] = col;
		style->fg[GTK_STATE_PRELIGHT] = col;
		gtk_widget_set_style(iconbuttons[3].l, style);
		if(flag_enc == ENC_GB)
			gtk_label_set_text(GTK_LABEL(iconbuttons[3].l), _("Simplified"));
		else
			gtk_label_set_text(GTK_LABEL(iconbuttons[3].l), _("Traditional"));
	} else if(flag_lock == LOCK_GB){
		col.red   = 46000;
		col.green = 0;
		col.blue  = 0;
		style = gtk_style_copy (w->style);
		style->fg[GTK_STATE_NORMAL] = col;
		style->fg[GTK_STATE_PRELIGHT] = col;
		gtk_widget_set_style(iconbuttons[3].l, style);
		gtk_label_set_text(GTK_LABEL(iconbuttons[3].l), _("Simplified"));
	} else if(flag_lock == LOCK_BIG5){
		col.red   = 46000;
		col.green = 0;
		col.blue  = 0;
		style = gtk_style_copy (w->style);
		style->fg[GTK_STATE_NORMAL] = col;
		style->fg[GTK_STATE_PRELIGHT] = col;
		gtk_widget_set_style(iconbuttons[3].l, style);
		gtk_label_set_text(GTK_LABEL(iconbuttons[3].l), _("Traditional"));
	}
	config_lock(flag_lock);
}

static gint menux = 0;
static gint menuy = 0;

static GtkMenuPositionFunc pos_menu(GtkMenu *menu, 
	gint *x, gint *y, gpointer user_data)
{
	*x = menux;
	*y = menuy;
	return 0;
}

static gint button_press(GtkWidget *widget, GdkEvent *event)
{
    if (event->type == GDK_BUTTON_PRESS) {
        GdkEventButton *bevent = (GdkEventButton *) event; 
	menux = (int)(bevent->x_root - bevent->x);
	menuy = (int)(bevent->y_root - bevent->y) + ICON_HEIGHT + 2;
        gtk_menu_popup (GTK_MENU(widget), NULL, NULL, 
		(GtkMenuPositionFunc)pos_menu, NULL,
                bevent->button, bevent->time);
        return TRUE;
    }

    return FALSE;
}

static void set_help_menu(icon_button *ib, menu_item *mi, int num)
{
	GtkWidget *menu;

	menu = create_menu(mi, num);
	gtk_signal_connect_object(GTK_OBJECT(ib->w), "event",
		GTK_SIGNAL_FUNC(button_press), GTK_OBJECT(menu));
}

static void create_toolbar()
{
	GtkWidget *hbox;
	GtkWidget *fixed;
	int dw, dh;

	root_window = gtk_window_new(GTK_WINDOW_POPUP);
	gtk_container_set_border_width(GTK_CONTAINER(root_window), 0);
	gtk_widget_set_usize(root_window, TOTAL_WIDTH, ICON_HEIGHT+3);

  	gtk_widget_set_events (root_window,
                         gtk_widget_get_events (root_window) |
                         GDK_BUTTON_MOTION_MASK |
                         GDK_POINTER_MOTION_HINT_MASK |
                         GDK_BUTTON_PRESS_MASK);

	gtk_widget_realize(root_window);
	dw = DisplayWidth(gdk_display, DefaultScreen(gdk_display));
	dh = DisplayHeight(gdk_display, DefaultScreen(gdk_display));
  	gtk_widget_set_uposition (root_window, 
		dw - TOTAL_WIDTH, 	//right alignment
		dh - 100);		//for control panel
	if(flag_showwindow == 1)gtk_widget_show(root_window);

	hbox = gtk_hbox_new(FALSE, 0);
	gtk_container_add(GTK_CONTAINER(root_window), hbox);
	gtk_widget_show(hbox);


	fixed = gtk_fixed_new();
	gtk_box_pack_start(GTK_BOX(hbox), fixed, TRUE, TRUE, 0);
	gtk_widget_show(fixed);

	add_iconbutton(root_window, fixed, (icon_button *)&(iconbuttons[0]));
	gtk_signal_connect(GTK_OBJECT(iconbuttons[0].w), "button_press_event",
		GTK_SIGNAL_FUNC(logo_pressed), NULL);
	gtk_signal_connect(GTK_OBJECT(iconbuttons[0].w), "button_release_event",
		GTK_SIGNAL_FUNC(logo_released), NULL);
	gtk_signal_connect(GTK_OBJECT(iconbuttons[0].w), "motion_notify_event",
		GTK_SIGNAL_FUNC(logo_motion), NULL);

	//full/half corner switch
	add_iconbutton(root_window, fixed, (icon_button *)&(iconbuttons[1]));
	gtk_signal_connect(GTK_OBJECT(iconbuttons[1].w), "clicked",
                GTK_SIGNAL_FUNC(toolbar_corner), NULL);

	//chinese/english punctuation
	add_iconbutton(root_window, fixed, (icon_button *)&(iconbuttons[2]));
	gtk_signal_connect(GTK_OBJECT(iconbuttons[2].w), "clicked",
                GTK_SIGNAL_FUNC(toolbar_punct), NULL);

	//chinese gb/big5
/*
	add_iconbutton(root_window, fixed, (icon_button *)&(iconbuttons[3]));
	gtk_signal_connect(GTK_OBJECT(iconbuttons[3].w), "clicked",
                GTK_SIGNAL_FUNC(toolbar_enc), NULL);
*/
	add_iconbutton(root_window, fixed, (icon_button *)&(iconbuttons[3]));
	set_help_menu((icon_button *)&(iconbuttons[3]), (menu_item *)&m_lock, 4);

	add_iconbutton(root_window, fixed, (icon_button *)&(iconbuttons[4]));
	set_help_menu((icon_button *)&(iconbuttons[4]), (menu_item *)&m_input, 2);

	add_iconbutton(root_window, fixed, (icon_button *)&(iconbuttons[5]));
	gtk_signal_connect(GTK_OBJECT(iconbuttons[5].w), "clicked",
                GTK_SIGNAL_FUNC(toolbar_keyboard), NULL);

	add_iconbutton(root_window, fixed, (icon_button *)&(iconbuttons[6]));
	gtk_signal_connect(GTK_OBJECT(iconbuttons[6].w), "clicked",
                GTK_SIGNAL_FUNC(toolbar_handwriting), NULL);

	add_iconbutton(root_window, fixed, (icon_button *)&(iconbuttons[7]));
	gtk_signal_connect(GTK_OBJECT(iconbuttons[7].w), "clicked",
                GTK_SIGNAL_FUNC(toolbar_voice), NULL);

	add_iconbutton(root_window, fixed, (icon_button *)&(iconbuttons[8]));
	set_help_menu((icon_button *)&(iconbuttons[8]), (menu_item *)&m_help, 8);

}

static char *gtkrc_string = "\
	style \"default\"\
	{\
       		fontset = \"8x16,\
                  -*-*-medium-r-normal--16-*-*-*-*-*-gb2312.1980-0\"\
	}\
	class \"GtkWidget\" style \"default\"";

static void usage()
{
	printf("Usage: zwincontrol [-show]	-- show the window when starting\n");
	exit(0);
}

static void menubar_pin()
{
	if(flag_showwindow == 1){
		flag_showwindow = 0;
	} else {
		flag_showwindow = 1;
	}
}

int main(int argc, char **argv)
{
	Window twin;

/*
	if(getenv("LD_PRELOAD")){
		printf("Please run this program without LD_PRELOAD env.\n");
		exit(1);
	}
*/
	if(argc > 1){
		if(!strcmp(argv[1], "-show")) flag_showwindow = 1;
		if(!strcmp(argv[1], "-h")) usage();
		if(!strcmp(argv[1], "-help")) usage();
		if(!strcmp(argv[1], "--help")) usage();
	}
	flag_scan = scan_menu();

	//init
	gtk_set_locale();
	//gtk_rc_add_default_file("/usr/lib/ZWinPro/zwincontrol.rc");

	bindtextdomain("zwincontrol", "/usr/local/share/locale");
	textdomain("zwincontrol");
	if(getenv("LC_ALL") && strstr(getenv("LC_ALL"), "zh_TW"))
		flag_encoding = HZSERVER_ENCODING_BIG5;
	else
		flag_encoding = HZSERVER_ENCODING_GB;

	gtk_init(&argc, &argv);
        gtk_rc_parse_string (gtkrc_string);

#ifdef  LOGO
	//create logo
	create_logo();
#endif

	//init status
	if(getenv("LC_ALL") && strstr(getenv("LC_ALL"), "zh_TW"))
		iconbuttons[3].status = 0;
	else
		iconbuttons[3].status = 1;

	arrow_cursor = XCreateFontCursor(gdk_display, XC_top_left_arrow);
	move_cursor = XCreateFontCursor(gdk_display, XC_fleur);
	down_cursor = XCreateFontCursor(gdk_display, XC_based_arrow_down);

	//create window
	create_toolbar();

	hz_cprotocol_atom = XInternAtom(gdk_display, HZ_TOOLBAR_ATOM, False);
	hz_config_atom = XInternAtom(gdk_display, HZ_CONFIG_ATOM, False);
	if((twin = XGetSelectionOwner(gdk_display, hz_cprotocol_atom))!= None){
		printf("ZWinControl is already activated.\n");
		warning(_("ZWinControl is already activated."));
		exit(1);
	}

	XSetSelectionOwner(gdk_display, hz_cprotocol_atom,
		GDK_WINDOW_XWINDOW(root_window->window) , CurrentTime);

        //process config event
        gdk_add_client_message_filter(hz_config_atom,
                process_client, NULL);


	//create_tips_window();

	gtk_main();

	return 0;
}

