/* -*- mode: C; c-file-style: "bsd"; tab-width: 4 -*- */
/* strokedata.h - character data included by bootdata.c.
 * JStroke 1.x - Japanese Kanji handwriting recognition technology demo.
 * Copyright (C) 1997  Robert E. Wells
 * http://wellscs.com/pilot
 * mailto:robert@wellscs.com
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program (gpl.html); if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * See readme.txt, changelo, and gpl.html for more information.
 *
 * Commentary:
 *
 * The data in this file was generated via an earlier version of the
 * compact.pl perl script, from the StrokeDic.txt file from Todd Rudick.

 * Character data. This is a special header file that is included
 * in "bootdata.c" to create the Pilot database, but is also parsed
 * directly by a Perl script in KanjiPad to create its database. For this
 * reason, all lines with the first character '"' _must_ be character
 * data. In the future, maybe change KanjiPad to work from StrokeDic.txt
 * directly. owt 090497.
 *
 * ------------------------------------------------------------------------- */
#ifndef __STROKEDATA_H__
#define __STROKEDATA_H__

#ifdef FOR_STROKEDIC_CREATE_1

CharPtr LoadStrokeDicPtr(void) {
    return 
    "A\244\100F\n"
    "A\244\101Faf\n"
    "B\244\105JFl\n"
    "B\244\103FL\n"
    "B\244\121FB|b1-y2\n"
    "B\244\110JC|y2-y1! x1-x2!\n"
    "B\244\102FB|b2-b1\n"
    "B\244\115MgJ|b2-y1\n"
    "B\244\107FF\n"
    "B\244\112AC|x1-x2! y1-y2!\n"
    "B\244\113AC|x2-x1! y1-y2\n"
    "B\244\123FaC\n"
    "B\244\106FaBg\n"
    "B\244\117MgJ|y1-y2\n"
    "C\244\125FBC|i3-x2\n"
    "C\244\172FFB\n"
    "C\244\131JFlC|x1-x2\n"
    "C\244\133AFaC|x3-x2\n"
    "C\244\316JFafaC\n"
    "C\244\175MFBmg\n"
    "C\244\166MFL\n"
    "C\244\146BMF\n"
    "C\244\165FBF|b2-b1 l3-l1\n"
    "C\244\176FBA\n"
    "C\244\124FFF\n"
    "C\244\163BLB\n"
    "C\244\150FBF|b1-y2 l1-l3\n"
    "C\244\154FaBgF\n"
    "C\244\143AMgC\n"
    "C\244\153AcJF\n"
    "C\244\160BAC\n"
    "C\244\127BFF\n"
    "C\244\126FJC|x2-x3\n"
    "C\244\142MgJC\n"
    "C\244\157FBC|x2-i3\n"
    "C\244\144AFB\n"
    "C\244\164JBB\n"
    "C\244\152FJC|x3-i2\n"
    "C\244\147FBF|b1-y2 l3-l1\n"
    "C\244\140BFL\n"
    "C\244\132JFlC|x3-x1\n"
    "C\244\135MgBL\n"
    "C\244\151AFaC|l1-l3\n"
    "D\244\253FFJB\n"
    "D\244\336MFBfbdB\n"
    "D\244\252FFAfC\n"
    "D\244\375FBFF\n"
    "D\244\306ABAL\n"
    "D\244\365CAJC\n"
    "D\244\266ACJB\n"
    "D\244\302ACBB\n"
    "D\244\373AFFB|b1-y4\n"
    "D\244\277ACLB\n"
    "D\244\347AJFB|a1-x2\n"
    "D\244\355AFaJC\n"
    "D\244\353JMFF|j2-y4! j1-y4! x1-i1 j1-b4 j2-b4\n"
    "D\244\374FJCC|b1-b4\n"
    "D\244\270FFJL\n"
    "D\244\333AcAfCM\n"
    "D\244\341FMFJ\n"
    "D\244\255FBMF\n"
    "D\244\310AFFB|b4-b2\n"
    "D\244\275ACAfC\n"
    "D\244\325FaBgIL\n"
    "D\244\265ACFFa\n"
    "D\244\344FBFaC\n"
    "D\244\356BFBF\n"
    "D\244\363ABiFK\n"
    "D\244\330MFJC\n"
    "D\244\342AFFB|a1-x2\n"
    "D\244\311AJFB|x2-i1\n"
    "D\244\326BACA\n"
    "D\244\276BFaJFl\n"
    "D\244\337ALCC\n"
    "D\244\257ABFF\n"
    "D\244\364FaBAC\n"
    "D\244\301FLFjJ\n"
    "D\244\323FJCC|b4-b1\n"
    "D\244\246JMCF\n"
    "D\244\244BMFB\n"
    "D\244\321FFJC|l1-l2\n"
    "D\244\346CCFB\n"
    "D\244\331ALBL\n"
    "D\244\272BMJC\n"
    "D\244\351BMFF|y4-b1! j4-b2!\n"
    "D\244\317FJFaC|a1-x2\n"
    "D\244\361FLAL\n"
    "D\244\307FJLL\n"
    "D\244\243FABC\n"
    "D\244\322FFJC|b1-y3\n"
    "D\244\367ACJC\n"
    "D\244\300ACMgJ\n"
    "D\244\345BFJK|x3-x4!\n"
    "D\244\371JBFM\n"
    "D\244\350BFMgJ\n"
    "D\245\106ABFaCf\n"
    "D\245\106ABFaIcf\n"
    "D\244\362AFFL\n"
    "D\244\354FBAC\n"
    "D\244\314FJMgL\n"
    "D\244\315FJFaC|b1-y2 x2-x1\n"
    "D\244\251FaCFaBg\n"
    "D\244\273BFAC|x4-x3!\n"
    "D\311\122ABMJ\n"
    "E\245\110BICAC\n"
    "E\245\153JFBMF\n"
    "E\245\303CFbFaAC\n"
    "E\245\127MfBFLB\n"
    "E\245\241BMFJC|x5-i4\n"
    "E\245\133FjJBMF\n"
    "E\245\151FBMFB\n"
    "E\245\176JFjCBC\n"
    "E\245\102BMFFF|l5-l4 i1-x5! i5-i2!\n"
    "E\245\132FFBBB\n"
    "E\245\314FBBFF\n"
    "E\245\103ABFBF\n"
    "E\245\150FBFAfC\n"
    "E\245\250BFMFF\n"
    "E\245\311FBFFC\n"
    "E\245\171AMgBMF\n"
    "E\245\123BMFJL\n"
    "E\245\336BBFaAC\n"
    "E\245\310BFAcAfC\n"
    "E\245\152FBBMF\n"
    "E\245\134FBIFaJ\n"
    "E\245\251FBIFBmg|y3-j2\n"
    "E\245\322BMFFB|b5-y3\n"
    "E\245\252FJFBF|b4-b3\n"
    "E\245\125BMBBF|j1-y5\n"
    "E\245\276FBACL\n"
    "E\245\327BMBBF|y5-b1\n"
    "E\245\113ABFBF|y5-y3\n"
    "E\245\161MFBMF\n"
    "E\245\166BMFJC|x4-x5 y5-y3\n"
    "E\245\174BMJLF\n"
    "E\245\253BFBMB\n"
    "E\245\334FFBAC|l2-l1 y3-y1\n"
    "E\245\167BMFAL\n"
    "E\245\242AFFJC|y2-y4\n"
    "E\245\104CFBFF\n"
    "E\245\175BMJCF\n"
    "E\246\254BBIFjC\n"
    "E\245\304CCIFB\n"
    "E\245\130BLBLB\n"
    "E\245\154MgJBMF\n"
    "E\311\165MFJJFl\n"
    "E\245\323BMFFB|y1-y5\n"
    "E\245\100FBBFL\n"
    "E\245\277FBFBF\n"
    "E\245\315AFBFF\n"
    "E\245\270AJFBC\n"
    "E\245\333FJBMF\n"
    "E\245\120ABBLB\n"
    "E\245\145BFBMF\n"
    "E\245\114ABMBL|y3-y5\n"
    "E\245\264FBIFB|j2-y3 y1-y2\n"
    "E\245\116ABFKC\n"
    "E\245\170AfCBMF\n"
    "E\245\320BMBFF|b3-y1\n"
    "E\245\243BcJFFjC\n"
    "E\245\126AFaCCC\n"
    "E\245\131FBMfLB\n"
    "E\245\247MFJAL\n"
    "E\245\325ABMFF\n"
    "E\245\142CAFFB\n"
    "E\245\307ACbAML\n"
    "E\245\326JFaBFaC\n"
    "E\245\262CALAC\n"
    "E\245\111ABFBC\n"
    "E\245\254JFBMB\n"
    "E\244\376FBMJC\n"
    "E\245\255FCAFB\n"
    "E\245\257AfCFJB\n"
    "E\245\300AcMCCF\n"
    "E\245\135AMgMFL\n"
    "E\245\137FBIAL\n"
    "E\245\273FBACF\n"
    "E\245\275FFBAC|l1-l2\n"
    "E\245\274FFBAC|l2-l1\n"
    "E\245\301MFBiFK\n"
    "E\245\331FaCFaBA\n"
    "E\246\127AFaBMF\n"
    "E\245\330BMFFF\n"
    "E\245\332AFFJC|b4-y2\n"
    "E\245\321BMBFF|y1-y3\n"
    "E\245\256AcAfCFjJ\n"
    "E\245\316JMFFB\n"
    "E\245\337BFCAF\n"
    "E\245\117ACCFaC\n"
    "E\245\117ACFMgB\n"
    "F\246\167BBFaBcJF\n"
    "F\246\347BFABiAC\n"
    "F\250\241FBBFFB\n"
    "F\246\114ABFFMB\n"
    "F\246\135BMFJCF\n"
    "F\246\164BBFaFFB\n"
    "F\246\320MCIMCI\n"
    "F\246\335ABMFFF|x3-x2\n"
    "F\246\303CCIFFBm\n"
    "F\246\136BMBMFF\n"
    "F\246\307FJBAJC\n"
    "F\246\125AFaCBMF\n"
    "F\246\275CCIFFB\n"
    "F\246\316AFFBLB\n"
    "F\245\370ACBFBF\n"
    "F\246\115AFaFJMgL\n"
    "F\246\116FBFBMF\n"
    "F\245\360ABFBAC\n"
    "F\247\154BMFJFafaC\n"
    "F\246\264FBACFBmg\n"
    "F\246\100FBBFAC\n"
    "F\245\163BMFBFB\n"
    "F\245\365ABABiMB\n"
    "F\246\261BMBBFF\n"
    "F\246\104FFJBBB\n"
    "F\246\345ABMBBF\n"
    "F\245\363ABAFFB\n"
    "F\245\346BFACAC|b6-b1!\n"
    "F\245\372BCAFJL\n"
    "F\246\126ABMBMF\n"
    "F\246\132AJFBMF\n"
    "F\246\156BcJFFaBF\n"
    "F\247\265FBFAFabgF\n"
    "F\246\277CCIFBF\n"
    "F\246\322FBFAALbg\n"
    "F\246\346AABFFB\n"
    "F\246\130ACFBMF\n"
    "F\246\101FBMBFF\n"
    "F\246\142FJBFBF\n"
    "F\246\256ALBMFF\n"
    "F\246\272FAFaCAL\n"
    "F\246\315AcAfCBAC\n"
    "F\246\334FAfCFBF\n"
    "F\246\162BBFaFaBgF\n"
    "F\246\170FBFFBC\n"
    "F\246\270CIAFaJK\n"
    "F\246\323FABMBB\n"
    "F\246\325FBFFIB\n"
    "F\246\333ABMFFF|y5-y4\n"
    "F\246\241FFBIKC\n"
    "F\252\333FBBBFaCf\n"
    "F\252\333FBBBFaIcf\n"
    "F\246\165BBFaFBC\n"
    "F\246\266AFFBAC|b6-b1!\n"
    "F\246\173AJCBCB\n"
    "F\246\340AJMCBF\n"
    "F\245\122BFAfCJL\n"
    "F\246\257AMgBMFF\n"
    "F\250\265AcAcAcCFacaCf\n"
    "F\246\113FAJFBL\n"
    "F\311\334BFJFBF\n"
    "F\246\342AFaMBFL\n"
    "F\250\263FkFBCFacaCf\n"
    "F\246\250JFMgKAC\n"
    "F\246\350FBMJLF\n"
    "F\246\336AFBBMF\n"
    "F\245\375AFBFJL\n"
    "F\245\376ACFBFF\n"
    "F\246\255BMFFFB\n"
    "F\246\163FJBFaBgF\n"
    "F\246\150AFaCAFaC\n"
    "F\246\166BBFaAFL\n"
    "F\246\141FBFMBL\n"
    "F\246\300CCIFbBL\n"
    "F\246\313AFBAFB\n"
    "F\245\362ABBMFB\n"
    "F\246\344BMFBIC\n"
    "F\245\374JCILAC\n"
    "F\246\122BMFFBF\n"
    "F\246\120BMFBMF\n"
    "F\246\327BMJCAC\n"
    "F\246\160BcJFBMF\n"
    "F\245\364ABAFBF\n"
    "F\246\176AFFBFB\n"
    "F\246\331JMFFJFl\n"
    "F\245\357ABFCAC\n"
    "F\246\174BMBJFlC\n"
    "F\246\155BcJFMFL\n"
    "F\246\312FABMFF\n"
    "F\245\361ABFJCC\n"
    "F\246\314CAFBAC\n"
    "F\246\243BACBFL\n"
    "F\246\265FBACBC\n"
    "F\250\103AFAfMBF\n"
    "F\245\347BFJBAC|b6-b1!\n"
    "F\246\153BFLAcJF\n"
    "F\246\263JFBMFF\n"
    "F\246\317CAFFFB\n"
    "F\246\117FBMFJC\n"
    "F\246\103FJFaCBB\n"
    "F\246\110BACAMgJ\n"
    "F\245\345FBMFFF\n"
    "G\246\354ABBFCAF\n"
    "G\246\363ABFBMFB\n"
    "G\252\341FBBABAL\n"
    "G\247\332AFBIKAC\n"
    "G\247\326BACMFJC\n"
    "G\247\331FFJBKAC\n"
    "G\247\357MFLAFJK\n"
    "G\250\251BMFFFAC\n"
    "G\250\244AFaJMBFF\n"
    "G\247\271BBFaFFJL\n"
    "G\250\170JMFFFFB\n"
    "G\247\164ACFFaBMF\n"
    "G\247\301BLBFBFaC\n"
    "G\247\306ACAFBMB\n"
    "G\250\124CCIAFFFk\n"
    "G\247\336FBIFBFaC|j2-y3\n"
    "G\250\104FBCIACC\n"
    "G\250\163BBFaJLJFl\n"
    "G\250\147ABgAFBFF\n"
    "G\247\275MFJMgBMF\n"
    "G\247\241FBIJMCI\n"
    "G\252\361AJFBCFacaCf\n"
    "G\247\165BMFACFM\n"
    "G\247\147MFFJBMF\n"
    "G\247\316FFJBAAA\n"
    "G\250\164AAcAfCBAC\n"
    "G\252\357ABiMgBCFacaCf\n"
    "G\250\115CCIMFJC\n"
    "G\250\243BMFFFJL\n"
    "G\250\245CFFFBMF\n"
    "G\247\144BMFBmFAC\n"
    "G\247\174FBIBFJFl\n"
    "G\247\273BBFaFJAfC\n"
    "G\247\334FBIBFJFl|j2-y3\n"
    "G\247\360FBIAFJK\n"
    "G\247\363FBMFFJC\n"
    "G\247\112FBBMFJL\n"
    "G\247\151AFBFBMF\n"
    "G\247\170BMFBACF\n"
    "G\246\365ABFJFBF\n"
    "G\250\141AcAcAcCAJC\n"
    "G\247\367FBACFBA\n"
    "G\250\301FaCaBFJFaC\n"
    "G\247\100ABAFBFF\n"
    "G\246\370ABMFBMF\n"
    "G\247\323FBFALCC\n"
    "G\250\160AFBACAfC|y6-y7 i6-x7!\n"
    "G\246\374ABBICJC\n"
    "G\252\300BFaBCFBF\n"
    "G\250\256FBMFFFB\n"
    "G\250\161AFBACJMmg\n"
    "G\246\355ABCFBFF\n"
    "G\252\354BFaBACMgA\n"
    "G\247\125BMFFIMgJ\n"
    "G\247\307BFJFaCFaBg\n"
    "G\247\311BFJFBAC\n"
    "G\247\333FBIBACA|j2-y3\n"
    "G\250\166BACBMFF\n"
    "G\246\371ABBMFFB\n"
    "G\246\332BFBMFBF\n"
    "G\250\255ABMFFIA\n"
    "G\250\257BFCAFFB\n"
    "G\247\152BMFAFaJK\n"
    "G\247\374FBACAAA\n"
    "G\250\252FBFJBAC\n"
    "G\247\351FBIAJFB|j2-y3\n"
    "G\250\253FBFBFJC\n"
    "G\247\131MFFBiCMgB\n"
    "G\247\364FBMFBAC\n"
    "G\250\254BMFBFJC\n"
    "G\247\370FBACFBC\n"
    "G\247\264ACCAAcJF\n"
    "G\246\375ABBMFFF\n"
    "G\250\246ACACBMF\n"
    "G\250\153BMBFFMgJ\n"
    "G\313\155BMBFFFBg\n"
    "G\250\110CCIBFaJL\n"
    "G\247\103ABABiFKF\n"
    "G\247\145BMFFBFF|y4-j2\n"
    "G\247\312AFBFFaFaCf\n"
    "G\247\314CAMFBmgBA\n"
    "G\247\126AcAFFaCMgJ\n"
    "G\247\353FBIJFlFaC|j2-y3\n"
    "G\250\247FBMFCAF\n"
    "G\250\272MFFJFaCdB\n"
    "G\247\277MFJBFaAC\n"
    "G\247\263BcJFAFBF\n"
    "G\247\324MgJCALCC\n"
    "G\247\342FBIMBFL|j2-y3\n"
    "G\247\102ABABMFF\n"
    "G\246\361ABCAFFB\n"
    "G\247\120CAFFBBB\n"
    "G\247\137FABCBMF\n"
    "G\247\345FBIFBiAL|j2-y3\n"
    "G\252\316JMFFMBL\n"
    "G\247\300MFJAFFL\n"
    "G\247\337FBIFFJC|j2-y3\n"
    "G\247\114ABFBFAC\n"
    "G\247\117BMFMgABB\n"
    "G\252\360FJFaCCFacaCf\n"
    "G\250\152FBMFFBC\n"
    "G\250\271FFFJFaCdB\n"
    "G\247\173FBIBFFbgJ\n"
    "G\247\253BcJFBFFbgJ\n"
    "G\247\321BFLBLCC\n"
    "G\250\276FaCaBBFFbgJ\n"
    "G\250\123CCIJFlFaC\n"
    "G\250\264AFFlCCFacaCf\n"
    "G\247\256BcJFBACA\n"
    "G\247\320AABJFlFaC\n"
    "G\247\105ACFFBAC\n"
    "G\247\355FBIABiMB|j2-y3\n"
    "G\250\323FCAFBAC\n"
    "G\247\121AFBACBB|y7-y6 x7-i6!\n"
    "G\250\275BMFFBFF|j2-y3\n"
    "G\250\175BMFFBiAC\n"
    "G\247\116CIACCFaC\n"
    "G\247\116CIACFMB\n"
    "G\250\172JMFFFBF\n"
    "H\251\173BBFaAFaCML\n"
    "H\250\314ABBFABiAK\n"
    "H\251\145AFBACAcJF\n"
    "H\251\366BMFFAMgAA\n"
    "H\250\174BFAfCBMFF\n"
    "H\253\102FBMBCCCC\n"
    "H\252\141CCICFbgFaAC\n"
    "H\255\136FBBBMFJC\n"
    "H\251\265ABFBFFaFaC\n"
    "H\252\165CCIACBMF\n"
    "H\252\242CAJCCAJC\n"
    "H\255\142FBBJFaCML\n"
    "H\251\271AABCFBFF\n"
    "H\251\343FBIBMFFB|j2-y3\n"
    "H\251\243BMCAFBLB\n"
    "H\250\316ABFBFFBF\n"
    "H\252\107BMFFFBAC|y5-y3\n"
    "H\252\145CCIFBMFB\n"
    "H\251\307ACBFaCFBF\n"
    "H\251\344FBIBMFFbgJ|j2-y3\n"
    "H\250\360BFAcAACMgJ\n"
    "H\251\250ABFBFBLB\n"
    "H\251\170BBFaBMFMF\n"
    "H\251\244BLBFJFFB\n"
    "H\251\245BLBFJBMF\n"
    "H\251\137FJCFBMFB\n"
    "H\254\350BFaBCAJFB\n"
    "H\251\165AFBACFaBgF\n"
    "H\251\171BBFaBMFFF\n"
    "H\252\137CCIBFCAF\n"
    "H\251\176MFJFBBMF\n"
    "H\251\332FBIBFMFF|j2-y3\n"
    "H\250\311BFBMFFaBgC\n"
    "H\250\312BFBMFBAC\n"
    "H\250\321ABFBBFAC\n"
    "H\256\154BLBFCAJC\n"
    "H\252\160CCIBMFJL\n"
    "H\252\367ACFFBCAF\n"
    "H\255\127FBBFBBMF\n"
    "H\250\343BMFFFFAC\n"
    "H\252\305BBFaJLFBF\n"
    "H\251\175MFJBLBLB\n"
    "H\250\351CAFFJCMgJ\n"
    "H\252\323FMFJBMFF\n"
    "H\251\266MFLbgBFAcAfC\n"
    "H\251\111BMFACAFBg\n"
    "H\251\124BMFBBMFF\n"
    "H\252\352BFJFaFLJL\n"
    "H\251\257FBFCAFFB\n"
    "H\251\353FBIAMgBMF|j2-y3\n"
    "H\251\371BMFFABiMgB\n"
    "H\252\326BFBFBMFF\n"
    "H\250\350BFAcAACBB\n"
    "H\251\370BMFFFBiAL\n"
    "H\251\144FMFFBAcJF\n"
    "H\250\301BcJFAfCBMF\n"
    "H\250\352MFJBMBBB\n"
    "H\260\321AfCFJCAAA\n"
    "H\250\317ABFBMFJC\n"
    "H\250\353FBMBACBB\n"
    "H\252\113FBACFBFjK\n"
    "H\254\347BFaBCBFBF\n"
    "H\252\317JMFFFBFaC\n"
    "H\250\306FBMFMFFB\n"
    "H\250\315ABFBFFBC\n"
    "H\252\166CCIAfCBMF\n"
    "H\252\331ACFBFBMF\n"
    "H\252\314FBFABMFF\n"
    "H\250\270FBFBAFaCdB\n"
    "H\255\131FBBJFBMF\n"
    "H\250\372FBFFIBFaC\n"
    "H\250\374ACCABFaFaC\n"
    "H\251\120JMFBFBMF\n"
    "H\251\166BBFaFFBAC\n"
    "H\250\373BFFBACFjK\n"
    "H\255\172FBACCCFacaCf\n"
    "H\251\322FMFJAJFB\n"
    "H\251\174BCABMBMF\n"
    "H\251\323FaBFFFFaAC\n"
    "H\251\333FBIFbgJBMF|j2-y3\n"
    "H\252\121FBACACAfC\n"
    "H\252\150CCIMJBMF\n"
    "H\253\253AFFBBFBF\n"
    "H\252\244CAJCAFaJC\n"
    "H\250\356AFFBMBBB\n"
    "H\251\155BcJFAFBFF\n"
    "H\251\272AABFBFBF\n"
    "H\251\312ACBAFBFF\n"
    "H\253\103FBFFBMFF\n"
    "H\251\365FBBFBMFF\n"
    "H\252\122FBACAJFB\n"
    "H\251\345FBIBLBLB|j2-y3\n"
    "H\252\375FaCdBBMFFF\n"
    "H\250\362BFACACFB\n"
    "H\250\364BFBMFFFB\n"
    "H\251\335FBIFJBMF|j2-y3\n"
    "H\252\276AFFJCBMF\n"
    "H\251\172BBFaBMBFF\n"
    "H\251\276BMFBALCC\n"
    "H\251\342FBIBMBFF|j2-y3\n"
    "H\252\140CCICFBFF\n"
    "H\252\370BFFFFBiAC\n"
    "H\251\127FBIFCAFB\n"
    "H\251\167BBFaFBFJC\n"
    "H\251\263BFJABiFCF\n"
    "H\251\350FBIABiFCF|j2-y3\n"
    "H\252\363ABiFCFFaCdB\n"
    "H\252\144CCIMFJAL\n"
    "H\252\272ABMFFAMgC\n"
    "H\255\241AFFJCCFacaCf\n"
    "H\250\345BMBBFFAC\n"
    "H\251\261BFJBFBMF\n"
    "H\252\106FBMFFBAC\n"
    "H\250\354FAfCFBIBB\n"
    "H\254\162FBFFAfMBF\n"
    "H\254\360BBFaJLFJK\n"
    "H\250\305ACCAFaBgIL\n"
    "H\251\300ACFFaBLCC\n"
    "H\252\151CCIJFaBFaC\n"
    "H\252\115FBACFABC\n"
    "H\251\347FBIABMFF|j2-y3\n"
    "H\252\171CCIABMFF\n"
    "H\255\242ABMFFCFacaCf\n"
    "H\252\117FBACFJFjK\n"
    "H\252\251JBFMFJFaC\n"
    "H\251\274AABJFaBFaC\n"
    "H\251\334FBIJFaBFaC|j2-y3\n"
    "H\252\143CCICJKCC\n"
    "H\253\104JFFIBFFF\n"
    "H\252\355FBFFABiAC\n"
    "H\255\135FBBBMBFF\n"
    "H\251\262BFJABFBC\n"
    "H\251\306ACBAFBMB\n"
    "H\252\376FaCdBABFBC\n"
    "H\253\126ABAFLMFB\n"
    "H\252\132FFBFBIKC\n"
    "H\252\101JMFFBMFaC\n"
    "H\252\155CCIMFBmgJB\n"
    "H\252\253AFBIAMgAA\n"
    "H\246\175ABCAFFJB\n"
    "H\251\136FFFJCFFB\n"
    "H\251\352FBIAMgMFL|j2-y3\n"
    "H\251\361BFMgJAFJK\n"
    "H\252\153CCIFBFAfC\n"
    "H\252\167CCIAMMFL\n"
    "H\251\320FMFJBFMgJ\n"
    "H\252\325JMFFBFMgJ\n"
    "H\252\252AFBIAFJC\n"
    "H\251\142FJCFBFJB\n"
    "H\251\146BcJFFFBAC\n"
    "H\252\124FBACAFJK\n"
    "H\251\331FBIFFBAC|j2-y3\n"
    "H\250\375BMFFFBAC|a6-a3\n"
    "H\314\141BLBBMFFB\n"
    "H\251\122ACFBMFMB\n"
    "H\251\372BMFFJMFF\n"
    "H\247\113AFaBMBFJL\n"
    "H\255\132FBBJFKAC\n"
    "H\252\274BFLBMFFF\n"
    "H\252\371BMFFBMFF\n"
    "H\251\135BFABAFaCC\n"
    "H\252\157CCIBMBFF\n"
    "H\252\114FBACFBAC\n"
    "H\250\322ABFJFaCBB\n"
    "H\251\115AFBACBMF\n"
    "H\255\175BMBFFCFacaCf\n"
    "I\253\163BFBMFABiAC\n"
    "I\253\302JFFAcAFKAC\n"
    "I\254\260CAMMMACCC\n"
    "I\255\107BMBFFBMFF\n"
    "I\253\303BcJFBMFJCF\n"
    "I\254\115BMFFBMFJC\n"
    "I\254\314BFJCIJFlFaC\n"
    "I\253\316MFJFAfCFBF\n"
    "I\250\370AFFBFBIMB\n"
    "I\255\265BFCAFBMFF\n"
    "I\254\354AFBACCCFB\n"
    "I\254\133MgJBMFFBAC\n"
    "I\256\254ACBAFJfMJF\n"
    "I\256\374CCIAFBfFjJF\n"
    "I\254\311BMBFFACJB\n"
    "I\254\322FBiALABMFF\n"
    "I\253\256FBIFBMFFF\n"
    "I\255\262FBBFBMFFB\n"
    "I\254\101FBIAFBBMF|j2-y3\n"
    "I\254\241CCIAFBBMF\n"
    "I\253\141BFaFFJLFBC\n"
    "I\250\367CAFFJCMFL\n"
    "I\254\335AFFJBMFFF\n"
    "I\254\366AcAfCBACMFL\n"
    "I\255\171FBMFFFBJFl\n"
    "I\253\310BBFaAFaCBMF\n"
    "I\255\150BFJFaFLFFL\n"
    "I\260\146CAFLBJCFacaCf\n"
    "I\253\346AFaMFFALCC\n"
    "I\257\305AcAfCBACJFafaC\n"
    "I\252\310AcAfCBACBFB\n"
    "I\256\265FBIFCAFJC|j2-y3\n"
    "I\257\125ABgAFCAFJC\n"
    "I\255\170BFaFBMFFFB\n"
    "I\253\254FFJBBBFBF\n"
    "I\253\264FBFIMgJFJC\n"
    "I\255\160CFFFBMFFB|b8-y9\n"
    "I\253\330MFFFFBFaFaCf\n"
    "I\254\343FJBMFFFJB\n"
    "I\255\255FaCdBMFFBiAC\n"
    "I\251\164FaBgIAJBICK\n"
    "I\251\267MFBmgAJBICK\n"
    "I\254\107FBBMFACJK\n"
    "I\254\134FBACFBBMF\n"
    "I\253\341AABAcAfCJFaC\n"
    "I\253\112ABMFAFFJK\n"
    "I\253\160FJBMFFFaBgF\n"
    "I\253\355ACBFBMFFF\n"
    "I\256\314BMFFBCAJL\n"
    "I\254\170CCIFBBFAC\n"
    "I\254\323ABMFFFBFF\n"
    "I\254\365AcAfCBACFBF\n"
    "I\255\245BFACJCFaCdB\n"
    "I\255\273AFBACBMFF\n"
    "I\253\376FBIFBFAABmg|j2-y3\n"
    "I\253\353ACBMFFBiAC|a5-a3\n"
    "I\254\144FBACBMFFF|b5-b2\n"
    "I\254\342FJBMFBACA\n"
    "I\253\144BCABMFFBB\n"
    "I\254\121BMFFAFMFF\n"
    "I\253\272CIAFaJCAcJF\n"
    "I\253\344BMBFFALCC\n"
    "I\253\374FBIALBMFF|j2-y3\n"
    "I\254\111BFJMgAFMBL\n"
    "I\253\371FBIFBFFBC|j2-y3\n"
    "I\253\307BBFaFAfCFBF\n"
    "I\254\274ABgABBFaFBC\n"
    "I\255\272CAFABMFFF\n"
    "I\254\102FBIACFBMF|j2-y3\n"
    "I\254\356AFBACCAJC\n"
    "I\254\130FaCFaBAFBAC\n"
    "I\255\253AFBMFFBFF\n"
    "I\257\254BFaBCBMFJL\n"
    "I\253\124ABAbCJLJFjC\n"
    "I\254\113FFFJCBMFF\n"
    "I\254\336AJFBBMFFF\n"
    "I\254\114BMFFMJBMF\n"
    "I\254\331BACABMFFF\n"
    "I\253\260FBIJFFbgCAC\n"
    "I\255\271ACBMFFBiAC|b6-y1\n"
    "I\253\110ABCFFFBMF\n"
    "I\253\111ABMFFAFaFaC\n"
    "I\257\253BFaBCBMFFB\n"
    "I\254\306FBBFFFJLL\n"
    "I\253\323ABMFMFBMB\n"
    "I\254\117BMFFFBFJC\n"
    "I\254\106FBFBIAFJC\n"
    "I\254\120BMFFAFBFF\n"
    "I\254\271AFBIAFBFF\n"
    "I\253\305BBFaFBMFFF\n"
    "I\254\165ABMFFBFaAC\n"
    "I\254\176CCIAFBFJL\n"
    "I\254\126CCIJFlFBAC\n"
    "I\253\145CAFBMFFBB\n"
    "I\257\252BFaBCBMFFF\n"
    "I\253\265FFFJCFFJC\n"
    "I\254\333FBACBMFFF|a5-a2\n"
    "I\260\145CAFFJCCFacaCf\n"
    "I\253\120ABBMFBFJK\n"
    "I\253\150BMFFFACBB\n"
    "I\253\125ABACACBMF\n"
    "I\255\100FABMBBFBC\n"
    "I\253\335AABFBFFBC\n"
    "I\253\345AfCBMFALCC\n"
    "I\255\114JMFFAfCBMF\n"
    "I\260\150MFFBiACCFacaCf\n"
    "I\254\264BMBFJCAJC\n"
    "I\254\161ABFFFJFlFaC\n"
    "I\257\371FBBACFBAC\n"
    "I\254\127FBACCFBFF\n"
    "I\260\112FBMFBABiAC\n"
    "I\254\104FBIJCILAC|j2-y3\n"
    "I\261\325FBMFBACMgJ\n"
    "I\254\303FBFIACAAA\n"
    "I\254\172CCIMFFFFB\n"
    "I\260\154ABMFMFCFacaCf\n"
    "I\253\106BFBMFBFaFB\n"
    "I\255\163BFBMFFFAC\n"
    "I\253\322BFCABFaBMB\n"
    "I\255\161CFFFBMFFB|b9-b8\n"
    "I\253\327BFJFBBFFaC\n"
    "I\253\343AcJFFaCALCC\n"
    "I\260\153JCILACCFacaCf\n"
    "I\254\175CCIBMFBMF\n"
    "I\260\316FFBBABMFL\n"
    "I\253\156FBBMCAFFB\n"
    "I\254\243CCIAJAJAC\n"
    "I\255\111FBIALBMFF\n"
    "I\252\315JMFFBFBMB\n"
    "I\250\365ABMBFFAFB\n"
    "I\255\270FkACBAJFkAC\n"
    "I\254\374CAFBFFFJC\n"
    "I\254\355AFBACBACA\n"
    "I\253\176BMFBMFBMF\n"
    "I\255\164AFaBMFFFAC\n"
    "I\255\165FBFBFACBC\n"
    "I\253\312FBFFBIFBC\n"
    "I\255\267JFkABMFBIC\n"
    "I\257\273CABACACMgJ\n"
    "I\254\140FBACFBMJC\n"
    "I\255\266FABMFFFAC\n"
    "I\253\113ABFBMFFJC\n"
    "I\253\117ABBMFFBAC\n"
    "I\255\115JMFFAMMFL\n"
    "I\254\131FBBFFFBAC\n"
    "I\253\137BMFFBMFFF\n"
    "I\254\326ACMgABMBBF\n"
    "I\260\147CAFBACCFacaCf\n"
    "I\255\261FABMBBFFF\n"
    "I\254\371AcAfCBACAMgC\n"
    "I\254\150FBACABiJMgB\n"
    "I\253\151FaCBMBFFMgJ\n"
    "I\253\325BAcAfCAcAfCLB\n"
    "I\254\166CCICAFFFB\n"
    "I\255\156FBMBBFAcJF\n"
    "I\257\104CCIACACbMF\n"
    "I\253\337AABMFFFFB\n"
    "I\256\306CABACCCFB\n"
    "I\315\371FJBMFFBFF\n"
    "I\255\246BMFFBiCFaCdB\n"
    "I\254\254CCIAMgBMFF\n"
    "J\256\327BBFaAcJFFBAC\n"
    "J\255\373BMFBMFFFAC\n"
    "J\260\174FaCdBBBFaFFJL\n"
    "J\256\372CCIFBMFFBC\n"
    "J\257\161CAFACBMBBF\n"
    "J\256\256ACBCABMFJL\n"
    "J\256\142BBFaBMFFAcJF\n"
    "J\257\316ACAfCMCIMCI\n"
    "J\255\315ABFJCBMFFL\n"
    "J\256\246BMFJCFALCC\n"
    "J\256\114FABMFFFAFaC\n"
    "J\256\141BBFaFACbgAAAC\n"
    "J\262\374FBBABFBMFB\n"
    "J\260\101BMFBICBFJK\n"
    "J\256\140BBFaFBFFBMF\n"
    "J\256\346FBACAFaCBMF\n"
    "J\256\326FBACBFAcAAC\n"
    "J\256\350FBACAFFBAC\n"
    "J\254\112MFFBiCFBFJL\n"
    "J\260\117CFFFBMFMFL\n"
    "J\260\137FBFBFACMFL\n"
    "J\260\247ACBMFFBiCJFl\n"
    "J\260\255ABMBFFJLAfC\n"
    "J\256\143BBFaBMFABMF\n"
    "J\256\243FBIJFlCALCC\n"
    "J\256\245FBBFACBACC\n"
    "J\257\335JMFFAMgACLB\n"
    "J\257\331MgAMgAMgABMFF\n"
    "J\256\337FBMBBFFBAC\n"
    "J\256\341FaCFaCFaCFBAC\n"
    "J\260\126CFFFBMFJBB\n"
    "J\260\160MFFJBMFFaCdB\n"
    "J\255\335CAFMFFBBAC\n"
    "J\260\141FBMFFFBFFB\n"
    "J\255\354FJABMFFBAC\n"
    "J\255\323ABBMFBBMFF\n"
    "J\256\167BFJFBMFFFB\n"
    "J\256\124BcJFBMFBmFAC\n"
    "J\256\251ACBFBMFBMF\n"
    "J\255\324ABBMFAFFJK\n"
    "J\256\325FBACBFACJK\n"
    "J\257\321FFFBACFFJB\n"
    "J\257\350AJMCBIBFJFl\n"
    "J\260\136FBFBMFFFAC\n"
    "J\255\260FaCdBAFaCFBFB\n"
    "J\260\252BFBMFBMBMF\n"
    "J\255\350BMCAFBLBBB\n"
    "J\260\251BMBFBFaBMFF\n"
    "J\256\332FBACMFFBiAC\n"
    "J\255\366BMFAfCALAFaC\n"
    "J\256\164CAFBFFAFBF\n"
    "J\256\171BFJACACFBF\n"
    "J\256\137BBFaBFCAFFB\n"
    "J\256\342FBFFBACKAC\n"
    "J\260\135BMFFFACFBA\n"
    "J\257\301FBBFaAcAfCBAC\n"
    "J\261\376ACFBACJFlFaC\n"
    "J\256\166ABMFMFFBMB\n"
    "J\257\310AcAfCBACABiFK\n"
    "J\257\327JMFFALBMFF\n"
    "J\256\311BMFFFBFFBC\n"
    "J\257\145BFJCIAFFJC\n"
    "J\256\147ABMFFIIFBC\n"
    "J\257\275AcAfCBACBACA\n"
    "J\255\311ABFBBFBMFF\n"
    "J\260\165FBMJLFFAMgC\n"
    "J\256\172MFBmgCIMFBmgCI\n"
    "J\256\355FJFjCAFFBAC\n"
    "J\257\135FBFIAFFBAC\n"
    "J\260\163CCIFBMJLFF\n"
    "J\255\327ABBAFACAAA\n"
    "J\255\343CIABAFBFFF\n"
    "J\256\356FJFjCAMgBMFF\n"
    "J\257\302AcAfCBACALBL\n"
    "J\256\321MFFFFBBMFF\n"
    "J\256\175AABACFFBAC\n"
    "J\260\243FaCdBACFFBAC\n"
    "J\256\144BBFaBCABMFF\n"
    "J\256\370CCIBCABMFF\n"
    "J\257\147BFJCIFBFBF\n"
    "J\262\273BFaBCCAFBFF\n"
    "J\257\272AFBAFBAFJC\n"
    "J\260\144FJFFBiACFBC\n"
    "J\256\102FJFFBiACBMF\n"
    "J\256\127BcJFFJFFBiAC\n"
    "J\256\266FBIFJFFBiAC|j2-y3\n"
    "J\256\373CCIMFFBFaFaC\n"
    "J\257\165FBBMFFFFAC\n"
    "J\260\167ACFFBCAIFB\n"
    "J\260\175FaCdBFBMFFFB\n"
    "J\260\111BFBMFFABiAC\n"
    "J\257\141BFBMBFFAFjC\n"
    "J\263\165FBIAJFBCFacaCf\n"
    "J\256\165BFJFBBFBMB\n"
    "J\256\260FMFJMCIMCI\n"
    "J\256\352FBACACFBFF\n"
    "J\257\262AFBACBMFFF\n"
    "J\257\300FBFFAcAfCBAC\n"
    "J\255\334ACFMFFJBMF\n"
    "J\267\152FBIBMFFBFaC|j2-y3\n"
    "J\264\241FBIAFBMFFB|j2-y3\n"
    "J\263\171AFBFBMFCFacaCf\n"
    "J\256\247ABMFFFALCC\n"
    "J\263\164FBMFBACCFacaCf\n"
    "J\263\123BFaBACBMBFF\n"
    "J\256\135FaBgIAAcAfCBAC\n"
    "J\261\141FBBBFBFaBMB\n"
    "J\256\365FFFJCBCIAC\n"
    "J\256\242FBFFIBBLCC\n"
    "J\255\120FAfCFBIAFJK\n"
    "J\257\142BFAcAfCBMBFF\n"
    "J\263\166FACbgAAACCFacaCf\n"
    "J\257\264AFBACAFFJC\n"
    "J\256\323JMFFCAFFJC\n"
    "J\263\161FaCBMFFBCFacaCf\n"
    "J\256\170BFJAFBFFaFaCf\n"
    "J\255\365FBIAJFBBMF\n"
    "J\256\151MFJFBBFBiAC\n"
    "J\256\173AABFBFBFAC\n"
    "J\263\176ACFFBACCFacaCf\n"
    "J\255\313ABFAfCFBIBB\n"
    "J\255\341CIFBMFFBAC\n"
    "J\255\360BFJMFFBBMF\n"
    "J\256\161ABMFFFMgBLB\n"
    "J\256\347FBACJCILAC\n"
    "J\260\121CFFFBMFFBC\n"
    "J\263\172AFBACAMmgCFacaCf\n"
    "J\257\333JMFFBMFBMF\n"
    "J\257\123AFBIFBFFBC\n"
    "J\257\307AcAfCBACBMJC\n"
    "J\257\340AfCBMFFALAL\n"
    "J\257\175FJBMFJFaBFaC\n"
    "J\260\250BFBFFMgCCCC\n"
    "J\255\326ABJFFFBFFF\n"
    "J\260\164FBMJLFFMFL\n"
    "J\255\277ABBFCAFBMF\n"
    "J\261\366FBACAFLMBF\n"
    "J\257\132FBFIBJFBFF\n"
    "J\257\140BMBFFCAFFB\n"
    "J\257\353AJMCBIJFlFaC\n"
    "J\257\150BFJCIJFaBFaC\n"
    "J\257\265AFBACCALBC\n"
    "J\263\121BFaBACJFaBFaC\n"
    "J\256\126BcJFBFBMFBF\n"
    "J\257\146BFJCIFBMJC\n"
    "J\261\323AFLMBFAFJK\n"
    "J\262\176CAFFJBFBiFlC\n"
    "J\257\102CCIACCAFaBgF\n"
    "J\257\311AcAfCBACACMgJ\n"
    "J\260\241FaCdBFBiALFBF\n"
    "J\253\152AFaBMBFJLMgJ\n"
    "J\256\267FBIFBMFFBC|j2-y3\n"
    "J\255\304ABFFFJCFFB\n"
    "J\256\160BLBAFaCFFFB\n"
    "J\255\345BFCAFBMFBB\n"
    "J\257\274AcAfCBACBFMgJ\n"
    "J\256\111FBIBMFFBFF\n"
    "J\257\337JMFFAJABAC\n"
    "J\257\166BMFFFMFBiFC\n"
    "J\256\121BcJFBMFFBiAC\n"
    "J\257\323FFFBACAFFL\n"
    "J\257\276AcAfCBACBFJK\n"
    "J\256\145BBFaACACBMF\n"
    "J\254\171CCIBFAfCJBL\n"
    "J\257\144ABiCMgJBMBFF\n"
    "J\256\310BFMgJAFABAC\n"
    "J\255\333ABACFBMFBB\n"
    "J\262\134CCIFMFJFJC\n"
    "J\257\120FAFaCBBACCC\n"
    "J\263\163FBMFFFBCFacaCf\n"
    "J\256\324BMFFBiCJMFF\n"
    "J\256\366CCIBMFFBiAC\n"
    "K\261\352FBACBFCAFFB\n"
    "K\261\114MFJFFBACFBC\n"
    "K\262\247BMBFFFBBFAC\n"
    "K\262\276AFBACAFaCAFaC\n"
    "K\260\354FBIFBMFICAC\n"
    "K\263\261FaCdBACFMFFAfC\n"
    "K\262\107CCIBFABAFaCC\n"
    "K\266\300FBBFBMBFFAC\n"
    "K\252\107FBBBMFFFBAC\n"
    "K\263\146ABALBMFFFAC\n"
    "K\261\361FBACFFJBKJC\n"
    "K\262\120CCIFJFBFFBF\n"
    "K\264\337FBFAFaJMiJFlFaC\n"
    "K\263\242BFBMFFaBgIFaCdB\n"
    "K\254\105FBIFBFFBIBC|j2-y3\n"
    "K\263\334BMFBMFFAMgAL\n"
    "K\264\367CCIBMFFAMgAL\n"
    "K\260\256FBBMFFFBAFFaf\n"
    "K\260\311FBBFFFJLLMgJ\n"
    "K\261\167BMFBMFBALCC\n"
    "K\263\145LMBFBMFFFAC\n"
    "K\262\264BMFFFMFFBiAC\n"
    "K\260\362FBBFFFACFBF\n"
    "K\261\110BBFaFJCFBMFB\n"
    "K\263\127FFJCBMFFFJL\n"
    "K\260\260ABCAMMMBCCC\n"
    "K\265\342FBBAMgCAFBAC\n"
    "K\261\317FBCIACCAFAC\n"
    "K\262\171FBFIFBCIACC\n"
    "K\265\352BFJFaFLBBCAF\n"
    "K\263\134CFFFBMFAFFB\n"
    "K\263\275AFaBMBFFACCC\n"
    "K\261\152MFBmgAfCBMFBIC\n"
    "K\261\320FBFAFaBgIAFAC\n"
    "K\265\337FBBBMAFBACF\n"
    "K\260\270ABBMFFBMBFC\n"
    "K\261\270FBIMFJFLBLB|j2-y3\n"
    "K\261\322FMFJAFACBMF\n"
    "K\264\246FBIBMFFAMgAL|j2-y3\n"
    "K\260\267ABMFFFFBFaFaC\n"
    "K\262\173FBFIBMFFFJL\n"
    "K\261\144BFJMFFBCIAC\n"
    "K\261\261FBIBBFaJLFBF|j2-y3\n"
    "K\263\274DLFABMFFFAC\n"
    "K\261\102BcJFABiFKBMFF\n"
    "K\262\126CCIBMFFFBiAL\n"
    "K\326\346AcAfCBACFBBFF\n"
    "K\263\314BMFFFBFFIFaC\n"
    "K\261\155ACCAFBACAAA\n"
    "K\262\275AFaCCFaCFFBAC\n"
    "K\262\323AcAfCBACBMBFF\n"
    "K\265\346FBBACCAFBAC\n"
    "K\261\124BLBFJCFBMFBg\n"
    "K\272\107ACBAfCFACAAA\n"
    "K\262\243BFCAFJAFBFF\n"
    "K\265\370BFaBCBMFFFJL\n"
    "K\260\365FBFCAFFBJFlC\n"
    "K\263\152FBFJBBCAFJK\n"
    "K\261\327ACFFBACCCFB\n"
    "K\263\104BMFBICBBFaAL\n"
    "K\261\111BBFaBFFBACFaC\n"
    "K\261\302FBIACCABFaFaC|j2-y3\n"
    "K\262\327AcAfCBACACaCCC\n"
    "K\262\337MCIMCIABMFF\n"
    "K\261\112BBFaABFABMFF\n"
    "K\262\121CCIFBFBACFjK\n"
    "K\245\272AABFBACCFFBg\n"
    "K\261\146BFJFBBFACCC\n"
    "K\260\323BFCABMJLBMF\n"
    "K\260\333BMFBMFFBMFF\n"
    "K\263\271BFCAFBMFFFB\n"
    "K\262\320AcAfCBACMgJBMF\n"
    "K\263\136CFFFBMFACAfC\n"
    "K\261\140BCABFaBMFBMB\n"
    "K\261\241ACBFBFFBMFF\n"
    "K\262\140CCIBFaJLFBAC\n"
    "K\262\324AcAfCBACBMFFB\n"
    "K\266\151ABAFBFFFCFacaCf\n"
    "K\261\300FBIABAFBFFF|j2-y3\n"
    "K\261\122BLBBBFaFFBAC\n"
    "K\263\266BACABAFBFFF\n"
    "K\262\115CCIFBFFBMFF\n"
    "K\261\244ACBFBBFBMFF\n"
    "K\263\144FBFFBMFFFAC\n"
    "K\261\265FBIBFCAFAcJF|j2-y3\n"
    "K\263\135CFFFBMFJFlFaC\n"
    "K\263\267FBFaBCCCCMFF\n"
    "K\261\333BFMgJAFFaBFJC\n"
    "K\262\356AJMCBIACBMF\n"
    "K\261\271FBIFBBFBMFF|j2-y3\n"
    "K\262\312CAFBACBMFFF\n"
    "K\262\325AcAfCBACBMFFF\n"
    "K\261\275FBIMFFBFaBMB|j2-y3\n"
    "K\261\344FBMBBFFBMFF\n"
    "K\261\137CCABMFFFBAC\n"
    "K\260\274ABBMFFFACBB\n"
    "K\261\332BFMgJACAFFJC\n"
    "K\263\125ABFCCBFABiAC\n"
    "K\266\145MFFBCIACCFacaCf\n"
    "K\262\304AFBAFBMFBmgBA\n"
    "K\262\346JMFFCABMFJL\n"
    "K\261\264FBIBFaJLFBAC|j2-y3\n"
    "K\262\110CCIBIJKBIJK\n"
    "K\262\277BBFaJLFAfCFBF\n"
    "K\265\333FBBFBFABMFF\n"
    "K\261\142BMBBFFFFBiAC\n"
    "K\261\151MFBmgBFFFFBiAC\n"
    "K\300\112JMFBFBMFAAA\n"
    "K\262\267BMFFFJCILAC\n"
    "K\265\310JMFFBFFFBiAC\n"
    "K\263\273FBFABMFFFAC\n"
    "K\263\276ABMFFFMgCCCC\n"
    "K\263\257FaCdBFBMFFBAC\n"
    "K\263\250ACFFBCAIAMgC\n"
    "K\260\261ABBFBMFBFaFB\n"
    "K\260\273ABBFBMFFFAC\n"
    "K\262\303AFBAFBBMBFF\n"
    "K\262\113CCIAFJCBACC\n"
    "K\263\243FBFABMFFFaCdB\n"
    "K\261\245ACBBFBMFFFB\n"
    "K\265\163CIAFaJCBMBBF\n"
    "K\263\263FaCdBAMAFFBLB\n"
    "K\260\312AFBMFFBFIMgJ\n"
    "K\260\363BCABFaBMFFBF\n"
    "K\261\157AABBMFFFFBC\n"
    "K\263\142JMFFFACbgAAAC\n"
    "K\263\156FBMFFFBAFaJC\n"
    "K\326\337CAFBACBFBMF\n"
    "K\261\103CCIJFaBFaCAfJF\n"
    "K\261\306FBIJFFFBFFF|j2-y3\n"
    "K\261\321BMFFFACAFJK\n"
    "K\260\366FBIBFCAFBMF\n"
    "K\263\255FaCdBBFCAFBMF\n"
    "K\262\355AJMCBIABMFF\n"
    "K\263\143BMFFFACFJFaC\n"
    "K\265\247AFBAFBMFFFB\n"
    "K\262\274FBMBBFFFBAC\n"
    "K\264\171FBIFBBBMBFF|j2-y3\n"
    "K\263\150ACMgABMFFFAC\n"
    "K\260\374BcJFMFFBFaBMB\n"
    "K\262\305AFBAFBABFBC\n"
    "K\263\241BFCAFBMFFaCdB\n"
    "K\260\306FBMFBMBFFBB\n"
    "K\263\254BMFFBMFFFBA\n"
    "K\260\276ABFMFJBMFBB\n"
    "K\261\131BLBJMFFJMFF\n"
    "K\265\336FBBBMFFJMFF\n"
    "K\263\130CFFFBMFBFMgA\n"
    "K\261\346BFLJMFFFBFF\n"
    "K\324\263FBIMFJBLBLB\n"
    "K\263\302BFJFBACFBAC\n"
    "K\261\113BBFaBALBCBLB\n"
    "K\260\310FaCFaBgAAFACMgJ\n"
    "K\262\162ABgCFaBgFBMBBF\n"
    "K\260\335BMFFBMFFBMF\n"
    "K\263\245BMFFBFIFaCFaBg\n"
    "K\260\337BMFABAFBFFF\n"
    "K\261\171ABBAFACALCC\n"
    "K\266\154AFFBBFBIFaCdB\n"
    "K\261\145BFJMFFBMFFB\n"
    "K\267\273CCIBBFaACBMF\n"
    "K\261\375ACACBMFAFaJC\n"
    "K\262\335MCIMCIBFCAF\n"
    "K\262\172FBFIBMFFBFF\n"
    "K\263\260FaCdBFBFALFBF\n"
    "K\262\166BFAcAfCCIACFB\n"
    "K\262\244BMBFFAFaCBMF\n"
    "K\262\311CAFBACBFCAF\n"
    "K\266\251FaCdBAFaCAFBFF\n"
    "K\262\104CCIBFBMFBAC\n"
    "K\263\256FaCdBFBFALAFaC\n"
    "K\262\326BMBFFAcAfCBAC\n"
    "K\261\336JFMgKACBMBBF\n"
    "L\270\252FBBFaCACAFFJC\n"
    "L\264\244FBIMFJFAfCFBF|j2-y3\n"
    "L\260\266ABBMFBMFFBFB\n"
    "L\266\274ACBMFFBiCAFaJC\n"
    "L\264\365CCIBMBFBMBMF\n"
    "L\271\102BMFBMFFFBCFacaCf\n"
    "L\267\353FBFIFBBBMFJC\n"
    "L\265\372CFFFBMFCMFaAC\n"
    "L\266\126FBFBFACBiFKAC\n"
    "L\264\251FBIACCAFFJFaC|j2-y3\n"
    "L\266\370ABMCAFBACFJC\n"
    "L\267\305CCIBMFFBMBBF\n"
    "L\266\371BcJFBBFaACbgAAAC\n"
    "L\271\114BMBFBMBMFCFacaCf\n"
    "L\266\120MgJBMFBMFFFAC\n"
    "L\303\270AcAfCBACACFFAfC\n"
    "L\266\175BMFFBMFFFFJB\n"
    "L\266\245FaCdBFBiALABMFF\n"
    "L\265\363AABFBFFBIFFB\n"
    "L\304\261CCABFaBMFFFJL\n"
    "L\263\316BBFaFBFFBMFBB\n"
    "L\264\110BBFaFBBFFACCC\n"
    "L\263\352BMFAFaBMJLFJC\n"
    "L\263\364FBIFBBFFFALL\n"
    "L\264\253FBIAFaBMJLFJC|j2-y3\n"
    "L\264\261FBFBFFIBAFJC\n"
    "L\264\303FBACBBFaBMFMF\n"
    "L\264\332FBFFFBACAFaJC\n"
    "L\266\241BMFFBMFFBMFF|l1-l5\n"
    "L\266\176BMFFBMFFFBAC\n"
    "L\263\337FBFBMFCAFBMF\n"
    "L\264\247FBIBFaFBMFFFB|j2-y3\n"
    "L\264\301FBBFFFACJMFF\n"
    "L\264\321FBACFBBFFFAC\n"
    "L\266\121BMFBFBMFFFAC\n"
    "L\264\333FBBFFFACAFaJC\n"
    "L\265\271AcAfCBACACFBMF\n"
    "L\266\132BMFBFBIBFMFF\n"
    "L\276\345BMFFFBFBBFJL\n"
    "L\266\324FBBBMFBFFIMgJ\n"
    "L\265\136FBFIFBFFACFFa\n"
    "L\265\254AFBAFBJMFFMgJ\n"
    "L\271\112BMFFBMBICCFacaCf\n"
    "L\266\250FaCdBBMFFBMFFC\n"
    "L\264\272BMFFBFBMFBAC\n"
    "L\265\262AcAfCBACFBFBMF\n"
    "L\260\351BMCAFFJCMFLF\n"
    "L\260\355BFBMFBFFaCFBF\n"
    "L\264\362CCIFBBMFJMFF\n"
    "L\266\261FMFJABBFBFFF\n"
    "L\261\163AABAFFBFBIMgB\n"
    "L\267\127ACBFBBBFLJBL\n"
    "L\264\344CCIFBBFACMFL\n"
    "L\265\167FJBMFFBMFFJC\n"
    "L\265\261AcAfCBACBFACJK\n"
    "L\266\265FBIFABMFFFAC\n"
    "L\266\102CFFFBMFAFBFF\n"
    "L\265\364FBFBFABiACKAC\n"
    "L\265\246AFBAFBFBMBAC\n"
    "L\263\312ACACACACACFB\n"
    "L\264\262FBBFBMFFAFJC\n"
    "L\265\265BFBIALAcAfCBAC\n"
    "L\265\374CFFFBMFMFBMF\n"
    "L\264\376CCICAFAcAfCAcAfC\n"
    "L\266\142FBMFFFBBMBFF\n"
    "L\265\116FBFABMFFACCC\n"
    "L\264\116BFBMFBACFJLC\n"
    "L\266\260ABAFBFFFFBAC\n"
    "L\264\140AABAJFBBMFFF\n"
    "L\266\266JBBFABMFFFAC\n"
    "L\264\273BMFFFBFABMFF\n"
    "L\263\323JMFFCAFFJCFaJ\n"
    "L\264\170BCABFaBMFAFFBg\n"
    "L\264\271BMFFBMFFBMFF|y5-y1\n"
    "L\265\112ABAFBFFFACCC\n"
    "L\265\166FJBMFBCABMFF\n"
    "L\265\375CFFFBMFFBFBF\n"
    "L\266\100CFFFBMFMgABMF\n"
    "L\266\110AFaBMBFACbgAAAC\n"
    "L\264\313FBACFBACFBAC\n"
    "L\266\105CFFFBMFACAAA\n"
    "L\264\115MFFFBIBMFFBC\n"
    "L\334\140FBMJLFFAFBFF\n"
    "L\271\105CAFACbgAAACCFacaCf\n"
    "L\300\110FaCdBAFBMFFCFacaCf\n"
    "L\264\270BMFFFBFFBMFF\n"
    "L\265\174AFBACCABMFJL\n"
    "L\265\264AcAfCBACAFaMBFL\n"
    "L\265\275CAFFFBCAFBMF\n"
    "L\265\115AFaCCFJCCACCC\n"
    "L\262\250FaBFBIFBMFBAC\n"
    "L\266\104CFFFBMFAJFBC\n"
    "L\263\320ACFMFFJBMFBB\n"
    "L\263\340FBBMFBMFFBiAC\n"
    "L\264\372CCIBMFFFACBB\n"
    "L\264\114CAFBMJLFFFBC\n"
    "L\264\153ACBFJFBFBMFF\n"
    "L\264\300FFJCFFJCBMFF\n"
    "L\266\125ABFCCBMFFFAC\n"
    "L\266\244FaCdBCAFACbgAAAC\n"
    "L\271\106FBFCAFFFBCFacaCf\n"
    "L\264\327FBACJMFFJMFF\n"
    "L\265\165AFFJCFBMFCAF\n"
    "L\264\274AFFJCBMFBMFF\n"
    "L\265\333CAFBFFABMFFF\n"
    "L\266\112BMFFFACBBFaFB\n"
    "L\264\302FBBMFFFBJMFF\n"
    "L\266\127FBFBFACMgABMF\n"
    "L\265\150BFJCIFaCBMFFB\n"
    "L\263\366FBIBMFFFBFJC\n"
    "L\264\243FBIBMFFFBFJC|j2-y3\n"
    "L\265\173AFBACBMFFBFF\n"
    "L\267\265MJFBBFACJFlFaC\n"
    "L\264\347CCIBFJFBBFFaC\n"
    "L\265\156FaCACAFBMFCAF\n"
    "L\267\146FBIFBBACFBMF|j2-y3\n"
    "L\264\311FBACFBMFFBAC\n"
    "L\264\366CCIBMFFBAFaAA\n"
    "L\265\153BFJCIFBMFCAF\n"
    "L\265\245AFBAFBFBFFBC\n"
    "L\265\252AFBAFBACFBMF\n"
    "L\265\251AFBAFBBMFBMF\n"
    "L\262\316AcAfCBACBFAfCJL\n"
    "L\265\243BFCAFBMFFBFF\n"
    "L\271\104CAFABMFFFCFacaCf\n"
    "L\266\167ACFFBCAIALBL\n"
    "L\264\103BcJFFBBFFFBAC\n"
    "L\266\122BMBBFBMFFFAC\n"
    "L\263\325FBFBMFFBCFBC\n"
    "L\266\272ACBMFFBiCFJFaC\n"
    "L\261\337BMFFAFaBMBFJL\n"
    "L\265\146ACAFBACBMBFF\n"
    "L\264\144JFFFBFFFALCC\n"
    "L\264\166FMFJJFFIBFFF\n"
    "L\266\117MFBmgJBBMFFFAC\n"
    "L\263\306ABFBBFABMFFB\n"
    "L\265\373CFFFBMFFCAFB\n"
    "L\264\111BBFaFBMFBMBFF\n"
    "L\264\266CAFBBCAFBMFF\n"
    "L\264\137AABAFBMFFAFaC\n"
    "L\264\124BMBFBMFBMBFF\n"
    "L\252\136FBFaBCCCCACMgJ\n"
    "L\271\115FMFJBMFBBCFacaCf\n"
    "L\270\311BFaBACFBMFFBC\n"
    "L\266\322FBBBMFFFACMgJ\n"
    "L\263\370FBFCAFFBMgBFaC\n"
    "L\263\304ABBFCABFaBFFbgA\n"
    "L\264\125BMBBMFFBMFFF\n"
    "L\264\316FBACFFFJCFFB\n"
    "L\266\124ABiCMgJBMFFFAC\n"
    "L\265\114AFFBBBBFACCC\n"
    "L\264\102BcJFFaBFJCBMFF\n"
    "L\264\162ACBACFBMFFBB\n"
    "L\265\123ABgACAFBMJLFF\n"
    "L\270\316BFaBACACACBMF\n"
    "L\264\345BFMgJAFFaBgFCFacaCf\n"
    "L\266\257FJAfCABAFBFFF\n"
    "L\264\255FBIBMFFFJFagAA|j2-y3\n"
    "L\267\156FBIACCAFFBLB|j2-y3\n"
    "L\266\247FaCdBBMFFFAFagAA\n"
    "L\265\270AcAfCBACAFaCBMF\n"
    "L\270\250FBBCCIAFaCBMF\n"
    "L\264\120BLBJFkABMFBIC\n"
    "L\265\147BFJCIAFBACBB\n"
    "L\262\270FJBMFBFAfCJBL\n"
    "L\266\161BMFFFBMFFBFF\n"
    "L\265\365FAFaCBBBFABiAC\n"
    "L\264\131BFJBMFFBiCFaCbgB\n"
    "L\264\142FBMFIKACALCC\n"
    "L\265\303JMFFBBFaJFjCML\n"
    "M\267\122ACCABFaALCCAFaC\n"
    "M\267\164BMFFBFCAFBMFF\n"
    "M\267\116BFCAFBMFFALCC\n"
    "M\271\110BMFBMFFBFBCFacaCf\n"
    "M\266\351BMFBFBMFABACF\n"
    "M\267\317CAJCFBMBBFFBF\n"
    "M\267\341ABgAFBFBMFABiAC\n"
    "M\273\267FBFBMFABACCFacaCf\n"
    "M\271\135ACFFBCAIACBMF\n"
    "M\267\166BMFFMFBFFMFFaC\n"
    "M\272\327BFaBCBMBFBMBMF\n"
    "M\266\256FBFBAABAFBFFF\n"
    "M\270\321AFaJMBFFMgAAFFB\n"
    "M\266\364FBIABMBFFJLAfC\n"
    "M\264\156ACBMFFBiCFBFJL\n"
    "M\270\323CFFFBMFBFAcAAC\n"
    "M\270\373FBMFFFBBFACAC\n"
    "M\271\152FaCdBFBMFBMALFB\n"
    "M\267\306CCIBMBFBFaBLFF\n"
    "M\275\305BFaBACBMFFAMgAL\n"
    "M\274\145BBFaFBBBMFFFAL\n"
    "M\267\120JFFBMFKACALCC\n"
    "M\272\176CCIFBBBMFFFJC|y10-j7\n"
    "M\271\170FFJBiFABMFFFAC\n"
    "M\261\363BFAfCFBBBFFBAC\n"
    "M\270\161CAFBFFAFBIKAC\n"
    "M\270\327CFFFBMFFBFBMF\n"
    "M\267\176BBCAFCAFFFBAC\n"
    "M\267\245FBACFBMgBMFFaCF\n"
    "M\270\124FBACFBACFFBAC\n"
    "M\267\115BMFFBMBICALCC\n"
    "M\270\267BFJFaFLBMFBmFAC\n"
    "M\271\165FBBFBMFFBABAL\n"
    "M\270\163MFFJBMFCAFFFB\n"
    "M\266\311ABALFABMFFFAC\n"
    "M\266\373BcJFCAFMFFBBAC\n"
    "M\270\150AcAfCBACBMFBMFF\n"
    "M\273\272BMFBFBMFMFCFacaCf\n"
    "M\267\275CCIFJBBMFFBAC\n"
    "M\271\252FBFBMFCAIFBFaC\n"
    "M\267\276CCIFBBFFBMBFF\n"
    "M\270\171JMFFFBMBBFAcJF\n"
    "M\266\305ABFBFFBMFFFAC\n"
    "M\266\312ABBLBABBFBFFF\n"
    "M\267\263BFBFJFFBACCAC\n"
    "M\270\374FBFFBMFFFBKAC\n"
    "M\270\157BMBBFJFFIBFFF\n"
    "M\272\136FBIBBFaJLAFBFF|j2-y3\n"
    "M\266\340BMFBMFBBMFBMF\n"
    "M\270\326CFFFBMFFBFFBC\n"
    "M\270\325CFFFBMFFFBIKC\n"
    "M\270\352CIAFaJCBMFFFAC\n"
    "M\271\175ACBMFFBiCMFBMF\n"
    "M\267\117CAFAcAfCAcAfCALCC\n"
    "M\267\124AFBACBAJCALCC\n"
    "M\271\123FBMJLFFAJCBCB\n"
    "M\270\160BMBBFFBFABMFF\n"
    "M\266\313ABAFBMFFFAMAA\n"
    "M\267\323BMFFMgABMFACCC\n"
    "M\270\324CFFFBMFCAFFFB\n"
    "M\273\135FBBFaBgFaAFFACCC\n"
    "M\271\242ACBMFFBiCAFBMB\n"
    "M\271\354BBFaBCIMFFBFaFaC\n"
    "M\267\126ACBFBBMFFFFAC\n"
    "M\267\163BFCAFFBACAJFB\n"
    "M\272\316BMFFFAFFBBFBF\n"
    "M\266\325FBFJLFBIJFlCMgJ\n"
    "M\270\164FBFFIBBMFFBFF\n"
    "M\270\333CFFFBMFJFMKAC\n"
    "M\270\361BMFBFBIBFJBAC\n"
    "M\270\140AFBAFBMFFBiCMB\n"
    "M\270\242JMFFABMFFBFaAC\n"
    "M\266\354CAFLBJJMFFFBF\n"
    "M\271\254ABCABMBFFBMFF\n"
    "M\267\121FBACBMFFFALCC\n"
    "M\270\351BMFFFACFFBKAC\n"
    "M\267\154FBIBMFBMFFFAC|j2-y3\n"
    "M\272\242CCIFBBBFBFaBMB\n"
    "M\271\304BMFFBBBMFFFJC\n"
    "M\267\170BMFFACCAFFJFaC\n"
    "M\267\366BFJCIAFFJCBMF\n"
    "M\270\130AFBACABAFBFFF\n"
    "M\270\172JMFFBMFFFJMgAA\n"
    "M\270\365BMFBFBIJCILAC\n"
    "M\270\356ABAFBFBMFFFAC\n"
    "M\270\245AJMCBIAFBFFaFjC\n"
    "M\271\161FBFaBCCCCBMFFL\n"
    "M\267\376BFFBACFaCBMFFF\n"
    "M\271\101BMBBFFFJFFBiAC\n"
    "M\272\172CCIFBBBMFFFJC|j7-y9\n"
    "M\267\150FBIAJMCBIAFlFaC|j2-y3\n"
    "M\267\320CAJCFABMFFFAC\n"
    "M\271\173ACMJFABMFFFAC\n"
    "M\267\114AABBLBFJBiAFJK\n"
    "M\272\326BFaBCFBMFBMBFF\n"
    "M\270\241JMFFAFBMFFAFaC\n"
    "M\271\323FBBBMFFFACFBF\n"
    "M\271\241ACBMFFBiCAMgMFL\n"
    "M\271\365FBBBMFFFACBMB\n"
    "M\267\371BMFFJMFFBMBBF\n"
    "M\267\300CCIFJFBAJCCAC\n"
    "M\271\167FaCFaBgFABMFFFAC\n"
    "M\273\162BFaBACBMFFFBAC\n"
    "M\271\160FBFaBCCCCBMBFF\n"
    "M\271\124FBMJLFFAFaCBMF\n"
    "M\270\270BFJFaFLBMBFFMgJ\n"
    "M\271\141ACFFBCAIACCFaC\n"
    "M\271\141ACFFBCAIACFMgB\n"
    "M\271\163FBFaBCCCCACCFaC\n"
    "M\271\163FBFaBCCCCACFMgB\n"
    "M\267\107BFJCAFMFFBBAC\n"
    "M\270\364BMFBFBIAFaCBMF\n"
    "M\270\334CFFFBMFAFBBMF\n"
    "M\270\354BMFFFACJFBMFF\n"
    "M\271\174ACAfCFABMFFFAC\n"
    "N\272\360AcAfCBACFBFJLAFaC\n"
    "N\272\373AcAfCBACABAFBFFF\n"
    "N\272\164CCIBBFaFBMBFFAC\n"
    "N\271\350BBFaFBBMFFFACMgA\n"
    "N\272\161FBMFBFBMFBAFaJC\n"
    "N\267\247FBACMFFBiCFBFJL\n"
    "N\273\325BMFFBMFFAFaCBMF\n"
    "N\272\104ACBLMBFBMFFFAC\n"
    "N\272\336AFBAFBBBFaBMFMF\n"
    "N\272\130BFMgJAFFBBFFFAC\n"
    "N\272\303ALAFFJCFaCFaBFJC\n"
    "N\272\256CCIAFaBMBFFACCC\n"
    "N\271\322FBIBFCAFBMFFJL\n"
    "N\273\310ACFFBCAIMFFBiAC\n"
    "N\273\171CFFFBMFFBMFBMF\n"
    "N\273\176CFFFBMFBMFLbFAC\n"
    "N\272\143FBACFBBFFBMBFF\n"
    "N\272\365AcAfCBACBMCAFBLB\n"
    "N\273\303FBMJLFFFBFAFaBgF\n"
    "N\273\250BFBMFBFaFACbgAAAC\n"
    "N\273\305FBMJLFFAFBFBMF\n"
    "N\272\273ABgACFFFBMFFJKC\n"
    "N\273\356FFAfCABMBFFJLAfC\n"
    "N\273\332FaCdBAFaCCFaCFFBgAC\n"
    "N\271\356BBFaAFaCCFaCFFBAC\n"
    "N\272\342AFBAFBBMFFFFJB\n"
    "N\273\304FBMJLFFAfCJLAFaC\n"
    "N\273\333BFBIALABAFBFFF\n"
    "N\272\317FJBMFCAFAcAfCAcAfC\n"
    "N\272\243CCIFBACACBCAAC\n"
    "N\276\102BFJFBBFACCCCFacaCf\n"
    "N\272\330AFBACAFBMFFBFF\n"
    "N\273\335FBFaBCCCCFABMBB\n"
    "N\340\266ACFFBCAIBFAfCJL\n"
    "N\271\321BFBMFFaBgIJFlCFBF\n"
    "N\274\364BFBMFFaBgIJFlACCC\n"
    "N\272\374AcAfCBACFBFABMFF\n"
    "N\271\374BFCAFBMFFFBAAA\n"
    "N\273\331FaCdBBFCAFBMFFFB\n"
    "N\272\353CAFBACFBFFBMFF\n"
    "N\250\356AFFBMBBBBFABiAC\n"
    "N\273\175FBIAJFBCFFFBMF\n"
    "N\273\241CFFFBMFCABMFJL\n"
    "N\273\321ACFFBCAIAFBFJL\n"
    "N\272\245CCIFBMFFFBAJFB\n"
    "N\274\150MFJCABMBFFBMFF\n"
    "N\276\104FBMBBFFBMFFCFacaCf\n"
    "N\271\263ABAFaBMBFACbgAAAC\n"
    "N\274\127FBICABMBFFBMFF\n"
    "N\274\250ACBCABMBFFBMFF\n"
    "N\272\101AfCBMFFALALALCC\n"
    "N\271\334FJCABAFBFFFFBC\n"
    "N\272\335BFCAIBLBFABMBB\n"
    "N\271\336BcJFBFCABMFBBMF\n"
    "N\274\170AABBLBFBFIAFJK\n"
    "N\272\173CCIFBFFBMFFFAC\n"
    "N\272\113FBIBFCABMFBBMF|j2-y3\n"
    "N\272\167CCIBFCABMFBBMF\n"
    "N\273\311ACFFBCAIBMFBMF\n"
    "N\273\173CFFFBMFMgACALCC\n"
    "N\271\347BBFaALCCBMBBFFB\n"
    "N\273\100BMBBFCFFFBMFBB\n"
    "N\273\326BMFFBMFFABFKAC\n"
    "N\270\117FJBMFABMBFFAFB\n"
    "N\273\363ABMFFFBMBFFFJK\n"
    "N\272\175CCIFBMBBFFFBAC\n"
    "N\273\107BFJABFBCBMACAC\n"
    "N\264\137BFaBACACBMFFAFaC\n"
    "N\273\104BMFFBMFFFBFFIB\n"
    "N\272\321FBFIABMFFFABMF\n"
    "N\274\175FBBBMFFFJCBACC\n"
    "N\274\307FBBBMFFFACBMFF\n"
    "N\276\245BMFFBFFACCCFBF\n"
    "N\275\244JMFFFBBBMFFFJC\n"
    "N\272\103ACBBMFFBMBBFFaC\n"
    "N\272\251CCIBMFFBMBBFFaC\n"
    "N\273\312ACFFBCAIAFaCBMF\n"
    "N\273\357BMFABMFFFMgABCC\n"
    "N\272\370AcAfCBACABMFFBMB\n"
    "N\274\322FBACFBBBMFFFJC\n"
    "N\272\364AcAfCBACBMCAFBFL\n"
    "N\273\244CFFFBMFAFBACAFafag\n"
    "N\274\313FBACCAFFFBCIAC\n"
    "N\277\343BMFBFBIFaCBMFFB\n"
    "N\271\261ABFJCCABMFFBAC\n"
    "N\272\361AcAfCBACMFFBCIAC\n"
    "N\275\155AcAfCBACFBMFFBAC\n"
    "N\272\174CCIMFJFBMBCCCC\n"
    "O\274\242MFJFFBACFBCALCC\n"
    "O\277\362BMFBFBMFFFACCFacaCf\n"
    "O\274\166BMFFBFBMFBACAAA\n"
    "O\276\125ACFFBCAICABMFJL\n"
    "O\277\326CFFFBMFBMFFAMgAL\n"
    "O\276\134BMFFBMFFCABMFJL\n"
    "O\275\164AcAfCBACMFFACbgAAAC\n"
    "O\276\356FBACFBBFBMBFFAC\n"
    "O\273\365ABBFCAFBMFFACCC\n"
    "O\275\133AFBACBBFaFACbgAAAC\n"
    "O\275\322CFFFBMFBMFFFBAC\n"
    "O\276\152ACBMFFBiCAFBAKAC\n"
    "O\275\124FJBMFBFaJBAFBFFF\n"
    "O\272\312BFBMFBFAFFBMBBF\n"
    "O\275\167AcAfCBACACCAFFJFaC\n"
    "O\276\271BMFBMFFJCBMFBMF\n"
    "O\274\136BcJFFBFBMFCAFBMF\n"
    "O\275\367BCAFJBiBFaFBMFFFB\n"
    "O\273\366ABCAFBFFAFBICAC\n"
    "O\275\141BBFaALABMFFIAMFBmg\n"
    "O\272\362BMBMFBFFaCAcAfCBAC\n"
    "O\276\163BFBFFMgBCCCAMgBMF\n"
    "O\274\171BFJMBBFFaACfCCAFaC\n"
    "O\274\100BFJFaFLFACbgAAACBB\n"
    "O\300\273FBMFFFBAFlFaCAFFBg\n"
    "O\274\344CCIFBFFMgAAcAfCBAC\n"
    "O\275\132AFBACBFBMFBMBMF\n"
    "O\274\274FBIBMFFFBFFIBFaC|j2-y3\n"
    "O\274\310FBMFFFBAJFBBMFF\n"
    "O\275\347BMFFFACBMFFAFcgCC\n"
    "O\275\350AJFBAJFBBMFFFAC\n"
    "O\275\354FBFBFACFBFFIBFaC\n"
    "O\274\355CCIBMFFBMgFFFBFF\n"
    "O\277\355CAFBMJLFFFBCCFacaCf\n"
    "O\275\321CFFFBMFFBFABMFF\n"
    "O\275\340BCABFaBMFBMFFFAC\n"
    "O\305\361BMFMFJABMFBMBFC\n"
    "O\274\146BBFaACAFBACBMBFF\n"
    "O\276\137FBFaBCCCCFJFFBiAC\n"
    "O\274\341CCIFaCACAFBMFCAF\n"
    "O\275\320CFFFBMFFBFFBMFF\n"
    "O\277\357MFLMFLFBBFACCFacaCf\n"
    "O\276\105FBMBBFFACMFLCFacaCf\n"
    "O\274\321FBACFBBMBBFBMFF\n"
    "O\302\303FBBJFBFBMFBFKAC\n"
    "O\277\325CFFFBMFFBBJFBMF\n"
    "O\275\326CFFFBMFABAFBFFF\n"
    "O\275\317CFFFBMFABFBFFaCaC\n"
    "O\275\315CFFFBMFCAJCCAJC\n"
    "O\276\156BFBFFMgBCCCCFBFF\n"
    "O\274\351CCIFBBMFFFBJMFF\n"
    "O\275\325CFFFBMFJMFBFBMF\n"
    "O\274\131FaCdBCAFACbgAAACFBF\n"
    "O\275\154AcAfCBACBFCABFaBMB\n"
    "O\274\304BFCABMFBBMFAFJK\n"
    "O\271\375AABBFAfCBMFFAFJK\n"
    "O\272\115FBIBFAfCBMFFAFJK|j2-y3\n"
    "O\277\175CAFBACBFJFbFFBMF\n"
    "O\275\361BMFBFBIBFaACBMFF\n"
    "O\276\311CAFABMFFFCFacaCfFBC\n"
    "O\274\366FBFALFBIJFlCACCC\n"
    "O\275\372JFFIBFFFFBMFFFB\n"
    "O\275\337BMFFFACBFCAFBMF\n"
    "O\275\143AFBAFBFBACBMFFF\n"
    "O\275\114AJMCBIJLFaCBMBBF\n"
    "O\275\175BMBBFAfCBMFFALAL\n"
    "O\274\320FBACFBMBBFFFBAC\n"
    "O\273\253BBFaFBACABMFFFAC\n"
    "O\274\305FBMFFBCBFMgJAFJK\n"
    "O\275\247BFJFaFLBMBFFBMFF\n"
    "O\275\341BMFFFACFFBFBIKC\n"
    "O\273\122AFFBBBBFAFaCFBFB\n"
    "O\274\121BMFFBFBBBMFFFAC\n"
    "O\274\130FBIFBFBBBMFFFAC\n"
    "O\274\253BACFBFBBBMFFFAC\n"
    "O\271\364BCABMBACAFACBMB\n"
    "O\271\372BCABMBACAFACFJB\n"
    "O\275\163AcAfCBACFMFJBMFBB\n"
    "O\275\307BFABBMFFBACABiAC\n"
    "O\274\311BMFFFBBFACBCIAC\n"
    "O\274\257BFJFBACFBACAFFBg\n"
    "O\276\171ABMBFFJLAfCFFBAC\n"
    "O\300\161BMFFBFIFJCCACCC\n"
    "O\274\176FABMFFBFaALCCAFaC\n"
    "O\275\140BBFaALCAFBFFACCC\n"
    "O\276\151CAFBFFACBMFFBiAC\n"
    "O\274\151MFJAABAFBMFFAFaC\n"
    "O\274\173BFJFaFLBMBFFALCC\n"
    "O\274\144BBFaFJCCABMFFBAC\n"
    "O\275\374FBMFFFBACFBMFBB\n"
    "O\306\106FBFaBCCCCFFBBCAF\n"
    "O\275\327CFFFBMFACFBMFBB\n"
    "P\275\156AcAfCBACBMFBMFFBFB\n"
    "P\275\303AABBMFBMFFBFBFFBg\n"
    "P\276\320ACBBFCAFBMFFACfCC\n"
    "P\303\255AFBACACCAMFFALCC\n"
    "P\303\141FBIFBBMBBFBFABiAC\n"
    "P\303\150ACBFBBMBBFBFABiAC\n"
    "P\300\362ABgAFBBABAFBFFFFaC\n"
    "P\276\321ACBJFFBMFCACACfCC\n"
    "P\301\331BMBBFFBMFABACCFacaCf\n"
    "P\300\135ACBMFFBiCBBFaBMFMF\n"
    "P\276\367FBACAcAfCAcAfCFJCKAC\n"
    "P\276\364FBACAFJCBMFBMBMF\n"
    "P\277\263ABFFBMFBMFMFFFAC\n"
    "P\276\256CIALAFFJCFaCFaBFJK\n"
    "P\302\310FBBAFBMFFBFFACCC\n"
    "P\276\315AFBBMFABMFFFALCC\n"
    "P\277\105CCIABMFFBFMgJAFJK\n"
    "P\276\313BBFaFBFFBMBBFALCC\n"
    "P\275\345BFBMFBFFaCBMFFFAC\n"
    "P\277\305AABAFaBMBFFFJCFFBg\n"
    "P\276\301ACCACbgAAMFFBiACFBF\n"
    "P\277\371ACFFBCAIFBBFBMFF\n"
    "P\277\324CFFFBMFCIAFaJCBMF\n"
    "P\276\247ABFAFaBCCCCFABMBB\n"
    "P\276\360FBACFBFBMFCAIFBC\n"
    "P\304\133FBIBFACFBBFFABiAC\n"
    "P\277\365ACFFBCAIBBFaFBFJC\n"
    "P\301\176FBBBFCAFFBACAJFB\n"
    "P\277\313BFCAFFBACBMFFFJL\n"
    "P\301\350ACFFBCAIAFFBBFBF\n"
    "P\276\343FBMFBACAFACFBFBF\n"
    "P\277\156AFBACFBFFBMFFFAC\n"
    "P\276\336FBIBMFBMFBMFFBAC|j2-y3\n"
    "P\277\102CCIBMBBFAMgBMFBIC\n"
    "P\276\302FBIBFBMBMFFBMFFF\n"
    "P\300\131FBMFCAIFABMFFFAC\n"
    "P\277\167AFBAFBBMBFFMgACCC\n"
    "P\276\350BMFFFBFaBCCCCFFAfC\n"
    "P\277\125CAJCJFjCCFJCCACCC\n"
    "P\277\100CCIBMBBFFFJFFBiAC\n"
    "P\301\241FBBCCIFBMFFBCFBC\n"
    "P\277\243AcAfCBACFBMFFBCFBC\n"
    "P\301\143AFAcMBFAFACAcAfCBAC\n"
    "P\301\327MFJBMFBFCAFFBCFacaCf\n"
    "P\276\304FJCABAFBFFFBMBFF\n"
    "P\276\300MFJBMFBFCAFFBFBF\n"
    "P\301\137AcAfCBACAFaCFFFBCFacaC\n"
    "P\277\261JMFFFBFBMFCAIAAA\n"
    "P\277\321CFFFBMFFBBFFFBAC\n"
    "P\277\151BFJFBACFBACFABMF\n"
    "P\277\331CFFFBMFACFBMFFBB\n"
    "P\277\351FBMFFFBACFBMFFBB\n"
    "P\277\304FBMFBMJLFBBMFBIC\n"
    "P\276\326FBIBFAcAfJABAFBFFF\n"
    "P\301\301CFFFBMFACCAFFBLB\n"
    "P\277\340FBMFBACFABMFFFAC\n"
    "P\300\163FBCAFBMFFFLbFLFFF\n"
    "P\301\365FBFFFBACMFFBCIAC\n"
    "P\277\375ACFFBCAIMFFBCIAC\n"
    "Q\300\176BMFFBFJBACFBFJBAC\n"
    "Q\301\322FBMFFFBBBFaFBFFBMF\n"
    "Q\300\364FBFIBMBBFFBMFABAC\n"
    "Q\301\372FBBMFFFBBMFBMFFLB\n"
    "Q\300\300FBIALAFFJCFaCFaBFJC|j2-y3\n"
    "Q\304\353AFBICAFBFFAFBgICAC\n"
    "Q\301\102AFFJCAFACBMFBMBMF\n"
    "Q\302\324CFFFBMFFBBBMFBFFF\n"
    "Q\301\276CFFFBMFCAFMFFBBAC\n"
    "Q\301\344ACFFBCAIMFFFFBFaFaC\n"
    "Q\301\277CFFFBMFFBBFFBMBFF\n"
    "Q\301\312BMFFFACFBBFFBMBFF\n"
    "Q\300\265ACCACbgAAMFFBiACALCC\n"
    "Q\300\277FBIBBFaAFaCCFaCFFBAC|j2-y3\n"
    "Q\301\302CFFFBMFABMFFFAFBC\n"
    "Q\300\357ACCABMBBFMFFBiCFBC\n"
    "Q\301\131AcAfCBACBBFaABFABMFF\n"
    "Q\300\166ABBCABFaBMFBMFFFAC\n"
    "Q\301\107FJBMFABAFBFFFACCC\n"
    "Q\301\132AcAfCBACFBFFBMFFFAC\n"
    "Q\305\326AcAfCBACFBFBBCAIKAC\n"
    "Q\302\101AFaBMBFFBCCCCAFFFB\n"
    "Q\300\352CAJCBMFBMFBMFFBAC\n"
    "Q\301\367FBFaBCCCCFBACBMFFF\n"
    "Q\300\336CCIMFFMFFABAFBFFF\n"
    "Q\301\353ACFFBCAIABFFIAFlFaC\n"
    "Q\301\303JMFFCAFFJCCFFFBMF\n"
    "Q\300\373BMFFFBFCAFBMFFBFF\n"
    "Q\300\165ABFABMFFAFaALCCAFaC\n"
    "Q\301\154MCIMCIBMBFFFBBFAC\n"
    "Q\304\375BFBMFBFAFFBMFFFJL\n"
    "Q\300\370BFJCIFJCCABMFFBAC\n"
    "Q\300\255BLBACCFaCFABMFFFAC\n"
    "R\303\102BBFaJFaCBMFFABMFFFAC\n"
    "R\302\262AFBAFBBMFFBMFFBMFF\n"
    "R\303\103BFCAFJAAAFABMFFFAC\n"
    "R\303\115FBBFFMgBCCCFJCFBMFB\n"
    "R\303\314BFaBACFBACFBACFFBAC\n"
    "R\302\352ACFFBCAIBCABMFFFAC\n"
    "R\300\376BMFFFACCABFaJFjCFBFB\n"
    "R\302\264AcAfCBACBFCAFBMFFKAC\n"
    "R\302\276FBFFIBBFCAFBMFFKAC\n"
    "R\302\265AcAfCBACCAFFFBCAFBMF\n"
    "R\302\246FJBMFFBACFBACFaBFAC\n"
    "R\303\330BMFFFACCABMBFFBMFF\n"
    "R\300\271FBFBMBFFFBFBFACKAC\n"
    "R\303\104BMFFFBFACFABMFFFAC\n"
    "R\303\147AABBLBFBFFAFACALCC\n"
    "R\302\355ACFFBCAIFBBMFFFFAC\n"
    "R\303\370FBBBMFFFJCABBFBFFF\n"
    "R\303\277FBBCCIACAFBACBMBFF\n"
    "R\303\320CFFFBMFCAFBBACBMFF\n"
    "R\302\320FBMBBFAABAFBMFFAFaC\n"
    "R\302\175BFJCIMFJBMFBFCAFFB\n"
    "R\303\257AFBAFBCCIFBMFFBFBC\n"
    "R\302\275ACAFBACBMBFFMCIMCI\n"
    "R\303\372FBFaBCCCCFaCFaBAFACMgJ\n"
    "R\302\140BMFFMFFMFFABAFBFFF\n"
    "R\300\335CCIBFBMFBFAFFBMBBF\n"
    "R\302\367BFACLBBMAfCABBFBFFF\n"
    "R\302\263CAFBACBMFFFBMFFBFF\n"
    "R\301\173BFBMFBFAFBMFBMFBMF\n"
    "R\303\376CAFBACFJCFABMFFFAC\n"
    "S\303\375BFCAFBMFFBMFBMFFFAC\n"
    "S\303\350ACFFBCAIBFCAFBMFFJL\n"
    "S\362\262AcAfCBACBMFBMFBMFFBAC\n"
    "S\304\265FBBAMgBMFAFACCFFFBMF\n"
    "S\304\110AFaBMBFFBCCCBFBMFBAC\n"
    "S\303\321CFFFBMFBFCAFBMFFKAC\n"
    "S\305\350BMBFBFaBMFFAFBMFFCFacaC\n"
    "S\303\165CCIFBMFBACFABMFFFAC\n"
    "S\304\246FBBCCIBMFBMFBMFFBAC\n"
    "S\305\246JMFFFBBJFBFBMFBFKJC\n"
    "S\305\121FBMBBFFBBFBMFFBJMFF\n"
    "S\303\172CAJCBMFFFBBFACBCIAC\n"
    "S\305\135BFJFBACFBACABMBFFAL\n"
    "S\303\271BMBBFAcAfCBACABAFBFFF\n"
    "S\304\122FBMCFBMCBFJMBBFABiAL\n"
    "T\304\263CFFFBMFCAFBFFAFBICAC\n"
    "T\304\166BFCAFBMFJBiBFCAFBMFJL\n"
    "T\305\124AcAfAMFFBiCFaCdBBFCAFBMFF\n"
    "T\304\301ACFFBCAIBFCAFBMFFBFF\n"
    "T\305\375CFFFBMFBFACFBBFFABiAC\n"
    "T\306\103FBMJLFFBFACFBBFFABiAC\n"
    "T\304\171AFBAFBFFFBACFBBFBMFF\n"
    "T\304\313JMFFCAFFJCBFBFFMgACCC\n"
    "T\304\346FBACBMFFBMFFFBMFFBAC\n"
    "U\304\245AJMCBIBMBMFBFAFFBMBBF\n"
    "U\305\125FMFJABBFBFFFFABMFFFAC\n"
    "U\305\104BMFBFBIMFFMFFABAFBFFF\n"
    "U\305\123FBFaBCCCCBMFBFBIAFaCBMF\n"
    "V\305\345FBBAMgBMFAFACBFBFFMgACCC\n"
    "V\305\247BFCAFBMFFFBmFLFFFBFABiAC\n"
    "V\305\242AFBAFBBFCAFBMFFFBmFLFFF\n"
    "W\305\263ACFFBCAIBMBMFBFAFFBMBBF\n"
    ;
}
#endif /* FOR_STROKEDIC_CREATE_2 */
#endif /*__STROKEDATA_H__*/
/* ----- End of strokedata.h ---------------------------------------------- */
