
#define DEBUG_XIM

#include <stdio.h>
#include <sys/stat.h>
#include <ctype.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xos.h>
#include <X11/Xatom.h>
#include <X11/keysym.h>
#include <X11/DECkeysym.h>
#include <X11/cursorfont.h>
#include <X11/Xlocale.h>
#ifdef IMLIB
#include <Imlib.h>
#endif
#include "IMdkit.h"
#include "Xi18n.h"
#include "IC.h"

#include "defs.h"
#include "chinput.h"
#include "hzserver.h"
#include "hzclient.h"
#include "ImmClient.h"
#include "ImmModule.h"
#include "XIM.h"
#include "keyboard.h"
#include "handw.h"

#include "globals.h"

/* From `area.c': */
void MyDrawString (Window win, GC gc, int x , int y , char *str , int num );
void MyDrawString2 (Window win, GC gc, GC gbgc, GC big5gc, int x , int y , char *str , int num );
void MyXmbDrawString (Display *dpy, Window win, XFontSet fs, 
	GC gc, int x , int y , char *str , int num );
void HZrootDrawInputArea (char *buf , int len );
void HZrootDrawCandidateArea (char *buf , int len );
void HZrootDrawPanel (void);
void HZoverspotDrawInputArea (char *buf , int len );
void HZoverspotDrawCandidateArea (char *buf , int len );
void HZoverspotDrawStatus (void);
void HZoverspotDrawPanel (void);
void HZoverspotDrawLabel (void);
void HZoverspotDrawEntry (int x , int y , int w , int h );
void HZoverspotSetLocation(IC *ic);
void HZbaDrawPanel (void);
void HZkaDrawPanel (void);
void HZbaDrawWindow (void);
void draw_button_label (Display *dpy , Window win , GC pgc , int x1 , int y1 , int x2 , int y2 , int offset , char *str , int len );
void HZkaDrawWindow (void);
void HZkaDrawButton (void);
void HZvkDrawPanel (void);
void HZhwDrawPanel (void);
void HZprocCandidateWindow(int x0, int y0);
/* From `chinput.c': */
void usage (void);
void HZloadRCIME(void);
void HZinitDaemon(void);
void HZserverInfo(void);

/* From `color.c': */
void get_colors (char *forecolor , char *backcolor , char *bordercolor );
void get_FontGC (Window win , GC *gc , XFontStruct *font_info , char *colorname );
void get_ColorGC (Window win , GC *gc , char *colorname );
void load_font (XFontStruct **font_info , char *fontname );
void alloc_color (char *forecolor , char *backcolor , char *bordercolor );
/* From `config.c': */
void HZprocCirculateInputMethod(void);
void HZprocToggleWindow(void);
void HZnotifyEncoding (Display *dpy , Window win );
void HZnotifyInputMethod (Display *dpy , Window win );
void HZnotifyStatus (Display *dpy , Window win );
void HZnotifyToolbar (void);
void HZrecvQuery (XClientMessageEvent *ev );
void proc_close (void);
void proc_position (int x , int y );
void proc_lock(int lock);
void proc_lockwindow (unsigned long w );
void proc_releasewindow (unsigned long w );
void unlock_window (void);
void lock_focus_window (void);
void proc_plugin (Window win , int xpos , int ypos );
void proc_freewin (Window win );
void proc_encodingflag (int enc );
void proc_encoding (int enc );
void proc_inmethod (int method );
void get_input_method (int method );
void proc_default (void);
void proc_textcolor (int r , int g , int b );
void proc_panelcolor (int r , int g , int b );
void proc_dimcolor (int r , int g , int b );
void proc_lightcolor (int r , int g , int b );
void HZprocSwitchMode (void);
void HZprocSetMode(int mode);
void HZonspotPreeditClear(void);
void HZoverspotDrawInputArea();
void HZoverspotDrawInputPanel();
void HZoverspotDrawCandidateArea();
void HZoverspotDrawCandidatePanel();
void HZoverspotDrawCandidateLabel();
void HZrecvConfig (XClientMessageEvent *ev );
void HZrealProcCommand (KeySym keysym , int state );
void HZprocXIMCommand (KeySym keysym , int state );
void HZprocCommand (XClientMessageEvent *ev );
void HZrecvInput (XClientMessageEvent *ev );
int HZgetInputMethod (char *imd );
void HZloadInputMethod (int id );
void HZswitchInputMethodById (int id );
/* From `convert.c': */
void gbchar_big5char (char *gb , char *big5 );
void big5char_gbchar (char *big5 , char *gb );
void gbstring_big5string (char *gbstr , char *big5str , int n );
void big5string_gbstring (char *big5str , char *gbstr , int n );
void gbmixstring_big5mixstring (char *gbstr , char *big5str , int n );
void big5mixstring_gbmixstring (char *big5str , char *gbstr , int n );
/* From `handw.c': */
void HZinitServerHandwritingPad (int x , int y , int w , int h );
void HZhwDrawWindow (void);
void HZhwClearPadLeft (void);
void HZhwClearPadRight (void);
void HZprocHWWindow (int x0 , int y0 );
void HZprocHWChildWindow (Window win, int x0 , int y0 );
void HZhwFlush(void);
/* From `hwengine.c': */
int HZinitHWEngine (void);
void HZhwToEnginePoint (int x , int y );
void HZhwToEngineNewLine (void);
int HZhwRecognize (void);
/* From `IC.c': */
IC * FindIC (CARD16 icid );
int FindEnc (IMForwardEventStruct *call_data );
int FindEncByID (int icid );
void CreateIC (IMChangeICStruct *call_data );
void DestroyIC (IMChangeICStruct *call_data );
void SetIC (IMChangeICStruct *call_data );
void GetIC (IMChangeICStruct *call_data );
/* From `init.c': */
void HZcheckInput (void);
void HZinitServerMisc (void);
void HZinitDisplay (void);
void HZinitServerAtom (void);
void HZinitServerFont (void);
void HZinitServerGC (void);
void HZinitServerInputArea (int x , int y , int w , int h );
void HZinitServerButtonArea (int bx , int by , int bw , int bh );
void HZinitServerBrowseArea (int kx , int ky , int kw , int kh , int offx1 , int offy1 , int offx2 , int offy2 );
void HZinitControlBar (void);
void HZparseParameters (int argc , char **argv );
void HZinitResource (void);
void HZloadRCFile (void);
void HZinitWindows (void);
void HZinitIME (void);
void HZinitIcons(void);
Boolean file_exist(char *fname);
/* From `inputbar.c': */
void HZprocKey (XEvent report );
void HZprocLeftButton (XEvent report );
void HZprocQJ (XEvent report );
void proc_qj (int corner );
void HZprocPunct (XEvent report );
void proc_punct (int punct );
void HZprocMiddleButton (XEvent report );
void HZprocRightButton (void);
void HZprocPopKWindow (void);
void HZprocKWindow (int x0 , int y0 );
void HZprocChangeKWindow (int x0 , int y0 );
void HZprocCloseWindow (XEvent report );
void HZprocMoveWindow (void);
int set_win (void);
void set_motion (void);
void move_win (void);
void HZresizeWindow (int count );
void HZrootInputFlush (void);
void HZrootCandidateFlush (void);
void HZrootFlush (void);
/* From `keyboard.c': */
void HZinitServerVirtualKeyboard (int x , int y , int w , int h );
void HZvkDrawWindow (void);
void HZprocVKWindow (int x0 , int y0 );
/* From `loop.c': */
void HZenterLoop (void);
/* From `offspot.c': */
void HZoffspotFlush(void);
void HZoffspotHideWindows(void);
void HZoffspotHideStatusWindow(IC *ic);
void HZoffspotDrawCaret(IC *ic, int pos);
/* From `onspot.c': */
void HZonspotFlush(void);
void HZonspotClear(void);
/* From `overspot.c': */
void HZinitServerCaretMode (int x1 , int y1 , int w1 , int h1 , int x2 , int y2 , int w2 , int h2 );
void HZprocHideWindows (void);
Boolean HZprocFocusIn (IMChangeFocusStruct *call_data );
Boolean HZprocFocusOut (IMChangeFocusStruct *call_data );
Boolean HZprocResetIC (IMResetICStruct *call_data );
void HZprocSetCurrentIC (IMForwardEventStruct *call_data );
void HZprocLocation (IC *ic );
void HZprocPopWindows (void);
void HZprocResizeWindow (int len );
void HZprocDisable (void);
void HZprocKeySelect(int x0, int y0);
void HZprocKeyUp(int x0, int y0);
void HZprocKeyDown(int x0, int y0);
void HZoverspotInputFlush (void);
void HZoverspotCandidateFlush (void);
void HZoverspotFlush (void);
void HZprocAutoHide (void);
/* From `server.c': */
void HZprocXIM (XKeyEvent *kev , char *buf , int *charcount );
void HZprocMessage (XClientMessageEvent *ev );
int set_reply_corner_punct (char c , char *buf );
int set_reply_corner (char c , char *buf );
int set_reply_punct (char c , char *buf );
int set_reply (char ch , char *buf );
int set_reply_default (char ch , char *buf );
int in_table (char c );
int in_alnum (char c );
int in_punct (char c );
/* From `util.c': */
Time get_time (void);
void draw_tri_button (Display *dpy , Window win , GC dimgc , GC lightgc , int x1 , int y1 , int x2 , int y2 , int x3 , int y3 , Boolean flag );
void draw_diamond_button (Display *dpy , Window win , GC dimgc , GC lightgc , int cx , int cy , Boolean flag );
void draw_button (Display *dpy , Window win , GC dimgc , GC lightgc , int x1 , int y1 , int x2 , int y2 , Boolean flag );
void draw_button_return (Display *dpy , Window win , GC dimgc , GC lightgc , int x , int y , int bw , int bh , Boolean flag );
void wait_button_release (void);
void draw_box (GC gc , int left , int top , int right , int bottom );
void undraw_box (GC gc , int left , int top , int right , int bottom );
Bool in_box (int x0 , int y0 , int x1 , int y1 , int x2 , int y2 );
void DrawSunkenBorder (Display *dpy , Window win , GC lightgc , GC dimgc , int x1 , int y1 , int x2 , int y2 );
void record_time (void);
Boolean expire_time (Time delta );
KeySym character_to_keysym (unsigned char i );
void SendKeysym (unsigned long keysym , Boolean f_shift , Boolean f_control , Boolean f_alt );
void SendEvent (unsigned char c , Boolean f_shift , Boolean f_control , Boolean f_alt );
int HZerrorHandler (Display *dpy , XErrorEvent *ev );
void myExit (void);
Window create_win (int x , int y , int w , int h );
int mb_strlen(char *str, int len);
Window find_parent(Window win, Atom WM_STATE);
Window find_top_window (Window win);
void candidate_preprocess(char *s);
/* From `XIM.c': */
Boolean IsForwardKey (XIMS ims , IMForwardEventStruct *call_data );
Boolean IsControlKey (XIMS ims , IMForwardEventStruct *call_data );
void ProcessControlKey (XIMS ims , IMForwardEventStruct *call_data );
Boolean ChinputOpenHandler (XIMS ims , IMOpenStruct *call_data );
Boolean ChinputCloseHandler (XIMS ims , IMCloseStruct *call_data );
Boolean ChinputCreateICHandler (XIMS ims , IMChangeICStruct *call_data );
Boolean ChinputDestroyICHandler (XIMS ims , IMChangeICStruct *call_data );
Boolean ChinputGetICValuesHandler (XIMS ims , IMChangeICStruct *call_data );
Boolean ChinputSetICValuesHandler (XIMS ims , IMChangeICStruct *call_data );
Boolean ChinputFocusIn (XIMS ims , IMChangeFocusStruct *call_data );
Boolean ChinputFocusOut (XIMS ims , IMChangeFocusStruct *call_data );
Boolean ChinputResetIC (XIMS ims , IMResetICStruct *call_data );
Boolean ChinputForwardEventHandler (XIMS ims , IMForwardEventStruct *call_data );
void ForwardString (char *text , int len );
int ForwardEvent (unsigned long keysym , Boolean f_shift , Boolean f_control , Boolean f_alt );
Boolean ChinputTriggerNotifyHandler (XIMS ims , IMTriggerNotifyStruct *call_data );
Boolean ChinputPreeditStartReplyHandler (XIMS ims , IMPreeditCBStruct *call_data );
Boolean ChinputPreeditCaretReplyHandler (XIMS ims , IMPreeditCBStruct *call_data );
Boolean ChinputProtoHandler (XIMS ims , IMProtocol *call_data );
void HZinitXIM (void);

void HZrootCornerFlush();
void HZrootPunctFlush();
void HZoverspotHideStatusWindow();
void HZoffspotMapWindows();

void LibOpen();
void LibRelease();
/* From `voice.c' */
void HZinitVoiceRecognition();
