/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

/*
 * Copyright 1997 by Yu Mingjian.          All Rights Reserved
 *
 * Permission to retain, use, modify, copy, and distribute Chinput1.0
 * in source or binary and its documentation (hereafter, the Software)
 * for noncommercial purpose is hereby granted to you without a fee,
 * provided that this entire copyright and permission notice appear in
 * all such copies, that no charge be associated with such copies,
 * that distribution of derivative works (including value-added
 * distributions such as with additional input dictionaries or fonts)
 * include clarification that such added or derived parts are not from
 * the original Software, and that the names of the author(s) not be
 * used to endorse or promote such works. The author(s) of the software
 * makes no representations about the suitability of this software for any
 * purpose.  It is provided "as is" without express or implied warranty.
 *
 * THE AUTHOR(S) OF THE SOFTWARE DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS
 * SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS,
 * IN NO EVENT SHALL THE AUTHOR(S) OF THE SOFTWARE BE LIABLE FOR ANY SPECIAL,
 * INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
 * LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE
 * OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * Author: Yu Mingjian, Institute of High Energy Physics, Academia Sinica
 * 
 */

#include <X11/IntrinsicP.h>
#include <X11/Xfuncs.h>

#define MAX_COLS	200
#define MAX_ROWS	128

typedef struct _status_button {
        int x, y;
        Boolean status;
        char *str1, *str2;
} status_button;

typedef struct {
/* These parameters apply to both windows */
	Window		window1;	/* window ID			*/
	Window		window2;	/* window ID			*/
	Window		window3;	/* window ID			*/
	Window		window4;	/* window ID			*/
	Window		window5;	/* window ID			*/
	Window		window6;	/* window ID			*/
	Display		*display;	/* X display for screen		*/

	Window		lockw;		/* window being locked by chinput */
	Bool		focus;		/* if the window being focused  */
	Bool		plugin;

	GC		normalGC;	/* normal painting		*/
	GC		normalgbGC;	/* normal painting		*/
	GC		normalbig5GC;	/* normal painting		*/
	GC		dimGC;		/* gc for dim border 		*/
	GC		lightGC;	/* gc for light border		*/
	GC		panelGC;	/* gc for panel			*/
	GC		barGC;		/* gc for title bar of VK	*/
	GC		ledGC;		/* gc for switch led		*/

	int		width;		/* width of columns		*/
	int		height;		/* height of rows		*/
	int		lspacing;	/* space in pixel between lines	*/

	int		encoding;	/* encoding the same as misc	*/

	/* Hanzi input area stuff					*/
	struct {
		int	rows;		/* number of rows in input area	*/
		int	cols;
		int	x, y;		/* upperleft of the input area	*/
		int	width, height;	/* width, height of input area  */
	} hzIwin;

	//button window area
	struct {
		Bool	flag;		/* flag marking the led on/off state */
		int	rows;
		int	cols;
		int	x, y;
		int width, height;
		int     q_x1, q_y1, q_x2, q_y2;
		int 	p_x1, p_y1, p_x2, p_y2;
                int     ledx1, ledy1, ledx2, ledy2;
		int     offset;
                                        /* Led position */
                int     btnx1, btny1, btnx2, btny2, btnx3, btny3;
	} hzBwin;	/* structure for button window */

	//keyboard window area
	struct {
		Bool	onflag;
		int	offx1, offy1;
		int	offx2, offy2;
		int	rows;
		int	cols;
		int	x, y;
		int	width, height;
		int	prevx1, prevy1, prevx2, prevy2, prevx3, prevy3;
		int	nextx1, nexty1, nextx2, nexty2, nextx3, nexty3;
				/* triangle buttons' position */
	        int cur;        /* current section              */
        	int first_start, first_end;   /* range of first byte    */
        	int second_start, second_end; /* rang of second byte    */
        	int second_start2, second_end2;/* for big5 encode       */
	} hzKwin;	/* structure for keyboard */

	//virtual keyboard
	struct {
		Bool	onflag;
		int	x, y;		//up-left corner position
		int	w, h;		//size of window
	} hzVKwin;

	//handwriting recognition pad
	struct {
		int	x, y;		//up-left corner position
		int	w, h;		//size of window
	} hzHWwin;

	//key window and choice window
	struct {
		int	x1, y1, w1, h1;
		int	x2, y2, w2, h2;
	} hzCwin;

	int		f_width;	/* font width of text		*/
	int		f_height;	/* font height of text		*/

} HZinputmod;

typedef struct _chinput_ime {
        char    name[20];		//section name
        char    namegb[20];		//input method name in GB
        char    namebig5[20];		//input method name in Big5
        char    encoding[5];		//encoding: GB or BIG5
        char    fname[80];		//file name relative to dict path
        char    module[128];		//module name
	int	favorite;
} chinput_ime;

typedef struct _chinput_rc {
	int	dmode;			//ROOT,OVERSPOT,ONSPOT,OFFSPOT
	int	hmode;			//YES or NO
	int	cmode;			//AUTO or NO
	int	areamode;		//CLIENT or SERVER
	int	showime;		//YES or NO
	char	dictionary[256];	//path or dictionary
	char	ime_gb[20];		//default GB ime
	char	ime_big5[20];		//default big5 ime
	//char	association[30];
	char	font[128];		//latin font
	char	gbfont[128];		//gb font
	char	big5font[128];		//big5 font

	int	width;			//inputbar width in chars

	char	dimcolor[8];		//color
	char	lightcolor[8];		//color
	char	panelcolor[8];		//color
	char	hzcolor[8];		//color
	char	ledcolor[8];		//color
	char	barcolor[8];		//color

	int	hwtimeout;		//timeout for handwriting
} chinput_rc;
