/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <signal.h>
#include <string.h>
#include <sys/ioctl.h>
#include <malloc.h>
#include <locale.h>
#include <libintl.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>

#define _(String)  gettext(String)
#define N_(String)  gettext(String)
#define __(String) (String)

#include "defs.h"
#include "hzclient.h"
#include "chinput.h"
#include "hzserver.h"
#include "xpm_message.h"
#include "xpm_question.h"
#include "xpm_warning.h"
#define  MAX_IMES	60

static void delete_event(GtkWidget *widget, GdkEvent  *event, gpointer  data)
{
}

static GtkWidget *turbopixlabel(GtkWidget *w, char **pixdata, char *title)
{
	GtkWidget *toplevel;
        GtkWidget *box;
        GtkWidget *label;
        GtkWidget *pixmapwid;
        GdkPixmap *pixmap;
        GdkBitmap *mask;
        GtkStyle *style;

        box = gtk_hbox_new(FALSE, 0);
        gtk_container_set_border_width(GTK_CONTAINER(box), 0);
        //add pixmap
        if(pixdata){
		toplevel = gtk_widget_get_toplevel(w);
		gtk_widget_realize(toplevel);
                style = gtk_widget_get_style(toplevel);
                pixmap = gdk_pixmap_create_from_xpm_d(
                        toplevel->window, &mask,
                        &style->bg[GTK_STATE_NORMAL], pixdata);
                pixmapwid = gtk_pixmap_new(pixmap, mask);
                gtk_box_pack_start(GTK_BOX(box), pixmapwid, TRUE, TRUE, 3);
                gtk_widget_show(pixmapwid);
        }

        //add label
        label = gtk_label_new(_(title));
        gtk_box_pack_start(GTK_BOX(box), label, TRUE, TRUE, 3);

        gtk_widget_show(label);

        return box;
}

void mainloop_destroyed(GtkWidget *w, GtkWidget **window)
{
	*window = NULL;
	gtk_main_quit ();
}


void real_message(char *title, char *buttontext, char *message, char **icon)
{
	static GtkWidget *window = NULL;
	GtkWidget *vbox;
	GtkWidget *hbox;
	GtkWidget *text, *button, *separator;

	if(!window){
		window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
		gtk_signal_connect(GTK_OBJECT(window), "destroy",
			GTK_SIGNAL_FUNC(mainloop_destroyed), &window);

		gtk_window_set_title(GTK_WINDOW(window), _(title));
		gtk_container_set_border_width(GTK_CONTAINER(window), 20);
		//gtk_window_set_modal(GTK_WINDOW(window), TRUE);

	        // set handler for delete event
	        gtk_signal_connect(GTK_OBJECT(window), "delete_event",
                           GTK_SIGNAL_FUNC(delete_event), NULL);

		vbox = gtk_vbox_new(FALSE, 20);
		gtk_container_add(GTK_CONTAINER(window), vbox);

		//add turbo box
		hbox = turbopixlabel(vbox, icon, " ");
		gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);

		//add text
		text = gtk_label_new(_(message));
		gtk_box_pack_start(GTK_BOX(vbox), text, TRUE, TRUE, 0);
		gtk_label_set_line_wrap(GTK_LABEL(text), TRUE);

		//add separator
		separator = gtk_hseparator_new();
		gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, TRUE, 0);

		//add button
		button = gtk_button_new_with_label(_(buttontext));
		gtk_signal_connect_object(GTK_OBJECT(button), "clicked",
			GTK_SIGNAL_FUNC(gtk_widget_destroy),
			GTK_OBJECT(window));
		gtk_box_pack_start(GTK_BOX(vbox), button, TRUE, FALSE, 0);

		GTK_WIDGET_SET_FLAGS(button, GTK_CAN_DEFAULT);
		gtk_widget_grab_default (button);
		gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);

	}

	if(!GTK_WIDGET_VISIBLE(window)){
		gtk_widget_show_all(window);
		gtk_main();
	} else {
		gtk_widget_destroy(window);
	}

}

void message(char *message)
{
	real_message("zwincontrol message", _("OK"), message, xpm_message);
}


void warning(char *message)
{
	//the same as message window except icon
	real_message("zwincontrol warning", _("OK"), message, xpm_warning);
}

static int yesno_value = 0;
static void yes_callback(GtkWidget *w, gpointer data)
{
	gtk_widget_destroy(gtk_widget_get_toplevel(data));
	gtk_main_quit();
	yesno_value = 1;
}

static void no_callback(GtkWidget *w, gpointer data)
{
	gtk_widget_destroy(gtk_widget_get_toplevel(data));
	gtk_main_quit();
	yesno_value = 0;
}

int real_yesno(char *title, char *byes, char *bno, char *message)
{
	static GtkWidget *window = NULL;
	GtkWidget *vbox;
	GtkWidget *hbox, *hbox2;
	GtkWidget *text, *yesbutton, *nobutton, *separator;

	if(!window){
		window = gtk_window_new(GTK_WINDOW_TOPLEVEL);
		gtk_window_set_policy(GTK_WINDOW(window), FALSE, FALSE, FALSE);
		gtk_window_set_position(GTK_WINDOW(window), GTK_WIN_POS_MOUSE);
		gtk_signal_connect(GTK_OBJECT(window), "destroy",
			GTK_SIGNAL_FUNC(mainloop_destroyed), &window);

		gtk_window_set_title(GTK_WINDOW(window), _(title));
		gtk_container_set_border_width(GTK_CONTAINER(window), 20);
		//gtk_window_set_modal(GTK_WINDOW(window), TRUE);

	        // set handler for delete event
	        gtk_signal_connect(GTK_OBJECT(window), "delete_event",
                           GTK_SIGNAL_FUNC(delete_event), NULL);

		vbox = gtk_vbox_new(FALSE, 20);
		gtk_container_add(GTK_CONTAINER(window), vbox);

		//add turbo box
		hbox = turbopixlabel(window, xpm_question, " ");
		gtk_box_pack_start(GTK_BOX(vbox), hbox, TRUE, TRUE, 0);

		//add text
		text = gtk_label_new(_(message));
		gtk_box_pack_start(GTK_BOX(vbox), text, TRUE, TRUE, 0);
		gtk_label_set_line_wrap(GTK_LABEL(text), TRUE);

		//add separator
		separator = gtk_hseparator_new();
		gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, TRUE, 0);

		//add button
		hbox2 = gtk_hbox_new(FALSE, 0);
		gtk_box_pack_start(GTK_BOX(vbox), hbox2, TRUE, FALSE, 0);

		yesbutton = gtk_button_new_with_label(_(byes));
		gtk_signal_connect_object(GTK_OBJECT(yesbutton), "clicked",
			GTK_SIGNAL_FUNC(yes_callback),
			GTK_OBJECT(window));
		gtk_box_pack_start(GTK_BOX(hbox2), yesbutton, TRUE, FALSE, 0);

		nobutton = gtk_button_new_with_label(_(bno));
		gtk_signal_connect_object(GTK_OBJECT(nobutton), "clicked",
			GTK_SIGNAL_FUNC(no_callback),
			GTK_OBJECT(window));
		gtk_box_pack_start(GTK_BOX(hbox2), nobutton, TRUE, FALSE, 0);

		GTK_WIDGET_SET_FLAGS(yesbutton, GTK_CAN_DEFAULT);
		gtk_widget_grab_default (yesbutton);

	}

	if(!GTK_WIDGET_VISIBLE(window)){
		gtk_widget_show_all(window);
		gtk_main();
		return yesno_value;
	} else {
		gtk_widget_destroy(window);
	}
	return 1;
}

int yesno(char *message)
{
	return real_yesno("", _("YES"), _("NO"), message);
}
