/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

#include <stdlib.h>
#include <stdio.h>
#include <unistd.h>
#include <stdarg.h>
#include <signal.h>
#include <string.h>
#include <sys/ioctl.h>
#include <malloc.h>
#include <locale.h>
#include <libintl.h>
#define _(String)  gettext(String)
#define N_(String)  gettext(String)
#define __(String) (String)

#include "defs.h"
#include "hzclient.h"
#include "chinput.h"
#include "hzserver.h"
#define  MAX_IMES	60

extern int flag_encoding;
extern chinput_ime chinputime[MAX_IMES];
extern chinput_rc  chinputrc;
extern int index_ime;

int write_resource_default(char *outfile)
{
	FILE *fp;
	char msg[256];

        fp = fopen(outfile, "w");
        if(!fp) {
		sprintf(msg, "Can not open file %s for writing!", outfile);
		warning(msg);
		return 0;
	}

	fprintf(fp, "!!!\n");
	fprintf(fp, "!!! This file is part of\n");
	fprintf(fp, "!!!\n");
	fprintf(fp, "!!!                        TurboLinux  ZWinPro\n");
	fprintf(fp, "!!!\n");
	fprintf(fp, "!!!                 Copyright (C) 1999 TurboLinux, Inc.\n"); 
	fprintf(fp, "!!!                        All Rights Reserved\n");
	fprintf(fp, "!!! Distributed under the terms of the GNU General Public License (GPL)\n");
	fprintf(fp, "!!!\n");
	fprintf(fp, "!!!\n");
	fprintf(fp, "!!! Authors:     TurboLinux Chinese Development Team:\n");
	fprintf(fp, "!!!              Justin Yu   <justiny@turbolinux.com.cn>\n");
	fprintf(fp, "!!!              Sean Chen   <seanc@turbolinux.com.cn>\n");
	fprintf(fp, "!!!              Daniel Fang <danf@turbolinux.com.cn>\n");
	fprintf(fp, "!!! WWW:         http://www.turbolinux.com.cn/ZWinPro/\n");
	fprintf(fp, "!!! FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/\n");
	fprintf(fp, "!!!\n");
	fprintf(fp, "\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! Resource file for Chinput-%s\n", VERSION);
	fprintf(fp, "!!! Generated by zwincontrol, Please do not edit by hand\n");
	fprintf(fp, "!\n");
	fprintf(fp, "\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! default style: ROOT OVERSPOT ONSPOT OFFSPOT \n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.dmode		=	OVERSPOT\n");


	fprintf(fp, "!\n");
	fprintf(fp, "! input window auto-hide mode AUTO or NO, only for CARET mode\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.hmode		=	NO\n");

	fprintf(fp, "!\n");
	fprintf(fp, "! show input method in the input window\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.showime		=	NO\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! input method\n");
	fprintf(fp, "! for gb  : TONEPY, PY, CCDOSPY, WuBi, CangJie, English, CTLau, SW, \n");
	fprintf(fp, "!           QianMa, TeleCode, ZRM\n");
	fprintf(fp, "! for big5: PY, ETZY, ZOZY, Simplex, CangJie, \n");
	fprintf(fp, "!	    English, 4Corner, HSU, ARRAY30, Boshiamy\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.dictionary		=	/usr/dict\n");
	fprintf(fp, "chinput.inputmethod.gb		=	ZNPY\n");
	fprintf(fp, "chinput.inputmethod.big5	=	PY\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! 16 point font set\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.font			=	8x16\n");
	fprintf(fp, "chinput.gbfont			=	-*-song-medium-r-normal--16-*-*-*-*-*-gbk-0\n");
	fprintf(fp, "chinput.big5font		=	-*-song-medium-r-normal--16-*-*-*-*-*-big5-0\n");
	fprintf(fp, "!\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! inputbar width in chars\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.width	=	70\n");
	fprintf(fp, "\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! panel color \n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.dimcolor	=	#666666\n");
	fprintf(fp, "chinput.lightcolor	=	#f5f5f5\n");
	fprintf(fp, "chinput.panelcolor	=	#c0c0c0\n");
	fprintf(fp, "chinput.hzcolor		=	#000000\n");
	fprintf(fp, "chinput.ledcolor	=	#00ff00\n");
	fprintf(fp, "chinput.barcolor	=	#000080\n");
	fprintf(fp, "\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! handwriting recognition timeout\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.hwtimeout	=	1500\n");

	fprintf(fp, "!\n");
	fprintf(fp, "! Input Method read by chinput\n");
	fprintf(fp, "! Format: The following items should be in the correct order\n");
	fprintf(fp, "!         [Section] : Input Method, the same in chinput.inputmethod.gb\n");
	fprintf(fp, "!         NAMEGB    : Name for gettext\n");
	fprintf(fp, "!         NAMEBIG5  : Name appeared in input bar\n");
	fprintf(fp, "!         ENCODING  : Encoding for this IME, should be GB or BIG5\n");
	fprintf(fp, "!         FILE      : Where the input method file located, maybe absolute path\n");
	fprintf(fp, "!                     or relative to chinput.dictionary\n");
	fprintf(fp, "!         MODULE    : absolute path of module\n");
	fprintf(fp, "!         FAVORITE  : I like this input method\n");
	fprintf(fp, "!\n");

	//write input method
	fprintf(fp, "[ZNPY]\n");
	fprintf(fp, "IMENAME			=	ƴ\n");
	fprintf(fp, "IMENAME			=	\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	gb\n");
	fprintf(fp, "MODULE			=	/usr/lib/libfreepy.so\n");
	fprintf(fp, "FAVORITE		=	YES\n");
	fprintf(fp, "\n");
	fprintf(fp, "[PY]\n");
	fprintf(fp, "IMENAME			=	޵ƴ\n");
	fprintf(fp, "IMENAME			=	Lի\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	gb/py.tab\n");
	fprintf(fp, "MODULE			=	/usr/lib/libhzinput.so\n");
	fprintf(fp, "FAVORITE		=	YES\n");
	fprintf(fp, "\n");
	fprintf(fp, "[TONEPY]\n");
	fprintf(fp, "IMENAME			=	ƴ\n");
	fprintf(fp, "IMENAME			=	aի\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	gb/tonepy.tab\n");
	fprintf(fp, "MODULE			=	/usr/lib/libhzinput.so\n");
	fprintf(fp, "FAVORITE		=	NO\n");
	fprintf(fp, "\n");
	fprintf(fp, "[CCDOSPY]\n");
	fprintf(fp, "IMENAME			=	дƴ\n");
	fprintf(fp, "IMENAME			=	Yg\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	gb/shuangpin.tab\n");
	fprintf(fp, "MODULE			=	/usr/lib/libhzinput.so\n");
	fprintf(fp, "FAVORITE		=	YES\n");
	fprintf(fp, "\n");
	fprintf(fp, "[WuBi]\n");
	fprintf(fp, "IMENAME			=	\n");
	fprintf(fp, "IMENAME			=	r\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	gb/wubi.tab\n");
	fprintf(fp, "MODULE			=	/usr/lib/libhzinput.so\n");
	fprintf(fp, "FAVORITE		=	YES\n");
	fprintf(fp, "\n");
	fprintf(fp, "[CangJie]\n");
	fprintf(fp, "IMENAME			=	\n");
	fprintf(fp, "IMENAME			=	aeJ\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	gb/cangjie.tab\n");
	fprintf(fp, "MODULE			=	/usr/lib/libhzinput.so\n");
	fprintf(fp, "FAVORITE		=	NO\n");
	fprintf(fp, "\n");
	fprintf(fp, "[English]\n");
	fprintf(fp, "IMENAME			=	Ӣ\n");
	fprintf(fp, "IMENAME			=	^~J\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	gb/english.tab\n");
	fprintf(fp, "MODULE			=	/usr/lib/libhzinput.so\n");
	fprintf(fp, "FAVORITE		=	NO\n");
	fprintf(fp, "\n");
	fprintf(fp, "[CTLau]\n");
	fprintf(fp, "IMENAME			=	\n");
	fprintf(fp, "IMENAME			=	Bf\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	gb/ctlau.tab\n");
	fprintf(fp, "MODULE			=	/usr/lib/libhzinput.so\n");
	fprintf(fp, "FAVORITE		=	NO\n");
	fprintf(fp, "\n");
	fprintf(fp, "[SW]\n");
	fprintf(fp, "IMENAME			=	β\n");
	fprintf(fp, "IMENAME			=	X\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	gb/sw.tab\n");
	fprintf(fp, "MODULE			=	/usr/lib/libhzinput.so\n");
	fprintf(fp, "FAVORITE		=	NO\n");
	fprintf(fp, "\n");
	fprintf(fp, "[QianMa]\n");
	fprintf(fp, "IMENAME			=	Ǯ\n");
	fprintf(fp, "IMENAME			=	XJ\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	gb/qianma.tab\n");
	fprintf(fp, "MODULE			=	/usr/lib/libhzinput.so\n");
	fprintf(fp, "FAVORITE		=	NO\n");
	fprintf(fp, "\n");
	fprintf(fp, "[ZRM]\n");
	fprintf(fp, "IMENAME			=	Ȼ\n");
	fprintf(fp, "IMENAME			=	۵MX\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	gb/ziranma.tab\n");
	fprintf(fp, "MODULE			=	/usr/lib/libhzinput.so\n");
	fprintf(fp, "FAVORITE		=	YES\n");
	fprintf(fp, "\n");
	fprintf(fp, "[MGM]\n");
	fprintf(fp, "IMENAME			=	\n");
	fprintf(fp, "IMENAME			=	XڽX\n");
	fprintf(fp, "ENCODING		=	GB\n");
	fprintf(fp, "FILE			=	gb/mgm.tab\n");
	fprintf(fp, "MODULE			=	/usr/lib/libhzinput.so\n");
	fprintf(fp, "FAVORITE		=	NO\n");
	fprintf(fp, "\n");
	fprintf(fp, "[PY]\n");
	fprintf(fp, "IMENAME			=	ƴ\n");
	fprintf(fp, "IMENAME			=	J\n");
	fprintf(fp, "ENCODING		=	BIG5\n");
	fprintf(fp, "FILE			=	big5/PY.cit\n");
	fprintf(fp, "MODULE			=	/usr/lib/libcxterminput.so\n");
	fprintf(fp, "FAVORITE		=	YES\n");
	fprintf(fp, "\n");
	fprintf(fp, "[ETZY]\n");
	fprintf(fp, "IMENAME			=	ע\n");
	fprintf(fp, "IMENAME			=	ʤѪ`\n");
	fprintf(fp, "ENCODING		=	BIG5\n");
	fprintf(fp, "FILE			=	big5/ETZY.cit\n");
	fprintf(fp, "MODULE			=	/usr/lib/libcxterminput.so\n");
	fprintf(fp, "FAVORITE		=	YES\n");
	fprintf(fp, "\n");
	fprintf(fp, "[ZOZY]\n");
	fprintf(fp, "IMENAME			=	һע\n");
	fprintf(fp, "IMENAME			=	s@`\n");
	fprintf(fp, "ENCODING		=	BIG5\n");
	fprintf(fp, "FILE			=	big5/ZOZY.cit\n");
	fprintf(fp, "MODULE			=	/usr/lib/libcxterminput.so\n");
	fprintf(fp, "FAVORITE		=	YES\n");
	fprintf(fp, "\n");
	fprintf(fp, "[Simplex]\n");
	fprintf(fp, "IMENAME			=	\n");
	fprintf(fp, "IMENAME			=	²J\n");
	fprintf(fp, "ENCODING		=	BIG5\n");
	fprintf(fp, "FILE			=	big5/Simplex.cit\n");
	fprintf(fp, "MODULE			=	/usr/lib/libhzinput.so\n");
	fprintf(fp, "FAVORITE		=	NO\n");
	fprintf(fp, "\n");
	fprintf(fp, "[CangJie]\n");
	fprintf(fp, "IMENAME			=	\n");
	fprintf(fp, "IMENAME			=	ܾeJ\n");
	fprintf(fp, "ENCODING		=	BIG5\n");
	fprintf(fp, "FILE			=	big5/CangJie.cit\n");
	fprintf(fp, "MODULE			=	/usr/lib/libcxterminput.so\n");
	fprintf(fp, "FAVORITE		=	YES\n");
	fprintf(fp, "\n");
	fprintf(fp, "[English]\n");
	fprintf(fp, "IMENAME			=	Ӣ\n");
	fprintf(fp, "IMENAME			=	^~J\n");
	fprintf(fp, "ENCODING		=	BIG5\n");
	fprintf(fp, "FILE			=	big5/English.cit\n");
	fprintf(fp, "MODULE			=	/usr/lib/libcxterminput.so\n");
	fprintf(fp, "FAVORITE		=	NO\n");
	fprintf(fp, "\n");
	fprintf(fp, "[4Corner]\n");
	fprintf(fp, "IMENAME			=	ĽǺ\n");
	fprintf(fp, "IMENAME			=	|X\n");
	fprintf(fp, "ENCODING		=	BIG5\n");
	fprintf(fp, "FILE			=	big5/4Corner.cit\n");
	fprintf(fp, "MODULE			=	/usr/lib/libcxterminput.so\n");
	fprintf(fp, "FAVORITE		=	NO\n");
	fprintf(fp, "\n");
	fprintf(fp, "[HSU]\n");
	fprintf(fp, "IMENAME			=	\n");
	fprintf(fp, "IMENAME			=	\\f\n");
	fprintf(fp, "ENCODING		=	BIG5\n");
	fprintf(fp, "FILE			=	big5/HSU.cit\n");
	fprintf(fp, "MODULE			=	/usr/lib/libcxterminput.so\n");
	fprintf(fp, "FAVORITE		=	NO\n");
	fprintf(fp, "\n");
	fprintf(fp, "[ARRAY30]\n");
	fprintf(fp, "IMENAME			=	У\n");
	fprintf(fp, "IMENAME			=	C\n");
	fprintf(fp, "ENCODING		=	BIG5\n");
	fprintf(fp, "FILE			=	big5/ARRAY30.cit\n");
	fprintf(fp, "MODULE			=	/usr/lib/libcxterminput.so\n");
	fprintf(fp, "FAVORITE		=	YES\n");
	fprintf(fp, "\n");
	fprintf(fp, "[Boshiamy]\n");
	fprintf(fp, "IMENAME			=	Ϻ\n");
	fprintf(fp, "IMENAME			=	\n");
	fprintf(fp, "ENCODING		=	BIG5\n");
	fprintf(fp, "FILE			=	big5/Boshiamy.cit\n");
	fprintf(fp, "MODULE			=	/usr/lib/libcxterminput.so\n");
	fprintf(fp, "FAVORITE		=	YES\n");
	
	fclose(fp);
	return 1;
}

int write_resource(char *outfile)
{
	int i;
	FILE *fp;
	char msg[256];

        fp = fopen(outfile, "w");
        if(!fp){
		sprintf(msg, "Cannot open file %s for writing.\n", outfile);
		warning(msg);
		return 0;
	}

	fprintf(fp, "!!!\n");
	fprintf(fp, "!!! This file is part of\n");
	fprintf(fp, "!!!\n");
	fprintf(fp, "!!!                        TurboLinux  ZWinPro\n");
	fprintf(fp, "!!!\n");
	fprintf(fp, "!!!                 Copyright (C) 1999 TurboLinux, Inc.\n"); 
	fprintf(fp, "!!!                        All Rights Reserved\n");
	fprintf(fp, "!!! Distributed under the terms of the GNU General Public License (GPL)\n");
	fprintf(fp, "!!!\n");
	fprintf(fp, "!!!\n");
	fprintf(fp, "!!! Authors:     TurboLinux Chinese Development Team:\n");
	fprintf(fp, "!!!              Justin Yu   <justiny@turbolinux.com.cn>\n");
	fprintf(fp, "!!!              Sean Chen   <seanc@turbolinux.com.cn>\n");
	fprintf(fp, "!!!              Daniel Fang <danf@turbolinux.com.cn>\n");
	fprintf(fp, "!!! WWW:         http://www.turbolinux.com.cn/ZWinPro/\n");
	fprintf(fp, "!!! FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/\n");
	fprintf(fp, "!!!\n");
	fprintf(fp, "\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! Resource file for Chinput-%s\n", VERSION);
	fprintf(fp, "!!! Generated by zwincontrol, Please do not edit by hand\n");
	fprintf(fp, "!\n");
	fprintf(fp, "\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! root-window (ROOT) mode or following caret mode (CARET)\n");
	fprintf(fp, "!\n");
	if(chinputrc.dmode == HZSERVER_DMODE_ROOT)
		fprintf(fp, "chinput.dmode		=	ROOT\n");
	else
		fprintf(fp, "chinput.dmode		=	CARET\n");


	fprintf(fp, "!\n");
	fprintf(fp, "! input window auto-hide mode AUTO or NO, only for CARET mode\n");
	fprintf(fp, "!\n");
	if(chinputrc.hmode == HZSERVER_HMODE_AUTO)
		fprintf(fp, "chinput.hmode		=	AUTO\n");
	else
		fprintf(fp, "chinput.hmode		=	NO\n");

	fprintf(fp, "!\n");
	fprintf(fp, "! show input method in the input window\n");
	fprintf(fp, "!\n");
	if(chinputrc.showime == 1)
		fprintf(fp, "chinput.showime		=	YES\n");
	else
		fprintf(fp, "chinput.showime		=	NO\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! input method\n");
	fprintf(fp, "! for gb  : TONEPY, PY, CCDOSPY, WuBi, CangJie, English, CTLau, SW, \n");
	fprintf(fp, "!           QianMa, TeleCode, ZRM\n");
	fprintf(fp, "! for big5: PY, ETZY, ZOZY, Simplex, CangJie, \n");
	fprintf(fp, "!	    English, 4Corner, HSU, ARRAY30, Boshiamy\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.dictionary		=	%s\n", 
		chinputrc.dictionary);
	fprintf(fp, "chinput.inputmethod.gb		=	%s\n",
		chinputrc.ime_gb);
	fprintf(fp, "chinput.inputmethod.big5	=	%s\n",
		chinputrc.ime_big5);
	fprintf(fp, "!\n");
	fprintf(fp, "! 16 point font set\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.font			=	%s\n",
		chinputrc.font);
	fprintf(fp, "chinput.gbfont			=	%s\n",
		chinputrc.gbfont);
	fprintf(fp, "chinput.big5font		=	%s\n",
		chinputrc.big5font);
	fprintf(fp, "!\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! inputbar width in chars\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.width	=	%d\n", chinputrc.width);
	fprintf(fp, "\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! panel color \n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.dimcolor	=	%s\n",chinputrc.dimcolor);
	fprintf(fp, "chinput.lightcolor	=	%s\n",chinputrc.lightcolor);
	fprintf(fp, "chinput.panelcolor	=	%s\n",chinputrc.panelcolor);
	fprintf(fp, "chinput.hzcolor		=	%s\n",chinputrc.hzcolor);
	fprintf(fp, "chinput.ledcolor	=	%s\n",chinputrc.ledcolor);
	fprintf(fp, "chinput.barcolor	=	%s\n",chinputrc.barcolor);
	fprintf(fp, "\n");
	fprintf(fp, "!\n");
	fprintf(fp, "! handwriting recognition timeout\n");
	fprintf(fp, "!\n");
	fprintf(fp, "chinput.hwtimeout	=	%d\n",chinputrc.hwtimeout);

	fprintf(fp, "!\n");
	fprintf(fp, "! Input Method read by chinput\n");
	fprintf(fp, "! Format: The following items should be in the correct order\n");
	fprintf(fp, "!         [Section] : Input Method, the same in chinput.inputmethod.gb\n");
	fprintf(fp, "!         NAMEGB    : Name for gettext\n");
	fprintf(fp, "!         NAMEBIG5  : Name appeared in input bar\n");
	fprintf(fp, "!         ENCODING  : Encoding for this IME, should be GB or BIG5\n");
	fprintf(fp, "!         PROMPT    : Appeared in two rows input bar\n");
	fprintf(fp, "!         FILE      : Where the input method file located, maybe absolute path\n");
	fprintf(fp, "!                     or relative to chinput.dictionary\n");
	fprintf(fp, "!         MODULE    : absolute path of module\n");
	fprintf(fp, "!         FAVORITE  : I like this input method\n");
	fprintf(fp, "!\n");

	//write input method
	for(i=0; i<index_ime; i++){
		fprintf(fp, "[%s]\n", chinputime[i].name);
		if(flag_encoding == HZSERVER_ENCODING_GB){
			char stmp[30];
			fprintf(fp, "IMENAME		=	%s\n",
				chinputime[i].namegb);
			gbstring_big5string(chinputime[i].namegb, stmp, 
				strlen(chinputime[i].namegb));
			fprintf(fp, "IMENAME		=	%s\n", stmp);
		} else {
			char stmp[30];
			big5string_gbstring(chinputime[i].namebig5, stmp,
				strlen(chinputime[i].namebig5));
			fprintf(fp, "IMENAME		=	%s\n", stmp);
			fprintf(fp, "IMENAME		=	%s\n",
				chinputime[i].namebig5);
		}
		fprintf(fp, "ENCODING	=	%s\n",
			chinputime[i].encoding);
		fprintf(fp, "FILE		=	%s\n",
			chinputime[i].fname);
		fprintf(fp, "MODULE		=	%s\n",
			chinputime[i].module);
		if(chinputime[i].favorite == 1)
			fprintf(fp, "FAVORITE	=	YES\n");
		else
			fprintf(fp, "FAVORITE	=	NO\n");
		fprintf(fp, "\n");
	}
	
	fclose(fp);
	return 1;
}


int file_exist(char *fname)
{
        char name[256];
        if(!strcmp(fname, "gb")) return 1;           //ZNPY
	if(fname[0] == '/') strcpy(name, fname);
	else sprintf(name, "%s/%s", chinputrc.dictionary, fname);

        if(access(name, F_OK) == 0) return 1;
        else return 0;
}

static int mystrcmp(char *str1, char *str2)
{
        return strncmp(str1, str2, strlen(str2));
}


//
static char *get_value(char *line)
{
	char *ptr;
	char *ptr2;
	line[strlen(line)-1] = '\0';			//trim line
	ptr = strchr(line, '=') + 1;			//search value
	while(*ptr == ' ' || *ptr == '\t') ptr++;	//skip spaces
	ptr2 = ptr;
	while(*ptr2 && *ptr2 != ' ' && *ptr2 != '\t') ptr2++;//skip non spaces
	*ptr2 = '\0';					//trim line
	return ptr;
}

int scan_menu()
{
	FILE *fp;
	char fname[256];
	char line[256];

	sprintf(fname, "%s/.chinput", getenv("HOME"));
	fp = fopen(fname, "r");
	if(!fp){
		fp = fopen("/usr/lib/ZWinPro/Chinput.ad", "r");
		if(!fp) return 0;
	}

	index_ime = 0;
	while(fgets(line, 256, fp)){
		if(line[0] == '!') continue;
                if(line[0] == '\n') continue;
                if(!mystrcmp(line, "chinput.dmode")){
                        if(!strcmp(get_value(line), "ROOT"))
                                chinputrc.dmode = HZSERVER_DMODE_ROOT;
                        else
                                chinputrc.dmode = HZSERVER_DMODE_OVERSPOT;
                } else if(!mystrcmp(line, "chinput.hmode")){
                        if(!strcmp(get_value(line), "AUTO"))
                                chinputrc.hmode = HZSERVER_HMODE_AUTO;
                        else
                                chinputrc.hmode = HZSERVER_HMODE_NO;
                } else if(!mystrcmp(line, "chinput.dictionary")){
                        strcpy(chinputrc.dictionary, get_value(line));
                } else if(!mystrcmp(line, "chinput.showime")){
                        if(!strcmp(get_value(line), "YES"))
                                chinputrc.showime = 1;
                        else
                                chinputrc.showime = 0;
                } else if(!mystrcmp(line, "chinput.font")){
                        strcpy(chinputrc.font, get_value(line));
                } else if(!mystrcmp(line, "chinput.gbfont")){
                        strcpy(chinputrc.gbfont, get_value(line));
                } else if(!mystrcmp(line, "chinput.big5font")){
                        strcpy(chinputrc.big5font, get_value(line));
                } else if(!mystrcmp(line, "chinput.width")){
                        chinputrc.width = atoi(get_value(line));
                } else if(!mystrcmp(line, "chinput.dimcolor")){
                        strcpy(chinputrc.dimcolor, get_value(line));
                } else if(!mystrcmp(line, "chinput.lightcolor")){
                        strcpy(chinputrc.lightcolor, get_value(line));
                } else if(!mystrcmp(line, "chinput.panelcolor")){
                        strcpy(chinputrc.panelcolor, get_value(line));
                } else if(!mystrcmp(line, "chinput.hzcolor")){
                        strcpy(chinputrc.hzcolor, get_value(line));
                } else if(!mystrcmp(line, "chinput.ledcolor")){
                        strcpy(chinputrc.ledcolor, get_value(line));
                } else if(!mystrcmp(line, "chinput.barcolor")){
                        strcpy(chinputrc.barcolor, get_value(line));
                } else if(!mystrcmp(line, "chinput.hwtimeout")){
                        chinputrc.hwtimeout = atoi(get_value(line));
                } else if(!mystrcmp(line, "chinput.inputmethod.gb")){
                        strcpy(chinputrc.ime_gb, get_value(line));
                } else if(!mystrcmp(line, "chinput.inputmethod.big5")){
                        strcpy(chinputrc.ime_big5, get_value(line));
                } else if(line[0] == '[') {	//find an entry
			char *ptr;
			ptr = strchr(line, ']');
			*ptr = '\0';		//trim
			strcpy(chinputime[index_ime].name, line+1);
			if(!fgets(line, 256, fp)) return 0;
			strcpy(chinputime[index_ime].namegb, get_value(line));
			if(!fgets(line, 256, fp)) return 0;
			strcpy(chinputime[index_ime].namebig5, get_value(line));
			if(!fgets(line, 256, fp)) return 0;
			strcpy(chinputime[index_ime].encoding,get_value(line));
			if(!fgets(line, 256, fp)) return 0;
			strcpy(chinputime[index_ime].fname,get_value(line));
			if(!fgets(line, 256, fp)) return 0;
			strcpy(chinputime[index_ime].module,get_value(line));
			if(!fgets(line, 256, fp)) return 0;
			if(!strcmp(get_value(line), "YES"))
				chinputime[index_ime].favorite = 1;
			else
				chinputime[index_ime].favorite = 0;
			//if(chinputime[index_ime].favorite == 1 &&
			//   file_exist(chinputime[index_ime].fname))index_ime++;
			index_ime ++;
		}
	}
	fclose(fp);
	return 1;
}

