/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

#ifdef   LOGO
#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <unistd.h>
#include <signal.h>
#include <string.h>
#include <sys/ioctl.h>
#include <malloc.h>
#include <gtk/gtk.h>
#include <gdk_imlib.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkkeysyms.h>

#include "icons/ZWinPro.xpm"

#define  FAINT_NUM 30
void create_logo()
{
	int i,j;
	GdkWindowAttr         attr;
	GdkWindow             *win;
	GdkPixmap             *p = NULL;
	GdkImlibImage         *im;
	int sw, sh;
	int display_w, display_h;
	unsigned char modify[256];

	gdk_imlib_init();

	gtk_widget_push_visual(gdk_imlib_get_visual());
	gtk_widget_push_colormap(gdk_imlib_get_colormap());
       
	//im=gdk_imlib_load_image("/usr/lib/ZWinPro/ZWinPro.gif");
	im = gdk_imlib_create_image_from_xpm_data(ZWinPro);
	if(!im) {
		printf("Cannot open file!");
		return;
	}
	sw=im->rgb_width;
	sh=im->rgb_height;
	attr.override_redirect = TRUE;
	attr.window_type=GDK_WINDOW_TEMP;
	attr.wclass=GDK_INPUT_OUTPUT;
	attr.event_mask=GDK_STRUCTURE_MASK;
	attr.width=sw;
	attr.height=sh;
	win=gdk_window_new(NULL,&attr,0);

	display_w = DisplayWidth(gdk_display, gdk_screen);
	display_h = DisplayHeight(gdk_display, gdk_screen);
	gdk_window_show(win);

	for(i=1; i<=20; i++){
		sw = i*32;
		sh = i*20;
		gdk_imlib_render(im, sw, sh);
		if(p) gdk_imlib_free_pixmap(p);
		p=gdk_imlib_move_image(im);
		//m=gdk_imlib_move_mask(im);
		gdk_window_set_back_pixmap(win,p,0);
		gdk_window_move_resize(win, 
			(display_w - sw)/2, (display_h - sh)/2, sw, sh);
		//gdk_imlib_paste_image(im, win, 0, 0, sw, sh);
		//if (m) gdk_window_shape_combine_mask(win,m,0,0);
		gdk_flush();
		usleep(300);
	}
	sleep(2);
/*
	gdk_imlib_render(im, sw, sh);
	gdk_window_move_resize(win, 
                (display_w - sw)/2, (display_h - sh)/2, sw, sh);
        gdk_window_set_back_pixmap(win,p,0);
        gdk_window_show(win);
	gdk_imlib_paste_image(im, win, 0, 0, sw, sh);
        gdk_flush();
	sleep(2);
*/
	for ( i=FAINT_NUM-1 ;i>=1;i--){
		for (j=0;j<256;j++)
			modify[j] = (unsigned char) ( j*i/FAINT_NUM );
		gdk_imlib_set_image_red_curve(im, modify);
		gdk_imlib_set_image_green_curve(im, modify);
		gdk_imlib_set_image_blue_curve(im, modify);
		gdk_imlib_changed_image(im);
		//gdk_imlib_render(im, pix_width, pix_height);
		gdk_imlib_paste_image(im, win, 100, 100, sw/2, sh/2);
		gdk_flush();
		usleep(500);
	}

	gdk_window_destroy(win);
	if(p) gdk_imlib_free_pixmap(p);
}


#endif
