/*
###
### This file is part of
###
###                        TurboLinux  ZWinPro
###
###                 Copyright (C) 1999 TurboLinux, Inc. 
###                        All Rights Reserved
### Distributed under the terms of the GNU General Public License (GPL)
###
###
### Authors:     TurboLinux Chinese Development Team:
###              Justin Yu   <justiny@turbolinux.com.cn>
###              Sean Chen   <seanc@turbolinux.com.cn>
###              Daniel Fang <danf@turbolinux.com.cn>
### WWW:         http://www.turbolinux.com.cn/ZWinPro/
### FTP:         ftp://ftp.turbolinux.com.cn/pub/ZWinPro/
###
*/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <signal.h>
#include <string.h>
#include <sys/ioctl.h>
#include <locale.h>
#include <libintl.h>
#include <gtk/gtk.h>
#include <time.h>

#include "icons/information.xpm"

#define _(String)  gettext(String)
#define N_(String)  gettext(String)
#define __(String) (String)

extern GtkWidget *pixlabel(GtkWidget *w, char **pixdata, char *title);
void create_tips_window();
static GtkWidget *tipswindow = NULL;
static GtkWidget *tips;
/*
static char *zwintips[] = {
//chinput for FreeBSD
"chinput-3.0.2 for FreeBSDcjackerĻ϶ɵ",
"ɵĽǶ.뷨ǽMagicChinput-1.0Ļ",
"ģMagicChinput-1.0",
"ԵĻϽ",
"Ŀǰ֧ƴ/˫ƴ/ʴ뷨",
"ʱ뷨",
//zwincontrol
"ZwincontrolZwinproһ,Ҫɶ뷨Ĺ",
"Ŀǰл뷨/лӢı/뷽ʽȵ",
"unicon-imMagicChinput-1.0ģ",
"ĿΪṩһǿ뷽ʽ",
"ҪĹ"
"Chinput-3.0.2ǡǡʹMagicChinput-1.0",
"ԿṩMagicChinputһ빦",
"ΨһĲ",
"Chinput-3.0.2+unicon-im+zwicontrolʱ",
"κʱ뷽ȥ",

};
*/

/*  Need to hardcode the MAXTIPS constant.  -ypwong
 #define MAXTIPS                (sizeof(zwintips)/sizeof(zwintips[0]))
*/
#define MAXTIPS		10

static int flag_browse = 0;
static int cur_item = 0;
static int prev_item = 0;

void menubar_tips()
{
	create_tips_window();
}

static void tips_next()
{
	int j;
        char zwintipID[15];     /* this variable will contain the msgid of
                                   the zwintip that will be displayed.
                                   --ypwong */

	if(flag_browse == 0){
		while((j =(int) ((float)MAXTIPS * rand()/(RAND_MAX+1.0)))==prev_item);
		prev_item = j;
		
	} else {
		j = cur_item;
		if(j == MAXTIPS) {
			j = 0;
			cur_item = 0;
		}
	}
    /*
	gtk_label_set_text(GTK_LABEL(tips), zwintips[j]);
    */
        /* construct the string.  --ypwong */
        sprintf(zwintipID, "zwintip%d", j+1);
	gtk_label_set_text(GTK_LABEL(tips), _(zwintipID));
	if(flag_browse == 1) cur_item ++;
}

static void checkbutton_cb(GtkWidget *w, void *data)
{
	if(gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(w))){
		cur_item = 0;
		flag_browse = 1;
	} else {
		flag_browse = 0;
	}
}


void create_tips_window()
{
        GtkWidget *vbox, *hbox1, *hbox2, *bnext, *bclose, 
		*separator, *pix, *label, *checkbutton;
	GtkStyle *style;
        char zwintipID[15];     /* newly added.  --ypwong */
        if(!tipswindow){
		int j;

		srand(time(NULL));
		j=(int) ((float)MAXTIPS * rand()/(RAND_MAX+1.0));
                tipswindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
                gtk_widget_set_usize(tipswindow, 450, 300);
                gtk_window_set_policy(GTK_WINDOW(tipswindow),FALSE,FALSE,FALSE);
                gtk_signal_connect(GTK_OBJECT(tipswindow), "destroy",
                        GTK_SIGNAL_FUNC(gtk_widget_destroyed), &tipswindow);
                gtk_window_set_title(GTK_WINDOW(tipswindow), "TurboLinux ZWinPro Tips");
                gtk_container_set_border_width(GTK_CONTAINER(tipswindow), 10);

                vbox = gtk_vbox_new(FALSE, 15);
		gtk_container_set_border_width(GTK_CONTAINER(vbox), 15);
                gtk_container_add(GTK_CONTAINER(tipswindow), vbox);
                gtk_widget_show(vbox);

		hbox1 = gtk_hbox_new(FALSE, 0);
		gtk_box_pack_start(GTK_BOX(vbox), hbox1, FALSE, FALSE, 5);
		gtk_widget_show(hbox1);

		pix = pixlabel(tipswindow, icon_info, NULL);
		gtk_box_pack_start(GTK_BOX(hbox1), pix, FALSE, FALSE, 5);
		gtk_widget_show(pix);

		label = gtk_label_new(_("Do You Know?"));
		style = gtk_style_copy(GTK_WIDGET(label)->style);
		gdk_font_unref(style->font);
		/*  Don't specify the encoding because the user may
		 *  use either GB/GBK or Big5, or even others.  --ypwong */
		style->font = gdk_fontset_load("-adobe-times-medium-r-normal--24-*-*-*-*-*-iso8859-1,-*-*-medium-r-normal--24-*-*-*-*-*-*-*");
		gtk_widget_set_style(label, style);
		gtk_box_pack_start(GTK_BOX(hbox1), label,TRUE,TRUE,5);
		gtk_widget_show(label);

                separator = gtk_hseparator_new();
                gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 5);
                gtk_widget_show(separator);

		//tips
                sprintf(zwintipID, "zwintip%d", j+1);
                /*
		tips = gtk_label_new(zwintips[j]);
                */
		tips = gtk_label_new(_(zwintipID));
                gtk_box_pack_start(GTK_BOX(vbox), tips, TRUE, FALSE, 15);
		gtk_label_set_line_wrap(GTK_LABEL(tips), TRUE);
		gtk_widget_show(tips);

                separator = gtk_hseparator_new();
                gtk_box_pack_start(GTK_BOX(vbox), separator, FALSE, FALSE, 5);
                gtk_widget_show(separator);

		hbox2 = gtk_hbox_new(FALSE, 0);
                gtk_box_pack_start(GTK_BOX(vbox), hbox2, FALSE, FALSE, 5);
                gtk_widget_show(hbox2);

		checkbutton = gtk_check_button_new_with_label(_("Read in sequence"));
		gtk_box_pack_start(GTK_BOX(hbox2),checkbutton, FALSE, FALSE, 5);
		gtk_signal_connect(GTK_OBJECT(checkbutton), "toggled",
	                GTK_SIGNAL_FUNC(checkbutton_cb), NULL);
		gtk_widget_show(checkbutton);		

                bnext = gtk_button_new_with_label(_("Next"));
                gtk_signal_connect(GTK_OBJECT(bnext), "clicked",
                        GTK_SIGNAL_FUNC(tips_next), (gpointer)NULL);
		gtk_box_pack_start(GTK_BOX(hbox2), bnext, TRUE, TRUE, 5);
		//gtk_widget_set_usize(bnext, 80, 32);
		gtk_widget_show(bnext);

		bclose = gtk_button_new_with_label(_("Close window"));
                gtk_signal_connect_object(GTK_OBJECT(bclose), "clicked",
                        GTK_SIGNAL_FUNC(gtk_widget_destroy),
                        GTK_OBJECT(tipswindow));
		gtk_box_pack_start(GTK_BOX(hbox2), bclose, TRUE, TRUE, 5);
		//gtk_widget_set_usize(bclose, 80, 32);
		gtk_widget_show(bclose);

        }

        if(!GTK_WIDGET_VISIBLE(tipswindow))
                gtk_widget_show(tipswindow);
        else
                gtk_widget_destroy(tipswindow);
}

