#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <unistd.h>
#include <dirent.h>
#include <errno.h>

#ifdef HAVE_GTK
#include "gui.h"
#endif

char *info;
char *helpstr[] = { "Usage: comclear [OPTIONS]\n",
  "With no options Comclear will print this message.\n",
  "  --cookies       Clear cookies\n",
  "  --cache         Clear cache\n",
  "  --history       Clear history\n",
  "  --dropdown      Clear the drop-down list\n",
  "  --all           Clear all tracks\n",
  "  --version       Print version information\n",
  "\n",
  NULL
};
int cache = 0, cookies = 0, history = 0, dropdown = 0;
char nsbase[100];

/* Event prototypes */

void print_help (void);
void cli_message (char *msg, int level, void *data);
void cli_error (char *errmsg);
void comclear (void *call, void *error, void *data, int verbosity);
void clear_dir (char *directory, void *statback, void *data);

/* Main */
int
main (int argc, char *argv[])
{

  int argcount;
  char *disp;

  /* Initialize verision/help */
  sprintf ((info = malloc (200)),
	   "Comclear for Unix, version %s\nBy Luke Reeves", VERSION);

  if ((argc > 1) || ((disp = getenv ("DISPLAY")) == NULL))
    {
      printf ("ComClear version %s\n", VERSION);

      /* Parse command line */
      for (argcount = 0; argcount < argc; argcount++)
	{
	  if (strcasecmp ("--cache", argv[argcount]) == 0)
	    {
	      cache = 1;
	    }
	  if (strcasecmp ("--cookies", argv[argcount]) == 0)
	    {
	      cookies = 1;
	    }
	  if (strcasecmp ("--dropdown", argv[argcount]) == 0)
	    {
	      dropdown = 1;
	    }
	  if (strcasecmp ("--history", argv[argcount]) == 0)
	    {
	      history = 1;
	    }
	  if (strcasecmp ("--all", argv[argcount]) == 0)
	    {
	      cache = 1;
	      cookies = 1;
	      dropdown = 1;
	      history = 1;
	    }
	  if (strcasecmp ("--help", argv[argcount]) == 0)
	    {
	      print_help ();
	    }
	}

      if (argc > 1)
	comclear (cli_message, cli_error, (void *) NULL, 1);
      else
	print_help ();
    }
  else
    {
#ifdef HAVE_GTK
      gui_init (argc, argv);
#else
      print_help ();
#endif
    }

}


void
print_help (void)
{
  int count = 0;
  while (helpstr[count] != NULL)
    {
      printf (helpstr[count]);
      count++;
    }
  exit (2);
}


void
cli_message (char *msg, int level, void *data)
{
  if (level < 2)
    printf ("%s\n", msg);
}

void
cli_error (char *errmsg)
{
  printf ("%s\n", errmsg);
  exit (1);
}



/* Interface independent functions */

void
comclear (void *status, void *error, void *data, int verbosity)
{
  /* Take a callback pointer to send status messages
   * as well as a verbosity.  Verbosity is 0 for just the stages
   * and 1 is notification of every action */

  char *userhome, *nshome;
  FILE *file1;
  char filename[512];
  struct stat buf;
  void (*errcall) (char *);
  void (*statcall) (char *, int, void *);

  if (error != NULL)
    errcall = error;
  if (status != NULL)
    statcall = status;

  if ((userhome = getenv ("HOME")) == NULL)
    {
      if (error == NULL)
	{
	  printf ("Error! Couldn't find HOME environment variable.");
	  exit (1);
	}
      errcall ("Couldn't find HOME environment variable.");
      return;
    }

  /* Build the netscape directory */
  nshome = malloc (strlen (userhome) + 20);
  sprintf (nshome, "%s/.netscape/", userhome);

  sprintf (filename, "%slock", nshome);

  if (lstat (filename, &buf) == 0)
    {
      if (error == NULL)
	{
	  printf ("Netscape is running.");
	  exit (1);
	}
      errcall ("Error! Netscape is running.");
      return;
    }

  /* First clear the cache */
  if (cache == 1)
    {
      statcall ("Clearing cache...", 1, data);
      sprintf (filename, "%scache", nshome);
      clear_dir (filename, status, data);
    }

  /* Then cookies */
  if (cookies == 1)
    {
      statcall ("Clearing cookies...", 1, data);
      sprintf (filename, "%scookies", nshome);
      unlink (filename);
    }

  /* Then history */
  if (history == 1)
    {
      statcall ("Clearing history...", 1, data);
      sprintf (filename, "%shistory.dat", nshome);
      unlink (filename);
    }

  /* Then drop down list */
  if (dropdown == 1)
    {
      statcall ("Clearing drop-down list...", 1, data);
      sprintf (filename, "%shistory.list", nshome);
      unlink (filename);
    }

  statcall ("Done.", 1, data);

}

void
clear_dir (char *directory, void *statback, void *data)
{
  DIR *dir;
  struct dirent *dirp;
  char buffer[512];
  void (*statcall) (char *, int, void *);
  struct stat buf;

  if (statback != NULL)
    statcall = statback;
  sprintf (buffer, "Clearing directory %s", directory);
  statcall (buffer, 2, data);
  dir = opendir (directory);

  while ((dirp = readdir (dir)) != NULL)
    {
      if ((strcmp (dirp->d_name, ".") != 0) &&
	  (strcmp (dirp->d_name, "..") != 0))
	{
	  sprintf (buffer, "%s/%s", directory, dirp->d_name);
	  stat (buffer, &buf);
	  if (S_ISDIR (buf.st_mode))
	    {
	      clear_dir (buffer, statback, data);
	      /* Now wipe out the actual directory */
	      rmdir (buffer);
	    }
	  else
	    {
	      unlink (buffer);
	    }
	}
    }

  closedir (dir);
}
