/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfoComponent;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import javax.swing.JTextField;

public class AirportInfoScaledValueField
extends JTextField
implements AirportInfoComponent {
    private AirportInfoRecord theRecord;
    private int scalingFactor;

    public AirportInfoScaledValueField(AirportInfoRecord airportInfoRecord, int n) {
        this.theRecord = airportInfoRecord;
        this.scalingFactor = n;
        int n2 = airportInfoRecord.byteBlockWindow.getSize();
        if ((n2 *= 3) > 40) {
            n2 = 40;
        }
        this.setColumns(n2);
        this.refreshDisplay();
    }

    public AirportInfoScaledValueField(AirportInfoRecord airportInfoRecord, int n, int n2) {
        this.theRecord = airportInfoRecord;
        this.scalingFactor = n;
        this.setColumns(n2);
        this.refreshDisplay();
    }

    public void refreshDisplay() {
        try {
            long l = Long.parseLong(this.theRecord.toString());
            long l2 = l / (long)this.scalingFactor;
            String string = new String();
            string = String.valueOf(string) + l2;
            this.setText(string);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    public void writeValue() throws ValueFormatException {
        long l = 0L;
        try {
            l = Long.parseLong(this.getText());
        }
        catch (NumberFormatException numberFormatException) {
            this.selectAll();
            this.requestFocus();
            throw new ValueFormatException("Bad number format.");
        }
        int n = this.theRecord.byteBlockWindow.getSize();
        long l2 = 0L;
        long l3 = 1L;
        int n2 = 0;
        while (n2 < n) {
            l3 *= 256L;
            ++n2;
        }
        --l3;
        if (l < l2 || l > (l3 /= (long)this.scalingFactor)) {
            this.selectAll();
            this.requestFocus();
            throw new ValueFormatException("Value must be between " + l2 + " and " + l3 + ".");
        }
        long l4 = l * (long)this.scalingFactor;
        String string = new String();
        string = String.valueOf(string) + l4;
        this.theRecord.setBytesFromString(string);
    }

    public void writeValue(String string) throws ValueFormatException {
        this.setText(string);
        this.writeValue();
        this.refreshDisplay();
    }
}

