/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfoComponent;
import airport.AirportInfoRecord;
import airport.ValueFormatException;
import javax.swing.JTextField;

public class AirportInfoTextField
extends JTextField
implements AirportInfoComponent {
    private AirportInfoRecord theRecord;

    public AirportInfoTextField(AirportInfoRecord airportInfoRecord) {
        this.theRecord = airportInfoRecord;
        int n = airportInfoRecord.byteBlockWindow.getSize();
        switch (airportInfoRecord.dataType) {
            case 3: {
                n = 20;
                break;
            }
            case 1: {
                n = 15;
                break;
            }
            default: {
                n *= 3;
            }
            case 0: 
        }
        if (n > 40) {
            n = 40;
        }
        this.setColumns(n);
        this.refreshDisplay();
    }

    public AirportInfoTextField(AirportInfoRecord airportInfoRecord, int n) {
        this.theRecord = airportInfoRecord;
        this.setColumns(n);
        this.refreshDisplay();
    }

    public void refreshDisplay() {
        this.setText(this.theRecord.toString());
    }

    public void writeValue() throws ValueFormatException {
        try {
            this.theRecord.setBytesFromString(this.getText());
        }
        catch (ValueFormatException valueFormatException) {
            this.selectAll();
            this.requestFocus();
            throw valueFormatException;
        }
    }

    public void writeValue(String string) throws ValueFormatException {
        this.setText(string);
        this.writeValue();
        this.refreshDisplay();
    }
}

