/*
 * Decompiled with CFR 0.152.
 */
package airport;

import airport.AirportInfo;
import airport.AirportInfoCheckBox;
import airport.AirportInfoComboBox;
import airport.AirportInfoLabelledTextField;
import airport.AirportInfoPanel;
import airport.AirportLoginInfoDialog;
import airport.AirportPhoneNumberPanel;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;

public class AirportModemConfigPanel
extends AirportInfoPanel
implements ActionListener {
    private AirportPhoneNumberPanel phoneNumberPanel;
    private AirportLoginInfoDialog loginDialog;
    private AirportInfoLabelledTextField modemTimeoutField;
    private AirportInfoComboBox tonePulseDialingBox;
    private AirportInfoCheckBox automaticDialingCheckbox;
    private JButton loginButton;
    private AirportInfo theInfo;

    public AirportModemConfigPanel(AirportInfo airportInfo) {
        this.theInfo = airportInfo;
        this.phoneNumberPanel = new AirportPhoneNumberPanel(airportInfo);
        this.loginButton = new JButton("Username/Password/Login Script");
        this.loginButton.setActionCommand("show login panel");
        this.loginButton.addActionListener(this);
        this.modemTimeoutField = new AirportInfoLabelledTextField("Modem timeout (in 10-second units)", airportInfo.get("Modem timeout"));
        this.tonePulseDialingBox = new AirportInfoComboBox("Tone or pulse (rotary) dialing", airportInfo.get("Dialing type (tone or pulse)"));
        this.tonePulseDialingBox.addItemAndValue("Tone", "08");
        this.tonePulseDialingBox.addItemAndValue("Pulse", "00");
        this.automaticDialingCheckbox = new AirportInfoCheckBox("Automatic dialing", airportInfo.get("Automatic dial"), "00", "02");
        this.setUpDisplay();
    }

    public void setUpDisplay() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 0;
        gridBagConstraints.ipadx = 0;
        gridBagConstraints.ipady = 0;
        gridBagConstraints.insets = new Insets(2, 10, 2, 10);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.weighty = 0.5;
        this.setLayout(gridBagLayout);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(this.phoneNumberPanel, gridBagConstraints);
        this.add(this.phoneNumberPanel);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.loginButton, gridBagConstraints);
        this.add(this.loginButton);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.automaticDialingCheckbox, gridBagConstraints);
        this.add(this.automaticDialingCheckbox);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.modemTimeoutField, gridBagConstraints);
        this.add(this.modemTimeoutField);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagLayout.setConstraints(this.tonePulseDialingBox, gridBagConstraints);
        this.add(this.tonePulseDialingBox);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("show login panel")) {
            Container container = this;
            while (container != null && !(container instanceof Frame)) {
                container = container.getParent();
            }
            Frame frame = (Frame)container;
            this.loginDialog = new AirportLoginInfoDialog(frame, "Login Information", true, this.theInfo);
            this.loginDialog.pack();
            Dimension dimension = this.loginDialog.getSize();
            dimension.height += 20;
            dimension.width += 20;
            ((Component)this.loginDialog).setSize(dimension);
            this.loginDialog.show();
        }
    }
}

