/*
 * Decompiled with CFR 0.152.
 */
package byteblock;

import byteblock.ByteBlock;
import byteblock.ByteBlockRectangularWindow;

public class ByteBlockMaskedWindow
extends ByteBlockRectangularWindow {
    private byte mask;

    public ByteBlockMaskedWindow(ByteBlock byteBlock, byte by) {
        super(byteBlock);
        this.mask = by;
    }

    public ByteBlockMaskedWindow(int n, int n2, int n3, ByteBlock byteBlock, byte by) {
        super(n, n2, n3, byteBlock);
        this.mask = by;
    }

    public byte[] getBytes(int n, int n2) {
        byte[] byArray = super.getBytes(n, n2);
        int n3 = 0;
        while (n3 < byArray.length) {
            byArray[n3] = (byte)(byArray[n3] & this.mask);
            ++n3;
        }
        return byArray;
    }

    public void clearBytes(int n, int n2) {
        byte by = (byte)(0xFF ^ this.mask);
        if (n2 > this.numRows * this.numCols) {
            n2 = this.numRows * this.numCols;
        }
        int n3 = this.baseStartIndex / this.baseBlock.numCols;
        int n4 = this.baseStartIndex - n3 * this.baseBlock.numCols;
        int n5 = n;
        while (n5 < n2) {
            int n6 = n5 / this.numCols;
            int n7 = n5 - n6 * this.numCols;
            int n8 = n7 + n4 + (n6 + n3) * this.baseBlock.numCols;
            this.baseBlock.bytes[n8] = (byte)(this.baseBlock.bytes[n8] & by);
            ++n5;
        }
    }

    public void writeBytes(int n, byte[] byArray) {
        this.clearBytes();
        int n2 = n + byArray.length;
        if (n2 > this.numRows * this.numCols) {
            n2 = this.numRows * this.numCols;
        }
        int n3 = this.baseStartIndex / this.baseBlock.numCols;
        int n4 = this.baseStartIndex - n3 * this.baseBlock.numCols;
        int n5 = n;
        while (n5 < n2) {
            int n6 = n5 / this.numCols;
            int n7 = n5 - n6 * this.numCols;
            int n8 = n7 + n4 + (n6 + n3) * this.baseBlock.numCols;
            this.baseBlock.bytes[n8] = (byte)(this.baseBlock.bytes[n8] | byArray[n5 - n] & this.mask);
            ++n5;
        }
    }

    public String toString(int n, int n2) {
        String string = new String();
        int n3 = this.baseStartIndex / this.baseBlock.numCols;
        int n4 = this.baseStartIndex - n3 * this.baseBlock.numCols;
        int n5 = n;
        while (n5 < n2) {
            int n6 = n5 / this.numCols;
            int n7 = n5 - n6 * this.numCols;
            int n8 = n7 + n4 + (n6 + n3) * this.baseBlock.numCols;
            int n9 = this.baseBlock.bytes[n8] & this.mask;
            if (n9 < 0) {
                n9 += 256;
            }
            string = String.valueOf(string) + this.getHex(n9) + " ";
            if (n7 == this.numCols - 1) {
                string = String.valueOf(string) + "\n";
            }
            ++n5;
        }
        return string;
    }

    public String toHexString(int n, int n2) {
        String string = new String();
        int n3 = this.baseStartIndex / this.baseBlock.numCols;
        int n4 = this.baseStartIndex - n3 * this.baseBlock.numCols;
        int n5 = n;
        while (n5 < n2) {
            int n6 = n5 / this.numCols;
            int n7 = n5 - n6 * this.numCols;
            int n8 = n7 + n4 + (n6 + n3) * this.baseBlock.numCols;
            int n9 = this.baseBlock.bytes[n8] & this.mask;
            if (n9 < 0) {
                n9 += 256;
            }
            string = String.valueOf(string) + this.getHex(n9);
            ++n5;
        }
        return string;
    }
}

