/*****************************************************************************\
 * FILE: OpenPosition.cpp
 *
 * PURPOSE:Implementation of the OpenPosition and Move classes
 *
 * Created by Eric Akers, 24 Dec 2003
 *
 * ChangeLog:
 *     ELA - <Date> - Initial Working Version
 *
 *
 *
 *   
 *   Copyright (C) 2003 Eric Akers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\*****************************************************************************/



// Header Files #############################################################
#include <stdio.h>

#include "AdjacentPosition.h"

// Macros ###################################################################


// Structures ###############################################################


// Class Function Definitions ###############################################


// ------------------- Move
Move::Move()
{
  row = col = 0;
}

Move::Move( int row, int col ) 
{
  this->row = row;
  this->col = col;
}


bool Move::operator<( Move & move )
{
  if( row < move.row ) {
    return true;
  }
  else if( row == move.row ) {
    if( col < move.col ) {
      return true;
    }
  }

  return false;
}



bool Move::operator==( Move & move )
{
  if( row == move.row && col == move.col ) {
    return true;
  }
  else {
    return false;
  }
}




// ----------------- AdjacentPosition

AdjacentPosition::_RowNode::_RowNode()
{
  // Initialize all to null
  for( int i=0; i<19; i++ ) {
    colNodes[i] = NULL;
  }
}

AdjacentPosition::AdjacentPosition()
{
  // Initialize the tree to null
  for( int i=0; i<19; i++ ) {
    decisionTree.rowNodes[i] = NULL;
  }
}


AdjacentPosition::~AdjacentPosition()
{
  // Delete all the nodes
  for( int i=0; i<19; i++ ) {
    if( decisionTree.rowNodes[i] != NULL ) {
      // Delete each ColNode inside the RowNode
      deleteColNode( decisionTree.rowNodes[i] );

      // Delete the RowNode
      delete decisionTree.rowNodes[i];
    }
  }
}


void AdjacentPosition::deleteColNode( RowNode * node ) 
{
  for( int i=0; i<19; i++ ) {
    if( node->colNodes[i] != NULL ) {
      delete node->colNodes[i];
    }
  }
}



void AdjacentPosition::addPosition( int row, int col )
{
  // Find the nodes
  RowNode * rowNode;
  ColNode * colNode;
  bool exists = findNode( row, col, &rowNode, &colNode );
  if( exists ) {
    // Our work here is done
    return;
  }

  // Create the new ColNode
  colNode = new ColNode();
  if( colNode == NULL ) {
    printf( "ALLOCATION ERROR\n" );
    exit( -1 );
  }

  // Add the new move into the list
  Move newMove( row, col );
  openPositions.push_front( newMove );
  colNode->iter = openPositions.begin();

  // Set the colNode
  rowNode->colNodes[col] = colNode;
}



// Remove a position form the list
void AdjacentPosition::removePosition( int row, int col )
{
  // Find the nodes
  RowNode * rowNode;
  ColNode * colNode;
  bool exists = findNode( row, col, &rowNode, &colNode );
  if( exists == false ) {
    // Our work here is done
    return;
  }

  // Erase the colNode only and remove it's move from the list
  openPositions.erase( colNode->iter );
  delete colNode;
  rowNode->colNodes[col] = NULL;
}



// Return the number of positions stored
int AdjacentPosition::size() const
{
  return openPositions.size();
}


// Return a list of positions
const list<Move> AdjacentPosition::getPositions() const
{
  return openPositions;
}


// Return the node with these values or the parent node if this node
// does not exist
bool AdjacentPosition::findNode( int row, int col, RowNode ** rowNode,
				 ColNode ** colNode )
{
  RowNode * curRow = decisionTree.rowNodes[row];
  if( curRow == NULL ) {
    // Create this and return it
    decisionTree.rowNodes[row] = new RowNode();
    if( decisionTree.rowNodes[row] == NULL ) {
      printf( "ALLOCATION ERROR\n" );
      exit( -1 );
    }

    // Initialize the col nodes
    for( int i=0; i<19; i++ ) {
      decisionTree.rowNodes[row]->colNodes[i] = NULL;
    }

    *rowNode = decisionTree.rowNodes[row];
    *colNode = NULL;
    return false;
  }

  // Atleast the row exists
  if( curRow->colNodes[col] == NULL ) {
    // Just return
    *rowNode = curRow;
    *colNode = NULL;
    return false;
  }

  // Return the values
  *rowNode = curRow;
  *colNode = curRow->colNodes[col];
  return true;
}


void AdjacentPosition::print()
{
  list<Move>::iterator iter = openPositions.begin();
  for( unsigned int i=0; i<openPositions.size(); iter++, i++ ) {
    Move tmp = *iter;
    printf( "(%d,%d)\n", tmp.row, tmp.col );
  }

}
