/*****************************************************************************\
 * FILE: SimpleHeuristic.h
 *
 * PURPOSE: Adds a heuristic function to the Board
 *
 * Created by Eric Akers, 30 Dec 2001
 *
 * ChangeLog:
 *     ELA - <Date> - Initial Working Version
 *
 *
 *
 *   
 *   Copyright (C) 2003 Eric Akers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\*****************************************************************************/



#ifndef SIMPLE_HEURISTC_H
#define SIMPLE_HEURISTC_H

// Header Files #############################################################
#include "Board.h"

// Macros ###################################################################


// Structures ###############################################################


// Global Variables #########################################################


// Class Definition #########################################################
class SimpleHeuristic : public Board
{
 public:
  SimpleHeuristic();

  long int getHeuristicValue( int player ) const;

 protected:
  // Heuristic Values
  static const int LENGTH_ONE_OPEN = 1;
  static const int LENGTH_ONE_CLOSED = 1;
  static const int LENGTH_TWO_OPEN = 2;
  static const int LENGTH_TWO_CLOSED = 1;
  static const int LENGTH_THREE_OPEN = 20;
  static const int LENGTH_THREE_CLOSED = 8;
  static const int LENGTH_FOUR_OPEN = 1000;
  static const int LENGTH_FOUR_CLOSED = 20;
  static const int LENGTH_FIVE = 20000;


  int getHeuristicForLength( int length, bool bothEndsOpen ) const;
};


#endif
