/*****************************************************************************\
 * FILE: actionCallbacks.cpp
 *
 * PURPOSE: Implements the callbacks that come from the gui
 *
 * Created by Eric Akers, 26 Dec 2003
 *
 * ChangeLog:
 *     ELA - <Date> - Initial Working Version
 *
 *
 *
 *
 *   Copyright (C) 2003 Eric Akers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\*****************************************************************************/




/* Header Files ############################################################# */
#include "connectFive.h"
#include "guiObject.h"
#include "computerSearch.h"

/* Macros ################################################################### */
// Difficulty settings
#define NOVICE_DIFFICULTY 2
#define AMATEUR_DIFFICULTY 4
#define EXPERT_DIFFICULTY 6
#define MASTER_DIFFICULTY 8

/* Structures ############################################################### */


/* Global Variables ######################################################### */


/* Function Declarations #################################################### */


/* Static Function Declarations ############################################# */


/* Main ##################################################################### */


/* Function Definitions  #################################################### */


/* Static Function Definitions ############################################## */

void mainMenuCallback( int eventType, guiObject * object )
{
  printf( "ENTERING mainmenuCallback\n" );
  switch( object->getIDNumber() )
    {
    case MM_QUIT_GAME:
      // Quit this sucker
      exit( 0 );
      break;

    case MM_PLAYER_ONE:
      // Set player one
      if( object->getLabel() == "Computer" ){
	setPlayerType( PLAYER_1, COMPUTER_PLAYER );
      }
      else { 
	setPlayerType( PLAYER_1, HUMAN_PLAYER );
      }
      break;

    case MM_PLAYER_TWO:
      // Set player two
      if( object->getLabel() == "Computer" ){
	setPlayerType( PLAYER_2, COMPUTER_PLAYER );
      }
      else { 
	setPlayerType( PLAYER_2, HUMAN_PLAYER );
      }

      break;

    case MM_START_GAME:
      // Delete the old computer players
      if( computerPlayers[PLAYER_1] != NULL ) {
	delete computerPlayers[PLAYER_1];
	delete computerPlayers[PLAYER_2];
      }

      // Reset the last move
      setLastMove( -1, -1 );

      // Set the computer players
      computerPlayers[PLAYER_1] = new computerSearch( getDifficulty() );
      computerPlayers[PLAYER_2] = new computerSearch( getDifficulty() );

      // Make sure player one is going first
      setCurrentPlayer( PLAYER_1 );
      setGameLabel( PLAYER_1, -1, -1 );

      // Let the fun begin
      changeGameMode( MODE_ONE_PLAYER );
      createNewBoard();

      // See if a computer should go first
      if( getCurrentPlayerType() == COMPUTER_PLAYER ) {
	getNextComputerMove( -1, -1 ); // This is the first move
      }
      break;

    case MM_DIFFICULTY:
      // Set the difficulty of a one player game
      if( object->getLabel() == "Novice" ) {
	setDifficulty( NOVICE_DIFFICULTY );
      }
      else if( object->getLabel() == "Amateur" ) {
	setDifficulty( AMATEUR_DIFFICULTY );
      }
      else if( object->getLabel() == "Expert" ) {
	setDifficulty( EXPERT_DIFFICULTY );
      }
      else if( object->getLabel() == "Master" ) {
	setDifficulty( MASTER_DIFFICULTY );
      }

      break;

    default:
      printf( "Invalid action\n" );
      exit( -1 );

      break;
    }
}
