/*****************************************************************************\
 * FILE: computerSearch.h
 *
 * PURPOSE: Defines the computer player search class
 *
 * Created by Eric Akers, 24 Dec 2003
 *
 * ChangeLog:
 *     ELA - <Date> - Initial Working Version
 *
 *
 *
 *   
 *   Copyright (C) 2003 Eric Akers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\*****************************************************************************/



#ifndef COMPUTERSEARCH_H
#define COMPUTERSEARCH_H

// Header Files #############################################################
#include <vector>
#include <stdio.h>

#include "SimpleHeuristic.h"

using namespace std;

// Macros ###################################################################


// Structures ###############################################################


// Global Variables #########################################################


// Class Definition #########################################################
class computerSearch
{
 public:
  computerSearch();
  computerSearch( int numPly );

  // Set the other players move into the state and return whether it
  // resulted in a winning state or not.
  bool setOtherPlayerMove( int row, int col );

  // Returns the next move for this player and whether the move
  // resulted in a winning state
  bool getNextMove( int & row, int & col );

  // Determine if the current state is a winner
  bool isWinner() const;

 private:
  SimpleHeuristic * boardState;

  bool isWinningState;
  bool hasLost;
  int plySearchLevel;

  Move winningMove;


  // Alpha beta searching
  long int doSearchMax( int alpha, int beta, int level,
			SimpleHeuristic * currentNode );
  long int doSearchMin( int alpha, int beta, int level,
			SimpleHeuristic * currentNode );

  // Filters moves
  bool filterMove( Move & curMove, SimpleHeuristic * board, int player );
  int numMoves;

};


#endif
