/*****************************************************************************\
 * FILE: connectFive.h
 *
 * PURPOSE: Project environment
 *
 * Created by Eric Akers, 22 Dec 2003
 *
 * ChangeLog:
 *     ELA - <Date> - Initial Working Version
 *
 *
 *   
 *   
 *   Copyright (C) 2003 Eric Akers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\*****************************************************************************/




#ifndef CONNECTFIVE_H
#define CONNECTFIVE_H


/* Header Files ############################################################## */
#include <SDL/SDL.h>
#include <SDL/SDL_thread.h>

#include "glfont2.h"
#include "guiContainer.h"
#include "guiMenuItem.h"
#include "computerSearch.h"
#include "SimpleHeuristic.h"

/* Macros #################################################################### */
#define WIN_WIDTH 800
#define WIN_HEIGHT 600
#define ROTATION_SCALE 500 // The number of pixels to rotate 360 degrees
#define DEFAULT_DISTANCE_EYE_CENTER 230.0

// View Setup
#define FOVY 60.0
#define ZNEAR 10
#define ZFAR 700

// Game modes
#define MODE_DEMO 0  // Main menu and when game starts
#define MODE_ONE_PLAYER 1
#define MODE_TWO_PLAYER 2
#define MODE_GAME_FINISHED 3

// GUI ID numbers
#define MM_QUIT_GAME 0
#define MM_PLAYER_ONE 1
#define MM_PLAYER_TWO 2
#define MM_DIFFICULTY 3
#define MM_START_GAME 4

// Players
#define HUMAN_PLAYER 0
#define COMPUTER_PLAYER 1
#define PLAYER_1 0
#define PLAYER_2 1

// User defined events
#define PLAY_COMPUTER_MOVE SDL_USEREVENT + 1


/* Global Variables ########################################################## */
// Dynamic rotation globals
extern int screenBaseX, screenBaseZ;
extern int lastScreenOffsetX, lastScreenOffsetY;
extern bool mouseMotion;
extern GLdouble screenRotateX, screenRotateZ;
extern GLdouble distanceEyeCenter;

// Translation globals
extern GLdouble screenMoveX, screenMoveY;

// The font
extern GLFont font;

// Highlighting which position on the board to select
extern int highlightCheckerX, highlightCheckerY;

// Flag that determines when mouse picking happens
extern bool mousePick;

// Contains the current menu to draw
extern guiContainer * currentMenu;

// The computer player(s)
extern computerSearch * computerPlayers[2];

// The SDL Thread that determines the next move by the computer
extern SDL_Thread * computerMoveThread;

// Holds the current state of the game
extern SimpleHeuristic * currentState;



/* Structures/Objects/Types ################################################## */


/* Function Declarations ##################################################### */

#ifdef __cplusplus
extern "C" {
#endif
  void display();
  void setupView( int width, int height, GLdouble fovy, GLdouble zNear, 
		  GLdouble zFar );
  void setupMenu( guiContainer * container );
  void setupGameMenu( guiContainer * container,
		      guiMenuItem * item1, guiMenuItem * item2 );

  void setupModelViewMatrix();
  void setupProjectionMatrix( int width, int height, GLdouble fovy, 
			      GLdouble zNear, GLdouble zFar );
  void drawScene();
  void setNextPlay( int x, int y );
  void changeGameMode( char newMode );
  char getGameMode();
  void createNewBoard();

  char getCurrentPlayerType();
  char getCurrentPlayer();
  void setCurrentPlayer( char player );
  void setPlayerType( char player, char type );
  void getNextComputerMove( int lastMoveRow, int lastMoveCol );
  int getDifficulty();
  void setDifficulty( int diff );
  int getDifficulty();
  void setGameWinner( char player );
  void setGameLabel( char player, int row, int col );
  void setLastMove( int row, int col );
  bool getLastMove( int * row, int * col );


  // Gui callbacks
  void mainMenuCallback( int eventType, guiObject * object );

#ifdef __cplusplus
}
#endif


#endif

