/*****************************************************************************\
 * FILE: guiMenuItem.cpp
 *
 * PURPOSE: Implementation of the guiMenuItem class
 *
 * Created by Eric Akers, 22 Dec 2003
 *
 * ChangeLog:
 *     ELA - <Date> - Initial Working Version
 *
 *
 *
 *   
 *   Copyright (C) 2003 Eric Akers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\*****************************************************************************/



// Header Files #############################################################
#include <SDL/SDL.h>

#include "guiMenuItem.h"

// Macros ###################################################################


// Structures ###############################################################


// Class Function Definitions ###############################################
guiMenuItem::guiMenuItem() : guiButton()
{
  setBorder( false );
}


guiMenuItem::guiMenuItem( GLdouble topLeftX, GLdouble topLeftY, 
			  GLdouble width, GLdouble height )
  :guiButton( topLeftX, topLeftY, width, height )
{
  setBorder( false );
}



guiMenuItem::guiMenuItem( string text ) : guiButton()
{
  setBorder( false );
  setLabel( text );
}



guiMenuItem::~guiMenuItem()
{}



bool guiMenuItem::doMouseEvent( Uint8 button, Uint8 state, Uint16 x, Uint16 y )
{
  // Only use the left button - release or click
  if( button != SDL_BUTTON_LEFT ) {
    return false;
  }


  // Make sure it is within the boundary
  if( x > xPos && x < (xPos + widgetWidth) &&
      y < yPos && y > (yPos - widgetHeight) ) {

    // Perform the action
    if( actionListener != NULL ) {
      actionListener->actionPerformed( GUI_EventMenuItem, this );
    }

    return true;
  }
  else {
    return false;
  }
}
