/*****************************************************************************\
 * FILE: guiObject.cpp
 *
 * PURPOSE: Implementation of the guiObject class
 *
 * Created by Eric Akers, 19 Dec 2003
 *
 * ChangeLog:
 *     ELA - <Date> - Initial Working Version
 *
 *
 *
 *   
 *   Copyright (C) 2003 Eric Akers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\*****************************************************************************/



// Header Files #############################################################
#include "guiObject.h"

// Macros ###################################################################


// Structures ###############################################################


// Globals ##################################################################
static GUI_COLORS guiDefaultColors;

// Define the default colors structure
GUI_COLORS::GUI_COLORS()
{
  fgr = fgg = fgb = 0.0;
  bgr = bgg = bgb = 0.7;
  fga = bga = 1.0;
}



// Class Function Definitions ###############################################
guiObject::guiObject()
{
  xPos = yPos = zPos = 0.0;
  widgetWidth = widgetHeight = 0;
  widgetFont = NULL;
  widgetBorder = true;
  isWidgetVisible = true;
  actionListener = NULL;
  labelWidth = 0.0;
  labelHeight = 0.0;
  actionCallback = NULL;

  // Set the default colors
  fgr = guiDefaultColors.fgr;
  fgg = guiDefaultColors.fgg;
  fgb = guiDefaultColors.fgb;
  fga = guiDefaultColors.fga;
  bgr = guiDefaultColors.bgr;
  bgg = guiDefaultColors.bgg;
  bgb = guiDefaultColors.bgb;
  bga = guiDefaultColors.bga;
}


guiObject::~guiObject()
{}



void guiObject::setPosition( GLdouble x, GLdouble y, GLdouble z )
{
  xPos = x;
  yPos = y;
  zPos = z;
}



void guiObject::setSize( GLdouble width, GLdouble height )
{
  widgetWidth = width;
  widgetHeight = height;
}


void guiObject::setWidth( GLdouble width )
{
  widgetWidth = width;
}



void guiObject::setHeight( GLdouble height )
{
  widgetHeight = height;
}


void guiObject::setLabel( string label )
{
  widgetLabel = label;

  if( widgetFont == NULL ) {
    // No font defined yet
    return;
  }

  widgetFont->Begin();
  std::pair<int,int> dimensions;
  widgetFont->GetStringSize( label.c_str(), &dimensions );
  labelWidth = (GLdouble)dimensions.first;
  labelHeight = (GLdouble)dimensions.second;
}

  

void guiObject::setGLFont( GLFont * font )
{
  widgetFont = font;
  widgetFont->Begin();

  std::pair<int,int> dimensions;
  widgetFont->GetStringSize( widgetLabel.c_str(), &dimensions );
  labelWidth = (GLdouble)dimensions.first;
  labelHeight = (GLdouble)dimensions.second;
}


void guiObject::setFGColor( GLdouble r, GLdouble g, GLdouble b, GLdouble a )
{
  fgr = r;
  fgg = g;
  fgb = b;
  fga = a;
}



void guiObject::setBGColor( GLdouble r, GLdouble g, GLdouble b, GLdouble a )
{
  bgr = r;
  bgg = g;
  bgb = b;
  bga = a;
}


void guiObject::setBorder( bool useBorder )
{
  widgetBorder = useBorder;
}


void guiObject::setVisible( bool isVisible )
{
  isWidgetVisible = isVisible;
}


void guiObject::setIDNumber( int idNumber )
{
  widgetID = idNumber;
}


void guiObject::setCommandCode( string code )
{
  commandCode = code;
}



void guiObject::getPosition( GLdouble & x, GLdouble & y, GLdouble & z ) const
{
  x = xPos;
  y = yPos;
  z = zPos;
}



void guiObject::getSize( GLdouble & width, GLdouble & height ) const
{
  width = widgetWidth;
  height = widgetHeight;
}



string guiObject::getLabel( string & label ) const
{
  label = widgetLabel;
  return widgetLabel;
}


string guiObject::getLabel() const
{
  return widgetLabel;
}


bool guiObject::getBorder() const
{
  return widgetBorder;
}


GLdouble guiObject::getLabelWidth() const
{
  return labelWidth;
}


GLdouble guiObject::getLabelHeight() const
{
  return labelHeight;
}


bool guiObject::isVisible() const
{
  return isWidgetVisible;
}


int guiObject::getIDNumber() const
{
  return widgetID;
}



string guiObject::getCommandCode() const
{
  return commandCode;
}



void guiObject::draw()
{}


// ------------------------ EVENTS
bool guiObject::doMouseEvent( Uint8 button, Uint8 state, Uint16 x, Uint16 y )
{
  if( isWidgetVisible == false ) {
    // This widget will not see any events
    //    printf( "****guiObject:mouseEvent false\n" );
    return false;
  }

  // Make sure it is within the boundary
  if( x > xPos && x < (xPos + widgetWidth) &&
      y < yPos && y > (yPos - widgetHeight) ) {
    //    printf( "****guiObject:mouseEvent true\n" );
    return true;
  }
  else {
    //    printf( "****guiObject:mouseEvent false\n" );
    return false;
  }
}



bool guiObject::doKeyboardEvent( Uint8 state, SDL_keysym keysym )
{
  return false;
}


// Actions
void guiObject::actionPerformed( int eventType, guiObject * eventObject )
{}


void guiObject::addActionListener( guiObject * listener )
{
  actionListener = listener;
}

void guiObject::addActionCallback( void (*callback)( int, guiObject * ) )
{
  actionCallback = callback;
}




// ------------------------ Global functions
void GUI_setDefaultColors( GLdouble fgr, GLdouble fgg, GLdouble fgb, 
			   GLdouble fga, GLdouble bgr, GLdouble bgg, 
			   GLdouble bgb, GLdouble bga )
{
  guiDefaultColors.fgr = fgr;
  guiDefaultColors.fgg = fgg;
  guiDefaultColors.fgb = fgb;
  guiDefaultColors.fga = fga;
  guiDefaultColors.bgr = bgr;
  guiDefaultColors.bgg = bgg;
  guiDefaultColors.bgb = bgb;
  guiDefaultColors.bga = bga;
}

