/*****************************************************************************\
 * FILE: AdjacentPosition.h
 *
 * PURPOSE: Defines a structure to store moves in the Board
 *
 * Created by Eric Akers, 24 Dec 2003
 *
 * ChangeLog:
 *     ELA - <Date> - Initial Working Version
 *
 *
 *
 *   
 *   Copyright (C) 2003 Eric Akers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\*****************************************************************************/



#ifndef ADJACENTPOSITION_H
#define ADJACENTPOSITION_H

// Header Files #############################################################
#include <list>

using namespace std;

// Macros ###################################################################


// Structures ###############################################################


// Global Variables #########################################################


// Class Definition #########################################################
class Move
{
 public:
  int row, col;
  Move();
  Move( int row, int col );

  bool operator<( Move & move );
  bool operator==( Move & move );
};


class AdjacentPosition
{
 public:
  AdjacentPosition();
  ~AdjacentPosition();

  // Add a position into the list of open positions. This will not
  // be added if it is a duplicate
  void addPosition( int row, int col );

  // Remove a position form the list
  void removePosition( int row, int col );

  // Return the number of positions stored
  int size() const;

  // Return a list of positions
  const list<Move> getPositions() const;

  // Debugging
  void print();


 private:
  // Defines the data stored in the second level
  typedef struct _ColNode {
    list<Move>::iterator iter;
  } ColNode;

  // Defines the data stored at the first level
  typedef struct _RowNode {
    _RowNode();
    // Data in the node
    ColNode * colNodes[19];
  } RowNode;

  // Defines the root of the decision tree
  typedef struct _RootNode {
    RowNode * rowNodes[19];
  } RootNode;


  // The list that stores all the positions
  list<Move> openPositions;

  // The root of the search tree
  RootNode decisionTree;

  // Helper functions
  bool findNode( int row, int col, RowNode ** rowNode, ColNode ** colNode );
  void deleteColNode( RowNode * node );
};

#endif
