/*****************************************************************************\
 * FILE: board.h
 *
 * PURPOSE: The state of the board.
 *
 * Created by Eric Akers, 23 Dec 2003
 *
 * ChangeLog:
 *     ELA - <Date> - Initial Working Version
 *
 *
 *
 *   
 *   Copyright (C) 2003 Eric Akers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\*****************************************************************************/



#ifndef BOARD_H
#define BOARD_H

// Header Files #############################################################
#include "AdjacentPosition.h"

// Macros ###################################################################


// Structures ###############################################################


// Global Variables #########################################################


// Class Definition #########################################################
class Board {
 public:
  // Definitions for the board
  static const int PLAYER_ONE = 1;
  static const int PLAYER_TWO = 2;
  static const int BLANK = 0;


  // Constructors
  Board();

  // Return the next state of the board with the given move. Sets the
  // winning state if it is.
  Board * getNextBoard( int row, int column, int player ) const;

  // Sets a move into the board. Allows any move set into the board,
  // so it can undo previous moves.
  void setPlayerMove( int row, int column, int player );

  // Return whether the board is in a game winning state or not
  bool isWinningState() const;

  // Returns the positions that are open and adjacent to other pieces
  inline const list<Move> getOpenAdjacentPositions() const {
    return openPositions.getPositions();  
  }

  // Returns the value of the position at row, col
  int getPlayerAt( int row, int column ) const;


 protected:
  // The values in the board
  unsigned char board[19][19];

  // Helper function
  void getDirectionDelta( int direction, int & row, int & col ) const;
  void setOpenAdjacentPositions( int row, int col );
  // Returns whether the location is a winner or not
  bool determineWinner( int row, int col );

  // Used to determine if a winner exists
  void Board::getNumAdjacentPieces( int row, int col, int direction, 
				    int & continuousLength, int & openSize,
				    int & fullLength ) const;



 private:

  // The decision tree to store adjacent positions
  AdjacentPosition openPositions;

  bool winner;
};


#endif
