/**************************************************\
FILE: eventHandler.h

PURPOSE: Header file for eventHandler.cpp

Created by Eric Akers, 24 Feb 2003

ChangeLog:
     ELA - 24 Feb 2003 - Initial Working Version



   Copyright (C) 2003 Eric Akers

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
 
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

\**************************************************/


#ifndef EVENTHANDLER_H
#define EVENTHANDLER_H

/* Header Files ############################################################## */
#include <SDL/SDL.h>

/* Macros #################################################################### */
#define MAX_EVENTS 5 // The max events to handle in one cycle
#define MAX_ZOOM_DISTANCE 400.0
#define MIN_ZOOM_DISTANCE 100.0
#define MAX_TRANSLATE_DISTANCE 50.0
#define TRANSLATE_CHANGE 5.0
#define ZOOM_CHANGE 5.0

/* Global Variables ########################################################## */

/* Structures/Objects/Types ################################################## */

/* Function Declarations ##################################################### */

/** Handles all the SDL events. */
void eventHandler();


/** Handles the mouse motion events.
 *  @param event The mouse motion event from SDL
 */
void handleMouseMotionEvent( SDL_Event & event );

  
/** Handles the mouse button up (or button release) events from SDL.
 *  @param event  The mouse event from SDL
 */
void handleMouseButtonUpEvent( SDL_Event & event );


/** Handles the mouse button down (or mouse button press) events from SDL.
 *  @param event The mouse button event
 */
void handleMouseButtonDownEvent( SDL_Event & event );


/** Handles the keyboard down (or button press) events.
 *  @param event The keyboard event from SDL
 */
void handleKeyDownEvent( SDL_Event & event );


/** Handles the keyboard up (or button release) events.
 *  @param event The keyboard event from SDL
 */
void handleKeyUpEvent( SDL_Event & event ) ;


/** Handles the quit requested events.
 *  @param event The keyboard event from SDL
 */
void handleQuitEvent( SDL_Event & event ) ;

#endif
