/*****************************************************************************\
 * FILE: guiButton.cpp
 *
 * PURPOSE: Implementation of the guiButton class
 *
 * Created by Eric Akers, 20 Dec 2003
 *
 * ChangeLog:
 *     ELA - <Date> - Initial Working Version
 *
 *
 *
 *   
 *   Copyright (C) 2003 Eric Akers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\*****************************************************************************/



// Header Files #############################################################
#include "guiButton.h"
#include "glfont2.h"

// Macros ###################################################################


// Structures ###############################################################


// Class Function Definitions ###############################################
guiButton::guiButton() : guiObject()
{
  labelScale = 1.0;
  isButtonActive = false;
}



guiButton::guiButton( GLdouble topLeftX, GLdouble topLeftY, GLdouble width, 
		      GLdouble height ) : guiObject()
{
  setPosition( topLeftX, topLeftY );
  setSize( width, height );
  labelScale = 1.0;
  isButtonActive = false;
}

guiButton::guiButton( GLdouble topLeftX, GLdouble topLeftY, GLFont * font,
		      string label, GLfloat textScale ) : guiObject()
{
  setPosition( topLeftX, topLeftY );
  setGLFont( font );
  setLabel( label );
  isButtonActive = false;

  // The width depends on the size of the text
  setSize( getLabelWidth() + 10, getLabelHeight() + 10 );
}



guiButton::~guiButton()
{}





void guiButton::draw()
{
  if( isWidgetVisible == false ) {
    // Do not draw
    return;
  }

  glEnable( GL_BLEND );
  // Draw the background rect first
  glColor4d( bgr, bgg, bgb, bga );
  glRectd( xPos, yPos, xPos + widgetWidth, yPos - widgetHeight );

  // Draw the border
  if( widgetBorder ) {
    glColor4d( fgr, fgg, fgb, fga );
    GLdouble leftX = xPos + 3;
    GLdouble topY = yPos - 3;
    GLdouble rightX = xPos + widgetWidth - 4; // Leave room for the line width
    GLdouble botY = yPos - widgetHeight + 3;

    glBegin( GL_LINE_STRIP );
    glVertex2d( leftX, topY );
    glVertex2d( leftX, botY );
    glVertex2d( rightX, botY );
    glVertex2d( rightX, topY );
    glVertex2d( leftX, topY );
    glEnd();
  }

  glEnable( GL_TEXTURE_2D );
  // If there exists a font, draw the label
  if( widgetFont != NULL ) {
    // Set the font to use in the draw function
    //    glTexEnvf( GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE );
    glColor4d( fgr, fgg, fgb, fga );
    widgetFont->Begin();

    widgetFont->DrawString( widgetLabel,// labelScale, 
		xPos + (widgetWidth/2) - (getLabelWidth()/2), 
		yPos - (widgetHeight/2) + (getLabelHeight()/2) );
  }
  glDisable( GL_TEXTURE_2D );
  glDisable( GL_BLEND );
}



bool guiButton::doMouseEvent( Uint8 button, Uint8 state, Uint16 x, Uint16 y )
{
  // Make sure the mouse click is within our boundary
  bool activeObject = guiObject::doMouseEvent( button, state, x, y );

  if( isButtonActive ) {
    // This button was previously clicked and this event should
    // return true no matter what. This should be SDL_RELEASED
    if( activeObject ) {
      // The actionPerformed needs to be called for the listener
      if( actionListener != NULL ) {
	actionListener->actionPerformed( GUI_EventMouseButton, this );
      }
      // The callback as well
      if( actionCallback != NULL ) {
	(*actionCallback)( GUI_EventMouseButton, this );
      }

      isButtonActive = false;
      return true;
    }
    else {
      // No longer active
      isButtonActive = false;
      return true;
    }
  }
  else if( activeObject ) {
    // We are waiting on a SDL_PRESSED event to activate the widget
    // Only use left mouse clicks
    if( button == SDL_BUTTON_LEFT ) {
      if( state == SDL_PRESSED ) {
	// The widget is activated by the left mouse click
	isButtonActive = true;
	return true;
      }
      else {
	// Do not handle releases without a click
	return false;
      }
    }
    else {
      return true;
    }
  }
  else {
    // make sure that we are not activated by a previous click
    isButtonActive = false;
    return false;
  }
}
