/*****************************************************************************\
 * FILE: guiComboBox.h
 *
 * PURPOSE: Defines a combo box widget
 *
 * Created by Eric Akers, 22 Dec 2003
 *
 * ChangeLog:
 *     ELA - <Date> - Initial Working Version
 *
 *
 *
 *   
 *   Copyright (C) 2003 Eric Akers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\*****************************************************************************/



#ifndef GUICOMBOBOX_H
#define GUICOMBOBOX_H

// Header Files #############################################################
#include <vector>

#include "guiObject.h"
#include "guiButton.h"
#include "guiMenuItem.h"
#include "guiDropDownMenu.h"

using namespace std;

// Macros ###################################################################


// Structures ###############################################################


// Global Variables #########################################################


// Class Definition #########################################################
class guiComboBox : public guiButton
{
 public:
  guiComboBox();
  guiComboBox( GLdouble topLeftX, GLdouble topLeftY, GLdouble width, 
	       GLdouble height );

  ~guiComboBox();

  // Add items to the combo box
  void addItem( guiMenuItem * item );

  // Setters
  virtual void setLabel( string label );
  virtual void setGLFont( GLFont * font );
  virtual void setFGColor( GLdouble r, GLdouble g, GLdouble b, 
			   GLdouble a = 1.0 );
  virtual void setBGColor( GLdouble r, GLdouble g, GLdouble b, 
			   GLdouble a = 1.0 );


  // Draw the box
  virtual void draw();

  // Handle mouse events
  virtual bool doMouseEvent( Uint8 button, Uint8 state, Uint16 x, Uint16 y );
  virtual void actionPerformed( int eventType, guiObject * eventObject );


 private:
  // The drop down menu
  guiDropDownMenu menu;

  // Flag that determines whether the drop down menu is drawn or not
  bool drawOptions;

  // Number of items in the box
  int numItems;
};


#endif
