/*****************************************************************************\
 * FILE: guiContainer.cpp
 *
 * PURPOSE: implementation of the guiContainer class
 *
 * Created by Eric Akers, 19 Dec 2003
 *
 * ChangeLog:
 *     ELA - <Date> - Initial Working Version
 *
 *
 *
 *   
 *   Copyright (C) 2003 Eric Akers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\*****************************************************************************/



// Header Files #############################################################
#include <GL/gl.h>
#include <GL/glu.h>

#include "guiContainer.h"
#include "guiObject.h"

// Macros ###################################################################


// Structures ###############################################################


// Class Function Definitions ###############################################


guiContainer::guiContainer( int winWidth, int winHeight )
{
  windowWidth = winWidth;
  windowHeight = winHeight;
}


guiContainer::~guiContainer()
{
  for( unsigned int i=0; i<widgets.size(); i++ ) {
    delete widgets[i];
  }
}


void guiContainer::addWidget( guiObject * widget )
{
  widgets.push_back( widget );
}
 


void guiContainer::display() const
{
  // Save some state before changing
  glPushAttrib( GL_ENABLE_BIT | GL_VIEWPORT_BIT | GL_TRANSFORM_BIT );

  // Disable what we don't want
  glDisable( GL_LIGHTING );
  glDisable( GL_FOG );
  glDisable( GL_TEXTURE_2D );
  glDisable( GL_DEPTH_TEST );

  // Setup the new viewport and draw the widgets so that they show
  // no matter the view
  glViewport( 0, 0, windowWidth, windowHeight );

  // Projection matrix
  glMatrixMode( GL_PROJECTION );
  glPushMatrix();
  glLoadIdentity();
  gluOrtho2D( 0, windowWidth, 0, windowHeight );

  // Modelview matrix
  glMatrixMode( GL_MODELVIEW );
  glPushMatrix();
  glLoadIdentity();

  // Draw the widgets now
  for( unsigned int i=0; i<widgets.size(); i++ ) {
    widgets[i]->draw();
  }

  // Restore the state for each matrix
  glMatrixMode( GL_PROJECTION );
  glPopMatrix();
  glMatrixMode( GL_MODELVIEW );
  glPopMatrix();
  glPopAttrib();
}
 


bool guiContainer::doMouseEvent( Uint8 button, Uint8 state, Uint16 x, Uint16 y )
{
  for( unsigned int i=0; i<widgets.size(); i++ ) {
    // The mouse pointer assumes 0,0 at top left, the viewport at bottom left
    if( widgets[i]->doMouseEvent( button, state, x, windowHeight - y ) ) {
      return true;
    }
  }
  return false;
}



bool guiContainer::doKeyboardEvent( Uint8 state, SDL_keysym keysym )
{
  for( unsigned int i=0; i<widgets.size(); i++ ) {
    if( widgets[i]->doKeyboardEvent( state, keysym ) ) {
      return true;
    }
  }
  return false;
}

