/*****************************************************************************\
 * FILE: guiContainer.h
 *
 * PURPOSE: Container that holds widgets
 *
 * Created by Eric Akers, 19 Dec 2003
 *
 * ChangeLog:
 *     ELA - <Date> - Initial Working Version
 *
 *
 *
 *   
 *   Copyright (C) <YEAR> Eric Akers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\*****************************************************************************/



#ifndef GUICONTAINER_H
#define GUICONTAINER_H

// Header Files #############################################################
#include <SDL/SDL.h>
#include <GL/gl.h>
#include <vector>

#include "guiObject.h"

using namespace std;

// Macros ###################################################################


// Structures ###############################################################


// Global Variables #########################################################


// Class Definition #########################################################
class guiContainer
{
 public:
  guiContainer( int winWidth, int winHeight );
  ~guiContainer();

  void addWidget( guiObject * widget );
  void display() const;
  bool doMouseEvent( Uint8 button, Uint8 state, Uint16 x, Uint16 y );
  bool doKeyboardEvent( Uint8 state, SDL_keysym keysym );

 protected:
  vector<guiObject*> widgets;
  int windowWidth, windowHeight;
};


#endif
