/*****************************************************************************\
 * FILE: guiDropDownMenu.cpp
 *
 * PURPOSE: Implementation of the drop down menu class
 *
 * Created by Eric Akers, 22 Dec 2003
 *
 * ChangeLog:
 *     ELA - <Date> - Initial Working Version
 *
 *
 *
 *   
 *   Copyright (C) 2003 Eric Akers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\*****************************************************************************/



// Header Files #############################################################
#include "guiDropDownMenu.h"

// Macros ###################################################################


// Structures ###############################################################


// Class Function Definitions ###############################################
guiDropDownMenu::guiDropDownMenu() : guiObject()
{}



guiDropDownMenu::guiDropDownMenu( GLdouble topLeftX, GLdouble topLeftY, 
				  GLdouble width, GLdouble height )
  :guiObject()
{
  setPosition( topLeftX, topLeftY );
  setSize( width, height );
}



guiDropDownMenu::~guiDropDownMenu()
{
  // Delete all the menu items
  for( unsigned int i=0; i<menuItems.size(); i++ ) {
    delete menuItems[i];
  }
}



// Add items to the combo box
void guiDropDownMenu::addItem( guiMenuItem * item )
{
  if( widgetFont != NULL ) {
    // For ease of creating menu items, add a font to the drop down menu
    item->setGLFont( widgetFont );
  }

  // Also set the color of the drop down menu
  item->setFGColor( fgr, fgg, fgb, fga );
  item->setBGColor( bgr, bgg, bgb, bga );

  menuItems.push_back( item );
}



void guiDropDownMenu::setLabel( string label )
{
  guiObject::setLabel( label );
  for( unsigned int i=0; i<menuItems.size(); i++ ) {
    menuItems[i]->setLabel( label );
  }
}


void guiDropDownMenu::setGLFont( GLFont * font )
{
  guiObject::setGLFont( font );
  for( unsigned int i=0; i<menuItems.size(); i++ ) {
    menuItems[i]->setGLFont( font );
  }
}




// Draw the box
void guiDropDownMenu::draw()
{
  // Determine the size of each
  int numItems = menuItems.size();
  GLdouble height = widgetHeight / numItems;
  GLdouble width = widgetWidth;

  // Draw each of the menu items in the list
  GLdouble yCoord = yPos;
  for( unsigned int i=0; i<menuItems.size(); i++ ) {
    // Set the size and location of each one
    menuItems[i]->setSize( width, height );
    menuItems[i]->setPosition( xPos, yCoord );
    menuItems[i]->draw();

    // Find the next y coord
    yCoord -= height;
  }

  // Draw the border
  if( widgetBorder ) {
    glColor4d( fgr, fgg, fgb, fga );
    GLdouble leftX = xPos + 3;
    GLdouble topY = yPos - 3;
    GLdouble rightX = xPos + widgetWidth - 3;
    GLdouble botY = yPos - widgetHeight + 3;

    glBegin( GL_LINE_STRIP );
    glVertex2d( leftX, topY );
    glVertex2d( leftX, botY );
    glVertex2d( rightX, botY );
    glVertex2d( rightX, topY );
    glVertex2d( leftX, topY );
    glEnd();
  }

}




// Handle mouse events
bool guiDropDownMenu::doMouseEvent( Uint8 button, Uint8 state, 
				    Uint16 x, Uint16 y )
{
  if( guiObject::doMouseEvent(button, state, x, y) == false ) {
    return false;
  }

  // Check each menu item
  for( unsigned int i=0; i<menuItems.size(); i++ ) {
    if( menuItems[i]->doMouseEvent(button, state, x, y) ) {
      return true;
    }
  }

  // The event has been handled regardless
  return true;
}


