/*****************************************************************************\
 * FILE: button.cpp
 *
 * PURPOSE: Draw simple buttons for a menu.
 *
 * Created by Eric Akers, 18 Dec 2003
 *
 * ChangeLog:
 *     ELA - <Date> - Initial Working Version
 *
 *
 *
 *
 *   Copyright (C) <YEAR> Eric Akers
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
\*****************************************************************************/




/* Header Files ############################################################# */
#include <GL/gl.h>
#include <GL/glu.h>

#include "connectFive.h"
#include "glfont2.h"
#include "guiContainer.h"
#include "guiButton.h"
#include "guiComboBox.h"
#include "guiMenuItem.h"
#include "eventHandler.h"

/* Macros ################################################################### */


/* Structures ############################################################### */


/* Global Variables ######################################################### */
// 
guiMenuItem * gameMenuItem;

/* Function Declarations #################################################### */


/* Function Declarations #################################################### */
void setupMenu( guiContainer * container )
{
  // Player One Combo Box
  printf( "PLayer 1\n" );
  guiComboBox * b1 = new guiComboBox( 50, 550, 200, 40 );
  b1->setGLFont( &font );
  b1->setLabel( "Player One" );
  b1->setFGColor( 0.0, 0.0, 0.0, 1.0 );
  b1->setBGColor( 1.0, 0.0, 0.0, 0.5 );
  b1->setIDNumber( MM_PLAYER_ONE );
  b1->addActionCallback( mainMenuCallback );
  // Create the options
  guiMenuItem * p1i1 = new guiMenuItem( "Human" );
  if( p1i1 == NULL ) {
    printf( "p1i1 null\n" );
    exit( -1 );
  }
  guiMenuItem * p1i2 = new guiMenuItem( "Computer" );
  if( p1i2 == NULL ) {
    printf( "p1i1 null\n" );
    exit( -1 );
  }
  // Add the options
  b1->addItem( p1i1 );
  b1->addItem( p1i2 );
  // Add the widget
  container->addWidget( b1 );

  // Player two combo box
  printf( "Player two\n" );
  guiComboBox * b2 = new guiComboBox( 50, 400, 200, 40 );
  b2->setGLFont( &font );
  b2->setLabel( "Player Two" );
  b2->setFGColor( 0.0, 0.0, 0.0, 1.0 );
  b2->setBGColor( 1.0, 0.0, 0.0, 0.5 );
  b2->setIDNumber( MM_PLAYER_TWO );
  b2->addActionCallback( mainMenuCallback );
  // Create the options
  guiMenuItem * p2i1 = new guiMenuItem( "Human" );
  guiMenuItem * p2i2 = new guiMenuItem( "Computer" );
  if( p2i1 == NULL ) {
    printf( "p1i1 null\n" );
    exit( -1 );
  }
  if( p2i2 == NULL ) {
    printf( "p1i1 null\n" );
    exit( -1 );
  }
  // Add the options
  b2->addItem( p2i1 );
  b2->addItem( p2i2 );
  // Add the widget
  container->addWidget( b2 );

  // Difficulty combo box
  guiComboBox * b3 = new guiComboBox( 300, 550, 200, 40 );
  b3->setGLFont( &font );
  b3->setLabel( "Difficulty" );
  b3->setFGColor( 0.0, 0.0, 0.0, 1.0 );
  b3->setBGColor( 1.0, 0.0, 0.0, 0.5 );
  b3->setIDNumber( MM_DIFFICULTY );
  b3->addActionCallback( mainMenuCallback );

  guiMenuItem * item1 = new guiMenuItem( "Novice" );
  b3->addItem( item1 );
  guiMenuItem * item2 = new guiMenuItem( "Amateur" );
  b3->addItem( item2 );
  guiMenuItem * item3 = new guiMenuItem( "Expert" );
  b3->addItem( item3 );
  guiMenuItem * item4 = new guiMenuItem( "Master" );
  b3->addItem( item4 );

  container->addWidget( b3 );

  // Quit button
  guiButton * b4 = new guiButton( 550, 550, 200, 40 );
  b4->setGLFont( &font );
  b4->setLabel( "Quit Game" );
  b4->setFGColor( 0.0, 0.0, 0.0, 1.0 );
  b4->setBGColor( 0.0, 0.0, 1.0, 0.5 );
  b4->setIDNumber( MM_QUIT_GAME );
  b4->addActionCallback( mainMenuCallback );
  container->addWidget( b4 );

  // Start Button
  printf( "Start Button\n" );
  guiButton * b5 = new guiButton( 550, 400, 200, 40 );
  b5->setGLFont( &font );
  b5->setLabel( "Start Game" );
  b5->setFGColor( 0.0, 0.0, 0.0, 1.0 );
  b5->setBGColor( 0.0, 0.0, 1.0, 0.5 );
  b5->setIDNumber( MM_START_GAME );
  b5->addActionCallback( mainMenuCallback );
  container->addWidget( b5 );
}


void setupGameMenu( guiContainer * container,
		    guiMenuItem * item1, guiMenuItem * item2 )
{
  // Status menu
  guiDropDownMenu * d1 = new guiDropDownMenu( 0, 600, 200, 75 );
  d1->setGLFont( &font );
  d1->setFGColor( 0.0, 0.0, 0.0, 1.0 );
  d1->setBGColor( 1.0, 0.0, 0.0, 0.5 );

  // Add the item to the status window
  d1->addItem( item1 );
  d1->addItem( item2 );

  container->addWidget( d1 );
}

/* Static Function Definitions ############################################## */


/* Static Function Definitions ############################################## */
