.\" $Id: conserver.cf.man,v 7.5 1999/08/16 03:00:45 ksb Exp $
.\" @(#)constab.5 01/06/91 OSU CIS; Thomas A. Fine
.TH CONSERVER.CF 5L "15 February 1991" "OSU/CIS"
.SH NAME
conserver.cf \- table of server console terminals used by conserver(8L)
.SH SYNOPSIS
.B /usr/local/lib/conserver.cf
.sp
.br
\fIserver\fP:\fIpassword\fP:\fIdevice\fP:\fIbaud\fP:\fIlogfile\fP:\fIgroup\fP
.br
\fIserver\fP:\fIpassword\fP:\fIdevice\fP:\fIbaud\fP:\fIlogfile\fP:\fIgroup\fP:\fItag\fP:\fIcontroller\fP
.br
\fB%%\fP
.br
\fIaccess hosts\fP
.SH DESCRIPTION
.B Conserver.cf
is the configuration file for
.IR conserver (8L).
All lines starting with the pound sign `#' are considered comment lines.
Blank lines are ignored.
.PP
The format of the console entries in this file has changed from version
6 to version 7 to allow
.IR passwd (8)
to manage encrypted passwords in the file.
To that end the encrypted password is now in column two (as in the
traditional system password and group files).
.PP
The first section of the file has lines that are separated into
six colon-separated fields:
.PP
\fIServer\fP name \- this doesn't have to be the name of the server;
it is used to refer to the server when using the console program.
.PP
\fIPassword\fP encrypted password \- allows access to any member console in
this group.  That is to say only one console in any group should set a
password.  If none sets a password the super user password is taken.
If \fIPassword\fP is of the form \fB##\fP\fIuser\fP, look up \fIuser\fP
in the system password file(s) and use the entry's password.
.PP
\fIDevice\fP file name \- the full path name of the device for this server.
This may contain a remote host name as \fItty\fP@\fIhost\fP in which case
the conserver will send connections for this server to \fIhost\fP.
This may be a shell command prefixed with a pipe (|), or a network
terminal server name prefixed with an exclaimation mark (!).
In the case of a shell command a pseudo-tty is installed with the
command running with the slave side controling the process.
.PP
\fIBaud\fP is the speed and parity for this console.
Speed may be given as an integer,
followed by the letter "h" for hardware flow or "x" for XON/XOFF flow
(default 'h'), then a parity.
A parity only requires the first letter of any of:
even, odd, mark, space, pass8.
On some systems an additional speed of "a" ("b") is available for
the EXTA (ETXB) setting.
The default speed is 9600, hardware flow, even parity.
If the \fIdevice\fP is a terminal server then this field is a port number
on that device.
.PP
\fILog\fP file name \- the full path name of file where all output from
this server is logged.
.PP
\fIGroup\fP number \- defines which group of servers this server is with.  There
will be one process running for each group of servers in this file.
If this field is empty the conserver program will fill groups automatically.
The special \fIgroup\fP plus (+) increments the present group number by one.
.PP
\fITag\fP \- the name of the power controller line for this console.
This token prefixes all command to the power controller, which must look
like a BlackBox Pow-R-Switch 8c.
.PP
\fIController\fP \- the name of the console line which connects to the
serial line power controller for this console.
The console client uses the power controller and tag to locate a console
to do power management against.
.PP
This section is terminated with a `%%' token on a line by itself.
.PP
The next section of the file contains a list of hosts and addresses
which are allowed to connect to the console server.
Three levels of access all allowed, ``trust'', ``allow'',
and ``refuse''.
The access modifier is followed by a colon and a list of addresses or
host names.
Any complete suffix of a host name my be used to allow access for all hosts
in that subdomain.
For example `cc.purdue.edu' will allow `mentor.cc.purdue.edu'
and `mace.cc.purdue.edu', but not `pucc.purdue.edu' or `hack.purdue.edu'.
.SH LIMITS
.PP
Groups should be numbered from 0, all members of a group should be contiguous
in the file.
The current hard limits are available from `conserver -V'.
.SH EXAMPLE
# server:[passwd]:/dev/file:baud:/usr/adm/logfile:group_num
.br
tree::/dev/ttyj0:9600e:/tmp/treelog:0
.br
fish::/dev/ttyj1:4800e:/tmp/fishlog:1
.br
bird::/dev/ttyj2:4800m:/tmp/birdlog:1
.br
solar::/dev/ttyj3:9600e:/tmp/solarlog:2
.br
stellar::/dev/ttyj4:9600e:/tmp/stellarlog:
.br
shell:s7UZ3Dd6HX9mA:/dev/ttyj5:1200e:/tmp/shelllog:3
.br
tribe::/dev/ttyj6:1200e:/tmp/tribelog:4
.br
reptile::/dev/ttyj7:57600xe:/tmp/reptilelog:
.br
flower::/dev/ttyj8:1200e:/tmp/flowerlog:
.br
mentor::/dev/ttyh0@extra.cc.purdue.edu:2400e:/tmp/mentor.log:
%%
.br
# access restrictions
.br
trusted: console.cc.purdue.edu 128.210.7.90
.br
allow: cc.purdue.edu stat.cc.purdue.edu
.sp
Notice that the console `shell' has a special password, all the others
use the superuser's password.

.SH "SEE ALSO"
console(1L), conserver(8L), autologin(8L), passwd(8), passwd(1)
