/*
 * cowbell
 * Copyright (c) 2005 Brad Taylor
 *
 * This file is part of cowbell.
 *
 * cowbell is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * cowbell is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with cowbell; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using Gtk;
using Glade;

namespace Cowbell.Gui
{
	public class GladeDialog
	{
		/* public methods */
		public GladeDialog (string resource)
		{
			xml = new Glade.XML (null, resource, "dialog", null);
			xml.BindFields (this);
			
			if (icon == null) {
				icon = new Gdk.Pixbuf (null, "cowbell.png");
			}

			dialog = ((Dialog)xml["dialog"]);
		}

		public int Run ()
		{
			return dialog.Run ();
		}

		public void Hide ()
		{
			dialog.Hide ();
		}

		/* protected properties */
		protected Glade.XML xml;
		protected Dialog dialog;

		/* private properties */
		private static Gdk.Pixbuf icon;

		/* private methods */
		static GladeDialog ()
		{
			Glade.XML.CustomHandler = new Glade.XMLCustomWidgetHandler (CustomWidgetHandler);
		}

		private static Gtk.Widget CustomWidgetHandler (Glade.XML x, string func_name,
		                                               string name, string string1,
		                                               string string2, int int1,
		                                               int int2)
		{
			switch (func_name) {
			case "AlbumCoverImage":
				return new AlbumCoverImage ();
			case "SongDatabaseTreeView":
				return new SongDatabaseTreeView ();
			default:
				return null;
			}
		}
	}
}
