#define VERSION "1.4-1"

#define IVAL_HOUR 1
#define IVAL_MIN  2

#define SERVERTYPE_SHOUTCAST 0
#define SERVERTYPE_ICECAST   1

/* Icy headers */
typedef struct icyHeaders
{
  char *name;
  char *genre;
  char *notice1;
  char *notice2;
  char *content_type;
  char *url;
  /* type: 
   * 0 Shoutcast 
   * 1 Icecast 
   */
  int type; 
  int br;
  int metaint;
  int pub;
} icyHeaders;

/* Currently played song */
typedef struct currentSong
{
  char *title;
  char *artist;
} currentSong;

/* Command line arguments are stored here */
typedef struct commandLine
{
  char *dir;
  char *logFile;
  char *pidFile;
  char *Next;
  int pige;
  int quite;
  int live;
  int background;
  int usePigeMeta;
  int intervalType;
  int useNumbers;
  int weekBackup;
  int interval;
  int skipSongs;
} commandLine;
  
typedef struct stats
{
  unsigned long songs;
  unsigned long reconnections;
} stats;

typedef struct cPigeUptime
{
  unsigned int day;
  unsigned int hour;
  unsigned int min;
  unsigned int sec;
} cPigeUptime;

typedef struct lastCut
{
  int hour;
  int min;
} lastCut;

/* explicit ? */
void print_credits ();
int server_socket = -1;

/* TCP connection to the server */
int server_connect (char *servername, int serverport);

/* Disconnect */
int server_close (int serversocket);

/* fetch metadata from mp3 stream */
char *getHeaders(int serversocket);

/* fetch song title from metadata */
char *getTitle(char *titleString);

/* parse metadata */
char *readMeta(int serversocket);

/* return a string pointer to print informations about current stream,
 * like title, bytes received, ... 
 */
char *statusLine(long long unsigned int uptime, long long unsigned int metacounter, int metaint, char *titre, char *nexttitre);

/* return a pointer to 128bytes of id3 tags */
char *GetId3v1(char *titre, char *artiste, char *radioName);

/* fetch icy data from stream */
icyHeaders *readicyheaders(char *headers);

/* store informations about title currently played (for id3v1) */
currentSong *getCurrentSong(char *titre);

/* print icy informations */
void print_icyheaders(icyHeaders *_icy_headers );

/* Free icy struct */
void free_icy_headers(icyHeaders *icy);

/* send http headers to connect to remote stream */
int sendHeaders(int serversocket, char *mountpoint, int metadata);

/* connect / reconnect to a stream */
int reconnect(int time, int _nb_tentatives, int _get_headers);

/* Parse command line arguments */
commandLine *parseCommandLine(int argc, char **argv);
void testCommandLine();

/* print help ... */
void print_help();

/* get Return code from HTTP server */
int getHTTPCode(char *buffer);

/* getUptime */
cPigeUptime *getUptime(long long unsigned int uptime);
char *getStats(long long unsigned int uptime, long long unsigned int metacounter, int metaint);

/* Intervals */
int checkInterval();
int mustCut(lastCut *cut);
int getCloserInterval(int now, int interval);
void checkWeekBackup();

#ifndef WIN32
int getSongs(char *dir);
#endif

#define IS_PRINTABLE(c) (((c >= 'a') && (c <= 'z')) || ((c >= 'A') && (c <= 'Z')) || ((c >= '0') && (c <= '9')) || (c == '-') || (c == ' ') || (c == '@'))
