// This may look like C code, but it is really -*- C++ -*-
/*
 ************************************************************************
 *
 *				Logging Service
 *
 * The Logger class below is intended to be as light-weight as possible,
 * so one can use it like
 *	Logger() << "Log this message" << "... and this too!" << endl;
 * Note that 'endl' at the end is not necessary: Logger's destructor
 * would take care of it (provided anything was logged at all).
 *
 * $Id: Logger.h,v 1.3 1999/12/26 23:13:28 oleg Exp oleg $
 *
 ************************************************************************
 */

#ifndef __GNUC__
#pragma once
#endif

#ifndef _Logger_h
#define _Logger_h

#if defined(__GNUC__) || defined(B_BEOS_VERSION)
#pragma interface
			// libstdc++ 2.8.1 lacks this class
class ostream_withassign : public ostream {
public:
  ostream_withassign(streambuf* sb) :
      ostream(sb) {}
  ostream_withassign& operator=(ostream& rhs)
    {  if (&rhs != (ostream*)this) init (rhs.rdbuf ()); return *this; }
  ostream_withassign& operator=(ostream_withassign& rhs)
    { operator= (static_cast<ostream&> (rhs)); return *this; }
  ostream_withassign& operator=(streambuf* sb)
    { init(sb); return *this; }
};
#endif

#include <iostream.h>

class Logger
{
  static ostream_withassign log_stream;	// where to log
  
				// These are deliberately private and
				// unimplemented to discourage
				// copy-constructing
  void operator = (const Logger&);
  Logger(const Logger&);

  bool was_something_logged;

public:
  Logger(void) : was_something_logged(false) {}
  ~Logger(void) { if(was_something_logged) log_stream << endl; }
  
  				// Set the log to append to a specified file
  static void set_log(const char log_file_name []);

				// Log a message (possibly followed by
				// arguments, in a manner similar to
				// printf())
				// This functionality isn't implemented
				// as I don't know how to safely vfprintf()
				// to a ostream (which may not be a fstream!)
  //static void log(const char * message,...);

  inline ostream& to_ostream(void)   { was_something_logged=true; return log_stream; }
  inline operator ostream& (void)   { return to_ostream(); }
  inline ostream& operator << (const char str []) { return to_ostream() << str; }
  inline ostream& operator << (const char c) { return to_ostream() << c; }
};


#endif
