// This may look like C code, but it is really -*- C++ -*-
/*
 ************************************************************************
 *
 *		       Adaptive Arithmetic Coding
 *	      	   Adaptive model for the source of data
 *
 * This is an extension over the basic Input_Data_Model which makes
 * an adaptive model for the input data.
 *
 * The present model is adjusted to coding node values of the Laplacian 
 * pyramid decomposition of gray-scale still images. Distribution of
 * the values is found (see laplpyr_hist.lst) to be almost ideally
 * modelled by the Lorentzian distribution with the very strong peak at
 * 0. This apriori information is coded into the frequency tables. As
 * symbol are processed, the frequency tables are updated (in the
 * way it is described in the book "Text Compression" referred to
 * elsewhere) to finely tune in the distribution.
 *
 * The program assumes the total no. of distinct input symbols
 * (integers) is relatively small, so simple linear arrays can be used
 * for storing and looking up the frequency tables. 
 *
 * $Id: arithm_modadapt.h,v 2.3 2000/11/15 03:06:49 oleg Exp oleg $
 *
 ************************************************************************
 */

#ifndef __GNUC__
#pragma once
#endif
#ifndef _arithm_modadapt_h
#define _arithm_modadapt_h 1

#ifdef __GNUC__
#pragma interface
#endif

#include "arithm.h"

class AdaptiveModel : public Input_Data_Model
{
  const Symbol symbol_lwb;	// Region the input symbol is expected in
  const Symbol symbol_upb;
  const int    no_symbols;	// No. of distinct symbols

  Index  * symbol_to_index;	// Symbol-to-index conversion
  Symbol * index_to_symbol;	// Conversion from symbol index to symbol value

  void initialize_model();
  
  AdaptiveModel(const AdaptiveModel&);		// Private and unimplemented:
  void operator = (const AdaptiveModel&);	// cloning is not allowed

public:
					// Construct a model for symbols
					// in [lwb,upb]
  AdaptiveModel(const Symbol lwb, const Symbol upb);
  ~AdaptiveModel(void);

					// Model is adaptive, there is
					// no need to write/read parameters
					// to/from the file
  void open(BitIn& ) 			{}
  void open(BitOut& ) 			{}

					// Update the adaptive model
  void update_model(const Index index);	 

					// Do nothing at present
  void scale_down_past(void)			{}

					// Return the index of a symbol
  Index  get_index(const Symbol symbol) const;
					// and the symbol for an index
  Symbol get_symbol(const Index index) const;
};

#endif
