// This may look like C code, but it is really -*- C++ -*-
//			Verify the arithmetic coding

#include "arithm_modadh.h"
#include "arithm_modadapt.h"

#if defined(unix) || defined(macintosh)
#define TMP_FILE_NAME "/tmp/aa"
#else
#define TMP_FILE_NAME "varithm.tmp"
#endif

static int * MyPattern;
static int MyPattern_size;

static void make_pattern()
{
  const int some_pattern [] = {1, 0, 3, 4, 0, 4, 0, 4, 0, 4, 0, 4, 0};
  MyPattern_size = sizeof(some_pattern) / sizeof(some_pattern[0]) + 1000;
  MyPattern = new int[MyPattern_size];

  register int i;
  for(i=0; i < (signed)(sizeof(some_pattern) / sizeof(some_pattern[0])); i++)
    MyPattern[i] = some_pattern[i];
  for(; i<MyPattern_size; i++)
    MyPattern[i] = i & 1;
}

				// Test the arithmetic coding with an Adaptive
				// Histogram model
static void test_adh(void)
{
  message("\nCreating Histogram ...\n");
  Histogram histogram(-7,7);
  register int i;
  for(i=0; i<MyPattern_size; i++)
    histogram.put(MyPattern[i]);

  message("\nWriting data ...");
  AdaptiveHistModel model(histogram);
  ArithmCodingOut ac(model);
  ac.open(TMP_FILE_NAME);
  for(i=0; i<MyPattern_size; i++)
    ac.put(MyPattern[i]);
  ac.close();

  message("\nCoded file " TMP_FILE_NAME " has been created\n");

  AdaptiveHistModel i_model;
  ArithmCodingIn ac1(i_model);
  ac1.open(TMP_FILE_NAME);
  for(i=0; i<MyPattern_size; i++)
  {
    register int val_read = ac1.get();
    if( i < 5 )
      message("\nValue read %d",val_read);
    if( val_read != MyPattern[i] )
      _error("Read value %d of the %d-th integer is not what it is "
	     "supposed to be, %d",
	     val_read, i, MyPattern[i]);
  }
  ac1.get();
  assert( ac1.is_eof() );
}

				// Test the arithmetic coding with an Adaptive
				// model
static void test_adaptive(void)
{
  register int i;
  const short magic_short = 15745;

  message("\n\nTesting the arithmetic coding with an AdaptiveModel\n");

  {
    message("\nWriting data ...");
    EndianOut o_stream(TMP_FILE_NAME);
    o_stream.write_short(magic_short);

    AdaptiveModel model(-3,4);
    ArithmCodingOut ac(model);
    ac.open(o_stream);
    ac.set_bigendian();
    for(i=0; i<MyPattern_size; i++)
      ac.put(MyPattern[i]);
    //	ac.close(); 			inferred upon destruction
    //	o_stream.close();
  }
  
  message("\nCoded file " TMP_FILE_NAME " has been created\n");

  EndianIn i_stream(TMP_FILE_NAME);
  assert( i_stream.read_short("Reading a magic number") == magic_short );

  AdaptiveModel i_model(-3,4);
  ArithmCodingIn ac1(i_model);
  ac1.open(i_stream);
  ac1.set_bigendian();
  for(i=0; i<MyPattern_size; i++)
  {
    register int val_read = ac1.get();
    if( i < 5 )
      message("\nValue read %d",val_read);
    if( val_read != MyPattern[i] )
      _error("Read value %d of the %d-th integer is not what it is "
	     "supposed to be, %d",
	     val_read, i, MyPattern[i]);
  }
}

				// Another test the arithmetic coding with
				// an Adaptive model
static void test_adaptive1(void)
{
  register unsigned int i;
  const int pattern [] = {0,0,0,0,1,0};

  message("\n\nTesting the arithmetic coding with an AdaptiveModel\n");

  message("\nWriting data ...");

  AdaptiveModel model(-1,4);
  ArithmCodingOut ac(model);
  ac.open(TMP_FILE_NAME);
  ac.set_littlendian();
  for(i=0; i<sizeof(pattern)/sizeof(pattern[0]); i++)
    ac.put(pattern[i]);
  ac.close();

  message("\nCoded file " TMP_FILE_NAME " has been created\n");

  EndianIn i_stream(TMP_FILE_NAME);
  AdaptiveModel i_model(-1,4);
  ArithmCodingIn ac1(i_model);
  ac1.open(i_stream);
  ac1.set_littlendian();
  for(i=0; i<sizeof(pattern)/sizeof(pattern[0]); i++)
  {
    register int val_read = ac1.get();
    if( i < 5 )
      message("\nValue read %d",val_read);
    if( val_read != pattern[i] )
      _error("Read value %d of the %d-th integer is not what it is "
	     "supposed to be, %d",
	     val_read, i, pattern[i]);
  }
  ac1.get();
  assert( ac1.is_eof() );
}

				// Test two encoded streams, one after another
static void test_two_streams(void)
{
  register unsigned int i;
  const int pattern1 [] = {0,0,0,0,0,0,1,0,4,4};
  const int pattern2 [] = {1,0,0,1,0,1};

  message("\n\nTesting the concatenating of two streams\n");

  message("\nWriting data ...");

  EndianOut stream(TMP_FILE_NAME);
  stream.set_littlendian();
  const int ethalon = 12345;

  {
    AdaptiveModel model(-1,4);
    ArithmCodingOut ac(model);
    ac.open(stream);
    for(i=0; i<sizeof(pattern1)/sizeof(pattern1[0]); i++)
      ac.put(pattern1[i]);
  }

  {
#if !defined(macintosh)
    message("\nPosition 0%o\n",stream.tellp());
#endif
    stream.write_long(ethalon);
    AdaptiveModel model(-1,4);
    ArithmCodingOut ac(model);
    ac.open(stream);
    for(i=0; i<sizeof(pattern2)/sizeof(pattern2[0]); i++)
      ac.put(pattern2[i]);
  }

  stream.close();

  message("\nCoded file " TMP_FILE_NAME " has been created\n");

  EndianIn i_stream(TMP_FILE_NAME);
  i_stream.set_littlendian();

  {
    AdaptiveModel i_model(-1,4);
    ArithmCodingIn ac1(i_model);
    ac1.open(i_stream);
    for(i=0; i<sizeof(pattern1)/sizeof(pattern1[0]); i++)
    {
      register int val_read = ac1.get();
      if( i < 5 )
	message("\nValue read %d",val_read);
      if( val_read != pattern1[i] )
	_error("Read value %d of the %d-th integer is not what it is "
	       "supposed to be, %d",
	       val_read, i, pattern1[i]);
    }
    ac1.get();
    assert( ac1.is_eof() );
  }

  {
    message("\nPosition 0%o\n",i_stream.tellg());
    assert( i_stream.read_long("Reading Ethalon") == ethalon );
    AdaptiveModel i_model(-1,4);
    ArithmCodingIn ac1(i_model);
    ac1.open(i_stream);
    for(i=0; i<sizeof(pattern2)/sizeof(pattern2[0]); i++)
    {
      register int val_read = ac1.get();
      if( i < 5 )
	message("\nValue read %d",val_read);
      if( val_read != pattern2[i] )
	_error("Read value %d of the %d-th integer is not what it is "
	       "supposed to be, %d",
	       val_read, i, pattern2[i]);
    }
  }
  message("\nDone\n");
}

int main(void)
{
  make_pattern();
  test_adh();
  test_adaptive();
  test_adaptive1();
  test_two_streams();
  return 0;
}
