// This may look like C code, but it is really -*- C++ -*-
//			Validate myenv
//
// $Id: vmyenv.cc,v 2.3 1999/12/26 23:53:15 oleg Exp oleg $

#include "myenv.h"
#include <stdlib.h>
#include <string.h>
#include <fstream.h>
#include "Logger.h"


        // Make sure that evaluation of 'STMT' aborts,
        // (as it was supposed to)
#if !defined(unix) && !defined(B_BEOS_VERSION)
#define must_have_failed(STMT) \
  cout << "can't check failure of " #STMT " on non-UNIX platforms" << endl
#else
#include <unistd.h>
#include <sys/wait.h>
#define must_have_failed(STMT) 				\
 if( const pid_t child_pid = fork() )			\
 {							\
   assert( child_pid != (pid_t)(-1) );			\
   int stat_loc;					\
   assert( waitpid( child_pid,&stat_loc,0 ) >= 0 );	\
   assure( stat_loc != 0, #STMT " didn't crash as expected" ); /* the child has really crashed */	\
   cerr << "The error above was expected, and caught" << endl;	\
 }							\
 else { /*in the child process*/ (void) STMT; exit(0); }
#endif

				// Validate does_start_with_ci()
static void test_does_start_with(void)
{
  cout << "\nValidating does_start_with_ci..." << endl;

  assert( does_start_with_ci("abcdef ","abc") );
  assert( does_start_with_ci(" abcdef "," abc") );
  assert( does_start_with_ci("abc","abc") );
  assert( does_start_with_ci("aBc","AbC") );
  assert( does_start_with_ci("aBc\n","AbC") );
  assert( !does_start_with_ci("aBe\n","AbC") );
  assert( !does_start_with_ci("acc","abc") );
  assert( !does_start_with_ci("","abc") );
  assert( does_start_with_ci("abc","") );
  assert( !does_start_with_ci("ab","abc") );
  assert( does_start_with_ci("a123456789.,a","A123456789.,") );
  assert( does_start_with_ci("a1234bB?\\def","A1234Bb?\\") );
  assert( does_start_with_ci("\rZ!@~#$Ll*()def","\rz!@~#$lL*()") );
  assert( !does_start_with_ci("a1234bB.\\def","A1234Bb?\\") );

  cout << "\nDone" << endl;
}


#ifdef macintosh
				// Validate xgetenv()
static void test_xgetenv(void)
{
  cout << "\nCan't use getenv on a Mac at present..." << endl;
}
#else
				// Validate xgetenv()
static void test_xgetenv(void)
{
  cout << "\nValidating xgetenv..." << endl;
  
  			// something that probably doesn't exist by default
  const char not_existing_env_name [] = "___XXXY"; 
  			// something that probably _does_ exist by default
#if defined(WIN32)
  const char pre_existing_env_name [] = "PATH"; 
#else
  const char pre_existing_env_name [] = "HOME"; 
#endif

  assert(
  	strcmp(xgetenv(not_existing_env_name,"---NOT FOUND---"),
  	       "---NOT FOUND---") == 0 );
  assert( xgetenv(not_existing_env_name,"")[0] == '\0' );

  must_have_failed(xgetenv(not_existing_env_name,0));
  
  char buffer[100];
  const char newly_bound_value [] = "___NEWLY_BOUND___";
  assert( putenv(
  	(sprintf(buffer,"%s=%s",not_existing_env_name,newly_bound_value),
  	buffer)) == 0 );
  	
  assert(
  	strcmp(xgetenv(not_existing_env_name,"---NOT FOUND---"),
  	       newly_bound_value) == 0 );
  	       
  assert(
  	strcmp(xgetenv(not_existing_env_name,""),
  	       newly_bound_value) == 0 );
  	       
  assert(
  	strcmp(xgetenv(not_existing_env_name,0),
  	       newly_bound_value) == 0 );
  	    
  assert( xgetenv(pre_existing_env_name,0) );

  cout << "\nDone" << endl;
}
#endif

				// Validate get_file_size()
static void test_get_file_size(void)
{
  cout << "\nValidating get_file_size..." << endl;

  const char * file_name = tmpnam(0);
  
  remove(file_name);		// make sure this file does not exist
  
  cout << "\tchecking status of _non_-existing file " << file_name << endl;
  
  must_have_failed(get_file_size(file_name));

  struct GFS_big_default : public GFS_Default
  {
    enum { def_size = (size_t)(-2) };
    size_t operator () (const char * file_name)
     { cerr << "GFS_big_default entered for " <<  file_name << endl;
       return def_size;
     }
    GFS_big_default& myself(void) { return *this; }
  };
  

  assert( get_file_size(file_name,GFS_big_default().myself()) ==
  		GFS_big_default::def_size);
  		
  cout << "\tcreating " << file_name << " of zero size " << endl;
  assert( ofstream(file_name).good() );
  cout << "\t\tThe file size was found to be " << get_file_size(file_name) << endl;
  assert( get_file_size(file_name,GFS_big_default().myself()) == 0 );
  assert( get_file_size(file_name) == 0 );

  const char sample_string [] = "12345";
  
  cout << "\twriting " << sample_string << " into " 
       << file_name << endl;
   
  assert( (ofstream(file_name) << sample_string).good() );
  cout << "\t\tThe file size was found to be " << get_file_size(file_name) << endl;
  assert( get_file_size(file_name,GFS_big_default().myself())
	  == strlen(sample_string) );
  assert( get_file_size(file_name) == strlen(sample_string) );

  cout << "\nDone" << endl;
}

static void test_logging(void)
{
  Logger logger;
  logger << "This message is sent through the logger ...";
  Logger();
  logger << "... should continue without " << "newline: " << "0x"
         << hex << (int)'\n' << '\n';
  logger << "This line however.... ";
  Logger() << "will be broken " << "...";
  logger << "this should appear on the next line" << endl;
  
  const char * const new_log_name = tmpnam(0);
  logger << "swithing the log to another file: " << new_log_name << endl;
  Logger::set_log(new_log_name);
  Logger() << "This record should appear in the new log";
  logger << "and so does this" << endl;
  cerr << "Done\n" << endl;
}

/*
 *------------------------------------------------------------------------
 *			Root module
 */

int main(void)
{
  cout << "\n\n\t\tVerify that myenv does function indeed\n" << endl;

  test_does_start_with();
  test_xgetenv();
  test_get_file_size();

  test_logging();
  
  cout << "\nAll tests passed" << endl;
  return 0;
}
