/*
 ************************************************************************
 *
 * This is a glue code that "renames" our sys_open() into open(),
 * so that our sys_open() takes place of (intercedes) 
 * the ordinary open(2) system call.
 * This code also implements fopen() in terms of our sys_open().
 *
 * $Id: sys_open_glue.c,v 2.0 1999/12/30 00:12:55 oleg Exp oleg $
 *
 ************************************************************************
 */ 

#include <sys/types.h>
#include <sys/stat.h>
#include <sys/file.h>
#include <sys/fcntl.h>
#include <errno.h>
#include <stdio.h>
#include <string.h>

extern int sys_open(const char *filename, const int mode, const int mask);
int open();	/* Suppress errors as open(2) is declared with varargs...
		   on GNU/Linux and FreeBSD... */

#if defined(__FreeBSD__)
/* Redirecting a wrapped open() in sys_open() to _open() which
   actually traps into the kernel. See the freebsd3.2 section of
   the Makefile, in particular the open_ext.o rule */
int __wrap_open(const char *filename, const int mode, const int mask)
{ return _open(filename, mode, mask); }
#endif

int open(const char *filename, const int mode, const int mask)
{
#if !defined(DEBUG)
  return sys_open(filename,mode,mask);
#else
  int result;
  printf("\nOpening '%s'...",filename);
  result = sys_open(filename,mode,mask);
  printf("\nresult... %d",result);
  if(result < 0 )
   perror("opening error");
  return result;
#endif
}


FILE *fopen(const char *filename, const char *mode)
{
  static struct ModeString { const char * str; const int bin_value; }
  mode_strings [] =
  { {"r+", O_RDWR}, {"rb+", O_RDWR}, {"w+", O_RDWR|O_CREAT|O_TRUNC},
    {"wb+", O_RDWR|O_CREAT|O_TRUNC},
    {"a+", O_RDWR|O_CREAT|O_APPEND},
    {"ab+", O_RDWR|O_CREAT|O_APPEND},
    {"r", O_RDONLY}, {"w", O_WRONLY|O_CREAT|O_TRUNC},
    {"a", O_WRONLY|O_CREAT|O_APPEND}
  };
  register struct ModeString * p;
  int fd = -1;
  errno = EINVAL;
  for(p=mode_strings; p< mode_strings + sizeof(mode_strings)/sizeof(mode_strings[0]);
      p++)
    if( strncmp(mode,p->str,strlen(p->str)) == 0 )
      {
        fd = sys_open(filename,p->bin_value,0777);
	break;
      }
  if( fd < 0 )
    return (FILE*)0;
  return fdopen(fd,mode);
}
