// This may look like C code, but it is really -*- C++ -*-
//		Verification of histogram operations

#include "histogram.h"
#include "myenv.h"
#include <iostream.h>


				// Test getting and putting symbols
static void test_getput(const int lwb, const int upb)
{
  cout << "\nTesting putting and getting symbols from [" << lwb << "," << upb
       << "]" << endl;
  Histogram histogram(lwb,upb);
  register int i;
  for(i=lwb; i<=upb; i++)
    histogram.put(i);
  for(i=lwb-1; i<=upb+1; i++)
    histogram.put_coerce(i);
  assert( histogram.get(histogram.symbol_lwb) == 3 ); // because of coercion
  assert( histogram.get(histogram.symbol_upb) == 3 ); // because of coercion
  for(i=lwb+1; i<=upb-1; i++)
    assert( histogram.get(i) == 2 );
  
  cout << "\nDone\n";
}

				// Test computing 0th order entropy of the
				// distribution
static void test_entropy(const int no_bits_expected, const int lwb)
{
  const int no_symbols = 1<<no_bits_expected;
  const int symbol_count = 10;
  cout << "\nCheck to see that the uniform distribution of " << no_symbols
       << " symbols\ntakes exactly " << no_bits_expected  
       << " bits per symbol to represent" << endl;
  Histogram histogram(lwb,2*no_symbols+lwb);
  for(register int i=0; i<symbol_count; i++)
     for(register int j=0; j<no_symbols; j++)
        histogram.put(2*j+lwb);
  assert( histogram.no_distinct_symbols() == no_symbols );
  cout << "\testimated entropy " << histogram.estimate_entropy() << endl;
  assert( (int)(histogram.estimate_entropy() + 0.001) == no_bits_expected );

  if( histogram.no_distinct_symbols() <= 20 )
    histogram.print("sample histogram");

  cout << "\nDone\n";
}


				// Testing routing function
int main(void)
{
  test_getput(1,2);
  test_getput(-1000,4000);
  test_entropy(4,100);
  test_entropy(14,-401);
  return 0;
}
