#!/bin/sh
# we assume this runs at the top of a Cream file structure

echo

# set $VIMRUNTIME (no trailing slash)
# 1. by Luc St-Louis
#vim --cmd 'echo $VIMRUNTIME' --cmd 'quit' 2> /tmp/creamVIMRUNTIME
#VIMRUNTIME=`perl -pe 's/\r\n//g' /tmp/creamVIMRUNTIME`
#rm -f /tmp/creamVIMRUNTIME

# 2. by Jacob Lerner
VIMRUNTIME=`vim -e -T dumb --cmd 'exe "set t_cm=\<C-M>"|echo $VIMRUNTIME|quit' | tr -d '\015' `

echo "\$VIMRUNTIME found:"
echo "  $VIMRUNTIME"
echo
echo "Installing to:"
echo "  $VIMRUNTIME/cream"
echo

# quit if not found
if [ "$VIMRUNTIME" == "" ] ; then
	echo "\"$VIMRUNTIME\" not found. Unable to continue."
	echo "Finished."
	exit 1
fi


# find where we're located so we can copy from here
HERE=`dirname $0`

# directories
echo "Verifying and creating directories..."
echo "  $VIMRUNTIME/cream"
mkdir -p $VIMRUNTIME/cream
echo "  $VIMRUNTIME/cream/addons"
mkdir -p $VIMRUNTIME/cream/addons
echo "  $VIMRUNTIME/cream/bitmaps"
mkdir -p $VIMRUNTIME/cream/bitmaps
echo "  $VIMRUNTIME/cream/docs"
mkdir -p $VIMRUNTIME/cream/docs
echo "  $VIMRUNTIME/cream/docs-html"
mkdir -p $VIMRUNTIME/cream/docs-html
echo "  $VIMRUNTIME/cream/filetypes"
mkdir -p $VIMRUNTIME/cream/filetypes
echo "  $VIMRUNTIME/cream/help"
mkdir -p $VIMRUNTIME/cream/help
echo "  $VIMRUNTIME/cream/spelldicts"
mkdir -p $VIMRUNTIME/cream/spelldicts
echo

# runtime files
echo "Copying runtime files..."
echo "  $VIMRUNTIME/cream/creamrc"
cp -uf $HERE/creamrc $VIMRUNTIME/cream/
echo "  $VIMRUNTIME/cream/*.vim"
cp -uf $HERE/*.vim $VIMRUNTIME/cream/
#echo "  $VIMRUNTIME/cream/cream.png"
#cp -uf $HERE/cream.png $VIMRUNTIME/cream/
#echo "  $VIMRUNTIME/cream/cream.svg"
#cp -uf $HERE/cream.svg $VIMRUNTIME/cream/
#echo "  $VIMRUNTIME/cream/cream.ico"
#cp -uf $HERE/cream.ico $VIMRUNTIME/cream/
echo "  $VIMRUNTIME/cream/addons/*.vim"
cp -uf $HERE/addons/*.vim $VIMRUNTIME/cream/addons/
echo "  $VIMRUNTIME/cream/bitmaps/*.xpm"
cp -uf $HERE/bitmaps/*.xpm $VIMRUNTIME/cream/bitmaps/
#echo "  $VIMRUNTIME/cream/bitmaps/*.bmp"
#cp -uf $HERE/bitmaps/*.bmp $VIMRUNTIME/cream/bitmaps/
echo "  $VIMRUNTIME/cream/docs/*.txt"
cp -uf $HERE/docs/*.txt $VIMRUNTIME/cream/docs/
echo "  $VIMRUNTIME/cream/docs-html/*.html"
cp -uf $HERE/docs-html/*.html $VIMRUNTIME/cream/docs-html/
echo "  $VIMRUNTIME/cream/docs-html/*.css"
cp -uf $HERE/docs-html/*.css $VIMRUNTIME/cream/docs-html/
echo "  $VIMRUNTIME/cream/docs-html/*.png"
cp -uf $HERE/docs-html/*.png $VIMRUNTIME/cream/docs-html/
echo "  $VIMRUNTIME/cream/filetypes/*.vim"
cp -uf $HERE/filetypes/*.vim $VIMRUNTIME/cream/filetypes/
echo "  $VIMRUNTIME/cream/help/*.txt"
cp -uf $HERE/help/*.txt $VIMRUNTIME/cream/help/
echo "  $VIMRUNTIME/cream/spelldicts/cream-spell-dict-eng-s*.vim"
cp -uf $HERE/spelldicts/cream-spell-dict-eng-s*.vim $VIMRUNTIME/cream/spelldicts/
echo "  $VIMRUNTIME/cream/spelldicts/cream-spell-dict.vim"
cp -uf $HERE/spelldicts/cream-spell-dict.vim $VIMRUNTIME/cream/spelldicts/
echo

# command
echo "Copying shell command..."
echo "  /usr/bin/cream"
cp -uf $HERE/cream /usr/bin/
echo

# menu entry
echo "Copying GNOME menu entry..."
echo "  /usr/share/applications/cream.desktop"
cp -uf $HERE/cream.desktop /usr/share/applications/
echo

# icons
echo "Copying graphic icons..."
echo "  /usr/share/icons"
cp -uf $HERE/cream.svg /usr/share/icons/
cp -uf $HERE/cream.png /usr/share/icons/
echo


# cleanup
echo "Cleaning up previous versions..."
if [ -e "$VIMRUNTIME/cream/cream-filetype-c.vim" ]; then
	rm -f $VIMRUNTIME/cream/cream-filetype-c.vim
fi
if [ -e "$VIMRUNTIME/cream/cream-filetype-html.vim" ]; then
	rm -f $VIMRUNTIME/cream/cream-filetype-html.vim
fi
if [ -e "$VIMRUNTIME/cream/cream-filetype-txt.vim" ]; then
	rm -f $VIMRUNTIME/cream/cream-filetype-txt.vim
fi
if [ -e "$VIMRUNTIME/cream/cream-filetype-vim.vim" ]; then
	rm -f $VIMRUNTIME/cream/cream-filetype-vim.vim
fi
echo

# finish
echo "Finished."
echo

