"=====================================================================
" cream-filetype.vim
"
" Cream -- An easy-to-use configuration of the famous Vim text editor
" [ http://cream.sourceforge.net ] Copyright (C) 2002-2004  Steve Hall
"
" License:
" This program is free software; you can redistribute it and/or modify
" it under the terms of the GNU General Public License as published by
" the Free Software Foundation; either version 2 of the License, or
" (at your option) any later version.
" [ http://www.gnu.org/licenses/gpl.html ]
"
" This program is distributed in the hope that it will be useful, but
" WITHOUT ANY WARRANTY; without even the implied warranty of
" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
" General Public License for more details.
"
" You should have received a copy of the GNU General Public License
" along with this program; if not, write to the Free Software
" Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
" 02111-1307, USA.
"
" Description:
" Filetypes and filetype dependent behavior (comments)
"

"______________________________________________________________________
" File Type Support

function! Cream_filetype(...)
" detect and set conditions based on filetype
" o {argument} (optional) is filetype to set, otherwise detected

	" detection
	if a:0 > 0
		execute "set filetype=" . a:1
	elseif &filetype == ""
		filetype detect
	endif

	" initialize indention
	call Cream_autoindent_init()

	if &filetype == ""
		set filetype=txt
	endif

	" ftplugins
	if  &filetype == "txt"
	\|| &filetype == "mail"
		call Cream_source($CREAM . "filetypes/txt.vim")
	else
		silent! syntax clear Sig
		silent! syntax clear EQuote1
		silent! syntax clear EQuote2
		silent! syntax clear EQuote3

		silent! syntax clear Cream_txt_bullets
		silent! syntax clear Cream_txt_charlines_half
		silent! syntax clear Cream_txt_charlines_full
		silent! syntax clear Cream_txt_timestamp
		silent! syntax clear Cream_txt_timestamp_value
		silent! syntax clear Cream_txt_foldtitles
	endif

	if &filetype == "c"
	    call Cream_source($CREAM . "filetypes/c.vim")
	endif

	if &filetype == "html"
	\|| &filetype == "php"
	    call Cream_source($CREAM . "filetypes/html.vim")
	endif

	if &filetype == "lisp"
	    call Cream_source($CREAM . "filetypes/lisp.vim")
	endif

	if &filetype == "vim"
	    call Cream_source($CREAM . "filetypes/vim.vim")
	endif

endfunction

