"=====================================================================
" cream-macros.vim
"
" Cream -- An easy-to-use configuration of the famous Vim text editor
" [ http://cream.sourceforge.net ] Copyright (C) 2002-2004  Steve Hall
" 
" License:
" This program is free software; you can redistribute it and/or modify
" it under the terms of the GNU General Public License as published by
" the Free Software Foundation; either version 2 of the License, or
" (at your option) any later version.
" [ http://www.gnu.org/licenses/gpl.html ]
" 
" This program is distributed in the hope that it will be useful, but
" WITHOUT ANY WARRANTY; without even the implied warranty of
" MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
" General Public License for more details.
" 
" You should have received a copy of the GNU General Public License
" along with this program; if not, write to the Free Software
" Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
" 02111-1307, USA.

" mapped elsewhere
" <F8>		Play macro (default)
" <S-F8>	Start/stop recording (default)

function! Cream_macro_record(...)
" record macro, get register if not passed one

	if exists("b:cream_recording")
		" stop recording if on
		normal q
		unlet b:cream_recording
	else
		" get register
		if exists("a:1")
			let myregrecord = a:1
		else
			let myregrecord = Cream_macro_getregister()
		endif

		" start recording
		let b:cream_recording = "yes"
		execute 'normal q' . myregrecord

	endif

endfunction


"......................................................................
" Macros, User-defined registers

"" record/stop recording macro (user-determined register)
"imap <silent> <C-F8> <C-o>:call Cream_macro_record()<CR>

" play macro in user-determined register
"*** BROKEN: odd behavior, possibly due to final execute statement with "@" char(?) ***
"imap <silent> <M-F8> <C-o>:call Cream_macro_playuser()<CR>
function! Cream_macro_playuser()
	let myregplay = Cream_macro_getregister()
"*** DEBUG
call confirm("DEBUG:\n myregplay  =  " . myregplay, "&Ok", 1, "Info")
"***
	execute 'normal @' . myregplay
endfunction

function! Cream_macro_getregister()
" get register from user

	if has("gui_running") && has("dialog_gui")
		let myreg = inputdialog(
			\"Please enter a register (A-z) to use for macro\n(only first letter used):")
	elseif has("dialog") && has("dialog_con")
		let myreg = input(
			\"Please enter a register (A-z) to use for macro\n(only first letter used):")
	else
		" error
		call confirm("breakage in Cream_macro_getregister()", "&Ok", 1, "Info")
		finish
	endif

	" default to q if one not given
	if myreg == ""
		let myreg = "q"
	endif

	" only use first letter of input
	let myreg = strpart(myreg, 0, 1)

	return myreg

endfunction

" Fix <Enter> remapping
"*** BROKEN: mapping to <C-m> not replaced correctly ***
"" * DANGER! Ctrl+M is Enter! 
"" * In order to use a <C-m> mapping, we had to make this!
"" * This mapping must load after (follow) the C-m mapping above!!! [not true]
"inoremap <silent> <Return> <C-o>:call Cream_return()<CR>
"function! Cream_return()
"	if &fileformat == "dos"
"		execute "normal i" . nr2char(10) . nr2char(13)
"	elseif &fileformat == "unix"
"		execute "normal i" . nr2char(10)
"	elseif &fileformat == "mac"
"		execute "normal i" . nr2char(13)
"	endif
"endfunction



