/***********************************************************************
 *  Copyright (C) 2002   Samuel Benzaquen 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***********************************************************************/
#include <stdio.h>
#include "contador.h"

map<int, int> puntos_cont;
map<int, int> contadores;

void set_punto(int i, int n){
	puntos_cont[i] = n;
}

int agregar_contador(int i, FILE *file){
	if ((contadores[i]++ % puntos_cont[i]) == (puntos_cont[i]-1)){
		fprintf(file, ".");
		if (((contadores[i] / puntos_cont[i]) % 50) == 0){
			fprintf(file, " %d\n", contadores[i]);
			fflush(file);
			return 2;
		}
		fflush(stdout);
		return 1;
	}
	return 0;
}

void imprimir_contador(int i, FILE *file){
	fprintf(file, " %d\n", contadores[i]);
}
