/***********************************************************************
 *  Copyright (C) 2002   Samuel Benzaquen 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***********************************************************************/
#include <stdio.h>
#include <iostream>
#include <fstream>
#include <vector>
#include <time.h>
#include <string.h>
#include <signal.h>
#include <unistd.h>
#include "wordset.h"
#include "mirandom.h"
#include "contador.h"
#include "parametros.h"

using namespace std;

typedef struct punto_s{
		int i,j;
		int v;
		int l;
		string ultimo;
		int ultimo_size;
		string palabra_puesta;
#ifdef HEUR
		int culpa;
#endif
} punto;

int filas, columnas;
unsigned int maximo_p = 0;

vector<punto> puntos;

vector<string> palabras_usadas;

int salida_normal = 1;

int verbose;

#ifdef HEUR

int maximo_culpa;

int atraviesa(int punto1, int punto2){
	if (puntos[punto1].v){
		if (puntos[punto2].v)
			return 0;
		if ((puntos[punto1].j >= puntos[punto2].j) &&
			 (puntos[punto1].j < puntos[punto2].j + puntos[punto2].l) &&
			 (puntos[punto2].i >= puntos[punto1].i) &&
			 (puntos[punto2].i < puntos[punto1].i + puntos[punto1].l))
			return 1;
	}
	else{
		if (!puntos[punto2].v)
			return 0;
		if ((puntos[punto2].j >= puntos[punto1].j) &&
			 (puntos[punto2].j < puntos[punto1].j + puntos[punto1].l) &&
			 (puntos[punto1].i >= puntos[punto2].i) &&
			 (puntos[punto1].i < puntos[punto2].i + puntos[punto2].l))
			return 1;
	}
	return 0;
}

int recomenzarb = 0;
int tiempo_reinicio;
int veces_reinicio;
void recomenzar(int signum){
	recomenzarb = 1;
}
#endif

void imprimir (string s){
	if (salida_normal)
		cout << ">>" << s << "<<" << endl;
	else
		cerr << ">>" << s << "<<" << endl;
	vector<string> v = palabras_coinciden(s, palabras_usadas);
	for (unsigned int i = 0; i < v.size(); i++)
	if (salida_normal)
		cout << v[i] << endl;
	else
		cerr << v[i] << endl;
}

void imprimir(char *puzzle){
	int en_blanco = 0;
	fprintf((salida_normal?stdout:stderr), "Imprimiendo... %d filas y %d columnas\n", filas, columnas);
	for (int i = 0; i < filas; i ++){
		for (int j = 0; j < columnas; j++){
			fprintf((salida_normal?stdout:stderr), "%c", puzzle[(i*columnas) + j]);
			if (puzzle[(i*columnas) + j] == ' ')
				en_blanco++;
		}
		fprintf((salida_normal?stdout:stderr), "\n");
	}
	fprintf((salida_normal?stdout:stderr), "Quedan todavia %d letras en blanco.\n", en_blanco);
}

void imprimir_sol(char *puzzle){
	int en_blanco = 0;
	printf("%d\n%d\n", filas, columnas);
	for (int i = 0; i < filas; i ++){
		for (int j = 0; j < columnas; j++){
			printf("%c", puzzle[(i*columnas) + j]);
			if (puzzle[(i*columnas) + j] == ' ')
				en_blanco++;
		}
		printf("\n");
	}
}

char *cargar_vacio(const char *filename){
	FILE *file = fopen(filename, "r");
	if (!file){
		fprintf(stderr, "Error al abrir el archivo de 'vacio' %s.\n", filename);
		exit (2);
	}
	fscanf(file, "%d", &filas);
	fscanf(file, "%d", &columnas);
	char *puzzle = (char*) malloc(filas*columnas*sizeof(char));
	for (int i = 0; i < filas; i ++){
		for (int j = 0; j < columnas; j++){
			char c;
			fscanf(file, "%c", &c);
			while ((c != ' ') && (c != '*'))
				fscanf(file, "%c", &c);
			puzzle[(i*columnas) + j] = c;
		}
	}
	fclose(file);
	return puzzle;
}

int length(register char *puzzle, register int i, register int j, register int vert){
	register int l = 0;
	if (vert)
		while(puzzle[((i+l)*columnas) + j] != '*')
			l++;
	else
		while(puzzle[(i*columnas) + j + l] != '*')
			l++;
	return l;
}

void buscar_puntos(char *puzzle){
	for (int i = 1; i < filas-1; i ++){
		for (int j = 1; j < columnas-1; j++){
			if ((puzzle[(i*columnas) + j] != '*') &&
				 (puzzle[(i*columnas) + j + 1] != '*') &&
				 (puzzle[(i*columnas) + j - 1] == '*')){
				punto p;
				p.i = i;
				p.j = j;
				p.v = 0;
				p.l = length(puzzle, i, j, 0);
#ifdef HEUR
				p.culpa = 0;
#endif				
				puntos.push_back(p);
			}
			if ((puzzle[(i*columnas) + j] != '*') &&
				 (puzzle[((i+1)*columnas) + j] != '*') &&
				 (puzzle[((i-1)*columnas) + j] == '*')){
				punto p;
				p.i = i;
				p.j = j;
				p.v = 1;
				p.l = length(puzzle, i, j, 1);
#ifdef HEUR
				p.culpa = 0;
#endif				
				puntos.push_back(p);
			}
		}
	}
}

string palabra_puzzle(register char *puzzle, int p){
	string s;
	if (puntos[p].v)
		for (int i = 0; i < puntos[p].l; i++)
			s += puzzle[(puntos[p].i+i)*columnas + (puntos[p].j)];
	else
		for (int i = 0; i < puntos[p].l; i++)
			s += puzzle[(puntos[p].i)*columnas + (puntos[p].j+i)];
	return s;
}

char *poner_palabra(register char *puzzle, int p, string palabra){
	register char *nuevo = (char*) malloc(filas*columnas*sizeof(char));
	memcpy(nuevo, puzzle, filas*columnas);
	if (puntos[p].v)
		for (int i = 0; i < puntos[p].l; i++)
			nuevo[(puntos[p].i+i)*columnas + puntos[p].j] = palabra[i];
	else
		for (int i = 0; i < puntos[p].l; i++)
			nuevo[puntos[p].i*columnas + puntos[p].j + i] = palabra[i];
	return nuevo;
}

char *poner(register char *puzzle, register unsigned int p){
	string palabra = palabra_puzzle(puzzle, p);
	int minimo;
	if (palabra == puntos[p].ultimo)
		minimo = puntos[p].ultimo_size;
	else{
		puntos[p].ultimo = palabra;
		minimo = puntos[p].ultimo_size = palabras_coinciden_tam(palabra);
	}
	unsigned int minimoI = p;
	if (maximo_p < p){
		if (verbose > 1)
			imprimir(puzzle);
		maximo_p = p;
	}
	for (unsigned int i = p; i < puntos.size(); i++){
		string palabra2 = palabra_puzzle(puzzle, i);
		int este;
		if (palabra2 == puntos[i].ultimo)
			este = puntos[i].ultimo_size;
		else{
			puntos[i].ultimo = palabra2;
			este = puntos[i].ultimo_size = palabras_coinciden_tam(palabra2);
		}
		if (este < minimo){
			minimo = este;
			minimoI = i;
		}
	}
	if (minimoI != p){
		punto aux = puntos[minimoI];
		puntos[minimoI] = puntos[p];
		puntos[p] = aux;
	}
	palabra = palabra_puzzle(puzzle, p);
	vector<string> coinciden = palabras_coinciden(palabra, palabras_usadas);
	while(coinciden.size() > 0){
#ifdef HEUR
		if (recomenzarb){
			return NULL;
		}
		for (unsigned int culpables = 0; culpables < p; culpables++){
			if ((puntos[culpables].culpa/puntos[culpables].l) > maximo_culpa/*MAXIMO_CULPA*/){
				if (verbose > 2){
					if (salida_normal)
						cout << "Hay una palabra culpable y me voy a salir (" << palabra_puzzle(puzzle, culpables) << ")" << endl;
					else
						cerr << "Hay una palabra culpable y me voy a salir (" << palabra_puzzle(puzzle, culpables) << ")" << endl;
				}
				return NULL;
			}
		}
		if ((puntos[p].culpa/puntos[p].l) > maximo_culpa/*MAXIMO_CULPA*/){
			if (verbose > 2)
				imprimir(puzzle);
			puntos[p].culpa = 0;
			maximo_p = p;
		}
#endif
		if (verbose > 0){
			if (agregar_contador(1, (salida_normal?stdout:stderr)) == 2){
				if (verbose > 1){
				imprimir_estadisticas(salida_normal);
				imprimir(puzzle);
				}
			}
		}
		int escogi = mirand(coinciden.size());
		string pal_escogida = coinciden[escogi];
		coinciden.erase(coinciden.begin()+escogi);
		char *nuevo = poner_palabra(puzzle, p, pal_escogida);
		palabras_usadas.push_back(pal_escogida);
		puntos[p].palabra_puesta = pal_escogida;
		if (p == puntos.size() - 1)
			return nuevo;
		else{
			char *iter = poner(nuevo, p+1);
			if (iter){
				return iter;
			}
			else{
				palabras_usadas.pop_back();
				free(nuevo);
			}
		}
	}
#ifdef HEUR
	for (unsigned int culpables = 0; culpables < p; culpables++){
		if (atraviesa(culpables, p)){
			puntos[culpables].culpa++;
		}
	}
#endif				
	return NULL;
}

int main(int argc, char **argv){
	time_t tiempo_inicial = time(NULL);
	map<string, string> params;
#ifdef HEUR
	params["c"] = "100";
	params["r"] = "0";
	params["vr"] = "0";
#endif				
	params["v"] = "0";
	params = leer_parametros(argc, argv, params);
#ifdef HEUR
	maximo_culpa = atoi(params["c"].c_str());
	tiempo_reinicio = atoi(params["r"].c_str());
	veces_reinicio = atoi(params["vr"].c_str());
#endif
	verbose = atoi(params["v"].c_str());

	if ((params["d"] == "") || (params["t"] == "")){
		fprintf(stderr, "For usage read docs/en/USAGE\n");
//  		fprintf(stderr, "Usage: crossword -d <lista_palabras> ");
//  #ifdef HEUR
//  		fprintf(stderr, "-c <maximo_culpa> ");
//  #endif				
//  		fprintf(stderr, "-t <vacio> -v <verbosidad> <salida>\n");
//  		fprintf(stderr, "            <lista_palabras>: Archivo que contiene la lista de palabras a usar.\n");
//  //		fprintf(stderr, "                              'numeros' significa que se van a usar numeros en vez de palabras.\n");
//  #ifdef HEUR
//  		fprintf(stderr, "            <maximo_culpa>: Determina que tan rapido descarta una palabra problematica (Valor por defecto: 100; intervalo = [0,infinito)).\n");
//  #endif				
//  		fprintf(stderr, "            <vacio>: Archivo que contiene el crucigrama vacio a ser llenado.\n");
//  		fprintf(stderr, "            <verbosidad>: Nivel de informacion que muestra la aplicacion (Valor por defecto: 0; intervalo = [0,3]).\n");
//  		fprintf(stderr, "            <salida>: Archivo en donde se colocara la salida. Si se omite, la salida sera a stdout y la salida normal va por stderr.\n");
		exit (1);
	}
	srand(time(NULL));
	if (params["-"] == "")
		salida_normal = 0;
	inicializar_wordset(params["d"].c_str()/*argv[1]*/, salida_normal, verbose);
	char *puzzle = cargar_vacio(params["t"].c_str()/*argv[2]*/);
	if (verbose > 0)
		imprimir(puzzle);
	buscar_puntos(puzzle);
	set_punto(1, 2000);
#ifdef HEUR
	if (tiempo_reinicio > 0){
		signal(SIGALRM, recomenzar);
		alarm(tiempo_reinicio);
	}
#endif
	char *sol = poner(puzzle, 0);
#ifdef HEUR
	while ((!sol) && recomenzarb){
		recomenzarb = 0;
		if (verbose > 0){
			if (salida_normal)
				cout << endl << "Tiempo agotado... reiniciando."<< endl;
			else
				cerr << endl << "Tiempo agotado... reiniciando."<< endl;
		}
		if (veces_reinicio-- > 0){
			signal(SIGALRM, recomenzar);
			alarm(tiempo_reinicio);
			palabras_usadas.clear();
			sol = poner(puzzle, 0);
		}
		else{
			if (verbose > 0){
				if (salida_normal)
					cout << "No quedan mas reinicios... saliendo." << endl;
				else
					cerr << "No quedan mas reinicios... saliendo." << endl;
			}
			exit(4);
		}
	}
#endif
	if (sol){
		if (salida_normal){
			ofstream salida(params["-"].c_str()/*argv[3]*/);
			if (!salida.is_open()){
				cerr << endl << "Error al abrir el archivo de salida " << params["-"] << "." << endl;
				exit(2);
			}
			salida << filas << endl << columnas << endl;
			for (int i = 0; i < filas; i ++){
				for (int j = 0; j < columnas; j++){
					salida << puzzle[(i*columnas) + j];
				}
				salida << endl;
			}
			for (unsigned int i = 0; i < puntos.size(); i++)
				salida << "(" << puntos[i].i << " " << puntos[i].j << ")" << (puntos[i].v?"V":">") << puntos[i].palabra_puesta << endl;
		}
		else{
			cout << filas << endl << columnas << endl;
			for (int i = 0; i < filas; i ++){
				for (int j = 0; j < columnas; j++){
					cout << puzzle[(i*columnas) + j];
				}
				cout << endl;
			}
			for (unsigned int i = 0; i < puntos.size(); i++)
				cout << "(" << puntos[i].i << " " << puntos[i].j << ")" << (puntos[i].v?"V":">") << puntos[i].palabra_puesta << endl;
		}
	}
	else{
		cerr << "\n\n\n\nNo consegui solucion para:" << endl;
		imprimir(puzzle);
		time_t tiempo_total = time(NULL) - tiempo_inicial;
		fprintf(stderr, "\nTiempo total %ld:%ld:%ld\n", tiempo_total/3600, (tiempo_total%3600)/60, tiempo_total%60);
		exit(3);
	}
	free(puzzle);
	if (verbose > 0){
		time_t tiempo_total = time(NULL) - tiempo_inicial;
		fprintf((salida_normal?stdout:stderr), "\nTiempo total %ld:%ld:%ld\n", tiempo_total/3600, (tiempo_total%3600)/60, tiempo_total%60);
	}
	exit(0);
}
