/***********************************************************************
 *  Copyright (C) 2002   Samuel Benzaquen 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***********************************************************************/
#include <vector>
#include <string>
#include <map>
#include "parametros.h"

using namespace std;

map<string, string> leer_parametros(int argc, char **argv, map<string, string> defaults){
	map<string, string> params = defaults;
	int estado = 0;
	string bandera;
	for (int i = 1; i < argc; i++){
		if (estado){ //Esta prendida una bandera de parametro
			params[bandera] = string(argv[i]);
			estado = 0;
		}
		else{
			if (argv[i][0] == '-'){
				bandera = string(argv[i]+1);
				estado = 1;
			}
			else{
				params[string("-")] += ((params[string("-")]=="")?"":" ") + string(argv[i]);
			}
		}
	}
	return params;
}
