/***********************************************************************
 *  Copyright (C) 2002   Samuel Benzaquen 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***********************************************************************/
#include <vector>
#include <string>
#include <map>
#include <algorithm>
#include <utility>
#include <iostream>
#include <fstream>
#include <stdio.h>
#include "contador.h"
#include "wordset.h"

using namespace std;


//La lista de las palabras organizadas de tal forma que sea sencillo y rapido
// ejecutar palabras_coinciden.
map<pair<int, pair<int, char> >, vector<string> > lista;

//int : numero de letras de la palabra
//int : para la letra i
//char: siendo el caracter c
//vector<string> : la lista de palabras bajo este renglon


//La lista completa de las palabras de tamano int.
map<int, vector<string> > lista_plana;


//Estructura de datos donde se guardan las peticiones ya resueltas para no
// necesitar recalcularlas (unicamente para optimizaci'on)
map<string, vector<string> > hechos;

//Variables para guardar las estadisticas de uso.
int hits = 0, supe = 0;


//Intersecta dos vectores y devuelve un nuevo vector con esta interseccion.
//supongo que los dos vectores de entrada estan ordenados, entonces puedo utilizar binary search en vez de find lineal.
// el vector resultante sigue siendo ordenado gracias a la manera de construccion
vector<string> intersectar(vector<string> v1, vector<string> v2){
	vector<string> salida;
	if (v1.size() < v2.size()){
		for(vector<string>::iterator it = v1.begin(); it != v1.end(); it++)
			if (binary_search(v2.begin(), v2.end(), (*it)))
				salida.push_back(*it);
	}
	else{
		for(vector<string>::iterator it = v2.begin(); it != v2.end(); it++)
			if (binary_search(v1.begin(), v1.end(), (*it)))
				salida.push_back(*it);
	}
	return salida;
}

//Es la operacion de conjunto A-B (los elementos de A que no estan en B)
// supongo que v2 no es ordenado, entonces no puedo usar binary search.
//(se utiliza con usadas que no esta lexicograficamente ordenada)
vector<string> menos(vector<string> v1, vector<string> v2){
	vector<string> salida;
	for(vector<string>::iterator it = v1.begin(); it != v1.end(); it++)
		if (find(v2.begin(), v2.end(), (*it)) == v2.end())
			salida.push_back(*it);
	return salida;
}


//Agrega una palabra a las estructuras adecuadas
//Unicamente utilizado en la carga de las palabras al principio de la ejecucion
void agregar_palabra(string palabra){
	int tamano = palabra.size();
	lista_plana[tamano].push_back(palabra);
	for (int i = 0; i < tamano; i++)
		lista[make_pair(tamano, make_pair(i, palabra[i]))].push_back(palabra);
//		lista[tamano][make_pair(i,palabra[i])].push_back(palabra);
}

//Inicializa el wordset con las palabras en el archivo filename
void inicializar_wordset(const char *filename, int salida_normal, int verbose){
	ifstream input (filename);
	if (!input.is_open()){
		fprintf(stderr, "Error al abrir el archivo de diccionario %s.\n", filename);
		exit(2);
	}

	string s;
	set_punto(0, 1000);
	if (verbose > 0){
		if (salida_normal)
			cout << "Cargando palabras en la estructura de datos..." << endl;
		else
			cerr << "Cargando palabras en la estructura de datos..." << endl;
	}
	input >> s;
	while(!input.eof()){
		if (verbose > 0){
			if (salida_normal)
				agregar_contador(0,stdout);
			else
				agregar_contador(0,stderr);
		}
		agregar_palabra(s);
		input >> s;
	}
	if (verbose > 0){
		if (salida_normal)
			imprimir_contador(0, stdout);
		else
			imprimir_contador(0, stderr);
		if (salida_normal)
			cout << "Optimizando las estructuras de datos..." << endl;
		else
			cerr << "Optimizando las estructuras de datos..." << endl;
	}
	set_punto(2, 100);
	for (map<pair<int, pair<int, char> >, vector<string> >::iterator it = lista.begin(); it != lista.end(); it++){
		if (verbose > 0)
			agregar_contador(2, (salida_normal?stdout:stderr));
		sort((*it).second.begin(), (*it).second.end());
	}
	if (verbose > 0){
		if (salida_normal)
			imprimir_contador(2,stdout);
		else
			imprimir_contador(2,stderr);
		if (salida_normal)
			cout << "Finalizada la carga y optimizacion del diccionario, empezando busqueda..." << endl;
		else
			cerr << "Finalizada la carga y optimizacion del diccionario, empezando busqueda..." << endl;
	}
}

int palabras_coinciden_tam(string p){
	map<string, vector<string> >::iterator it;
	if ((it = hechos.find(p)) != hechos.end()){
		hits++;
		supe++;
		return (*it).second.size();
	}
	else
		return palabras_coinciden(p).size();
}

vector<string> palabras_coinciden(string p, vector<string> usadas){
	hits++;
	map<string, vector<string> >::iterator it;
	if ((it = hechos.find(p)) != hechos.end()){
		supe++;
		return menos((*it).second, usadas);
	}
	vector<string> salida;
	int tamano = p.size();
	int con_letra[30];
	int con_letras = 0;
	for (int i = 0; i < tamano; i++){
		if (p[i] != ' '){
			con_letra[con_letras++] = i;
		}
	}
	if (con_letras > 0){
		salida = lista[make_pair(tamano, make_pair(con_letra[0], p[con_letra[0]]))];
		for (int i = 1; i < con_letras; i++){
			salida = intersectar(salida, lista[make_pair(tamano, make_pair(con_letra[i], p[con_letra[i]]))]);
		}
		hechos[p] = salida;
		return menos(salida, usadas);
	}
	else{
		hechos[p] = lista_plana[tamano];
		return menos(lista_plana[tamano], usadas);
	}
}

vector<string> palabras_coinciden(string p){
	hits++;
	map<string, vector<string> >::iterator it;
	if ((it = hechos.find(p)) != hechos.end()){
		supe++;
		return (*it).second;
	}
	vector<string> salida;
	int tamano = p.size();
	int con_letra[30];
	int con_letras = 0;
	for (int i = 0; i < tamano; i++){
		if (p[i] != ' '){
			con_letra[con_letras++] = i;
		}
	}
	if (con_letras > 0){
		salida = lista[make_pair(tamano, make_pair(con_letra[0], p[con_letra[0]]))];
		for (int i = 1; i < con_letras; i++){
			salida = intersectar(salida, lista[make_pair(tamano, make_pair(con_letra[i], p[con_letra[i]]))]);
		}
		hechos[p] = salida;
		return salida;
	}
	else{
		hechos[p] = lista_plana[tamano];
		return lista_plana[tamano];
	}
}

void imprimir_estadisticas(int salida_normal){
	fprintf((salida_normal?stdout:stderr), "He tenido %d hits de las cuales sabia %d.\n", hits, supe);
	fprintf((salida_normal?stdout:stderr), "El tamano de las hechas es de %d.\n", hechos.size());
}
