/***********************************************************************
 *  Copyright (C) 2002   Samuel Benzaquen 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 ***********************************************************************/
#include <vector>
#include <string>
#include <iostream>
#include <map>
#include <utility>

using namespace std;

//Inicializa el wordset con las palabras que se encuentran el archivo.
//salida_normal indica si la impresion del progreso sera por stdout o stderr
void inicializar_wordset(const char *, int salida_normal, int verbose);

//Devuelve el vector de las palabras que coinciden con el patron deseado.
//El patron esta determinado por letras definidas y por espacios en blanco
// que pueden ser sustituidos por cualquier letra.
vector<string> palabras_coinciden(string);
//Igual que el anterior, pero se le introduce el vector de palabras que no deseo en
// la respuesta (e.g. las palabras que ya he usado).
vector<string> palabras_coinciden(string, vector<string>);

//Dice el tamano del vector que seria devuelto por palabras_coinciden
//Utilizada unicamente por razones de optimizaci'on
int palabras_coinciden_tam(string);

//Imprime la estadisticas de hits que se han hecho al palabras_coinciden
// y cuantas ya he hecho y tengo en memoria.
void imprimir_estadisticas(int salida_normal);
